/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.schedule.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.base.portal.application.model.SysAppResource;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppResourceService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ResourceRecycleService {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysAppResourceService sysAppResourceService;
    @Resource
    private ISysDeployService sysDeployService;

    public void schedule(Integer day) {
        List sysApplicationList = this.sysApplicationService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysApplication::getReleaseStatus, (Object)"1")).eq(SysApplication::getResourceStatus, (Object)"0")).eq(SysApplication::getDelFlag, (Object)"0")).eq(SysApplication::getIsOnline, (Object)"1"));
        for (SysApplication sysApplication : sysApplicationList) {
            if (HussarUtils.isEmpty((Object)sysApplication.getPublishFormalTime())) continue;
            Timestamp nowTime = Timestamp.valueOf(LocalDateTime.now());
            Timestamp publishTime = Timestamp.valueOf(sysApplication.getPublishFormalTime());
            if (nowTime.getTime() - publishTime.getTime() < (long)(day * 24 * 60 * 1000)) continue;
            sysApplication.setResourceStatus("1");
            int count = this.sysDeployService.getCount(sysApplication.getId());
            SysAppResource sysAppResource = (SysAppResource)this.sysAppResourceService.getById((Serializable)sysApplication.getDevelopResourceId());
            sysAppResource.setResidueNum(Integer.valueOf(sysAppResource.getResidueNum() + count));
            sysAppResource.setAssignedNum(Integer.valueOf(sysAppResource.getAssignedNum() - count));
            this.sysAppResourceService.updateById((Object)sysAppResource);
            this.sysDeployService.updateIsPublish(sysApplication.getId());
            this.sysApplicationService.updateById((Object)sysApplication);
        }
    }
}

