/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.constant.AppConstants;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppGroupMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDomain;
import com.jxdinfo.hussar.base.portal.application.model.SysAppGroup;
import com.jxdinfo.hussar.base.portal.application.model.SysAppResource;
import com.jxdinfo.hussar.base.portal.application.model.SysAppVersion;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDomainService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppResourceService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppVersionService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationDeploy;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationGroup;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitServerDto;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.base.portal.yamlServer.service.IYamlService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.ExcelUtil;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysApplicationServiceImpl")
public class SysApplicationServiceImpl
extends HussarServiceImpl<SysApplicationMapper, SysApplication>
implements ISysApplicationService {
    @Resource
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private SysAppGroupMapper sysAppGroupMapper;
    @Resource
    private ISysAppDomainService iSysAppDomainService;
    @Resource
    private ISysAppResourceService sysAppResourceService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysDeployService sysDeployService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysStruAssistOrganService sysStruAssistOrganService;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private IYamlService yamlService;
    @Resource
    private IGitlabService gitlabService;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysAppVersionService sysAppVersionService;
    @Resource
    private ISysAppDomainService sysAppDomainService;

    public List<SysAppGroupVo> getManageAppList(Long appGroupId, String appName, String appStatus, String releaseStatus, String resourceStatus) {
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Object> appList = new ArrayList();
        List<Object> sysAppGroups = new ArrayList<SysAppGroup>();
        if (user.isSuperAdmin()) {
            List<SysApplicationDeploy> sysApplicationDeploys = this.sysApplicationMapper.getManageList(appGroupId, appName, appStatus, releaseStatus, resourceStatus);
            for (int i = 0; i < sysApplicationDeploys.size(); ++i) {
                sysApplicationDeploys.get(i).setAppGitUrl(this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplicationDeploys.get(i).getAppCode() + ".git");
                appList.add(new SysApplicationVo(sysApplicationDeploys.get(i)));
            }
            if (HussarUtils.isEmpty((Object)appGroupId) && HussarUtils.isEmpty((Object)appName) && HussarUtils.isEmpty((Object)appStatus) && HussarUtils.isEmpty((Object)releaseStatus) && HussarUtils.isEmpty((Object)resourceStatus)) {
                LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                wrapper.eq(SysAppGroup::getDelFlag, (Object)"0");
                wrapper.orderByAsc(SysAppGroup::getGroupType);
                sysAppGroups = this.sysAppGroupService.list((Wrapper)wrapper);
            } else {
                ArrayList<Long> groupIds = new ArrayList<Long>();
                for (SysApplicationDeploy sysApplicationDeploy : appList) {
                    groupIds.add(sysApplicationDeploy.getAppGroupId());
                }
                if (HussarUtils.isNotEmpty(groupIds)) {
                    sysAppGroups = this.sysAppGroupMapper.getAppGroup(null, groupIds);
                }
            }
        } else {
            appList = this.sysApplicationMapper.getAppListNew(user.getId(), appGroupId, appName, appStatus, releaseStatus, resourceStatus);
            ArrayList<Long> groupIds = new ArrayList<Long>();
            if (HussarUtils.isEmpty((Object)appGroupId) && HussarUtils.isEmpty((Object)appName) && HussarUtils.isEmpty((Object)appStatus) && HussarUtils.isEmpty((Object)releaseStatus) && HussarUtils.isEmpty((Object)resourceStatus)) {
                groupIds.add(AppConstants.DEFAULT_GROUP_ID);
            }
            for (SysApplicationDeploy sysApplicationDeploy : appList) {
                sysApplicationDeploy.setAppGitUrl(this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplicationDeploy.getAppCode() + ".git");
                groupIds.add(sysApplicationDeploy.getAppGroupId());
            }
            if (groupIds.size() > 0) {
                sysAppGroups = this.sysAppGroupMapper.getAppGroup(user.getUserId(), groupIds);
            }
        }
        return this.combinedData(appList, sysAppGroups);
    }

    public Boolean getAppProStatus(Long time) {
        File file = new File(this.gitlabConfigProperty.getTempPath() + File.separator + time);
        return !file.exists();
    }

    public List<String> getBuilddefs(String projectId) {
        ArrayList<String> list = new ArrayList<String>();
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet("http://60.204.136.32:8787/api/ci/builddefs?projectId=" + projectId);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            JSONArray jsonArray = JSONArray.parseArray((String)result);
            if (jsonArray.size() == 0) {
                List<String> list2 = null;
                return list2;
            }
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
        return list;
    }

    public Long updateApp(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = sysApplicationDto.getSysApplication();
        if ("1".equals(sysApplicationDto.getFlag())) {
            sysApplication.setResourceStatus("");
        }
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        SysApplication oldApp = (SysApplication)this.getById(sysApplication.getId());
        SysUsers oldLeader = this.sysUsersService.getUser(oldApp.getProjectLeader());
        SysUsers newLeader = this.sysUsersService.getUser(sysApplication.getProjectLeader());
        SysApplicationServiceImpl that = this;
        if (oldApp.getProjectLeader() != null && !oldApp.getProjectLeader().equals(sysApplication.getProjectLeader())) {
            this.gitlabService.deleteUserFGroupOrProject(oldLeader.getUserAccount(), user.getChar1(), "projects", oldApp.getAppCode());
            this.gitlabService.inviteUserJoinGroupOrProject(newLeader.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(newLeader.getId());
            sysUserRole.setGrantedRole(AppConstants.PROJECT_LEADER_ID);
            sysUserRole.setAdminOption("1");
            if (this.sysUserRoleService.getUserRole(sysUserRole.getUserId(), sysUserRole.getGrantedRole()) < 1) {
                this.sysUserRoleService.save((Object)sysUserRole);
            }
            new Thread(() -> {
                try {
                    that.syncDevloper(String.valueOf(sysApplication.getProjectLeader()), String.valueOf(sysApplication.getId()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
        this.updateById((BaseEntity)sysApplication);
        return time;
    }

    public SysAppDeploy getSysDeployInfo(Long appId, String deployType, Long userId) {
        return this.sysDeployService.getSysDeployInfo(appId, deployType, userId);
    }

    public int getFrontCount(String threeDomainFront, String twoDomain, Long deployId) {
        return this.sysDeployService.getFrontCount(threeDomainFront, twoDomain, deployId);
    }

    public int getMobileCount(String threeDomainMobile, String twoDomain, Long deployId) {
        return this.sysDeployService.getMobileCount(threeDomainMobile, twoDomain, deployId);
    }

    public Long publish(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = (SysApplication)this.getById(sysApplicationDto.getSysApplication().getId());
        sysApplication.setPersonalBrance(sysApplicationDto.getSysApplication().getPersonalBrance());
        sysApplication.setResourceStatus("0");
        SysAppDeploy sysAppDeploy = sysApplicationDto.getSysAppDeploy();
        sysAppDeploy.setDeployStatus("1");
        sysAppDeploy.setDeployType("1");
        sysAppDeploy.setDelFlag("0");
        sysAppDeploy.setIsPublish("1");
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        this.saveOrUpdate((BaseEntity)sysApplication);
        Thread thread = new Thread(() -> {
            try {
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken, "dev");
                this.yamlService.createValues(sysAppDeploy, sysApplication.getAppCreateType(), sysApplication.getAppCode(), time);
                this.gitlabService.pushToDev("1", sysApplication.getAppCode(), "\u5e94\u7528\u53d1\u5e03", accessToken, time);
                if (!"1".equals(sysApplication.getPersonalBrance())) {
                    this.gitlabService.unProtectBranch(sysApplication.getAppCode(), accessToken);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        });
        if (null == sysAppDeploy.getAppDeployId()) {
            sysAppDeploy.setAppId(sysApplication.getId());
            this.sysDeployService.save((Object)sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
            this.sysAppResourceService.countApplicationNum(sysApplication.getDevelopResourceId());
            thread.start();
        } else {
            SysAppDeploy oldSysAppDeploy = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            this.sysDeployService.updateDeploy(sysAppDeploy);
            if ("0".equals(oldSysAppDeploy.getIsPublish())) {
                this.sysAppResourceService.countApplicationNum(sysApplication.getDevelopResourceId());
            }
            if (!HussarUtils.isEmpty((Object)oldSysAppDeploy.getDomainId())) {
                if (!oldSysAppDeploy.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(oldSysAppDeploy.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.iSysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.iSysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
            if (!oldSysAppDeploy.equals(sysAppDeploy)) {
                thread.start();
            }
        }
        new Thread(() -> {
            try {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("sysApplication", sysApplication);
                String url = "http://" + sysAppDeploy.getThreeLevelDomainFront() + "." + sysAppDeploy.getTwoLevelDomain() + ":" + sysAppDeploy.getAppFrontPort() + "/hussarApi/hussarBase/authorization/newapp/saveOrUpdateNewApplication";
                this.post(url, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        return time;
    }

    public Long publishToTestEnvironment(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = (SysApplication)this.getById(sysApplicationDto.getSysApplication().getId());
        SysAppDeploy sysAppDeploy = sysApplicationDto.getSysAppDeploy();
        sysAppDeploy.setDeployType("3");
        sysAppDeploy.setDelFlag("0");
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        new Thread(() -> {
            try {
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken, "1".equals(sysApplication.getPersonalBrance()) ? "dev" : "master");
                this.yamlService.createValues(sysAppDeploy, sysApplication.getAppCreateType(), sysApplication.getAppCode(), time);
                this.gitlabService.pushToDev(sysApplication.getPersonalBrance(), sysApplication.getAppCode(), "\u53d1\u5e03\u6d4b\u8bd5\u73af\u5883\u63d0\u4ea4\u90e8\u7f72\u4fe1\u606f", accessToken, time);
                SysAppVersion sysAppVersion = new SysAppVersion();
                String versionNum = "";
                List versionNumList = this.sysAppVersionService.getVersionNum(sysApplicationDto.getSysApplication().getId(), "D");
                versionNum = versionNumList.size() > 0 ? (String)versionNumList.get(0) : "V1.0.0";
                int count = this.sysAppVersionService.getCount(sysApplication.getId(), "B");
                String versionName = sysApplication.getAppCode() + "_" + versionNum + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_B_T" + (count + 1);
                sysAppVersion.setVersionNum(versionNum);
                sysAppVersion.setVersionDesc(versionNum);
                sysAppVersion.setVersionName(versionName);
                sysAppVersion.setAppId(sysApplication.getId());
                sysAppVersion.setVersionType("B");
                sysAppVersion.setBranchName("1".equals(sysApplication.getPersonalBrance()) ? "dev" : "master");
                this.sysAppVersionService.saveVersion(sysAppVersion, user);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        if (null == sysAppDeploy.getAppDeployId()) {
            sysAppDeploy.setAppId(sysApplication.getId());
            this.sysDeployService.save((Object)sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        } else {
            SysAppDeploy oldSysAppDeploy = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            this.sysDeployService.updateDeploy(sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)oldSysAppDeploy.getDomainId())) {
                if (!oldSysAppDeploy.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(oldSysAppDeploy.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.iSysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.iSysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        }
        return time;
    }

    public Long publishToFormalEnvironment(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = (SysApplication)this.getById(sysApplicationDto.getSysApplication().getId());
        if (sysApplication != null) {
            sysApplication.setReleaseStatus("1");
            sysApplication.setAppStatus("1");
            this.updateById((BaseEntity)sysApplication);
        }
        SysAppDeploy sysAppDeploy = sysApplicationDto.getSysAppDeploy();
        sysAppDeploy.setDeployType("4");
        sysAppDeploy.setDelFlag("0");
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        new Thread(() -> {
            try {
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken, "1".equals(sysApplication.getPersonalBrance()) ? "dev" : "master");
                this.yamlService.createValues(sysAppDeploy, sysApplication.getAppCreateType(), sysApplication.getAppCode(), time);
                this.gitlabService.pushToDev(sysApplication.getPersonalBrance(), sysApplication.getAppCode(), "\u53d1\u5e03\u6b63\u5f0f\u73af\u5883\u63d0\u4ea4\u90e8\u7f72\u4fe1\u606f", accessToken, time);
                SysAppVersion sysAppVersion = new SysAppVersion();
                String versionNum = "";
                List versionNumList = this.sysAppVersionService.getVersionNum(sysApplication.getId(), "B");
                int count = this.sysAppVersionService.getCount(sysApplication.getId(), "R");
                versionNum = versionNumList.size() > 0 ? (String)versionNumList.get(0) : "V1.0.0";
                if (count > 0) {
                    int num = 0;
                    String[] numArray = versionNum.split("\\.");
                    num = Integer.parseInt(numArray[2]) + 1;
                    versionNum = numArray[0] + "." + numArray[1] + "." + num;
                }
                String versionName = sysApplication.getAppCode() + "_" + versionNum + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_R";
                sysAppVersion.setVersionNum(versionNum);
                sysAppVersion.setVersionDesc(versionNum);
                sysAppVersion.setVersionName(versionName);
                sysAppVersion.setAppId(sysApplication.getId());
                sysAppVersion.setVersionType("R");
                sysAppVersion.setBranchName("1".equals(sysApplication.getPersonalBrance()) ? "dev" : "master");
                this.sysAppVersionService.saveVersion(sysAppVersion, user);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        new Thread(() -> {
            try {
                String domainName = this.sysAppDomainService.getDomainName(Long.valueOf(Long.parseLong(sysAppDeploy.getTwoLevelDomain())));
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("sysApplication", sysApplication);
                String url = "http://" + sysAppDeploy.getThreeLevelDomainFront() + "." + domainName + ":" + sysAppDeploy.getAppFrontPort() + "/hussarApi/hussarBase/authorization/newapp/saveOrUpdateNewApplication";
                this.post(url, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        if (null == sysAppDeploy.getAppDeployId()) {
            sysAppDeploy.setAppId(sysApplication.getId());
            this.sysDeployService.save((Object)sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        } else {
            SysAppDeploy oldSysAppDeploy = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            this.sysDeployService.updateDeploy(sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)oldSysAppDeploy.getDomainId())) {
                if (!oldSysAppDeploy.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(oldSysAppDeploy.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.iSysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.iSysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        }
        return time;
    }

    public SysApplication getApplicationInfo() {
        return this.sysApplicationMapper.getApplicationInfo();
    }

    @HussarTransactional
    public Boolean deleteApp(Long appId) {
        SysApplication appInfo = (SysApplication)this.getById(appId);
        if ("1".equals(appInfo.getAppStatus())) {
            return false;
        }
        appInfo.setDelFlag("1");
        appInfo.setResourceStatus("1");
        if ("1".equals(appInfo.getIsOnline())) {
            int count = this.sysDeployService.getCount(appId);
            SysAppResource sysAppResource = (SysAppResource)this.sysAppResourceService.getById((Serializable)appInfo.getDevelopResourceId());
            sysAppResource.setResidueNum(Integer.valueOf(sysAppResource.getResidueNum() + count));
            sysAppResource.setAssignedNum(Integer.valueOf(sysAppResource.getAssignedNum() - count));
            this.sysAppResourceService.updateById((Object)sysAppResource);
            this.sysDeployService.updateIsPublish(appId);
        }
        return this.updateById((BaseEntity)appInfo);
    }

    public ApiResponse<SysApplicationVo> getAppDetail(Long appId) {
        SysApplicationVo sysApplicationVo = this.sysApplicationMapper.getAppDetail(appId);
        return ApiResponse.success((Object)sysApplicationVo);
    }

    public Long copyApplication(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        SysApplication sysApplication = sysApplicationDto.getSysApplication();
        SysApplication application = (SysApplication)this.getById(sysApplication.getId());
        Long appId = IdWorker.getId((Object)new SysApplication());
        sysApplication.setId(appId);
        sysApplication.setAppStatus("1");
        sysApplication.setReleaseStatus("0");
        sysApplication.setAppStatus("2");
        sysApplication.setDelFlag("0");
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
        new Thread(() -> {
            try {
                this.gitlabService.pullToLocal(application.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken, "dev");
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode() + File.separator + ".git"));
                this.gitlabService.createProject(sysApplication.getAppCode(), sysApplication.getAppDescribe(), accessToken, time);
                this.gitlabService.inviteUserJoinGroupOrProject(projectLeaderUser.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(projectLeaderUser.getId());
        sysUserRole.setGrantedRole(AppConstants.PROJECT_LEADER_ID);
        sysUserRole.setAdminOption("1");
        if (this.sysUserRoleService.getUserRole(sysUserRole.getUserId(), sysUserRole.getGrantedRole()) < 1) {
            this.sysUserRoleService.save((Object)sysUserRole);
        }
        this.save((BaseEntity)sysApplication);
        return time;
    }

    public Boolean updateAppStatus(Long appId, String appStatus) {
        SysApplication sysApplication = (SysApplication)this.getById(appId);
        if ("0".equals(appStatus) && "0".equals(sysApplication.getReleaseStatus())) {
            return false;
        }
        sysApplication.setAppStatus(appStatus);
        try {
            SysAppDeploy sysAppDeploy = this.sysDeployService.getDeployByDeployType(appId);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sysApplication", sysApplication);
            String url = "http://" + sysAppDeploy.getThreeLevelDomainFront() + "." + sysAppDeploy.getTwoLevelDomain() + ":" + sysAppDeploy.getAppFrontPort() + "/hussarApi/hussarBase/authorization/newapp/saveOrUpdateNewApplication";
            this.post(url, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.updateById((BaseEntity)sysApplication);
    }

    public ApiResponse<SysApplicationDto> getAppDetailAndDeploy(Long appId) {
        SysApplicationDto sysApplicationDto = new SysApplicationDto();
        SysAppDeploy sysAppDeploy = new SysAppDeploy();
        SecurityUser user = BaseSecurityUtil.getUser();
        Boolean superAdmin = user.isSuperAdmin();
        Boolean projectLeader = user.getRolesList().contains(AppConstants.PROJECT_LEADER_ID);
        Boolean applicationLeader = user.getRolesList().contains(AppConstants.APP_ADMIN_ID);
        SysApplication sysApplication = this.sysApplicationMapper.getAppDetailContainUserName(appId);
        sysAppDeploy = superAdmin != false || projectLeader != false || applicationLeader != false ? this.sysDeployService.getAppDeploy(appId, null, "1") : ("1".equals(sysApplication.getPersonalBrance()) ? this.sysDeployService.getAppDeploy(appId, user.getId(), "2") : this.sysDeployService.getAppDeploy(appId, null, "1"));
        sysApplicationDto.setSysAppDeploy(sysAppDeploy);
        sysApplication.setAppGitUrl(this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        sysApplicationDto.setSysApplication(sysApplication);
        return ApiResponse.success((Object)sysApplicationDto);
    }

    public Boolean updateSecretKey(Long appId) {
        SysApplication sysApplication = new SysApplication();
        sysApplication.setId(appId);
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        return this.updateById((BaseEntity)sysApplication);
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplicationDeploy sysApplicationDeploy : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplicationDeploy.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplicationDeploy);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplicationDeploy> sysApplicationList = new ArrayList<SysApplicationDeploy>();
            sysApplicationList.add(sysApplicationDeploy);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        ArrayList<SysAppGroupVo> res = new ArrayList<SysAppGroupVo>(resultCollect.values());
        Collections.sort(res, (o1, o2) -> o1.getCreateTime().compareTo(o2.getCreateTime()));
        return res;
    }

    public Boolean checkUser(String userAccount) {
        SysUsers user = this.sysUsersService.getUserByUserAccount(userAccount);
        return HussarUtils.isNotEmpty((Object)user);
    }

    @HussarTransactional
    public String syncDevloper(String ids, String appId) {
        SysAppDeploy sysAppDeploy = (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEL_FLAG", (Object)"0")).eq((Object)"APP_ID", (Object)appId)).eq((Object)"DEPLOY_TYPE", (Object)"1"));
        String containerPath = sysAppDeploy.getThreeLevelDomainFront() + "." + sysAppDeploy.getTwoLevelDomain() + ":" + sysAppDeploy.getAppFrontPort();
        if (containerPath == null || "".equals(containerPath)) {
            throw new BaseException("\u5e94\u7528\u5730\u5740\u9519\u8bef\uff0c\u540c\u6b65\u7528\u6237\u5230\u5e94\u7528\u5931\u8d25\uff01");
        }
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (int i = 0; i < idArray.length; ++i) {
            idList.add(Long.parseLong(idArray[i]));
        }
        List users = this.sysUsersService.listByIds(idList);
        ArrayList<Long> empIdList = new ArrayList<Long>();
        for (int i = 0; i < users.size(); ++i) {
            empIdList.add(((SysUsers)users.get(i)).getEmployeeId());
        }
        List strus = this.sysStruService.listByIds(empIdList);
        String empIdsStr = empIdList.stream().map(Object::toString).collect(Collectors.joining(","));
        List staffs = this.sysStaffService.getSysStaffListByEmpIds(empIdsStr);
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (int i = 0; i < strus.size(); ++i) {
            orgIdList.add(((SysStru)strus.get(i)).getOrganId());
        }
        List organs = this.sysOrganService.listByIds(orgIdList);
        List sysStruAssistOrgan = this.sysStruAssistOrganService.getStruAssistOrganByStruIds(empIdList);
        ArrayList<String> organFcode = new ArrayList<String>();
        for (int i = 0; i < organs.size(); ++i) {
            organFcode.add(((SysOrgan)organs.get(i)).getOrganFcode());
        }
        List organList = this.sysOrganService.getFOrganListByOrganFcode(organFcode);
        String organIds = organList.stream().map(o -> o.getId().toString()).collect(Collectors.joining(","));
        List struList = this.sysStruService.getStruByOrganIds(organIds);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", struList);
        data.put("organs", organList);
        data.put("staffs", staffs);
        data.put("users", users);
        data.put("sysStruAssistOrgan", sysStruAssistOrgan);
        String url = containerPath + "/hussarApi/hussarBase/authorization/newapp/importData";
        this.post(url, data);
        return "success";
    }

    public ApiResponse importExcelApplication(MultipartFile file) {
        try {
            List list;
            JSONObject json = ExcelUtil.getJsonFromXlsWithNullValue((byte[])file.getBytes(), (int)1, null);
            String code = json.getString("code");
            Map data = (Map)json.get((Object)"data");
            String appGroup = (String)data.get("appGroup");
            String domainName = (String)data.get("domainName");
            String databaseType = (String)data.get("databaseType");
            String appTypeWeb = (String)data.get("appTypeWeb");
            String appTypeApp = (String)data.get("appTypeApp");
            String appTypeProcedure = (String)data.get("appTypeProcedure");
            String isOnline = (String)data.get("isOnline");
            data.put("appGroupId", "");
            data.put("domainId", "");
            if (HussarUtils.isNotEmpty((Object)appGroup) && HussarUtils.isNotEmpty((Object)(list = this.sysAppGroupService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_NAME", (Object)appGroup)).eq((Object)"DEL_FLAG", (Object)"0"))))) {
                data.put("appGroupId", ((SysAppGroup)list.get(0)).getId());
            }
            if (HussarUtils.isNotEmpty((Object)domainName) && HussarUtils.isNotEmpty((Object)(list = this.iSysAppDomainService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DOMAIN_NAME", (Object)domainName)).eq((Object)"DEL_FLAG", (Object)"0")).eq((Object)"DOMAIN_STATUS", (Object)"0"))))) {
                data.put("domainId", ((SysAppDomain)list.get(0)).getId());
            }
            if (HussarUtils.isNotEmpty((Object)databaseType)) {
                switch (databaseType) {
                    case "Oracle": {
                        databaseType = "1";
                        break;
                    }
                    case "Mysql": {
                        databaseType = "2";
                        break;
                    }
                    case "\u8fbe\u68a6": {
                        databaseType = "3";
                        break;
                    }
                    case "\u795e\u901a": {
                        databaseType = "4";
                        break;
                    }
                    case "PgSQL": {
                        databaseType = "5";
                        break;
                    }
                    case "SQL Server": {
                        databaseType = "6";
                        break;
                    }
                    case "\u91d1\u4ed3": {
                        databaseType = "7";
                        break;
                    }
                    default: {
                        databaseType = null;
                    }
                }
                data.put("databaseType", databaseType);
            }
            if (HussarUtils.isNotEmpty((Object)appTypeWeb)) {
                if ("\u662f".equals(appTypeWeb)) {
                    data.put("appTypeWeb", 1);
                } else {
                    data.put("appTypeWeb", null);
                }
            }
            if (HussarUtils.isNotEmpty((Object)appTypeApp)) {
                if ("\u662f".equals(appTypeApp)) {
                    data.put("appTypeApp", 2);
                } else {
                    data.put("appTypeApp", null);
                }
            }
            if (HussarUtils.isNotEmpty((Object)appTypeProcedure)) {
                if ("\u662f".equals(appTypeProcedure)) {
                    data.put("appTypeProcedure", 3);
                } else {
                    data.put("appTypeProcedure", null);
                }
            }
            if ("\u662f".equals(isOnline)) {
                data.put("isOnline", "1");
            } else if ("\u5426".equals(isOnline)) {
                data.put("isOnline", "0");
            }
            if ("200".equals(code) && HussarUtils.isNotEmpty((Object)data)) {
                return ApiResponse.success((Object)data);
            }
            if (data.size() == 0) {
                return ApiResponse.fail((String)json.getString("\u8bf7\u5728\u6a21\u677f\u4e2d\u8fdb\u884c\u586b\u5199\u5e94\u7528\u90e8\u7f72\u4fe1\u606f"));
            }
            return ApiResponse.fail((String)json.getString("\u5bfc\u5165\u5931\u8d25"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
    }

    public void downloadTemplate(HttpServletResponse response, Map map) throws IOException {
        String filePath = (String)map.get("filePath");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        org.springframework.core.io.Resource resource = resolver.getResource("classpath:file\\application\\" + filePath);
        File file = File.createTempFile("tmp", filePath.substring(filePath.indexOf(".") + 1));
        try {
            FileUtils.copyInputStreamToFile((InputStream)resource.getInputStream(), (File)file);
            SysApplicationServiceImpl.download(file, response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException();
        }
        finally {
            file.deleteOnExit();
        }
    }

    public static void download(File file, HttpServletResponse response) {
        try {
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Length", "" + file.length());
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/" + file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(".") + 1) + ";charset=utf-8");
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void post(String url, Map<String, Object> map) {
        try (HttpResponse res = null;){
            res = ((HttpRequest)((HttpRequest)HttpRequest.post((String)url).timeout(90000).contentType("application/json", "UTF-8")).bodyText(IdempotentJsonUtils.toString(map), "application/json", "utf-8")).send();
            res.charset("utf-8");
            if (res.bodyText().equals("fail")) {
                this.log.error(res.bodyText());
                throw new BaseException("\u64cd\u4f5c\u5931\u8d25");
            }
        }
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }

    public Boolean obtainChanges(GitServerDto gitServerDto) {
        List list;
        SysApplication sysApplication = (SysApplication)this.getById(gitServerDto.getAppId());
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean superAdmin = user.isSuperAdmin();
        boolean projectLeader = user.getUserId().equals(sysApplication.getProjectLeader());
        SysAppDeploy sysAppDeploy = new SysAppDeploy();
        if (superAdmin || projectLeader) {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
                sysAppDeploy.setBranchName("dev");
            }
        } else if ("1".equals(sysApplication.getPersonalBrance())) {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"USER_ID", (Object)user.getUserId())).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
            }
        } else {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
            sysAppDeploy.setBranchName("dev");
        }
        String accessToken = this.sysUsersService.getUser(user.getId()).getChar1();
        return true;
    }

    public Boolean commitChanges(GitServerDto gitServerDto) {
        List list;
        SysApplication sysApplication = (SysApplication)this.getById(gitServerDto.getAppId());
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean superAdmin = user.isSuperAdmin();
        boolean projectLeader = user.getId().equals(sysApplication.getProjectLeader());
        SysAppDeploy sysAppDeploy = new SysAppDeploy();
        if (superAdmin || projectLeader) {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
                sysAppDeploy.setBranchName("dev");
            }
        } else if ("1".equals(sysApplication.getPersonalBrance())) {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"USER_ID", (Object)user.getUserId())).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
            }
        } else {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
            sysAppDeploy = (SysAppDeploy)list.get(0);
            sysAppDeploy.setBranchName("dev");
        }
        if (sysAppDeploy.getAppIp() == null || sysAppDeploy.getAppFrontPort() == null) {
            return false;
        }
        String accessToken = this.sysUsersService.getUser(user.getId()).getChar1();
        if (HussarUtils.isNotEmpty((Object)accessToken)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sysAppDeploy", sysAppDeploy);
            data.put("sysApplication", sysApplication);
            data.put("accessToken", accessToken);
            data.put("type", "2");
            String url = "http://" + sysAppDeploy.getThreeLevelDomainFront() + "." + sysAppDeploy.getTwoLevelDomain() + ":" + sysAppDeploy.getAppFrontPort() + "/hussarApi/hussarBase/authorization/newapp/abutmentGitlab";
            this.post(url, data);
        }
        return true;
    }

    public Boolean restoreDelApplication(Long appId) {
        return this.sysApplicationMapper.restoreDelApplication(appId);
    }

    public Page<SysApplicationGroup> pageList(Page page, SysApplication sysApplication) {
        return ((SysApplicationMapper)this.getBaseMapper()).pageList((Page<SysApplicationGroup>)page, sysApplication);
    }
}

