/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.SysUsersApplicationVo;
import com.jxdinfo.hussar.base.portal.application.constant.AppConstants;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppAuthUserMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppAuthUserDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppDeployDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppAuthUser;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDomain;
import com.jxdinfo.hussar.base.portal.application.model.SysAppResource;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthUserService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDomainService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppResourceService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.base.portal.yamlServer.service.IYamlService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppAuthUserServiceImpl")
public class SysAppAuthUserServiceImpl
extends HussarServiceImpl<SysAppAuthUserMapper, SysAppAuthUser>
implements ISysAppAuthUserService {
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    ISysDeployService sysDeployService;
    @Resource
    IYamlService yamlService;
    @Resource
    IGitlabService gitlabService;
    @Resource
    ISysUserRoleService sysUserRoleService;
    @Resource
    ISysApplicationService sysApplicationService;
    @Resource
    SysAppAuthUserMapper sysAppAuthUserMapper;
    @Resource
    ISysAppDomainService sysAppDomainService;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    private ISysAppResourceService sysAppResourceService;

    public List<SysUsersApplicationVo> getUsers(Long appId, String authType) {
        return this.sysAppAuthUserMapper.getUsers(appId, authType);
    }

    public ApiResponse<String> addAuthUser(SysAppAuthUserDto sysAppAuthUserDto) {
        try {
            Long appId = sysAppAuthUserDto.getAppId();
            List userList = sysAppAuthUserDto.getSysAppAuthUserList();
            String authType = sysAppAuthUserDto.getAuthType();
            List authUserList = this.sysAppAuthUserMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId)).eq((Object)"DEL_FLAG", (Object)"0")).eq((Object)"AUTH_TYPE", (Object)authType));
            if (HussarUtils.isNotEmpty((Object)userList) && HussarUtils.isNotEmpty((Object)authUserList)) {
                block2: for (int i = 0; i < authUserList.size(); ++i) {
                    for (int j = 0; j < userList.size(); ++j) {
                        if (!((SysAppAuthUser)authUserList.get(i)).getUserId().equals(((SysAppAuthUser)userList.get(j)).getUserId())) continue;
                        authUserList.remove(i);
                        userList.remove(j);
                        --i;
                        --j;
                        continue block2;
                    }
                }
            }
            this.deleteAndAddUserAuth(authUserList, userList, authType, appId);
            return ApiResponse.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    public ApiResponse<Page<SysAppAuthUser>> getAuthUser(SysAppAuthUserDto sysAppAuthUserDto) {
        Page pager = new Page(sysAppAuthUserDto.getPage().getCurrent(), sysAppAuthUserDto.getPage().getSize());
        return ApiResponse.success(this.sysAppAuthUserMapper.getUserListByUserId((Page<SysAppAuthUser>)pager, sysAppAuthUserDto));
    }

    public Long addDeploy(SysAppDeployDto sysAppDeployDto) {
        Long time = System.currentTimeMillis();
        SysAppDeploy sysAppDeploy = sysAppDeployDto.getSysAppDeploy();
        if (sysAppDeploy != null) {
            sysAppDeploy.setDeployStatus("1");
            sysAppDeploy.setDeployType("2");
            sysAppDeploy.setDelFlag("0");
            sysAppDeploy.setIsPublish("1");
        }
        Boolean onlineAuth = sysAppDeployDto.getOnlineAuth();
        String token = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId()).getChar1();
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppDeploy.getAppId());
        SysAppDeploy sysAppDeployOld = (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysAppDeploy.getAppId())).eq(SysAppDeploy::getUserId, (Object)sysAppDeploy.getUserId())).eq(SysAppDeploy::getDelFlag, (Object)"0"));
        if (sysAppDeployOld == null) {
            Long count = this.sysDeployService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysAppDeploy.getAppId())).eq(SysAppDeploy::getBranchName, (Object)sysAppDeploy.getBranchName()));
            if (count > 0L) {
                throw new BaseException("\u5206\u652f\u540d\u5df2\u5b58\u5728\uff0c\u4e0d\u505a\u64cd\u4f5c");
            }
            new Thread(() -> {
                try {
                    if (onlineAuth.booleanValue()) {
                        this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), token, "dev");
                        this.yamlService.createValues(sysAppDeploy, sysApplication.getAppCreateType(), sysApplication.getAppCode(), time);
                        this.gitlabService.createDevByUser(sysApplication.getAppCreateType(), sysApplication.getAppCode(), sysAppDeploy.getBranchName(), token, time);
                    } else {
                        this.gitlabService.createBranch(sysApplication.getAppCode(), sysAppDeploy.getBranchName(), token);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
                }
            }).start();
            this.sysDeployService.saveSysDeploy(sysAppDeploy);
            this.sysAppResourceService.countApplicationNum(sysApplication.getDevelopResourceId());
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain = new SysAppDomain();
                sysAppDomain.setId(sysAppDeploy.getDomainId());
                sysAppDomain.setDomainStatus("1");
                this.sysAppDomainService.updateStatus(sysAppDomain);
            }
        } else {
            if ("0".equals(sysAppDeployOld.getIsPublish())) {
                this.sysAppResourceService.countApplicationNum(sysApplication.getDevelopResourceId());
            }
            if (sysAppDeploy.getBranchName().equals(sysAppDeployOld.getBranchName())) {
                if (onlineAuth.booleanValue()) {
                    new Thread(() -> {
                        try {
                            this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), token, "dev");
                            this.yamlService.createValues(sysAppDeploy, sysApplication.getAppCreateType(), sysApplication.getAppCode(), time);
                            this.gitlabService.pushToGit(this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), sysApplication.getAppCode(), sysApplication.getAppDescribe(), sysAppDeploy.getBranchName(), token);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
                        }
                    }).start();
                }
                this.sysDeployService.updateDeploy(sysAppDeploy);
            } else {
                Long count = this.sysDeployService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysAppDeploy.getAppId())).eq(SysAppDeploy::getBranchName, (Object)sysAppDeploy.getBranchName()));
                if (count > 0L) {
                    throw new BaseException("\u5206\u652f\u540d\u5df2\u5b58\u5728\uff0c\u4e0d\u505a\u64cd\u4f5c");
                }
                new Thread(() -> {
                    try {
                        if (onlineAuth.booleanValue()) {
                            this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), token, "dev");
                            this.yamlService.createValues(sysAppDeploy, sysApplication.getAppCreateType(), sysApplication.getAppCode(), time);
                            this.gitlabService.createDevByUser(sysApplication.getAppCreateType(), sysApplication.getAppCode(), sysAppDeploy.getBranchName(), token, time);
                        } else {
                            this.gitlabService.createBranch(sysApplication.getAppCode(), sysAppDeploy.getBranchName(), token);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
                    }
                }).start();
                this.sysDeployService.updateDelFlag(sysAppDeploy.getAppId(), sysAppDeploy.getUserId());
                sysAppDeploy.setAppDeployId(Long.valueOf(IdWorker.getId((Object)new SysAppDeploy())));
                this.sysDeployService.saveSysDeploy(sysAppDeploy);
            }
            if (!HussarUtils.isEmpty((Object)sysAppDeployOld.getDomainId())) {
                if (!sysAppDeployOld.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(sysAppDeployOld.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.sysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.sysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.sysAppDomainService.updateStatus(sysAppDomain2);
            }
        }
        return time;
    }

    public Boolean addRoles(String userIds, String userAccounts) {
        List userRoleList = this.sysUserRoleService.selectUserIdByRoleId(String.valueOf(AppConstants.APP_ADMIN_ID));
        if (HussarUtils.isNotEmpty((Object)userIds)) {
            ArrayList<String> userIdList = new ArrayList<String>(Arrays.asList(userIds.split(",")));
            block0: for (int i = 0; i < userRoleList.size(); ++i) {
                for (int j = 0; j < userIdList.size(); ++j) {
                    if (!((String)userRoleList.get(i)).equals(userIdList.get(j))) continue;
                    userRoleList.remove(i);
                    userIdList.remove(j);
                    --i;
                    --j;
                    continue block0;
                }
            }
            this.addUserApplicationAdmin(userIdList);
        }
        this.deleteUserApplicationAdmin(userRoleList);
        return true;
    }

    public List<SysUsersApplicationVo> getRoles() {
        return this.sysAppAuthUserMapper.getRoles();
    }

    public ApiResponse<String> updateAppAuthUser(Long appAuthId, Boolean onlineAuth) {
        try {
            SysAppAuthUser authUser = (SysAppAuthUser)this.getById(appAuthId);
            SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)authUser.getAppId());
            if (onlineAuth.booleanValue()) {
                authUser.setOnlineAuth("1");
                this.gitlabService.inviteUserJoinGroupOrProject(this.sysUsersService.getUser(authUser.getUserId()).getUserAccount(), this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId()).getChar1(), "projects", sysApplication.getAppCode(), false);
                new Thread(() -> {
                    try {
                        this.sysApplicationService.syncDevloper(String.valueOf(authUser.getUserId()), String.valueOf(authUser.getAppId()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            } else {
                int count;
                authUser.setOnlineAuth("0");
                this.gitlabService.deleteUserFGroupOrProject(this.sysUsersService.getUser(authUser.getUserId()).getUserAccount(), this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId()).getChar1(), "projects", sysApplication.getAppCode());
                if ("1".equals(sysApplication.getPersonalBrance()) && (count = this.sysDeployService.getCountByUserId(sysApplication.getId(), authUser.getUserId())) > 0) {
                    SysAppResource sysAppResource = (SysAppResource)this.sysAppResourceService.getById((Serializable)sysApplication.getDevelopResourceId());
                    sysAppResource.setResidueNum(Integer.valueOf(sysAppResource.getResidueNum() + count));
                    sysAppResource.setAssignedNum(Integer.valueOf(sysAppResource.getAssignedNum() - count));
                    this.sysAppResourceService.updateById((Object)sysAppResource);
                    this.sysDeployService.updateIsPublishByUserId(sysApplication.getId(), authUser.getUserId());
                }
            }
            this.updateById((BaseEntity)authUser);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ApiResponse.success();
    }

    public boolean addAuthUserBatch(List<SysAppAuthUser> sysAppAuthUserList) {
        for (int i = 0; i < sysAppAuthUserList.size(); ++i) {
            this.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)sysAppAuthUserList.get(i).getAppId())).eq((Object)"USER_ID", (Object)sysAppAuthUserList.get(i).getUserId()));
        }
        return this.saveBatch(sysAppAuthUserList);
    }

    public Boolean deleteUserApplicationAdmin(List<String> userRoleList) {
        for (String item : userRoleList) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(Long.valueOf(Long.parseLong(item)));
            sysUserRole.setGrantedRole(AppConstants.APP_ADMIN_ID);
            this.sysUserRoleService.removeById((Object)sysUserRole);
            SysUsers sysUsers = this.sysUsersService.getUser(Long.valueOf(Long.parseLong(item)));
            sysUsers.setChar1("");
            this.sysUsersService.updateById((Object)sysUsers);
        }
        return true;
    }

    public Boolean addUserApplicationAdmin(List<String> userIdList) {
        for (int i = 0; i < userIdList.size(); ++i) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(Long.valueOf(Long.parseLong(userIdList.get(i))));
            sysUserRole.setGrantedRole(AppConstants.APP_ADMIN_ID);
            sysUserRole.setAdminOption("1");
            this.sysUserRoleService.save((Object)sysUserRole);
            SysUsers sysUsers = this.sysUsersService.getUser(Long.valueOf(Long.parseLong(userIdList.get(i))));
            SysUsers superAdmin = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
            sysUsers.setChar1(superAdmin.getChar1());
            this.sysUsersService.updateById((Object)sysUsers);
        }
        return true;
    }

    private void deleteAndAddUserAuth(List<SysAppAuthUser> deleteUserList, List<SysAppAuthUser> addUserList, String authType, Long appId) {
        SysApplication appInfo = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
        if (HussarUtils.isNotEmpty(deleteUserList)) {
            for (SysAppAuthUser item : deleteUserList) {
                SysAppDeploy sysAppDeploy;
                int count;
                item.setDelFlag("1");
                if ("1".equals(authType) && "1".equals(appInfo.getIsOnline())) {
                    this.gitlabService.deleteUserFGroupOrProject(this.sysUsersService.getUser(item.getUserId()).getUserAccount(), this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId()).getChar1(), "projects", appInfo.getAppCode());
                }
                this.sysAppAuthUserMapper.update(item, (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"AUTH_TYPE", (Object)authType)).eq((Object)"APP_ID", (Object)appId)).eq((Object)"USER_ID", (Object)item.getUserId()));
                if ("1".equals(appInfo.getPersonalBrance()) && (count = this.sysDeployService.getCountByUserId(appId, item.getUserId())) > 0) {
                    SysAppResource sysAppResource = (SysAppResource)this.sysAppResourceService.getById((Serializable)appInfo.getDevelopResourceId());
                    sysAppResource.setResidueNum(Integer.valueOf(sysAppResource.getResidueNum() + count));
                    sysAppResource.setAssignedNum(Integer.valueOf(sysAppResource.getAssignedNum() - count));
                    this.sysAppResourceService.updateById((Object)sysAppResource);
                }
                if ((sysAppDeploy = this.sysDeployService.getAppDeplyByAppId(appId, item.getUserId())) == null) continue;
                sysAppDeploy.setIsPublish("0");
                this.sysDeployService.updateById((Object)sysAppDeploy);
            }
        }
        if (HussarUtils.isNotEmpty(addUserList)) {
            for (SysAppAuthUser item : addUserList) {
                item.setAppId(appId);
                item.setDelFlag("0");
                item.setOnlineAuth("0");
                if (this.sysUserRoleService.getUserRole(item.getUserId(), AppConstants.DEV_ROLE) < 1) {
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(item.getUserId());
                    sysUserRole.setGrantedRole(AppConstants.DEV_ROLE);
                    sysUserRole.setAdminOption("1");
                    this.sysUserRoleService.save((Object)sysUserRole);
                }
                this.save((BaseEntity)item);
            }
        }
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }

    private Map<String, Object> getDevopsData(SysApplication sysApplication, String branch) {
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("projectId", sysApplication.getProjectId());
        dataMap.put("gitUrl", "http://10.26.4.30:8888/" + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        dataMap.put("branch", branch);
        dataMap.put("templateName", "JXD");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("developer", user.getUserName());
        map.put("version", "7.6.3");
        map.put("projectCode", "jxk-dk");
        dataMap.put("map", map);
        return dataMap;
    }
}

