/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.portal.application.model.SysAppVersion;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppVersionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7248\u672c"})
@RestController(value="com.jxdinfo.hussar.base.portal.group.controller.SysAppVersionController")
@RequestMapping(value={"/hussarBase/application/version"})
public class SysAppVersionController {
    @Resource
    private ISysAppVersionService sysAppVersionService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u7248\u672c", notes="\u83b7\u53d6\u5168\u90e8\u7248\u672c")
    public ApiResponse<List<SysAppVersion>> getVersionList() {
        try {
            return ApiResponse.success((Object)this.sysAppVersionService.list((Wrapper)new QueryWrapper().eq((Object)"DEL_FLAG", (Object)"0")));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/add"})
    @CheckPermission(value={"hussarBase:application:version:add"})
    @ApiOperation(value="\u65b0\u589e\u7248\u672c", notes="\u65b0\u589e\u7248\u672c")
    public ApiResponse<Boolean> addVersion(@ApiParam(value="\u7248\u672c\u5b9e\u4f53") @RequestBody SysAppVersion sysAppVersion) {
        try {
            Wrapper queryWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)sysAppVersion.getAppId())).eq((Object)"VERSION_NUM", (Object)sysAppVersion.getVersionNum());
            if (this.sysAppVersionService.count(queryWrapper) > 0L) {
                return ApiResponse.fail((String)"\u7248\u672c\u53f7\u5df2\u5b58\u5728");
            }
            String regex = "^(V)([0-9]\\d|[0-9])(.([0-9]\\d|\\d)){2}";
            if (!sysAppVersion.getVersionNum().matches(regex)) {
                return ApiResponse.fail((String)"\u8f93\u5165\u7684\u7248\u672c\u53f7\u4e0d\u7b26\u5408\u89c4\u5219");
            }
            sysAppVersion.setVersionType("D");
            return ApiResponse.success((Object)this.sysAppVersionService.save((Object)sysAppVersion));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u4fee\u6539\u7248\u672c", notes="\u4fee\u6539\u7248\u672c")
    public ApiResponse<Boolean> updateVersion(@ApiParam(value="\u7248\u672c\u5b9e\u4f53") @RequestBody SysAppVersion sysAppVersion) {
        try {
            Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)sysAppVersion.getAppId())).eq((Object)"VERSION_NUM", (Object)sysAppVersion.getVersionNum())).ne((Object)"VERSION_ID", (Object)sysAppVersion.getId());
            if (this.sysAppVersionService.count(queryWrapper) > 0L) {
                return ApiResponse.fail((String)"\u7248\u672c\u53f7\u5df2\u5b58\u5728");
            }
            String regex = "^(V)([0-9]\\d|[0-9])(.([0-9]\\d|\\d)){2}";
            if (!sysAppVersion.getVersionNum().matches(regex)) {
                return ApiResponse.fail((String)"\u8f93\u5165\u7684\u7248\u672c\u53f7\u4e0d\u7b26\u5408\u89c4\u5219");
            }
            return ApiResponse.success((Object)this.sysAppVersionService.updateById((Object)sysAppVersion));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/delete"})
    @CheckPermission(value={"hussarBase:application:version:delete"})
    @ApiOperation(value="\u5220\u9664\u7248\u672c", notes="\u5220\u9664\u7248\u672c")
    public ApiResponse<Boolean> deleteVersion(@ApiParam(value="\u7248\u672cid") @RequestParam Long id) {
        try {
            return ApiResponse.success((Object)this.sysAppVersionService.removeById((Serializable)id));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u6839\u636e\u7248\u672cID\u83b7\u53d6\u8be6\u60c5", notes="\u6839\u636e\u7248\u672cID\u83b7\u53d6\u8be6\u60c5")
    public ApiResponse<SysAppVersion> getAppDetail(@ApiParam(value="\u7248\u672cId") @RequestParam Long id) {
        try {
            return ApiResponse.success((Object)this.sysAppVersionService.getById((Serializable)id));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/pageList"})
    @CheckPermission(value={"hussarBase:application:version:pageList"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u7248\u672c\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u5e94\u7528\u7248\u672c\u4fe1\u606f\u5217\u8868")
    public ApiResponse<Page<SysAppVersion>> getPageList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @RequestBody JSONObject jsonObject) {
        try {
            Page page = (Page)jsonObject.toJavaObject(Page.class);
            SysAppVersion sysAppVersion = (SysAppVersion)jsonObject.toJavaObject(SysAppVersion.class);
            AbstractWrapper queryWrapper = ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)sysAppVersion.getAppId())).eq((Object)"DEL_FLAG", (Object)"0")).like(!HussarUtils.isEmpty((Object)sysAppVersion.getVersionNum()), (Object)"VERSION_NUM", (Object)sysAppVersion.getVersionNum())).like(!HussarUtils.isEmpty((Object)sysAppVersion.getVersionDesc()), (Object)"VERSION_DESC", (Object)sysAppVersion.getVersionDesc())).like(!HussarUtils.isEmpty((Object)sysAppVersion.getVersionName()), (Object)"VERSION_NAME", (Object)sysAppVersion.getVersionName());
            return ApiResponse.success((Object)this.sysAppVersionService.page((IPage)page, (Wrapper)queryWrapper));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/import"})
    @CheckPermission(value={"hussarBase:application:version:import"})
    @ApiOperation(value="\u5bfc\u5165\u65b0\u7248\u672c", notes="\u5bfc\u5165\u65b0\u7248\u672c")
    public ApiResponse<Long> importVersion(@ApiParam(value="\u5e94\u7528\u538b\u7f29\u5305") @RequestParam(value="file") MultipartFile file, @ApiParam(value="\u7248\u672c\u4fe1\u606f") @Validated @RequestPart SysAppVersion sysAppVersion) {
        try {
            return ApiResponse.success((Object)this.sysAppVersionService.importVersion(sysAppVersion, file));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/getImportStatus"})
    @ApiOperation(value="\u5bfc\u5165\u7248\u672c", notes="\u5bfc\u5165\u7248\u672c")
    public ApiResponse<Long> getImportStatus(Long time) {
        try {
            return ApiResponse.success((String)this.sysAppVersionService.getImportStatus(time));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/download"})
    @CheckPermission(value={"hussarBase:application:version:download"})
    @ApiOperation(value="\u4e0b\u8f7d\u7248\u672c", notes="\u4e0b\u8f7d\u7248\u672c")
    public void download(Long id, HttpServletResponse response) {
        try {
            this.sysAppVersionService.downVersion(id, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/reset"})
    @CheckPermission(value={"hussarBase:application:version:reset"})
    @ApiOperation(value="\u8fd8\u539f\u7248\u672c", notes="\u8fd8\u539f\u7248\u672c")
    public ApiResponse<Long> reset(Long id) {
        try {
            return ApiResponse.success((Object)this.sysAppVersionService.resetVersion(id));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/checkVersionNum"})
    @ApiOperation(value="\u68c0\u9a8c\u7248\u672c\u53f7\u662f\u5426\u91cd\u590d", notes="\u68c0\u9a8c\u7248\u672c\u53f7\u662f\u5426\u91cd\u590d")
    public ApiResponse<Boolean> checkVersionNum(@ApiParam(value="\u7248\u672c\u53f7") String versionNum, String appId) {
        try {
            Wrapper queryWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId)).eq((Object)"VERSION_NUM", (Object)versionNum);
            return ApiResponse.success((Object)(this.sysAppVersionService.count(queryWrapper) > 0L ? 1 : 0));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/getDownloadFlag"})
    @ApiOperation(value="\u68c0\u9a8c\u7248\u672c\u53f7\u662f\u5426\u91cd\u590d", notes="\u68c0\u9a8c\u7248\u672c\u53f7\u662f\u5426\u91cd\u590d")
    public ApiResponse getDownloadFlag() {
        try {
            return this.sysAppVersionService.getDownloadFlag();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/downloadFile"})
    @ApiOperation(value="\u4e0b\u8f7d\u7248\u672c", notes="\u4e0b\u8f7d\u7248\u672c")
    public void downloadFile(HttpServletResponse response) {
        try {
            this.sysAppVersionService.downloadFile(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

