/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.base.portal.application.constant.AppConstants;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDevelopTeamMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppGroupMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.base.portal.application.dto.AppUserAuthorizeDto;
import com.jxdinfo.hussar.base.portal.application.dto.AppUserQueryDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysUserAppConfigDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDomain;
import com.jxdinfo.hussar.base.portal.application.model.SysAppGroup;
import com.jxdinfo.hussar.base.portal.application.model.SysAppVersion;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDomainService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppVersionService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.base.portal.application.vo.AppOrgUserVo;
import com.jxdinfo.hussar.base.portal.application.vo.AppUserInfoVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppFormTreeVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysUserAppConfigVo;
import com.jxdinfo.hussar.base.portal.form.model.SysForm;
import com.jxdinfo.hussar.base.portal.form.model.SysFormGroup;
import com.jxdinfo.hussar.base.portal.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.base.portal.form.service.ISysFormService;
import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitServerDto;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.base.portal.yamlServer.service.IYamlService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.ExcelUtil;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import org.apache.commons.io.FileUtils;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysApplicationServiceImpl")
public class SysApplicationServiceImpl
extends HussarServiceImpl<SysApplicationMapper, SysApplication>
implements ISysApplicationService {
    @Resource
    private ISysIdtableService sysIdTableService;
    @Resource
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private SysAppGroupMapper sysAppGroupMapper;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormGroupService sysFormGroupService;
    @Resource
    private ISysAppDomainService iSysAppDomainService;
    @Resource
    private ISysFormService formService;
    @Resource
    private ISysAppAuthorizeService sysAppAuthorizeService;
    @Resource
    private ISysAppDevelopTeamService developTeamService;
    @Resource
    private SysAppDevelopTeamMapper developTeamMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysAppDevelopTeamMemberService developTeamMemberService;
    @Resource
    private ISysDeployService sysDeployService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysStruAssistOrganService sysStruAssistOrganService;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    private IYamlService yamlService;
    @Resource
    private IGitlabService gitlabService;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysAppVersionService sysAppVersionService;

    public List<SysAppGroupVo> getAppList(String appName) {
        List<Long> appIds = this.getCurrentUserAuthorityApp();
        if (HussarUtils.isEmpty(appIds)) {
            return null;
        }
        List<Object> appList = new ArrayList();
        ArrayList<Long> groupIds = new ArrayList<Long>();
        appList = this.sysApplicationMapper.getAppList(appName, appIds);
        for (SysApplication sysApplication : appList) {
            groupIds.add(sysApplication.getAppGroupId());
        }
        ArrayList<SysAppGroup> sysAppGroups = new ArrayList();
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysAppGroups = this.sysAppGroupMapper.getAppGroup(null, groupIds);
        }
        ArrayList<SysApplicationVo> arrayList = new ArrayList<SysApplicationVo>();
        for (SysApplication sysApplication : appList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)sysApplication, (Object)vo);
            arrayList.add(vo);
        }
        return this.combinedData(appList, sysAppGroups);
    }

    public List<SysAppGroupVo> getManageAppList(Long appGroupId, String appName, String appStatus) {
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Object> appList = new ArrayList();
        List<Object> sysAppGroups = new ArrayList<SysAppGroup>();
        if (user.isSuperAdmin()) {
            List applicationList = this.sysApplicationMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(!HussarUtils.isEmpty((Object)appGroupId), SysApplication::getAppGroupId, (Object)appGroupId)).like(!HussarUtils.isEmpty((Object)appName), SysApplication::getAppName, (Object)appName)).eq(!HussarUtils.isEmpty((Object)appStatus), SysApplication::getAppStatus, (Object)appStatus)).eq(SysApplication::getDelFlag, (Object)"0"));
            for (int i = 0; i < applicationList.size(); ++i) {
                ((SysApplication)applicationList.get(i)).setAppGitUrl(this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + ((SysApplication)applicationList.get(i)).getAppCode() + ".git");
                appList.add(new SysApplicationVo((SysApplication)applicationList.get(i)));
            }
            if (HussarUtils.isEmpty((Object)appGroupId) && HussarUtils.isEmpty((Object)appName) && HussarUtils.isEmpty((Object)appStatus)) {
                LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                wrapper.eq(SysAppGroup::getDelFlag, (Object)"0");
                wrapper.orderByAsc(SysAppGroup::getGroupType);
                sysAppGroups = this.sysAppGroupService.list((Wrapper)wrapper);
            } else {
                ArrayList<Long> groupIds = new ArrayList<Long>();
                for (SysApplication sysApplication : appList) {
                    groupIds.add(sysApplication.getAppGroupId());
                }
                if (HussarUtils.isNotEmpty(groupIds)) {
                    sysAppGroups = this.sysAppGroupMapper.getAppGroup(null, groupIds);
                }
            }
        } else {
            appList = this.sysApplicationMapper.getAppListNew(user.getId(), appGroupId, appName, appStatus);
            ArrayList<Long> groupIds = new ArrayList<Long>();
            if (HussarUtils.isEmpty((Object)appGroupId) && HussarUtils.isEmpty((Object)appName) && HussarUtils.isEmpty((Object)appStatus)) {
                groupIds.add(AppConstants.DEFAULT_GROUP_ID);
            }
            for (SysApplication sysApplication : appList) {
                sysApplication.setAppGitUrl(this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
                groupIds.add(sysApplication.getAppGroupId());
            }
            if (groupIds.size() > 0) {
                sysAppGroups = this.sysAppGroupMapper.getAppGroup(user.getUserId(), groupIds);
            }
        }
        return this.combinedData(appList, sysAppGroups);
    }

    public Boolean getAppProStatus(Long time) {
        File file = new File(this.gitlabConfigProperty.getTempPath() + File.separator + time);
        return !file.exists();
    }

    public Long updateApp(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = sysApplicationDto.getSysApplication();
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        SysApplication oldApp = (SysApplication)this.getById(sysApplication.getId());
        SysUsers oldLeader = (SysUsers)this.sysUsersService.getById((Serializable)oldApp.getProjectLeader());
        SysUsers newLeader = (SysUsers)this.sysUsersService.getById((Serializable)sysApplication.getProjectLeader());
        SysApplicationServiceImpl that = this;
        if (oldApp.getProjectLeader() != null && !oldApp.getProjectLeader().equals(sysApplication.getProjectLeader())) {
            this.gitlabService.deleteUserFGroupOrProject(oldLeader.getUserAccount(), user.getChar1(), "projects", oldApp.getAppCode());
            this.gitlabService.inviteUserJoinGroupOrProject(newLeader.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(newLeader.getId());
            sysUserRole.setGrantedRole(AppConstants.PROJECT_LEADER_ID);
            sysUserRole.setAdminOption("1");
            if (this.sysUserRoleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUserRole.getUserId())).eq((Object)"GRANTED_ROLE", (Object)sysUserRole.getGrantedRole())) == null) {
                this.sysUserRoleService.save((Object)sysUserRole);
            }
            new Thread(() -> {
                try {
                    that.syncDevloper(String.valueOf(sysApplication.getProjectLeader()), String.valueOf(sysApplication.getId()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
        this.updateById((BaseEntity)sysApplication);
        return time;
    }

    public SysAppDeploy getSysDeployInfo(Long appId, String deployType, Long userId) {
        return this.sysDeployService.getSysDeployInfo(appId, deployType, userId);
    }

    public Long publish(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = (SysApplication)this.getById(sysApplicationDto.getSysApplication().getId());
        SysAppDeploy sysAppDeploy = sysApplicationDto.getSysAppDeploy();
        sysAppDeploy.setDeployStatus("1");
        sysAppDeploy.setDeployType("1");
        sysAppDeploy.setDelFlag("0");
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        Thread thread = new Thread(() -> {
            try {
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken);
                this.yamlService.createValues(sysAppDeploy, sysApplication.getAppCreateType(), sysApplication.getAppCode(), time);
                this.gitlabService.pushToDev(sysApplication.getAppCreateType(), sysApplication.getAppCode(), "\u53d1\u5e03", accessToken, time);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        });
        if (null == sysAppDeploy.getAppDeployId()) {
            sysAppDeploy.setAppId(sysApplication.getId());
            this.sysDeployService.save((Object)sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
            thread.start();
        } else {
            SysAppDeploy oldSysAppDeploy = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            this.sysDeployService.updateDeploy(sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)oldSysAppDeploy.getDomainId())) {
                if (!oldSysAppDeploy.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(oldSysAppDeploy.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.iSysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.iSysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
            if (!oldSysAppDeploy.equals(sysAppDeploy)) {
                thread.start();
            }
        }
        new Thread(() -> {
            try {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("sysApplication", sysApplication);
                String url = "http://" + sysAppDeploy.getAppIp() + ":" + sysAppDeploy.getAppFrontPort() + "/hussarApi/hussarBase/application/saveOrUpdateNewApplication";
                this.post(url, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        return time;
    }

    public Long publishToTestEnvironment(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = (SysApplication)this.getById(sysApplicationDto.getSysApplication().getId());
        SysAppDeploy sysAppDeploy = sysApplicationDto.getSysAppDeploy();
        sysAppDeploy.setDeployType("3");
        sysAppDeploy.setDelFlag("0");
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        new Thread(() -> {
            try {
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken);
                this.yamlService.createValues(sysAppDeploy, sysApplication.getAppCreateType(), sysApplication.getAppCode(), time);
                this.gitlabService.pushToDev(sysApplication.getAppCreateType(), sysApplication.getAppCode(), "\u53d1\u5e03\u6d4b\u8bd5\u73af\u5883\u63d0\u4ea4\u90e8\u7f72\u4fe1\u606f", accessToken, time);
                SysAppVersion sysAppVersion = new SysAppVersion();
                String versionNum = "";
                List versionNumList = this.sysAppVersionService.getVersionNum(sysApplicationDto.getSysApplication().getId(), "D");
                versionNum = versionNumList.size() > 0 ? (String)versionNumList.get(0) : "V1.0.0";
                int count = this.sysAppVersionService.getCount(sysApplication.getId(), "B");
                String versionName = sysApplication.getAppCode() + "_" + versionNum + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_B_T" + (count + 1);
                sysAppVersion.setVersionNum(versionNum);
                sysAppVersion.setVersionDesc(versionNum);
                sysAppVersion.setVersionName(versionName);
                sysAppVersion.setAppId(sysApplication.getId());
                sysAppVersion.setVersionType("B");
                this.sysAppVersionService.saveVersion(sysAppVersion, user);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        if (null == sysAppDeploy.getAppDeployId()) {
            sysAppDeploy.setAppId(sysApplication.getId());
            this.sysDeployService.save((Object)sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        } else {
            SysAppDeploy oldSysAppDeploy = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            this.sysDeployService.updateDeploy(sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)oldSysAppDeploy.getDomainId())) {
                if (!oldSysAppDeploy.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(oldSysAppDeploy.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.iSysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.iSysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        }
        return time;
    }

    public Long publishToFormalEnvironment(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = (SysApplication)this.getById(sysApplicationDto.getSysApplication().getId());
        if (sysApplication != null) {
            sysApplication.setReleaseStatus("1");
            this.updateById((BaseEntity)sysApplication);
        }
        SysAppDeploy sysAppDeploy = sysApplicationDto.getSysAppDeploy();
        sysAppDeploy.setDeployType("4");
        sysAppDeploy.setDelFlag("0");
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        new Thread(() -> {
            try {
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken);
                this.yamlService.createValues(sysAppDeploy, sysApplication.getAppCreateType(), sysApplication.getAppCode(), time);
                this.gitlabService.pushToDev(sysApplication.getAppCreateType(), sysApplication.getAppCode(), "\u53d1\u5e03\u6b63\u5f0f\u73af\u5883\u63d0\u4ea4\u90e8\u7f72\u4fe1\u606f", accessToken, time);
                SysAppVersion sysAppVersion = new SysAppVersion();
                String versionNum = "";
                List versionNumList = this.sysAppVersionService.getVersionNum(sysApplication.getId(), "B");
                int count = this.sysAppVersionService.getCount(sysApplication.getId(), "R");
                versionNum = versionNumList.size() > 0 ? (String)versionNumList.get(0) : "V1.0.0";
                if (count > 0) {
                    int num = 0;
                    String[] numArray = versionNum.split("\\.");
                    num = Integer.parseInt(numArray[2]) + 1;
                    versionNum = numArray[0] + "." + numArray[1] + "." + num;
                }
                String versionName = sysApplication.getAppCode() + "_" + versionNum + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_R";
                sysAppVersion.setVersionNum(versionNum);
                sysAppVersion.setVersionDesc(versionNum);
                sysAppVersion.setVersionName(versionName);
                sysAppVersion.setAppId(sysApplication.getId());
                sysAppVersion.setVersionType("R");
                this.sysAppVersionService.saveVersion(sysAppVersion, user);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        new Thread(() -> {
            try {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("sysApplication", sysApplication);
                String url = "http://" + sysAppDeploy.getAppIp() + ":" + sysAppDeploy.getAppFrontPort() + "/hussarApi/hussarBase/application/saveOrUpdateNewApplication";
                this.post(url, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        if (null == sysAppDeploy.getAppDeployId()) {
            sysAppDeploy.setAppId(sysApplication.getId());
            this.sysDeployService.save((Object)sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        } else {
            SysAppDeploy oldSysAppDeploy = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            this.sysDeployService.updateDeploy(sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)oldSysAppDeploy.getDomainId())) {
                if (!oldSysAppDeploy.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(oldSysAppDeploy.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.iSysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.iSysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        }
        return time;
    }

    public SysApplication getApplicationInfo() {
        return this.sysApplicationMapper.getApplicationInfo();
    }

    @HussarTransactional
    public Boolean deleteApp(Long appId) {
        SysApplication appInfo = (SysApplication)this.getById(appId);
        if ("1".equals(appInfo.getAppStatus())) {
            return false;
        }
        appInfo.setDelFlag("1");
        return this.updateById((BaseEntity)appInfo);
    }

    public ApiResponse<SysApplicationVo> getAppDetail(Long appId) {
        SysApplicationVo sysApplicationVo = this.sysApplicationMapper.getAppDetail(appId);
        return ApiResponse.success((Object)sysApplicationVo);
    }

    public Long copyApplication(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        SysApplication sysApplication = sysApplicationDto.getSysApplication();
        SysApplication application = (SysApplication)this.getById(sysApplication.getId());
        Long appId = IdWorker.getId((Object)new SysApplication());
        sysApplication.setId(appId);
        sysApplication.setAppStatus("1");
        sysApplication.setReleaseStatus("0");
        sysApplication.setDelFlag("0");
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
        new Thread(() -> {
            try {
                this.gitlabService.pullToLocal(application.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken);
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode() + File.separator + ".git"));
                this.gitlabService.createProject(sysApplication.getAppCreateType(), sysApplication.getAppCode(), sysApplication.getAppDescribe(), accessToken, time);
                this.gitlabService.inviteUserJoinGroupOrProject(projectLeaderUser.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(projectLeaderUser.getId());
        sysUserRole.setGrantedRole(AppConstants.PROJECT_LEADER_ID);
        sysUserRole.setAdminOption("1");
        if (this.sysUserRoleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUserRole.getUserId())).eq((Object)"GRANTED_ROLE", (Object)sysUserRole.getGrantedRole())) == null) {
            this.sysUserRoleService.save((Object)sysUserRole);
        }
        this.save((BaseEntity)sysApplication);
        return time;
    }

    public Boolean updateAppStatus(Long appId, String appStatus) {
        SysApplication sysApplication = (SysApplication)this.getById(appId);
        if ("0".equals(appStatus) && "0".equals(sysApplication.getReleaseStatus())) {
            return false;
        }
        sysApplication.setAppStatus(appStatus);
        try {
            SysAppDeploy sysAppDeploy = this.sysDeployService.getDeployByDeployType(appId);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sysApplication", sysApplication);
            String url = "http://" + sysAppDeploy.getAppIp() + ":" + sysAppDeploy.getAppFrontPort() + "/hussarApi/hussarBase/application/saveOrUpdateNewApplication";
            this.post(url, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.updateById((BaseEntity)sysApplication);
    }

    public ApiResponse<SysApplicationDto> getAppDetailAndDeploy(Long appId) {
        SysApplicationDto sysApplicationDto = new SysApplicationDto();
        SysAppDeploy sysAppDeploy = new SysAppDeploy();
        SecurityUser user = BaseSecurityUtil.getUser();
        Boolean superAdmin = user.isSuperAdmin();
        Boolean projectLeader = user.getRolesList().contains(AppConstants.PROJECT_LEADER_ID);
        Boolean applicationLeader = user.getRolesList().contains(AppConstants.APP_ADMIN_ID);
        sysAppDeploy = superAdmin != false || projectLeader != false || applicationLeader != false ? this.sysDeployService.getAppDeploy(appId, null, "1") : this.sysDeployService.getAppDeploy(appId, user.getId(), "2");
        SysApplication sysApplication = this.sysApplicationMapper.getAppDetailContainUserName(appId);
        sysApplicationDto.setSysAppDeploy(sysAppDeploy);
        sysApplication.setAppGitUrl(this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        sysApplicationDto.setSysApplication(sysApplication);
        return ApiResponse.success((Object)sysApplicationDto);
    }

    public SysApplicationVo getAuthorityAppDetail(Long appId) {
        SecurityUser user;
        List dataFormGroup;
        Boolean authorityFlag = this.validateAuthorityByAppId(appId);
        if (!authorityFlag.booleanValue()) {
            throw new HussarException("\u60a8\u6ca1\u6709\u8be5\u5e94\u7528\u7684\u8bbf\u95ee\u6743\u9650");
        }
        boolean designedOrNotFlag = false;
        List dataForm = (List)this.formService.getSysFormByAppId(appId).getData();
        if (HussarUtils.isNotEmpty((Object)dataForm)) {
            designedOrNotFlag = true;
        }
        if (!designedOrNotFlag && HussarUtils.isNotEmpty((Object)(dataFormGroup = (List)this.sysFormGroupService.getFormGroupList(appId).getData()))) {
            designedOrNotFlag = true;
        }
        Boolean hasAuthorityCreateForm = (user = BaseSecurityUtil.getUser()).isSuperAdmin() || user.getRolesList().contains(AppConstants.APP_ADMIN_ID) ? Boolean.valueOf(true) : this.developTeamService.checkCurrentUserInTeam(appId);
        SysApplicationVo appDetail = this.sysApplicationMapper.getAppDetail(appId);
        appDetail.setDesignedOrNot(Boolean.valueOf(designedOrNotFlag));
        appDetail.setHasAuthorityCreateForm(hasAuthorityCreateForm);
        return appDetail;
    }

    public Boolean updateSecretKey(Long appId) {
        SysApplication sysApplication = new SysApplication();
        sysApplication.setId(appId);
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        return this.updateById((BaseEntity)sysApplication);
    }

    public String getCurrentCode() {
        return this.sysIdTableService.getCurrentCode("APP_CODE", "SYS_APPLICATION");
    }

    public ApiResponse<List<SysAppFormTreeVo>> getAppFormList(Long appId) {
        ArrayList<SysAppFormTreeVo> treeList = new ArrayList<SysAppFormTreeVo>();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            SysApplication sysApplication = (SysApplication)this.getById(appId);
            SysAppFormTreeVo appTreeVo = new SysAppFormTreeVo();
            appTreeVo.setLabel(sysApplication.getAppName());
            appTreeVo.setId(sysApplication.getId().toString());
            appTreeVo.setHasChildren(Boolean.valueOf(true));
            appTreeVo.setType(1);
            treeList.add(appTreeVo);
        } else {
            List applicationList = this.list();
            for (Object sysApplication : applicationList) {
                SysAppFormTreeVo appTreeVo = new SysAppFormTreeVo();
                appTreeVo.setLabel(sysApplication.getAppName());
                appTreeVo.setId(sysApplication.getId().toString());
                appTreeVo.setHasChildren(Boolean.valueOf(true));
                appTreeVo.setType(1);
                treeList.add(appTreeVo);
            }
        }
        LambdaQueryWrapper formWrapper = Wrappers.lambdaQuery();
        formWrapper.eq(HussarUtils.isNotEmpty((Object)appId), SysFormGroup::getAppId, (Object)appId);
        formWrapper.orderByAsc(SysFormGroup::getSeq);
        List formGroupList = this.sysFormGroupService.list((Wrapper)formWrapper);
        for (SysFormGroup sysFormGroup : formGroupList) {
            SysAppFormTreeVo formGroupTreeVo = new SysAppFormTreeVo();
            formGroupTreeVo.setId(sysFormGroup.getId().toString());
            formGroupTreeVo.setLabel(sysFormGroup.getGroupName());
            formGroupTreeVo.setParentId(sysFormGroup.getAppId().toString());
            formGroupTreeVo.setIcon(sysFormGroup.getGroupIcon());
            formGroupTreeVo.setType(2);
            treeList.add(formGroupTreeVo);
        }
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(HussarUtils.isNotEmpty((Object)appId), SysForm::getAppId, (Object)appId);
        queryWrapper2.orderByAsc(SysForm::getSeq);
        List formList = this.sysFormService.list((Wrapper)queryWrapper2);
        for (SysForm sysForm : formList) {
            SysAppFormTreeVo formTreeVo = new SysAppFormTreeVo();
            formTreeVo.setId(sysForm.getId().toString());
            formTreeVo.setLabel(sysForm.getFormName());
            if (HussarUtils.isEmpty((Object)sysForm.getFormGroupId())) {
                formTreeVo.setParentId(sysForm.getAppId().toString());
            } else {
                formTreeVo.setParentId(sysForm.getFormGroupId().toString());
            }
            formTreeVo.setIcon(sysForm.getFormIcon());
            formTreeVo.setType(3);
            treeList.add(formTreeVo);
        }
        return ApiResponse.success((Object)HussarTreeParser.getTreeList(treeList));
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplication sysApplication : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplication> sysApplicationList = new ArrayList<SysApplication>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        ArrayList<SysAppGroupVo> res = new ArrayList<SysAppGroupVo>(resultCollect.values());
        Collections.sort(res, new Comparator<SysAppGroupVo>(){

            @Override
            public int compare(SysAppGroupVo o1, SysAppGroupVo o2) {
                return o1.getCreateTime().compareTo(o2.getCreateTime());
            }
        });
        return res;
    }

    public Boolean validateAuthorityByAppId(Long appId) {
        List currentUserRoleList;
        HashSet currentUserRoleSet;
        ApiResponse appRoleList = this.sysAppAuthorizeService.getAppRoleList(appId);
        List roleVoList = (List)appRoleList.getData();
        if (HussarUtils.isEmpty((Object)roleVoList)) {
            return false;
        }
        Set authorityRoleSet = roleVoList.stream().map(RoleVo::getId).collect(Collectors.toSet());
        Sets.SetView intersectionSet = Sets.intersection(authorityRoleSet, currentUserRoleSet = new HashSet(currentUserRoleList = BaseSecurityUtil.getUser().getRolesList()));
        if (HussarUtils.isEmpty((Object)intersectionSet)) {
            return false;
        }
        return true;
    }

    public List<Long> getCurrentUserAuthorityApp() {
        return this.sysAppAuthorizeService.getCurrentUserAuthorityApp();
    }

    public IPage<AppOrgUserVo> getAppOrgUser(Page<AppOrgUserVo> page, AppUserQueryDto appUserQueryDto) {
        SysStru stru;
        SecurityUser user = BaseSecurityUtil.getUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", appUserQueryDto.getOrgId());
        map.put("appId", appUserQueryDto.getAppId());
        map.put("account", SqlQueryUtil.transferSpecialChar((String)appUserQueryDto.getAccount()));
        map.put("name", SqlQueryUtil.transferSpecialChar((String)appUserQueryDto.getName()));
        map.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        String struFid = "/";
        if (HussarUtils.isNotEmpty((Object)appUserQueryDto.getOrgId()) && HussarUtils.isNotEmpty((Object)(stru = (SysStru)this.sysStruMapper.selectById((Serializable)appUserQueryDto.getOrgId())))) {
            struFid = stru.getStruFid();
        }
        map.put("struFid", OrganUtil.convert((String)SqlQueryUtil.transferSpecialChar((String)struFid)));
        Long orgId = appUserQueryDto.getOrgId();
        if (ToolUtil.isNotEmpty((Object)user) && user.isGradeadmin()) {
            Long deptId = user.getDeptId();
            if (ToolUtil.isEmpty((Object)deptId)) {
                return page;
            }
            int checkResult = 1;
            if (ToolUtil.isNotEmpty((Object)orgId) && !"11".equals(String.valueOf(orgId))) {
                checkResult = this.sysStruMapper.checkIsGradeStru(deptId, orgId);
            }
            if (checkResult == 1) {
                if (!ToolUtil.isEmpty((Object)orgId)) {
                    List<AppOrgUserVo> roleOrgUserVoList = this.sysApplicationMapper.getAppOrgUser(page, map);
                    page.setRecords(roleOrgUserVoList);
                    return page;
                }
                List<Object> roleOrgUserVoList = this.sysApplicationMapper.getAppOrgUserNoPage(map);
                roleOrgUserVoList = roleOrgUserVoList.stream().filter(o -> !o.getAccount().contains("admin") && !o.getAccount().contains("hussar")).collect(Collectors.toList());
                Long struId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getEmployeeId();
                Long gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
                List userStruIdList = this.sysStruService.getChildOrgId(gradeParentId, "02");
                userStruIdList.add(BaseSecurityUtil.getUser().getId());
                QueryWrapper sysUsersQueryWrapper = new QueryWrapper();
                sysUsersQueryWrapper.lambda().in(SysUsers::getEmployeeId, (Collection)userStruIdList);
                List userIdList = this.sysUsersService.list((Wrapper)sysUsersQueryWrapper).stream().map(SysUsers::getId).collect(Collectors.toList());
                roleOrgUserVoList = roleOrgUserVoList.stream().filter(o -> userIdList.contains(o.getId())).collect(Collectors.toList());
                int current = Integer.parseInt(String.valueOf(page.getCurrent()));
                int size = Integer.parseInt(String.valueOf(page.getSize()));
                ArrayList<Object> appOrgUserVoLists = new ArrayList<Object>();
                int num = (current - 1) * size;
                if (num < roleOrgUserVoList.size()) {
                    for (int i = (current - 1) * size; i < size * current && num < roleOrgUserVoList.size(); ++num, ++i) {
                        appOrgUserVoLists.add(roleOrgUserVoList.get(i));
                    }
                }
                page.setRecords(appOrgUserVoLists);
                page.setTotal((long)roleOrgUserVoList.size());
            }
        } else {
            page.setRecords(this.sysApplicationMapper.getAppOrgUser(page, map));
        }
        return page;
    }

    public String getContainerAccessAddress(SysUserAppConfigDto sysUserAppConfigDto) {
        String containerAccessAddress = this.sysApplicationMapper.getContainerAccessAddress(sysUserAppConfigDto);
        if (ToolUtil.isNotEmpty((Object)containerAccessAddress)) {
            return containerAccessAddress;
        }
        throw new BaseException("\u8be5\u5e94\u7528\u7528\u6237\u6682\u65e0\u914d\u7f6e\u5e94\u7528\u5730\u5740\uff01");
    }

    public Page<AppUserInfoVo> getApplicationUserList(Page<AppUserInfoVo> page, Long appId, String userName) {
        return this.sysApplicationMapper.getApplicationUserList(page, appId, userName);
    }

    public Boolean addUserAuthorize(AppUserAuthorizeDto appUserAuthorizeDto) {
        List userIds = appUserAuthorizeDto.getUserIds();
        if (HussarUtils.isEmpty((Object)userIds)) {
            throw new HussarException("\u8bf7\u5173\u8054\u7528\u6237");
        }
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appUserAuthorizeDto.getAppId()));
        this.developTeamMemberService.removeById((Serializable)sysAppDevelopTeam.getId());
        ArrayList<SysAppDevelopTeamMember> sysAppDevelopTeamMembers = new ArrayList<SysAppDevelopTeamMember>();
        for (Long userId : userIds) {
            SysAppDevelopTeamMember sysAppDevelopTeamMember = new SysAppDevelopTeamMember();
            sysAppDevelopTeamMember.setTeamId(sysAppDevelopTeam.getId());
            sysAppDevelopTeamMember.setUserId(userId);
            sysAppDevelopTeamMembers.add(sysAppDevelopTeamMember);
        }
        return this.developTeamMemberService.saveBatch(sysAppDevelopTeamMembers);
    }

    public Boolean addUserConfig(SysUserAppConfigDto sysUserAppConfigDto) {
        return null;
    }

    public SysUserAppConfigVo getUserConfig(SysUserAppConfigDto sysUserAppConfigDto) {
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)sysUserAppConfigDto.getAppId()));
        SysAppDevelopTeamMember developTeamMember = (SysAppDevelopTeamMember)this.developTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getUserId, (Object)sysUserAppConfigDto.getUserId())).eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        SysUserAppConfigVo sysUserAppConfigVo = new SysUserAppConfigVo();
        BeanUtils.copyProperties((Object)developTeamMember, (Object)sysUserAppConfigVo);
        return sysUserAppConfigVo;
    }

    public Boolean checkUser(String userAccount) {
        SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaUpdateWrapper().eq(SysUsers::getUserAccount, (Object)userAccount));
        return HussarUtils.isNotEmpty((Object)user);
    }

    @HussarTransactional
    public String syncDevloper(String ids, String appId) {
        SysAppDeploy sysAppDeploy = (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEL_FLAG", (Object)"0")).eq((Object)"APP_ID", (Object)appId)).eq((Object)"DEPLOY_TYPE", (Object)"1"));
        String containerPath = sysAppDeploy.getAppIp() + ":" + sysAppDeploy.getAppFrontPort();
        if (containerPath == null || "".equals(containerPath)) {
            throw new BaseException("\u5e94\u7528\u5730\u5740\u9519\u8bef\uff0c\u540c\u6b65\u7528\u6237\u5230\u5e94\u7528\u5931\u8d25\uff01");
        }
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (int i = 0; i < idArray.length; ++i) {
            idList.add(Long.parseLong(idArray[i]));
        }
        List users = this.sysUsersService.listByIds(idList);
        ArrayList<Long> empIdList = new ArrayList<Long>();
        for (int i = 0; i < users.size(); ++i) {
            empIdList.add(((SysUsers)users.get(i)).getEmployeeId());
        }
        List strus = this.sysStruService.listByIds(empIdList);
        Wrapper staffQueryWrapper = (Wrapper)new QueryWrapper().in((Object)"STRU_ID", empIdList);
        List staffs = this.sysStaffService.list(staffQueryWrapper);
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (int i = 0; i < strus.size(); ++i) {
            orgIdList.add(((SysStru)strus.get(i)).getOrganId());
        }
        List organs = this.sysOrganService.listByIds(orgIdList);
        Wrapper struAssistOrganQueryWrapper = (Wrapper)new QueryWrapper().in((Object)"STRU_ID", empIdList);
        List sysStruAssistOrgan = this.sysStruAssistOrganService.list(struAssistOrganQueryWrapper);
        ArrayList<String> organFcode = new ArrayList<String>();
        for (int i = 0; i < organs.size(); ++i) {
            organFcode.add(((SysOrgan)organs.get(i)).getOrganFcode());
        }
        List organList = this.sysOrganService.getFOrganListByOrganFcode(organFcode);
        ArrayList<Long> organId = new ArrayList<Long>();
        for (int i = 0; i < organList.size(); ++i) {
            organId.add(((SysOrgan)organList.get(i)).getId());
        }
        List struList = this.sysStruService.list((Wrapper)new QueryWrapper().in((Object)"ORGAN_ID", organId));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", struList);
        data.put("organs", organList);
        data.put("staffs", staffs);
        data.put("users", users);
        data.put("sysStruAssistOrgan", sysStruAssistOrgan);
        String url = containerPath + "/hussarApi/hussarBase/application/importData";
        this.post(url, data);
        return "success";
    }

    public String importData(JSONObject data) {
        try {
            List strus = JSONArray.parseArray((String)IdempotentJsonUtils.toString((Object)data.get((Object)"strus")), SysStru.class);
            List organs = JSONArray.parseArray((String)IdempotentJsonUtils.toString((Object)data.get((Object)"organs")), SysOrgan.class);
            List staffs = JSONArray.parseArray((String)IdempotentJsonUtils.toString((Object)data.get((Object)"staffs")), SysStaff.class);
            List users = JSONArray.parseArray((String)IdempotentJsonUtils.toString((Object)data.get((Object)"users")), SysUsers.class);
            List sysStruAssistOrgan = JSONArray.parseArray((String)IdempotentJsonUtils.toString((Object)data.get((Object)"sysStruAssistOrgan")), SysStruAssistOrgan.class);
            this.insertOrUpdateList(strus);
            this.insertOrUpdateList(organs);
            this.insertOrUpdateList(staffs);
            this.insertOrUpdateList(users);
            this.insertOrUpdateList(sysStruAssistOrgan);
            for (int i = 0; i < users.size(); ++i) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(((SysUsers)users.get(i)).getId());
                sysUserRole.setGrantedRole(AppConstants.DEV_ROLE);
                sysUserRole.setAdminOption("1");
                if (this.sysUserRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUserRole.getUserId())).eq((Object)"GRANTED_ROLE", (Object)AppConstants.DEV_ROLE)).size() == 0) {
                    this.sysUserRoleService.save((Object)sysUserRole);
                }
                sysUserRole.setGrantedRole(AppConstants.PUBLIC_ROLE);
                if (this.sysUserRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUserRole.getUserId())).eq((Object)"GRANTED_ROLE", (Object)AppConstants.PUBLIC_ROLE)).size() != 0) continue;
                this.sysUserRoleService.save((Object)sysUserRole);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "fail";
        }
        return "success";
    }

    public ApiResponse importExcelApplication(MultipartFile file) {
        try {
            List list;
            JSONObject json = ExcelUtil.getJsonFromXlsWithNullValue((byte[])file.getBytes(), (int)1, null);
            String code = json.getString("code");
            Map data = (Map)json.get((Object)"data");
            String appGroup = (String)data.get("appGroup");
            String domainName = (String)data.get("domainName");
            String databaseType = (String)data.get("databaseType");
            String appTypeWeb = (String)data.get("appTypeWeb");
            String appTypeApp = (String)data.get("appTypeApp");
            String appTypeProcedure = (String)data.get("appTypeProcedure");
            String isOnline = (String)data.get("isOnline");
            data.put("appGroupId", "");
            data.put("domainId", "");
            if (HussarUtils.isNotEmpty((Object)appGroup) && HussarUtils.isNotEmpty((Object)(list = this.sysAppGroupService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_NAME", (Object)appGroup)).eq((Object)"DEL_FLAG", (Object)"0"))))) {
                data.put("appGroupId", ((SysAppGroup)list.get(0)).getId());
            }
            if (HussarUtils.isNotEmpty((Object)domainName) && HussarUtils.isNotEmpty((Object)(list = this.iSysAppDomainService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DOMAIN_NAME", (Object)domainName)).eq((Object)"DEL_FLAG", (Object)"0")).eq((Object)"DOMAIN_STATUS", (Object)"0"))))) {
                data.put("domainId", ((SysAppDomain)list.get(0)).getId());
            }
            if (HussarUtils.isNotEmpty((Object)databaseType)) {
                switch (databaseType) {
                    case "Oracle": {
                        databaseType = "1";
                        break;
                    }
                    case "Mysql": {
                        databaseType = "2";
                        break;
                    }
                    case "\u8fbe\u68a6": {
                        databaseType = "3";
                        break;
                    }
                    case "\u795e\u901a": {
                        databaseType = "4";
                        break;
                    }
                    case "PgSQL": {
                        databaseType = "5";
                        break;
                    }
                    case "SQL Server": {
                        databaseType = "6";
                        break;
                    }
                    case "\u91d1\u4ed3": {
                        databaseType = "7";
                        break;
                    }
                    default: {
                        databaseType = null;
                    }
                }
                data.put("databaseType", databaseType);
            }
            if (HussarUtils.isNotEmpty((Object)appTypeWeb)) {
                if ("\u662f".equals(appTypeWeb)) {
                    data.put("appTypeWeb", 1);
                } else {
                    data.put("appTypeWeb", null);
                }
            }
            if (HussarUtils.isNotEmpty((Object)appTypeApp)) {
                if ("\u662f".equals(appTypeApp)) {
                    data.put("appTypeApp", 2);
                } else {
                    data.put("appTypeApp", null);
                }
            }
            if (HussarUtils.isNotEmpty((Object)appTypeProcedure)) {
                if ("\u662f".equals(appTypeProcedure)) {
                    data.put("appTypeProcedure", 3);
                } else {
                    data.put("appTypeProcedure", null);
                }
            }
            if ("\u662f".equals(isOnline)) {
                data.put("isOnline", "1");
            } else if ("\u5426".equals(isOnline)) {
                data.put("isOnline", "0");
            }
            if ("200".equals(code) && HussarUtils.isNotEmpty((Object)data)) {
                return ApiResponse.success((Object)data);
            }
            if (data.size() == 0) {
                return ApiResponse.fail((String)json.getString("\u8bf7\u5728\u6a21\u677f\u4e2d\u8fdb\u884c\u586b\u5199\u5e94\u7528\u90e8\u7f72\u4fe1\u606f"));
            }
            return ApiResponse.fail((String)json.getString("\u5bfc\u5165\u5931\u8d25"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
    }

    public void downloadTemplate(HttpServletResponse response, Map map) throws IOException {
        String filePath = (String)map.get("filePath");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        org.springframework.core.io.Resource resource = resolver.getResource("classpath:file\\application\\" + filePath);
        File file = File.createTempFile("tmp", filePath.substring(filePath.indexOf(".") + 1));
        try {
            FileUtils.copyInputStreamToFile((InputStream)resource.getInputStream(), (File)file);
            SysApplicationServiceImpl.download(file, response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException();
        }
        finally {
            file.deleteOnExit();
        }
    }

    public static void download(File file, HttpServletResponse response) {
        try {
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Length", "" + file.length());
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/" + file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(".") + 1) + ";charset=utf-8");
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer updateStaff = 0;
        Integer insertStaff = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object object = objects.get(i);
                if (object instanceof SysStru) {
                    SysStru stru = (SysStru)object;
                    if (this.sysEmployeeService.updateById((Object)stru)) {
                        if (stru.getStruType().equals("9")) {
                            n2 = updateStaff;
                            n = updateStaff = Integer.valueOf(updateStaff + 1);
                        }
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysEmployeeService.save((Object)stru);
                        if (stru.getStruType().equals("9")) {
                            n2 = insertStaff;
                            n = insertStaff = Integer.valueOf(insertStaff + 1);
                        }
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrgan) {
                    SysOrgan organ = (SysOrgan)object;
                    if (SqlHelper.retBool((Integer)this.sysOrganMapper.updateById((Object)organ))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganMapper.insert((Object)organ);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysStaff) {
                    SysStaff sysStaff = (SysStaff)object;
                    if (SqlHelper.retBool((Integer)this.sysStaffMapper.updateById((Object)sysStaff))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStaffMapper.insert((Object)sysStaff);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysUsers) {
                    SysUsers sysUsers = (SysUsers)object;
                    if (SqlHelper.retBool((Integer)this.sysUsersMapper.updateById((Object)sysUsers))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysUsersMapper.insert((Object)sysUsers);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysStruAssistOrgan) {
                    SysStruAssistOrgan sysStruAssistOrgan = (SysStruAssistOrgan)object;
                    if (SqlHelper.retBool((Integer)this.sysStruAssistOrganMapper.updateById((Object)sysStruAssistOrgan))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStruAssistOrganMapper.insert((Object)sysStruAssistOrgan);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
        }
        result.put("update", update);
        result.put("updateStaff", updateStaff);
        result.put("insertStaff", insertStaff);
        result.put("insert", insert);
        return result;
    }

    private void post(String url, Map<String, Object> map) {
        try (HttpResponse res = null;){
            res = ((HttpRequest)((HttpRequest)HttpRequest.post((String)url).timeout(90000).contentType("application/json", "UTF-8")).bodyText(IdempotentJsonUtils.toString(map), "application/json", "utf-8")).send();
            res.charset("utf-8");
            if (res.bodyText().equals("fail")) {
                this.log.error(res.bodyText());
                throw new BaseException("\u64cd\u4f5c\u5931\u8d25");
            }
        }
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }

    public Boolean obtainChanges(GitServerDto gitServerDto) {
        List list;
        SysApplication sysApplication = (SysApplication)this.getById(gitServerDto.getAppId());
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean superAdmin = user.isSuperAdmin();
        boolean projectLeader = user.getUserId().equals(sysApplication.getProjectLeader());
        SysAppDeploy sysAppDeploy = new SysAppDeploy();
        if (superAdmin || projectLeader) {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
                sysAppDeploy.setBranchName("dev");
            }
        } else {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"USER_ID", (Object)user.getUserId())).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
            }
        }
        String accessToken = this.sysUsersService.getUser(user.getId()).getChar1();
        return true;
    }

    public Boolean commitChanges(GitServerDto gitServerDto) {
        List list;
        SysApplication sysApplication = (SysApplication)this.getById(gitServerDto.getAppId());
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean superAdmin = user.isSuperAdmin();
        boolean projectLeader = user.getId().equals(sysApplication.getProjectLeader());
        SysAppDeploy sysAppDeploy = new SysAppDeploy();
        if (superAdmin || projectLeader) {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
                sysAppDeploy.setBranchName("dev");
            }
        } else {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"USER_ID", (Object)user.getUserId())).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
            }
        }
        if (sysAppDeploy.getAppIp() == null || sysAppDeploy.getAppFrontPort() == null) {
            return false;
        }
        String accessToken = this.sysUsersService.getUser(user.getId()).getChar1();
        if (HussarUtils.isNotEmpty((Object)accessToken)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sysAppDeploy", sysAppDeploy);
            data.put("sysApplication", sysApplication);
            data.put("accessToken", accessToken);
            data.put("type", "2");
            String url = "http://" + sysAppDeploy.getAppIp() + ":" + sysAppDeploy.getAppFrontPort() + "/hussarApi/hussarBase/application/abutmentGitlab";
            this.post(url, data);
        }
        return true;
    }

    public ApiResponse abutmentGitlab(Map<String, Object> dataMap) {
        Long time = System.currentTimeMillis();
        try {
            if (dataMap != null) {
                SysApplication sysApplication = (SysApplication)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataMap.get("sysApplication")), SysApplication.class);
                SysAppDeploy sysAppDeploy = (SysAppDeploy)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataMap.get("sysAppDeploy")), SysAppDeploy.class);
                String accessToken = (String)dataMap.get("accessToken");
                String type = (String)dataMap.get("type");
                if (HussarUtils.isEmpty((Object)accessToken)) {
                    ApiResponse apiResponse = ApiResponse.fail((String)"\u4e2a\u4eba\u7528\u6237\u4ee4\u724c\u4e3a\u7a7a");
                    return apiResponse;
                }
                GitServerDto gitServerDto = new GitServerDto();
                gitServerDto.setToken(accessToken);
                gitServerDto.setBranch(sysAppDeploy.getBranchName());
                gitServerDto.setAppCode(sysApplication.getAppCode());
                if ("1".equals(type)) {
                    this.gitlabService.pull2local(gitServerDto);
                } else if ("2".equals(type)) {
                    this.gitlabService.push2remote(gitServerDto);
                }
            } else {
                ApiResponse.fail((String)"\u53c2\u6570\u4f20\u8f93\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
        }
        return ApiResponse.success();
    }
}

