/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.constant.AppConstants;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDeployMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDomainMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppTemplateMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppTemplate;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppTemplateService;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.file.ZipFile;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppTemplateImpl")
public class SysAppTemplateImpl
extends HussarServiceImpl<SysAppTemplateMapper, SysAppTemplate>
implements ISysAppTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppTemplateImpl.class);
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private IGitlabService gitlabService;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    public SysAppDeployMapper sysAppDeployMapper;
    @Autowired
    public SysAppDomainMapper sysAppDomainMapper;
    @Autowired
    public SysUserRoleMapper sysUserRoleMapper;
    private static final String importCache = "IMPORT_CACHE";

    public boolean removeById(Serializable id) {
        SysAppTemplate sysAppTemplate = (SysAppTemplate)super.getById(id);
        sysAppTemplate.setDelFlag("1");
        File file = new File(sysAppTemplate.getTemplatePath());
        file.delete();
        return super.updateById((BaseEntity)sysAppTemplate);
    }

    public Long importTemplate(MultipartFile multipartFile, SysAppTemplate sysAppTemplate) throws IOException {
        Long time = System.currentTimeMillis();
        if (ToolUtil.isEmpty((Object)multipartFile)) {
            throw new BaseException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileName = sysAppTemplate.getTemplateName() + ".zip";
        String path = this.gitlabConfigProperty.getTemplatePath() + File.separator + fileName;
        String tempPath = this.gitlabConfigProperty.getTempPath() + File.separator + time;
        HussarCacheUtil.put((String)importCache, (Object)time, (Object)"loading...", (long)600L);
        File tempFile = new File(path);
        multipartFile.transferTo(tempFile);
        new Thread(() -> {
            try {
                ZipFile.unzip((String)path, (String)tempPath, (Charset)Charset.forName("GBK"));
                if (this.checkFile(tempPath)) {
                    sysAppTemplate.setTemplatePath(path);
                    this.save((BaseEntity)sysAppTemplate);
                    HussarCacheUtil.put((String)importCache, (Object)time, (Object)"success", (long)600L);
                } else {
                    tempFile.delete();
                    HussarCacheUtil.put((String)importCache, (Object)time, (Object)"\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42", (long)600L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                HussarCacheUtil.put((String)importCache, (Object)time, (Object)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u89e3\u538b\u9519\u8bef\uff0c\u5e94\u4e3a.zip\u683c\u5f0f\u4e14\u80fd\u6b63\u5e38\u89e3\u538b", (long)600L);
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        return time;
    }

    public String getImportStatus(Long time) {
        return (String)HussarCacheUtil.get((String)importCache, (Object)time);
    }

    private boolean checkFile(String path) {
        File file = new File(path);
        File[] files = file.listFiles();
        if (files.length == 4 && new File(path + File.separator + "hussar-web").exists() && new File(path + File.separator + "hussar-front").exists() && new File(path + File.separator + "\u5168\u91cfsql").exists() && new File(path + File.separator + ".gitignore").exists()) {
            return true;
        }
        return files.length == 5 && new File(path + File.separator + "hussar-web").exists() && new File(path + File.separator + "hussar-front").exists() && new File(path + File.separator + "hussar-mobile").exists() && new File(path + File.separator + "\u5168\u91cfsql").exists() && new File(path + File.separator + ".gitignore").exists();
    }

    public void downloadTemplate(Long id, HttpServletResponse response) {
        SysAppTemplate sysAppTemplate = (SysAppTemplate)this.getById(id);
        String filePath = sysAppTemplate.getTemplatePath();
        String fileName = sysAppTemplate.getTemplateName() + ".zip";
        File file = new File(filePath);
        try (FileInputStream fis = new FileInputStream(file);
             ServletOutputStream os = response.getOutputStream();){
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            IOUtils.copy((InputStream)fis, (OutputStream)os, (int)4096);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @HussarTransactional
    public Long addApp(SysApplicationDto sysApplicationDto) {
        Long currentTime = System.currentTimeMillis();
        SysApplication sysApplication = sysApplicationDto.getSysApplication();
        List sysApplications = this.sysApplicationMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)sysApplication.getAppCode())).or()).eq(SysApplication::getAppName, (Object)sysApplication.getAppName()));
        if (ToolUtil.isNotEmpty((Object)sysApplications)) {
            throw new BaseException("\u5e94\u7528\u540d\u79f0\u6216\u5e94\u7528\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        sysApplication.setAppStatus("1");
        sysApplication.setReleaseStatus("0");
        sysApplication.setDelFlag("0");
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        SysAppTemplateImpl that = this;
        SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(projectLeaderUser.getId());
        sysUserRole.setGrantedRole(AppConstants.PROJECT_LEADER_ID);
        sysUserRole.setAdminOption("1");
        if (this.sysUserRoleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUserRole.getUserId())).eq((Object)"GRANTED_ROLE", (Object)sysUserRole.getGrantedRole())) == null) {
            this.sysUserRoleMapper.insert((Object)sysUserRole);
        }
        this.sysApplicationMapper.insert(sysApplication);
        new Thread(() -> {
            try {
                this.gitlabService.createDir(sysApplication.getAppCode(), currentTime);
                SysAppTemplate sysAppTemplate = (SysAppTemplate)that.getById(sysApplication.getTemplateId());
                String filePath = "";
                filePath = AppConstants.TEMPLATE_HUSSAR.equals(sysAppTemplate.getId()) ? this.gitlabConfigProperty.getTemplatePath() + File.separator + "hussar.zip" : sysAppTemplate.getTemplatePath();
                ZipFile.unzip((String)filePath, (String)(this.gitlabConfigProperty.getTempPath() + File.separator + currentTime + File.separator + sysApplication.getAppCode()), (Charset)Charset.forName("GBK"));
                String accessToken = user.getChar1();
                this.gitlabService.createProject(sysApplication.getAppCreateType(), sysApplication.getAppCode(), sysApplication.getAppDescribe(), accessToken, currentTime);
                this.gitlabService.inviteUserJoinGroupOrProject(projectLeaderUser.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + currentTime));
            }
        }).start();
        return currentTime;
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }

    private void post(String url, Map<String, Object> map) {
        try (HttpResponse res = null;){
            res = ((HttpRequest)((HttpRequest)HttpRequest.post((String)url).timeout(90000).contentType("application/json", "UTF-8")).bodyText(IdempotentJsonUtils.toString(map), "application/json", "utf-8")).send();
            res.charset("utf-8");
            if (res.bodyText().equals("fail")) {
                throw new BaseException("\u540c\u6b65\u7528\u6237\u5230\u5e94\u7528\u5931\u8d25\uff01");
            }
        }
    }
}

