/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppAuthMapper;
import com.jxdinfo.hussar.base.portal.application.model.SysAppAuth;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthService;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppAuthVo;
import com.jxdinfo.hussar.base.portal.license.config.LicenseClientProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.rest.client.ApiClient;
import com.jxdinfo.hussar.rest.model.RequestBody;
import com.jxdinfo.hussar.rest.token.TokenUtil;
import com.jxdinfo.hussar.rest.util.Base64;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppAuthServiceImpl")
@HussarDs(value="master")
public class SysAppAuthServiceImpl
extends HussarServiceImpl<SysAppAuthMapper, SysAppAuth>
implements ISysAppAuthService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppAuthServiceImpl.class);
    @Autowired
    private LicenseClientProperties licenseClientProperties;
    @Resource
    private ISysUsersService sysUsersService;

    public boolean save(SysAppAuth sysAppAuth) {
        Long userId = BaseSecurityUtil.getUser().getId();
        sysAppAuth.setCheckStatus("0");
        sysAppAuth.setUserId(userId);
        sysAppAuth.setApplyTime(LocalDateTime.now());
        SysUsers sysUsers = (SysUsers)this.sysUsersService.getById((Serializable)userId);
        Long id = IdWorker.getId((Object)new SysAppAuth());
        sysAppAuth.setId(id);
        sysAppAuth.setProcessKey("bpm_sqshlc");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userAccount", sysUsers.getUserAccount());
        map.put("userName", sysUsers.getUserName());
        map.put("authType", sysAppAuth.getAuthType());
        map.put("createTime", sysAppAuth.getApplyTime());
        map.put("authCode", sysAppAuth.getAuthCode());
        map.put("authCreateTime", sysAppAuth.getAuthCreateTime());
        map.put("authEndTime", sysAppAuth.getAuthEndTime());
        map.put("remark", sysAppAuth.getRemark());
        JSONObject res = InstanceEngineService.startProcessInstanceByKey((String)sysAppAuth.getProcessKey(), (String)String.valueOf(userId), (String)String.valueOf(sysAppAuth.getId()), map).getResult().getJSONObject(0);
        sysAppAuth.setProcessInstanceId(res.getString("processInsId"));
        TaskEngineService.completeTask((String)res.getString("taskId"), (String)String.valueOf(userId), (String)sysAppAuth.getRemark(), null);
        return super.save((BaseEntity)sysAppAuth);
    }

    public boolean removeById(Serializable id) {
        SysAppAuth sysAppAuth = (SysAppAuth)super.getById(id);
        sysAppAuth.setDelFlag("1");
        return super.updateById((BaseEntity)sysAppAuth);
    }

    public Page<SysAppAuthVo> pageList(Page page, SysAppAuthVo sysAppAuthVo) {
        return ((SysAppAuthMapper)this.getBaseMapper()).pageList((Page<SysAppAuthVo>)page, sysAppAuthVo);
    }

    public boolean audit(JSONObject jsonObject) {
        String taskId = jsonObject.getString("taskId");
        String opinion = jsonObject.getString("opinion");
        String checkStatus = jsonObject.getString("checkStatus");
        SecurityUser user = BaseSecurityUtil.getUser();
        if ("1".equals(checkStatus)) {
            return "1".equals(TaskEngineService.completeTask((String)taskId, (String)String.valueOf(user.getId()), (String)opinion, null).getCode());
        }
        return "1".equals(TaskEngineService.rejectToLastTask((String)taskId, (String)String.valueOf(user.getId()), (String)opinion, (boolean)false, null).getCode());
    }

    public void downloadAuthFile(Long id, HttpServletResponse response) throws IOException {
        SysAppAuth sysAppAuth = (SysAppAuth)this.getById(id);
        String licenseId = sysAppAuth.getAuthType();
        RequestBody body = new RequestBody();
        if ("1".equals(licenseId)) {
            body.setIsDev(Boolean.valueOf(true));
            body.setType("V8-dev");
            body.setCode(sysAppAuth.getAuthCode());
            body.setName(this.sysUsersService.getUser(sysAppAuth.getUserId()).getUserName());
            body.setStartDate(sysAppAuth.getAuthCreateTime());
            body.setEndDate(sysAppAuth.getAuthEndTime());
        }
        if ("2".equals(licenseId)) {
            body.setType("V8");
            body.setCode(sysAppAuth.getAuthCode());
            body.setName(this.sysUsersService.getUser(sysAppAuth.getUserId()).getUserName());
            body.setStartDate(sysAppAuth.getAuthCreateTime());
            body.setEndDate(sysAppAuth.getAuthEndTime());
        }
        if ("3".equals(licenseId)) {
            body.setIsBatch(Boolean.valueOf(true));
            body.setType("V8-vol");
            body.setCode("Y8UN2BCE47-CFAELT4DE5-2DGNXMLV4D-NZEJRYAEVN");
            body.setName("\u6d4b\u8bd5-H");
            body.setStartDate("2022-07-03");
            body.setEndDate("2022-08-09");
            body.setQuantity(Integer.valueOf(100));
        }
        JSONObject exJsonObject = new JSONObject();
        exJsonObject.put("remarks", (Object)"\u6388\u6743\u5907\u6ce8\u4fe1\u606f");
        body.setExtendJson(exJsonObject.toJSONString());
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)body);
        ApiClient client = new ApiClient();
        String token = TokenUtil.getAccessToken((String)this.licenseClientProperties.getLicenseServerIp(), (String)this.licenseClientProperties.getLicenseServerPort(), (String)this.licenseClientProperties.getLicenseServerUserName(), (String)this.licenseClientProperties.getLicenseServerPassword());
        if (token == null) {
            logger.info("\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u8ba4\u8bc1token");
            response.setHeader("Content-Type", "text/html;charset=utf-8");
            response.getWriter().print("\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u8ba4\u8bc1token");
            return;
        }
        String license = client.getLicense(jsonObject, this.licenseClientProperties.getLicenseServerHeader(), token, this.licenseClientProperties.getLicenseServerIp(), this.licenseClientProperties.getLicenseServerPort());
        JSONObject licenseJSON = JSONObject.parseObject((String)license);
        String success = licenseJSON.getString("success");
        if (Boolean.valueOf(success).booleanValue()) {
            String fileName = licenseJSON.getString("fileName");
            String fileContent = licenseJSON.getString("fileContent");
            this.decodeToResponse(fileName, fileContent, response);
        } else {
            response.setHeader("Content-Type", "text/html;charset=utf-8");
            response.getWriter().print(JSON.toJSONString((Object)licenseJSON));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeToResponse(String fileName, String fileContent, HttpServletResponse response) {
        InputStream in = null;
        try {
            byte[] bytes = Base64.decode((byte[])fileContent.getBytes("UTF-8"));
            in = new ByteArrayInputStream(bytes);
            response.setContentType("multipart/form-data");
            response.addHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            int b = 0;
            byte[] buffer = new byte[512];
            while (b != -1) {
                b = in.read(buffer);
                if (b == -1) continue;
                response.getOutputStream().write(buffer, 0, b);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                response.getOutputStream().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("\u5173\u95ed\u6587\u4ef6IOException!");
            }
        }
    }
}

