/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.portal.application.model.SysAppAuth;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthService;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppAuthVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6388\u6743\u4fe1\u606f"})
@RestController(value="com.jxdinfo.hussar.base.portal.group.controller.SysAppAuthController")
@RequestMapping(value={"/hussarBase/application/auth"})
public class SysAppAuthController {
    @Resource
    private ISysAppAuthService sysAppAuthService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u6388\u6743\u4fe1\u606f", notes="\u83b7\u53d6\u5168\u90e8\u6388\u6743\u4fe1\u606f")
    public ApiResponse<List<SysAppAuth>> getDomainList() {
        try {
            return ApiResponse.success((Object)this.sysAppAuthService.list((Wrapper)new QueryWrapper().eq((Object)"DEL_FLAG", (Object)"0")));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/add"})
    @CheckPermission(value={"hussarBase:application:auth:add"})
    @ApiOperation(value="\u65b0\u589e\u6388\u6743\u4fe1\u606f", notes="\u65b0\u589e\u6388\u6743\u4fe1\u606f")
    public ApiResponse<Boolean> addDomain(@ApiParam(value="\u6388\u6743\u4fe1\u606f\u5b9e\u4f53") @RequestBody SysAppAuth sysAppAuth) {
        try {
            return ApiResponse.success((Object)this.sysAppAuthService.save((Object)sysAppAuth));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/audit"})
    @CheckPermission(value={"hussarBase:application:auth:audit"})
    @ApiOperation(value="\u5ba1\u6838\u6388\u6743\u4fe1\u606f", notes="\u5ba1\u6838\u6388\u6743\u4fe1\u606f")
    public ApiResponse<Boolean> auditDomain(@ApiParam(value="\u6388\u6743\u4fe1\u606f\u5b9e\u4f53") @RequestBody JSONObject jsonObject) {
        try {
            return ApiResponse.success((Object)this.sysAppAuthService.audit(jsonObject));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u4fee\u6539\u6388\u6743\u4fe1\u606f", notes="\u4fee\u6539\u6388\u6743\u4fe1\u606f")
    public ApiResponse<Boolean> updateDomain(@ApiParam(value="\u6388\u6743\u4fe1\u606f\u5b9e\u4f53") @RequestBody SysAppAuth sysAppAuth) {
        try {
            Wrapper queryWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"AUTH_CODE", (Object)sysAppAuth.getAuthCode())).ne((Object)"AUTH_ID", (Object)sysAppAuth.getId());
            if (this.sysAppAuthService.count(queryWrapper) > 0L) {
                return ApiResponse.fail((String)"\u6388\u6743\u4fe1\u606f\u5df2\u5b58\u5728");
            }
            return ApiResponse.success((Object)this.sysAppAuthService.updateById((Object)sysAppAuth));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u6388\u6743\u4fe1\u606f", notes="\u5220\u9664\u6388\u6743\u4fe1\u606f")
    public ApiResponse<Boolean> deleteDomain(@ApiParam(value="\u6388\u6743\u4fe1\u606fid") @RequestParam Long id) {
        try {
            return ApiResponse.success((Object)this.sysAppAuthService.removeById((Serializable)id));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/detail"})
    @CheckPermission(value={"hussarBase:application:auth:detail"})
    @ApiOperation(value="\u6839\u636e\u6388\u6743\u4fe1\u606fID\u83b7\u53d6\u8be6\u60c5", notes="\u6839\u636e\u6388\u6743\u4fe1\u606fID\u83b7\u53d6\u8be6\u60c5")
    public ApiResponse<SysAppAuth> getAppDetail(@ApiParam(value="\u6388\u6743\u4fe1\u606fId") @RequestParam Long id) {
        try {
            return ApiResponse.success((Object)this.sysAppAuthService.getById((Serializable)id));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/download"})
    @CheckPermission(value={"hussarBase:application:auth:download"})
    @ApiOperation(value="\u4e0b\u8f7d\u6388\u6743\u6587\u4ef6", notes="\u4e0b\u8f7d\u6388\u6743\u6587\u4ef6")
    public void download(Long id, HttpServletResponse response) {
        try {
            this.sysAppAuthService.downloadAuthFile(id, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/pageList"})
    @CheckPermission(value={"hussarBase:application:auth:pageList"})
    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5217\u8868")
    public ApiResponse<Page<SysAppAuthVo>> getPageList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @RequestBody JSONObject jsonObject) {
        try {
            Page page = (Page)jsonObject.toJavaObject(Page.class);
            SysAppAuthVo sysAppAuthVo = (SysAppAuthVo)jsonObject.toJavaObject(SysAppAuthVo.class);
            return ApiResponse.success((Object)this.sysAppAuthService.pageList(page, sysAppAuthVo));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/checkAuthCode"})
    @ApiOperation(value="\u68c0\u9a8c\u6388\u6743\u7801\u662f\u5426\u91cd\u590d", notes="\u68c0\u9a8c\u6388\u6743\u7801\u662f\u5426\u91cd\u590d")
    public ApiResponse<Boolean> checkName(@ApiParam(value="\u6388\u6743\u4fe1\u606f\u6388\u6743\u7801") @RequestParam String code) {
        try {
            Wrapper queryWrapper = (Wrapper)new QueryWrapper().eq((Object)"AUTH_CODE", (Object)code);
            return ApiResponse.success((Object)(this.sysAppAuthService.count(queryWrapper) > 0L ? 1 : 0));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

