/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.constant.AppConstants;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDeployMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDomainMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppRecordLogMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppRecordMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppTemplateMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecord;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecordLog;
import com.jxdinfo.hussar.base.portal.application.model.SysAppTemplate;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppTemplateService;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.file.ZipFile;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppTemplateImpl")
public class SysAppTemplateImpl
extends HussarServiceImpl<SysAppTemplateMapper, SysAppTemplate>
implements ISysAppTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppTemplateImpl.class);
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private IGitlabService gitlabService;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    public SysAppDeployMapper sysAppDeployMapper;
    @Autowired
    public SysAppDomainMapper sysAppDomainMapper;
    private static final String importCache = "IMPORT_CACHE";
    @Autowired
    private SysAppRecordMapper sysAppRecordMapper;
    @Autowired
    private SysAppRecordLogMapper sysAppRecordLogMapper;

    public boolean removeById(Serializable id) {
        SysAppTemplate sysAppTemplate = (SysAppTemplate)super.getById(id);
        sysAppTemplate.setDelFlag("1");
        File file = new File(sysAppTemplate.getTemplatePath());
        file.delete();
        return super.updateById((BaseEntity)sysAppTemplate);
    }

    public Long importTemplate(MultipartFile multipartFile, SysAppTemplate sysAppTemplate) throws IOException {
        Long time = System.currentTimeMillis();
        if (ToolUtil.isEmpty((Object)multipartFile)) {
            throw new BaseException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileName = sysAppTemplate.getTemplateName() + ".zip";
        String path = this.gitlabConfigProperty.getTemplatePath() + File.separator + fileName;
        String tempPath = this.gitlabConfigProperty.getTempPath() + File.separator + time;
        HussarCacheUtil.put((String)importCache, (Object)time, (Object)"loading...", (long)600L);
        File tempFile = new File(path);
        multipartFile.transferTo(tempFile);
        new Thread(() -> {
            try {
                ZipFile.unzip((String)path, (String)tempPath, (Charset)Charset.forName("GBK"));
                if (this.checkFile(tempPath)) {
                    sysAppTemplate.setTemplatePath(path);
                    this.save((BaseEntity)sysAppTemplate);
                    HussarCacheUtil.put((String)importCache, (Object)time, (Object)"success", (long)600L);
                } else {
                    tempFile.delete();
                    HussarCacheUtil.put((String)importCache, (Object)time, (Object)"\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42", (long)600L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                HussarCacheUtil.put((String)importCache, (Object)time, (Object)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u89e3\u538b\u9519\u8bef\uff0c\u5e94\u4e3a.zip\u683c\u5f0f\u4e14\u80fd\u6b63\u5e38\u89e3\u538b", (long)600L);
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        return time;
    }

    public String getImportStatus(Long time) {
        return (String)HussarCacheUtil.get((String)importCache, (Object)time);
    }

    private boolean checkFile(String path) {
        File file = new File(path);
        File[] files = file.listFiles();
        if (files.length == 5 && new File(path + File.separator + "hussar-web").exists() && new File(path + File.separator + "hussar-front").exists() && new File(path + File.separator + "sql").exists() && new File(path + File.separator + ".gitignore").exists() && new File(path + File.separator + "hussar-config").exists()) {
            return true;
        }
        return files.length == 6 && new File(path + File.separator + "hussar-web").exists() && new File(path + File.separator + "hussar-front").exists() && new File(path + File.separator + "hussar-mobile").exists() && new File(path + File.separator + "sql").exists() && new File(path + File.separator + ".gitignore").exists() && new File(path + File.separator + "hussar-config").exists();
    }

    public void downloadTemplate(Long id, HttpServletResponse response) {
        SysAppTemplate sysAppTemplate = (SysAppTemplate)this.getById(id);
        String filePath = this.gitlabConfigProperty.getTemplatePath() + File.separator + sysAppTemplate.getTemplateName() + ".zip";
        String fileName = sysAppTemplate.getTemplateName() + ".zip";
        File file = new File(filePath);
        try (FileInputStream fis = new FileInputStream(file);
             ServletOutputStream os = response.getOutputStream();){
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(sysAppTemplate.getTemplateName() + ".zip", StandardCharsets.UTF_8.name()));
            IOUtils.copy((InputStream)fis, (OutputStream)os, (int)4096);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @HussarTransactional
    public Long addApp(SysApplicationDto sysApplicationDto) {
        LocalDateTime log1StartTime = LocalDateTime.now();
        Long currentTime = System.currentTimeMillis();
        SysApplication sysApplication = sysApplicationDto.getSysApplication();
        List sysApplications = this.sysApplicationMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)sysApplication.getAppCode())).or()).eq(SysApplication::getAppName, (Object)sysApplication.getAppName()));
        if (ToolUtil.isNotEmpty((Object)sysApplications)) {
            throw new BaseException("\u5e94\u7528\u540d\u79f0\u6216\u5e94\u7528\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        sysApplication.setAppStatus("2");
        sysApplication.setReleaseStatus("0");
        sysApplication.setDelFlag("0");
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        SysAppTemplateImpl that = this;
        SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(projectLeaderUser.getId());
        sysUserRole.setGrantedRole(AppConstants.PROJECT_LEADER_ID);
        sysUserRole.setAdminOption("1");
        if (this.sysUserRoleService.getUserRole(sysUserRole.getUserId(), sysUserRole.getGrantedRole()) < 1) {
            this.sysUserRoleService.save((Object)sysUserRole);
        }
        this.sysApplicationMapper.insert(sysApplication);
        SysAppRecord sysAppRecord = new SysAppRecord();
        sysAppRecord.setAppId(sysApplication.getId());
        sysAppRecord.setRecordType("1");
        sysAppRecord.setPipelineType("\u5e94\u7528\u521b\u5efa");
        sysAppRecord.setStatus("1");
        this.sysAppRecordMapper.insert(sysAppRecord);
        SysAppRecordLog recordLog1 = new SysAppRecordLog();
        recordLog1.setRecordId(sysAppRecord.getId());
        recordLog1.setLogInfo("\u4fdd\u5b58\u5e94\u7528\u4fe1\u606f");
        recordLog1.setStartTime(log1StartTime);
        recordLog1.setEndTime(LocalDateTime.now());
        recordLog1.setStatus("0");
        this.sysAppRecordLogMapper.insert(recordLog1);
        new Thread(() -> {
            LocalDateTime failStartTime = recordLog1.getEndTime();
            String logInfo = "\u4e0b\u8f7d\u5e76\u89e3\u538b\u6a21\u677f\u6e90\u7801";
            try {
                this.gitlabService.createDir(sysApplication.getAppCode(), currentTime);
                SysAppTemplate sysAppTemplate = (SysAppTemplate)that.getById(sysApplication.getTemplateId());
                String filePath = this.gitlabConfigProperty.getTemplatePath() + File.separator + sysAppTemplate.getTemplateName() + ".zip";
                String tempPath = this.gitlabConfigProperty.getTempPath() + File.separator + currentTime + File.separator + sysApplication.getAppCode();
                ZipFile.unzip((String)filePath, (String)tempPath, (Charset)Charset.forName("GBK"));
                if ("1".equals(sysApplication.getAppType())) {
                    this.deleteFile(new File(tempPath + File.separator + "hussar-mobile"));
                }
                SysAppRecordLog recordLog2 = new SysAppRecordLog();
                recordLog2.setRecordId(sysAppRecord.getId());
                recordLog2.setLogInfo(logInfo);
                recordLog2.setStartTime(recordLog1.getEndTime());
                recordLog2.setEndTime(LocalDateTime.now());
                recordLog2.setStatus("0");
                this.sysAppRecordLogMapper.insert(recordLog2);
                logInfo = "\u521b\u5efagit\u9879\u76ee\u5e76\u4e0a\u4f20\u6e90\u7801";
                failStartTime = recordLog2.getEndTime();
                String accessToken = user.getChar1();
                this.gitlabService.createProject(sysApplication.getAppCode(), sysApplication.getAppDescribe(), "\u521b\u5efa\u5e94\u7528", accessToken, currentTime);
                SysAppRecordLog recordLog3 = new SysAppRecordLog();
                recordLog3.setRecordId(sysAppRecord.getId());
                recordLog3.setLogInfo(logInfo);
                recordLog3.setStartTime(recordLog2.getEndTime());
                recordLog3.setEndTime(LocalDateTime.now());
                recordLog3.setStatus("0");
                this.sysAppRecordLogMapper.insert(recordLog3);
                logInfo = "git\u9879\u76ee\u6388\u6743\u5e94\u7528\u8d1f\u8d23\u4eba";
                failStartTime = recordLog3.getEndTime();
                this.gitlabService.inviteUserJoinGroupOrProject(projectLeaderUser.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
                SysAppRecordLog recordLog4 = new SysAppRecordLog();
                recordLog4.setRecordId(sysAppRecord.getId());
                recordLog4.setLogInfo(logInfo);
                recordLog4.setStartTime(recordLog3.getEndTime());
                recordLog4.setEndTime(LocalDateTime.now());
                recordLog4.setStatus("0");
                this.sysAppRecordLogMapper.insert(recordLog4);
                logInfo = "\u5e94\u7528\u521b\u5efa\u6210\u529f";
                failStartTime = recordLog4.getEndTime();
                SysAppRecordLog recordLog5 = new SysAppRecordLog();
                recordLog5.setRecordId(sysAppRecord.getId());
                recordLog5.setLogInfo(logInfo);
                recordLog5.setStartTime(recordLog4.getEndTime());
                recordLog5.setEndTime(LocalDateTime.now());
                recordLog5.setStatus("0");
                this.sysAppRecordLogMapper.insert(recordLog5);
                sysAppRecord.setStatus("2");
                this.sysAppRecordMapper.updateById(sysAppRecord);
            }
            catch (Exception e) {
                e.printStackTrace();
                SysAppRecordLog recordLogFail = new SysAppRecordLog();
                recordLogFail.setRecordId(sysAppRecord.getId());
                recordLogFail.setLogInfo(logInfo);
                recordLogFail.setStartTime(failStartTime);
                recordLogFail.setEndTime(LocalDateTime.now());
                recordLogFail.setStatus("1");
                recordLogFail.setErrInfo(e.getMessage());
                this.sysAppRecordLogMapper.insert(recordLogFail);
                sysAppRecord.setStatus("3");
                this.sysAppRecordMapper.updateById(sysAppRecord);
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + currentTime));
            }
        }).start();
        return sysApplication.getId();
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }
}

