/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDevopsMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppDevopsDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevops;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecord;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecordLog;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevopsService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecordLogService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecordService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppResourceService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.DESUtil;
import com.jxdinfo.hussar.common.utils.DevopsUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppDevopsServiceImpl")
public class SysAppDevopsServiceImpl
extends HussarServiceImpl<SysAppDevopsMapper, SysAppDevops>
implements ISysAppDevopsService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppDevopsServiceImpl.class);
    @Value(value="${devops.uri.devops-uri}")
    private String devopsUri;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    private SysAppDevopsMapper sysAppDevopsMapper;
    @Resource
    private ISysDeployService sysDeployService;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    ISysApplicationService sysApplicationService;
    @Resource
    ISysAppResourceService sysAppResourceService;
    @Resource
    ISysAppRecordService sysAppRecordService;
    @Resource
    ISysAppRecordLogService sysAppRecordLogService;

    public JSONObject createProjectAndPipeline(SysApplication sysApplication, SysAppDeploy sysAppDeploy, String branch, SysAppRecord sysAppRecord) {
        String[] appTypeArray;
        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
        sysAppRecordLog.setRecordId(sysAppRecord.getId());
        sysAppRecordLog.setLogInfo("\u9879\u76ee\u6784\u5efa");
        sysAppRecordLog.setStatus("2");
        sysAppRecordLog.setType("1");
        sysAppRecordLog.setStartTime(LocalDateTime.now());
        this.sysAppRecordLogService.save((Object)sysAppRecordLog);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> project = new HashMap<String, String>();
        project.put("projectCode", sysApplication.getAppCode());
        project.put("projectName", sysApplication.getAppName());
        String frontType = "";
        for (String appType : appTypeArray = sysApplication.getAppType().split(",")) {
            frontType = "".equals(frontType) ? SysAppDevopsServiceImpl.getAppType(appType) : frontType + "," + SysAppDevopsServiceImpl.getAppType(appType);
        }
        project.put("projectType", frontType);
        project.put("projectCategory", "project");
        project.put("projectTemplateId", "project-template-default");
        dataMap.put("project", project);
        dataMap.put("gitUrl", this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        dataMap.put("branch", branch);
        dataMap.put("templateName", "lcdp");
        dataMap.put("databaseType", SysAppDevopsServiceImpl.databaseType(sysAppDeploy.getDatabasetType()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("databaseIp", sysAppDeploy.getDatabaseUrl());
        map.put("databasePort", sysAppDeploy.getDatabasePort());
        map.put("databaseName", sysAppDeploy.getDatabaseName());
        map.put("databaseUser", sysAppDeploy.getDatabaseAccount());
        map.put("databasePassword", DESUtil.encrypt((String)"qddt@2023", (String)sysAppDeploy.getDatabasePassword()));
        int version = 0;
        SysAppDevops sysAppDevops = (SysAppDevops)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)branch));
        version = sysAppDevops != null ? sysAppDevops.getVersion() + 1 : 1;
        map.put("version", "v" + version);
        map.put("releas", sysApplication.getAppCode() + "-dev");
        map.put("imageRepo", sysAppDeploy.getAppNamespace());
        map.put("sqlPath", this.getSqlPath(sysAppDeploy.getDatabasetType()));
        dataMap.put("map", map);
        String urlDevops = this.devopsUri + "api/integration/ddm";
        logger.info("\u5bf9\u63a5devops\u521b\u5efa\u9879\u76ee\uff0c\u6784\u5efa\u6d41\u6c34\u7ebf\u63a5\u53e3\u53c2\u6570\uff1aurl\uff1a-------> {};param:----------->{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u5bf9\u63a5devops\u521b\u5efa\u9879\u76ee\uff0c\u6784\u5efa\u6d41\u6c34\u7ebf\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1ajson:-->{},", (Object)json);
        json.put("version", (Object)version);
        json.put("releas", (Object)(sysApplication.getAppCode() + "-" + branch));
        if ("200".equals(json.getString("statusCode"))) {
            sysAppRecordLog.setStatus("0");
            if ("1".equals(sysAppDeploy.getDeployType()) || "2".equals(sysAppDeploy.getDeployType())) {
                sysAppRecord.setDefinitionId(json.getString("devDefinitionId"));
            } else if ("3".equals(sysAppDeploy.getDeployType())) {
                sysAppRecord.setDefinitionId(json.getString("testDefinitionId"));
            } else if ("4".equals(sysAppDeploy.getDeployType())) {
                sysAppRecord.setDefinitionId(json.getString("prodDefinitionId"));
            }
        } else {
            sysAppRecordLog.setStatus("1");
            sysAppRecordLog.setErrInfo(json.getString("errorLocalizedMessage"));
            sysAppRecord.setStatus("3");
        }
        sysAppRecordLog.setEndTime(LocalDateTime.now());
        this.sysAppRecordLogService.updateById((Object)sysAppRecordLog);
        this.sysAppRecordService.updateById((Object)sysAppRecord);
        logger.info("\u6d41\u6c34\u7ebf\u65e5\u5fd7\u4fe1\u606fsysAppRecordLog\uff1a-------->{}", (Object)sysAppRecordLog);
        return json;
    }

    public JSONObject executePipeline(String definitionId, String version, String frontType, String isInit, String env, String branch, SysAppDeploy sysAppDeploy, SysAppRecord sysAppRecord) {
        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
        sysAppRecordLog.setRecordId(sysAppRecord.getId());
        sysAppRecordLog.setLogInfo("\u6784\u5efa\u6d41\u6c34\u7ebf");
        sysAppRecordLog.setStatus("2");
        sysAppRecordLog.setType("1");
        sysAppRecordLog.setStartTime(LocalDateTime.now());
        this.sysAppRecordLogService.save((Object)sysAppRecordLog);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> project = new HashMap<String, String>();
        project.put("version", version);
        project.put("databaseIp", sysAppDeploy.getDatabaseUrl());
        project.put("databasePort", sysAppDeploy.getDatabasePort());
        project.put("databaseName", sysAppDeploy.getDatabaseName());
        project.put("databaseUser", sysAppDeploy.getDatabaseAccount());
        project.put("databasePassword", DESUtil.encrypt((String)"qddt@2023", (String)sysAppDeploy.getDatabasePassword()));
        project.put("sqlPath", this.getSqlPath(sysAppDeploy.getDatabasetType()));
        project.put("imageRepo", sysAppDeploy.getAppNamespace());
        project.put("branch", branch);
        dataMap.put("buildParams", project);
        dataMap.put("env", env);
        dataMap.put("frontType", frontType);
        dataMap.put("isInit", isInit);
        String urlDevops = this.devopsUri + "api/integration/ddm/" + definitionId + "/execute";
        logger.info("\u5bf9\u63a5devops,\u6267\u884c\u6d41\u6c34\u7ebf\u53c2\u6570\uff1aurlDevops:---------->{}\uff0cdataMap:--------->{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u5bf9\u63a5devops,\u6267\u884c\u6d41\u6c34\u7ebf\u8fd4\u56de\u7ed3\u679cjson:--------->\uff1a{}", (Object)json);
        if ("200".equals(json.get((Object)"status").toString())) {
            sysAppRecord.setBuildId(json.get((Object)"buildId").toString());
            sysAppRecord.setPipelineStatus("1");
            sysAppRecordLog.setStatus("0");
        } else {
            sysAppRecord.setStatus("3");
            sysAppRecord.setPipelineStatus("3");
            sysAppRecordLog.setStatus("1");
            sysAppRecordLog.setErrInfo(json.getString("errorLocalizedMessage"));
        }
        sysAppRecordLog.setEndTime(LocalDateTime.now());
        sysAppRecord.setDefinitionId(definitionId);
        this.sysAppRecordService.updateById((Object)sysAppRecord);
        this.sysAppRecordLogService.updateById((Object)sysAppRecordLog);
        logger.info("\u6d41\u6c34\u7ebf\u65e5\u5fd7\u4fe1\u606fsysAppRecordLog\uff1a-------->{}", (Object)sysAppRecordLog);
        return json;
    }

    String getSqlPath(String dataType) {
        String sqlPath = "";
        if (HussarUtils.isNotEmpty((Object)dataType)) {
            switch (dataType) {
                case "1": {
                    sqlPath = "sql/ORACLE/qddt-oracle.sql";
                    break;
                }
                case "2": {
                    sqlPath = "sql/MYSQL/qddt-mysql.sql";
                    break;
                }
                case "3": {
                    sqlPath = "sql/DM/qddt-dm.sql";
                    break;
                }
                case "4": {
                    sqlPath = "sql/OSCA/qddt-oscar.sql";
                    break;
                }
                case "5": {
                    sqlPath = "sql/POSTGRE/qddt-postgre.sql";
                    break;
                }
                case "6": {
                    sqlPath = "sql/SQLSERVER/qddt-sqlserver.sql";
                    break;
                }
                case "7": {
                    sqlPath = "sql/KINGBASE/qddt-kingbase.sql";
                    break;
                }
                default: {
                    sqlPath = "sql/MYSQL/qddt-mysql.sql";
                }
            }
        }
        return sqlPath;
    }

    public JSONObject createPipelineByPerson(SysApplication sysApplication, SysAppDeploy sysAppDeploy, String projectId, SysAppRecord sysAppRecord) {
        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
        sysAppRecordLog.setRecordId(sysAppRecord.getId());
        sysAppRecordLog.setLogInfo("\u6784\u5efa\u4e2a\u4eba\u6d41\u6c34\u7ebf");
        sysAppRecordLog.setStatus("2");
        sysAppRecordLog.setType("1");
        sysAppRecordLog.setStartTime(LocalDateTime.now());
        this.sysAppRecordLogService.save((Object)sysAppRecordLog);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("projectId", projectId);
        dataMap.put("gitUrl", this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        dataMap.put("branch", sysAppDeploy.getBranchName());
        dataMap.put("templateName", "lcdp");
        HashMap<String, String> map = new HashMap<String, String>();
        String userAccount = this.sysUsersService.getUser(sysAppDeploy.getUserId()).getUserAccount();
        map.put("developer", userAccount + "-" + sysAppDeploy.getBranchName());
        int version = 0;
        SysAppDevops sysAppDevops = (SysAppDevops)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeploy.getBranchName()));
        version = sysAppDevops != null ? sysAppDevops.getVersion() + 1 : 1;
        map.put("version", "v" + version);
        map.put("projectCode", sysApplication.getAppCode());
        map.put("releas", sysApplication.getAppCode() + "-" + sysAppDeploy.getBranchName());
        map.put("imageRepo", sysAppDeploy.getAppNamespace());
        map.put("sqlPath", this.getSqlPath(sysAppDeploy.getDatabasetType()));
        dataMap.put("map", map);
        String urlDevops = this.devopsUri + "api/integration/ddm/build/branch";
        logger.info("\u4e2a\u4eba\u5206\u652f\u6784\u5efa\u6d41\u6c34\u7ebf\uff1a\u5bf9\u63a5devops\u53c2\u6570\uff1aurlDevops===============>{},dataMap:===============>{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u4e2a\u4eba\u5206\u652f\u6784\u5efa\u6d41\u6c34\u7ebf\uff0c\u8fd4\u56de\u53c2\u6570\uff1ajson:-->{},", (Object)json);
        json.put("version", (Object)version);
        json.put("releas", (Object)(sysApplication.getAppCode() + "-" + sysAppDeploy.getBranchName()));
        if ("200".equals(json.getString("statusCode"))) {
            sysAppRecordLog.setStatus("0");
            sysAppRecord.setDefinitionId(json.getString("definitionId"));
        } else {
            sysAppRecordLog.setStatus("1");
            sysAppRecordLog.setErrInfo(json.getString("errorLocalizedMessage"));
            sysAppRecord.setStatus("3");
        }
        sysAppRecordLog.setEndTime(LocalDateTime.now());
        this.sysAppRecordLogService.updateById((Object)sysAppRecordLog);
        this.sysAppRecordService.updateById((Object)sysAppRecord);
        return json;
    }

    private static String databaseType(String databaseType) {
        String name = "";
        if (HussarUtils.isNotEmpty((Object)databaseType)) {
            switch (databaseType) {
                case "1": {
                    name = "oracle";
                    break;
                }
                case "2": {
                    name = "mysql";
                    break;
                }
                case "3": {
                    name = "dameng";
                    break;
                }
                default: {
                    name = "db2";
                }
            }
        }
        return name;
    }

    public JSONObject releaseResource(String relase) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("env", "DEV");
        dataMap.put("relase", relase);
        String urlDevops = this.devopsUri + "/api/integration/ddm/remove/relase";
        logger.info("\u91ca\u653e\u5f00\u53d1\u73af\u5883\u8d44\u6e90\uff0c\u5bf9\u63a5devops\u53c2\u6570\uff1aurlDevops------->{},dataMap--------->{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u91ca\u653e\u5f00\u53d1\u73af\u5883\u8d44\u6e90\uff0c\u5bf9\u63a5devops\u8fd4\u56de\u53c2\u6570\uff1ajson----------------->{}", (Object)json);
        return json;
    }

    private String getBuilddefs(String buildDefinitionId) {
        logger.info("\u8fdb\u5165getBuilddefs---------------------");
        String stageName = "";
        CloseableHttpClient httpclients = null;
        try {
            JSONObject json;
            JSONObject pipelineInstance;
            JSONObject executingStageInstance;
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(this.devopsUri + "api/ci/builddefs/" + buildDefinitionId + "/instances");
            logger.info("\u5bf9\u63a5devops\u67e5\u8be2\u8282\u70b9\u4fe1\u606f\u53c2\u6570\uff1a{}==========", (Object)(this.devopsUri + "api/ci/builddefs/" + buildDefinitionId + "/instances"));
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            logger.info("response", (Object)response);
            HttpEntity httpEntity = response.getEntity();
            if (null == httpEntity) {
                logger.info("\u5bf9\u63a5devops\u67e5\u8be2\u8282\u70b9\u4fe1\u606f\u8fd4\u56de\u7a7a");
                String string = null;
                return string;
            }
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            logger.info("result", (Object)result);
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject == null) {
                logger.info("line312exit");
                String string = null;
                return string;
            }
            JSONArray data = JSONArray.parseArray((String)jsonObject.getString("data"));
            if (data.size() > 0 && (executingStageInstance = JSON.parseObject((String)(pipelineInstance = JSON.parseObject((String)(json = JSON.parseObject((String)data.get(0).toString())).getString("pipelineInstance"))).getString("executingStageInstance"))) != null) {
                stageName = executingStageInstance.getString("stageName");
            }
            logger.info("line324exit");
            String string = stageName;
            return string;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
    }

    public List<Map<String, Object>> getBuilddefAll(Long appId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
        Wrapper sysAppDeployWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().ne((Object)"IS_PUBLISH", (Object)"0")).eq((Object)"DEL_FLAG", (Object)"0")).isNotNull((Object)"IS_PUBLISH")).eq((Object)"APP_ID", (Object)sysApplication.getId());
        List sysAppDeployList = this.sysDeployService.list(sysAppDeployWrapper);
        if (HussarUtils.isEmpty((Object)sysAppDeployList)) {
            logger.info("{}\u8be5\u9879\u76ee\u6682\u65e0\u90e8\u7f72\u4fe1\u606f\uff1a===============", (Object)appId);
            return null;
        }
        logger.info("\u67e5\u8be2\u9879\u76ee{} \u7684\u90e8\u7f72\u4fe1\u606f\uff1a==============={}", (Object)sysApplication.getAppCode(), (Object)sysAppDeployList);
        Object httpclients = null;
        try {
            String isOnline = sysApplication.getIsOnline();
            String personalBrance = sysApplication.getPersonalBrance();
            String branchName = null;
            String env = null;
            for (int i = 0; i < sysAppDeployList.size(); ++i) {
                SysAppDeploy sysAppDeploy = (SysAppDeploy)sysAppDeployList.get(i);
                if ("1".equals(sysAppDeploy.getDeployType())) {
                    branchName = "1".equals(personalBrance) ? "dev" : "master";
                    env = "\u5f00\u53d1\u73af\u5883";
                } else if ("2".equals(sysAppDeploy.getDeployType())) {
                    branchName = sysAppDeploy.getBranchName();
                    env = "\u5f00\u53d1\u73af\u5883-" + this.sysUsersService.getUser(sysAppDeploy.getUserId()).getUserName();
                } else if ("3".equals(sysAppDeploy.getDeployType())) {
                    if ("1".equals(isOnline) || "1".equals(personalBrance)) {
                        branchName = "dev";
                        env = "\u6d4b\u8bd5\u73af\u5883";
                    } else {
                        branchName = "master";
                        env = "\u6b63\u5f0f\u73af\u5883";
                    }
                }
                Wrapper devopsWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId)).eq((Object)"BRANCH", (Object)branchName);
                SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsMapper.selectOne(devopsWrapper);
                HashMap<String, String> map = new HashMap<String, String>();
                if ("2".equals(sysAppDeploy.getIsPublish())) {
                    map.put("env", env);
                    map.put("isPublish", sysAppDeploy.getIsPublish());
                    map.put("projectDeploy", "");
                    if (null == sysAppDevops) {
                        map.put("stageName", "");
                        map.put("devopsStatus", "0");
                    } else {
                        String definitionId = null;
                        if ("1".equals(sysAppDeploy.getDeployType()) || "2".equals(sysAppDeploy.getDeployType())) {
                            definitionId = sysAppDevops.getDevDefinitionId();
                        } else if ("3".equals(sysAppDeploy.getDeployType())) {
                            definitionId = sysAppDevops.getTestDefinitionId();
                        } else if ("4".equals(sysAppDeploy.getDeployType())) {
                            definitionId = sysAppDevops.getProdDefinitionId();
                        }
                        String stageName = this.getBuilddefs(sysAppDevops.getDevDefinitionId());
                        if (HussarUtils.isNotBlank((CharSequence)stageName) && stageName.contains("9:")) {
                            map.put("projectDeploy", "0");
                        }
                        if (HussarUtils.isBlank((CharSequence)stageName)) {
                            if (null == map.get("projectDeploy")) {
                                map.put("stageName", "");
                                map.put("devopsStatus", "0");
                            } else {
                                map.put("stageName", "");
                                map.put("devopsStatus", "1");
                            }
                        } else {
                            map.put("stageName", this.getBuilddefs(sysAppDevops.getDevDefinitionId()));
                        }
                    }
                    list.add(map);
                    continue;
                }
                map.put("env", env);
                map.put("isPublish", sysAppDeploy.getIsPublish());
                map.put("devopsStatus", sysAppDeploy.getDevopsStatus());
                map.put("stageName", "");
                list.add(map);
            }
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
        return list;
    }

    public List<SysAppRecord> getAppRecordInfo(Long appId) {
        return this.sysAppRecordService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId)).orderByDesc((Object)"CREATE_TIME"));
    }

    private List<SysAppRecordLog> getPipelineInfo(SysAppRecord sysAppRecord) {
        ArrayList<SysAppRecordLog> resLogList = new ArrayList<SysAppRecordLog>();
        String definitionId = sysAppRecord.getDefinitionId();
        String buildId = sysAppRecord.getBuildId();
        CloseableHttpClient httpclients = null;
        try {
            JSONArray data;
            String result;
            JSONObject jsonObject;
            String url = this.devopsUri + "api/ci/builddefs/" + definitionId + "/instances?buildDefinitionId=" + definitionId + "&cascadeStageInstance=true&refreshToken=true";
            logger.info("\u5bf9\u63a5devops\u67e5\u8be2\u8282\u70b9\u4fe1\u606f\u53c2\u6570\uff1a{}==========", (Object)url);
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            logger.info("response", (Object)response);
            HttpEntity httpEntity = response.getEntity();
            if (null != httpEntity && null != (jsonObject = JSON.parseObject((String)(result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8")))) && null != (data = JSONArray.parseArray((String)jsonObject.getString("data")))) {
                JSONObject pipelineInstance;
                JSONArray engineStageInstances;
                JSONObject single = null;
                for (int i = 0; i < data.size(); ++i) {
                    if (!buildId.equals(data.getJSONObject(i).get((Object)"buildId").toString())) continue;
                    single = data.getJSONObject(i);
                }
                if (null != single && null != (engineStageInstances = JSONArray.parseArray((String)(pipelineInstance = single.getJSONObject("pipelineInstance")).getString("engineStageInstances")))) {
                    for (int j = 0; j < engineStageInstances.size(); ++j) {
                        JSONObject stageInfo = engineStageInstances.getJSONObject(j);
                        String instanceStatus = stageInfo.getString("instanceStatus");
                        if ("disable".equals(instanceStatus) || "unexecuted".equals(instanceStatus)) continue;
                        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
                        sysAppRecordLog.setRecordId(sysAppRecord.getId());
                        String stageName = stageInfo.getString("stageName");
                        sysAppRecordLog.setLogInfo(stageName.substring(stageName.lastIndexOf(":") + 1));
                        sysAppRecordLog.setStartTime(LocalDateTime.parse(stageInfo.getString("beginTime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        sysAppRecordLog.setEndTime(null == stageInfo.getString("endTime") ? null : LocalDateTime.parse(stageInfo.getString("endTime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        String status = stageInfo.getString("instanceStatus");
                        if ("success".equals(status)) {
                            sysAppRecordLog.setStatus("0");
                        } else if ("failure".equals(status)) {
                            sysAppRecordLog.setStatus("1");
                        } else if ("executing".equals(status)) {
                            sysAppRecordLog.setStatus("2");
                        }
                        sysAppRecordLog.setType("2");
                        resLogList.add(sysAppRecordLog);
                    }
                }
            }
            logger.info("\u5bf9\u63a5devops\u67e5\u8be2\u8282\u70b9\u65e0\u8fd4\u56de\u4fe1\u606fhttpEntity\uff1a==============>{}", (Object)httpEntity);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
        return resLogList;
    }

    public List<SysAppRecordLog> getRecordLog(Long recordId, String type) {
        List dataLogList = this.sysAppRecordLogService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RECORD_ID", (Object)recordId)).orderByAsc((Object)"START_TIME")).orderByAsc((Object)"END_TIME"));
        if ("2".equals(type)) {
            logger.info("\u65e5\u5fd7\u4fe1\u606f\u901a\u8fc7\u63a5\u53e3\u67e5\u8be2\u4fe1\u606f\uff1a============");
            SysAppRecord sysAppRecord = (SysAppRecord)this.sysAppRecordService.getById((Serializable)recordId);
            if ("1".equals(sysAppRecord.getPipelineStatus())) {
                List<SysAppRecordLog> pipelineInfo = this.getPipelineInfo(sysAppRecord);
                dataLogList.addAll(pipelineInfo);
                this.orderByStartTimeAEndTime(dataLogList);
            }
        }
        return dataLogList;
    }

    public void orderByStartTimeAEndTime(List<SysAppRecordLog> dataLogList) {
        Comparator<SysAppRecordLog> comparator = new Comparator<SysAppRecordLog>(){

            @Override
            public int compare(SysAppRecordLog log1, SysAppRecordLog log2) {
                int result = log1.getStartTime().compareTo(log2.getStartTime());
                if (result == 0) {
                    result = log1.getEndTime().compareTo(log2.getEndTime());
                }
                return result;
            }
        };
        Collections.sort(dataLogList, comparator);
    }

    public SysAppRecord getRecordInfoById(Long recordId) {
        return (SysAppRecord)this.sysAppRecordService.getById((Serializable)recordId);
    }

    public Boolean stageInfo(SysAppDevopsDto sysAppDevopsDto) {
        logger.info("devops\u8282\u70b9\u56de\u8c03\u53c2\u6570\uff1asysAppDevopsDto------{}", (Object)(null == sysAppDevopsDto ? "" : sysAppDevopsDto.toString()));
        List list = this.sysAppRecordService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEFINITION_ID", (Object)sysAppDevopsDto.getDefinitionId())).orderByDesc((Object)"CREATE_TIME"));
        if (HussarUtils.isNotEmpty((Object)list)) {
            SysAppRecord sysAppRecord = (SysAppRecord)list.get(0);
            SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo(sysAppDevopsDto.getStageName());
            sysAppRecordLog.setStatus("200".equals(sysAppDevopsDto.getStatus()) ? "0" : "1");
            sysAppRecordLog.setErrInfo(sysAppDevopsDto.getMsg());
            sysAppRecordLog.setStartTime(sysAppDevopsDto.getStartTime());
            sysAppRecordLog.setEndTime(sysAppDevopsDto.getEndTime());
            this.sysAppRecordLogService.save((Object)sysAppRecordLog);
        }
        return true;
    }

    private void getDevopsInfo(SysApplication sysApplication, SysAppDeploy sysAppDeploy, List res) {
        Long appId = sysApplication.getId();
        String isOnline = sysApplication.getIsOnline();
        String personalBrance = sysApplication.getPersonalBrance();
        String branchName = null;
        String env = null;
        if ("1".equals(sysAppDeploy.getDeployType())) {
            branchName = "1".equals(personalBrance) ? "dev" : "master";
            env = "\u5f00\u53d1\u73af\u5883";
        } else if ("2".equals(sysAppDeploy.getDeployType())) {
            branchName = sysAppDeploy.getBranchName();
            env = "\u5f00\u53d1\u73af\u5883-" + this.sysUsersService.getUser(sysAppDeploy.getUserId()).getUserName();
        } else if ("3".equals(sysAppDeploy.getDeployType())) {
            if ("1".equals(isOnline) || "1".equals(personalBrance)) {
                branchName = "dev";
                env = "\u6d4b\u8bd5\u73af\u5883";
            } else {
                branchName = "master";
                env = "\u6b63\u5f0f\u73af\u5883";
            }
        }
        Wrapper devopsWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId)).eq((Object)"BRANCH", (Object)branchName);
        SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsMapper.selectOne(devopsWrapper);
        String definitionId = null;
        if (null != sysAppDevops) {
            if ("1".equals(sysAppDeploy.getDeployType()) || "2".equals(sysAppDeploy.getDeployType())) {
                definitionId = sysAppDevops.getDevDefinitionId();
            } else if ("3".equals(sysAppDeploy.getDeployType())) {
                definitionId = sysAppDevops.getTestDefinitionId();
            } else if ("4".equals(sysAppDeploy.getDeployType())) {
                definitionId = sysAppDevops.getProdDefinitionId();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ENV", env);
            map.put("isPublish", sysAppDeploy.getIsPublish());
            map.put("devopsStatus", sysAppDeploy.getDevopsStatus());
            if ("2".equals(sysAppDeploy.getIsPublish())) {
                map.put("stageName", this.getBuilddefs(sysAppDevops.getDevDefinitionId()));
            } else {
                map.put("stageName", "");
            }
            res.add(map);
        } else {
            logger.info("{}\u8be5\u5e94\u7528\u7684{}\u5206\u652f\u65e0devops\u90e8\u7f72\u4fe1\u606f\uff1a===============", (Object)appId, (Object)branchName);
        }
    }

    public Boolean updateStatus(SysAppDevopsDto sysAppDevopsDto) {
        logger.info("devops\u56de\u8c03\u63a5\u53e3\u63a5\u6536\u53c2\u6570\uff1asysAppDevopsDto------{}", (Object)(null == sysAppDevopsDto ? "" : sysAppDevopsDto.toString()));
        String env = sysAppDevopsDto.getEnv();
        SysAppDevops sysAppDevops = null;
        sysAppDevops = "DEV".equals(env) && !"dev".equals(sysAppDevopsDto.getBranch()) ? (SysAppDevops)this.sysAppDevopsMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID", (Object)sysAppDevopsDto.getProjectId())).eq((Object)"BRANCH", (Object)sysAppDevopsDto.getBranch())) : (SysAppDevops)this.sysAppDevopsMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID", (Object)sysAppDevopsDto.getProjectId())).isNotNull((Object)"TEST_DEFINITION_ID"));
        if (null != sysAppDevops) {
            String definitionId = "";
            if ("DEV".equals(env)) {
                definitionId = sysAppDevops.getDevDefinitionId();
            } else if ("TEST".equals(env)) {
                definitionId = sysAppDevops.getTestDefinitionId();
            } else if ("PROD".equals(env)) {
                definitionId = sysAppDevops.getProdDefinitionId();
            }
            List recordlist = this.sysAppRecordService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEFINITION_ID", (Object)definitionId)).eq((Object)"BUILD_ID", (Object)sysAppDevopsDto.getBuildId()));
            List recordLogList = this.sysAppRecordLogService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RECORD_ID", (Object)((SysAppRecord)recordlist.get(0)).getId())).orderByDesc((Object)"CREATE_TIME"));
            List<SysAppRecordLog> pipelineInfo = this.getPipelineInfo((SysAppRecord)recordlist.get(0));
            SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
            sysAppRecordLog.setRecordId(((SysAppRecord)recordlist.get(0)).getId());
            sysAppRecordLog.setLogInfo("\u6d41\u6c34\u7ebf\u6267\u884c\u7ed3\u675f");
            sysAppRecordLog.setStartTime(pipelineInfo.get(pipelineInfo.size() - 1).getEndTime());
            sysAppRecordLog.setEndTime(LocalDateTime.now());
            sysAppRecordLog.setStatus("200".equals(sysAppDevopsDto.getStatus()) ? "0" : "1");
            sysAppRecordLog.setErrInfo(sysAppDevopsDto.getMsg());
            sysAppRecordLog.setType("1");
            pipelineInfo.add(sysAppRecordLog);
            this.sysAppRecordLogService.saveBatch(pipelineInfo);
            SysAppRecord sysAppRecord = (SysAppRecord)recordlist.get(0);
            if ("200".equals(sysAppDevopsDto.getStatus())) {
                sysAppRecord.setPipelineStatus("2");
            } else {
                sysAppRecord.setPipelineStatus("3");
                sysAppRecord.setStatus("3");
            }
            this.sysAppRecordService.updateById((Object)sysAppRecord);
        }
        return true;
    }

    private static String getAppType(String appType) {
        String type = "";
        type = "1".equals(appType) ? "web" : ("2".equals(appType) ? "app" : ("3".equals(appType) ? "h5" : ""));
        return type;
    }
}

