/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.base.portal.application.dto.AppUserAuthorizeDto;
import com.jxdinfo.hussar.base.portal.application.dto.AppUserQueryDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppAuthorizeDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysUserAppConfigDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppCommonService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.vo.AppOrgUserVo;
import com.jxdinfo.hussar.base.portal.application.vo.AppUserInfoVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppFormTreeVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppRecycleVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysUserAppConfigVo;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitServerDto;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7cfb\u7edf\u5e94\u7528"})
@RestController(value="com.jxdinfo.hussar.base.portal.application.controller.sysApplicationController")
@RequestMapping(value={"/hussarBase/application/"})
public class SysApplicationController {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysAppCommonService sysAppCommonService;
    @Resource
    private ISysAppRecycleService sysAppRecycleService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private ISysAppAuthorizeService sysAppAuthorizeService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u5217\u8868", notes="\u67e5\u8be2\u5e94\u7528\u5217\u8868")
    public ApiResponse<List<SysAppGroupVo>> getAppList(@ApiParam(value="\u5e94\u7528\u540d\u79f0") @RequestParam String appName) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.getAppList(appName));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @GetMapping(value={"/manage/list"})
    @ApiOperation(value="\u63a7\u5236\u53f0\u83b7\u53d6\u5e94\u7528\u5217\u8868", notes="\u63a7\u5236\u53f0\u83b7\u53d6\u5e94\u7528\u5217\u8868")
    public ApiResponse<List<SysAppGroupVo>> getManageAppList(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestParam Long appGroupId, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestParam String appName, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestParam String appStatus) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.getManageAppList(appGroupId, appName, appStatus));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/add"})
    @CheckPermission(value={"hussarBase:application:add"})
    @ApiOperation(value="\u521b\u5efa\u5e94\u7528", notes="\u521b\u5efa\u5e94\u7528")
    public ApiResponse<Boolean> addApp(@ApiParam(value="\u5e94\u7528\u5b9e\u4f53") @RequestBody SysApplicationDto sysApplicationDto) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_NAME", (Object)sysApplicationDto.getSysApplication().getAppName())).or()).eq((Object)"APP_CODE", (Object)sysApplicationDto.getSysApplication().getAppCode());
        if (this.sysApplicationService.count(queryWrapper) > 0L) {
            return ApiResponse.fail((String)"\u5e94\u7528\u540d\u79f0\u6216\u5e94\u7528\u6807\u8bc6\u5df2\u5b58\u5728");
        }
        try {
            return ApiResponse.success((Object)this.sysApplicationService.addApp(sysApplicationDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/saveOrUpdateNewApplication"})
    @ApiOperation(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u65b0\u5e94\u7528\u6570\u636e", notes="\u4fdd\u5b58\u6216\u66f4\u65b0\u65b0\u5e94\u7528\u6570\u636e")
    public ApiResponse<Boolean> saveOrUpdateNewApplication(@ApiParam(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u65b0\u5e94\u7528\u6570\u636e") @RequestBody Map<String, Object> data) {
        if (data != null) {
            SysApplication sysApplication = (SysApplication)JSONObject.parseObject((String)JSONObject.toJSONString((Object)data.get("sysApplication")), SysApplication.class);
            try {
                return ApiResponse.success((Object)this.sysApplicationService.saveOrUpdateNewApplication(sysApplication));
            }
            catch (Exception e) {
                e.printStackTrace();
                return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
            }
        }
        return ApiResponse.fail((String)"\u5e94\u7528\u7ba1\u7406\u4fe1\u606f\u521b\u5efa\u5931\u8d25");
    }

    @PostMapping(value={"/edit"})
    @CheckPermission(value={"hussarBase:application:edit"})
    @ApiOperation(value="\u7f16\u8f91\u5e94\u7528", notes="\u7f16\u8f91\u5e94\u7528")
    public ApiResponse<Long> updateApp(@ApiParam(value="\u5e94\u7528\u5b9e\u4f53") @RequestBody SysApplicationDto sysApplicationDto) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_NAME", (Object)sysApplicationDto.getSysApplication().getAppName())).ne((Object)"APP_ID", (Object)sysApplicationDto.getSysApplication().getId());
        if (this.sysApplicationService.count(queryWrapper) > 0L) {
            return ApiResponse.fail((String)"\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728");
        }
        try {
            return ApiResponse.success((Object)this.sysApplicationService.updateApp(sysApplicationDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/delete"})
    @CheckPermission(value={"hussarBase:application:delete"})
    @ApiOperation(value="\u5e94\u7528\u5220\u9664", notes="\u5e94\u7528\u5220\u9664")
    public ApiResponse<Boolean> deleteApp(@ApiParam(value="\u5e94\u7528id") @RequestParam Long id) {
        try {
            Boolean flag = this.sysApplicationService.deleteApp(id);
            if (flag.booleanValue()) {
                return ApiResponse.success();
            }
            return ApiResponse.fail((int)10001, (String)"\u5e94\u7528\u5728\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u53ef\u5220\u9664");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u8be6\u60c5", notes="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u8be6\u60c5")
    public ApiResponse<SysApplicationDto> getAppDetail(@ApiParam(value="\u5e94\u7528Id") @RequestParam Long appId) {
        try {
            return this.sysApplicationService.getAppDetailAndDeploy(appId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/copyApplication"})
    @CheckPermission(value={"hussarBase:application:copyApplication"})
    @ApiOperation(value="\u751f\u6210\u526f\u672c", notes="\u751f\u6210\u526f\u672c")
    public ApiResponse<Long> copyApplication(@ApiParam(value="\u751f\u6210\u526f\u672c") @RequestBody SysApplicationDto sysApplicationDto) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_NAME", (Object)sysApplicationDto.getSysApplication().getAppName())).or()).eq((Object)"APP_CODE", (Object)sysApplicationDto.getSysApplication().getAppCode());
        if (this.sysApplicationService.count(queryWrapper) > 0L) {
            return ApiResponse.fail((String)"\u5e94\u7528\u540d\u79f0\u6216\u5e94\u7528\u6807\u8bc6\u5df2\u5b58\u5728");
        }
        try {
            return ApiResponse.success((Object)this.sysApplicationService.copyApplication(sysApplicationDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @GetMapping(value={"/updateAppStatus"})
    @CheckPermission(value={"hussarBase:application:updateAppStatus"})
    @ApiOperation(value="\u5e94\u7528\u542f\u505c", notes="\u5e94\u7528\u542f\u505c")
    public ApiResponse<Boolean> updateAppStatus(@ApiParam(value="\u5e94\u7528\u542f\u505c") @RequestParam Long appId, @ApiParam(value="\u542f\u505c\u72b6\u6001") @RequestParam String appStatus) {
        try {
            Boolean flag = this.sysApplicationService.updateAppStatus(appId, appStatus);
            if (flag.booleanValue()) {
                return ApiResponse.success();
            }
            return ApiResponse.fail((String)"\u8be5\u5e94\u7528\u672a\u53d1\u5e03\u5230\u6b63\u5f0f\uff0c\u4e0d\u53ef\u505c\u7528");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/secretKey"})
    @ApiOperation(value="\u91cd\u7f6e\u5e94\u7528\u5bc6\u94a5", notes="\u91cd\u7f6e\u5e94\u7528\u5bc6\u94a5")
    public ApiResponse<Boolean> updateSecretKey(@ApiParam(value="\u5e94\u7528\u5217\u8868") @RequestParam Long appId) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.updateSecretKey(appId));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @GetMapping(value={"/getSysDeployInfo"})
    @ApiOperation(value="\u53d1\u5e03\u5230\u6d4b\u8bd5\u3001\u6b63\u5f0f\u6570\u636e\u56de\u663e", notes="\u53d1\u5e03\u5230\u6d4b\u8bd5\u3001\u6b63\u5f0f\u6570\u636e\u56de\u663e")
    public ApiResponse<SysAppDeploy> getSysDeployInfo(@ApiParam(value="\u53d1\u5e03\u5230\u6d4b\u8bd5\u3001\u6b63\u5f0f\u6570\u636e\u56de\u663e") @RequestParam Long appId, @RequestParam String deployType, @RequestParam Long userId) {
        try {
            SysAppDeploy sysAppDeploy = this.sysApplicationService.getSysDeployInfo(appId, deployType, userId);
            return ApiResponse.success((Object)sysAppDeploy);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/publishToTestEnvironment"})
    @CheckPermission(value={"hussarBase:application:publishToTestEnvironment"})
    @ApiOperation(value="\u53d1\u5e03\u5230\u6d4b\u8bd5\u73af\u5883", notes="\u53d1\u5e03\u5230\u6d4b\u8bd5\u73af\u5883")
    public ApiResponse<Long> publishToTestEnvironment(@ApiParam(value="\u53d1\u5e03\u5230\u6d4b\u8bd5\u73af\u5883") @RequestBody SysApplicationDto sysApplicationDto) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.publishToTestEnvironment(sysApplicationDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/publishToFormalEnvironment"})
    @CheckPermission(value={"hussarBase:application:publishToFormalEnvironment"})
    @ApiOperation(value="\u53d1\u5e03\u5230\u6b63\u5f0f\u73af\u5883", notes="\u53d1\u5e03\u5230\u6b63\u5f0f\u73af\u5883")
    public ApiResponse<Long> publishToFormalEnvironment(@ApiParam(value="\u53d1\u5e03\u5230\u6b63\u5f0f\u73af\u5883") @RequestBody SysApplicationDto sysApplicationDto) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.publishToFormalEnvironment(sysApplicationDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @GetMapping(value={"/getApplicationInfo"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u4fe1\u606f", notes="\u83b7\u53d6\u5e94\u7528\u4fe1\u606f")
    public ApiResponse<SysApplication> getApplicationInfo() {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.getApplicationInfo());
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @GetMapping(value={"/currentCode"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u6807\u8bc6", notes="\u83b7\u53d6\u5e94\u7528\u6807\u8bc6")
    public ApiResponse<String> getCurrentCode() {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.getCurrentCode(), (String)"\u83b7\u53d6\u5e94\u7528\u6807\u8bc6\u6210\u529f\u201c");
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @GetMapping(value={"/recycle/list"})
    @ApiOperation(value="\u83b7\u53d6\u56de\u6536\u7ad9\u5e94\u7528\u5217\u8868", notes="\u83b7\u53d6\u56de\u6536\u7ad9\u5e94\u7528\u5217\u8868")
    public ApiResponse<Page<SysAppRecycleVo>> getRecycleList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u5e94\u7528\u540d\u79f0") @RequestParam String appName) {
        try {
            return ApiResponse.success((Object)this.sysAppRecycleService.getRecycleList(pageInfo, appName));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/recycle/revert"})
    @ApiOperation(value="\u56de\u6536\u7ad9\u8fd8\u539f", notes="\u56de\u6536\u7ad9\u8fd8\u539f")
    public ApiResponse<Boolean> revertApp(@RequestParam Long id) {
        try {
            return ApiResponse.success((Object)this.sysAppRecycleService.revertApp(id));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/recycle/delete"})
    @ApiOperation(value="\u56de\u6536\u7ad9\u5220\u9664", notes="\u56de\u6536\u7ad9\u5220\u9664")
    public ApiResponse<Boolean> deleteRecycleApp(@RequestParam Long id) {
        try {
            return ApiResponse.success((Object)this.sysAppRecycleService.deleteRecycleApp(id));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @GetMapping(value={"/appFormList"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u8868\u5355\u6811", notes="\u67e5\u8be2\u5e94\u7528\u8868\u5355\u6811")
    public ApiResponse<List<SysAppFormTreeVo>> getAppFormList(@ApiParam(value="\u5e94\u7528Id") @RequestParam Long appId) {
        try {
            return this.sysApplicationService.getAppFormList(appId);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/visit/authorize"})
    @ApiOperation(value="\u5e94\u7528\u8bbf\u95ee\u6388\u6743\u65b0\u589e", notes="\u5e94\u7528\u8bbf\u95ee\u6388\u6743\u65b0\u589e")
    public ApiResponse<Boolean> addAuthorize(@ApiParam(value="\u5e94\u7528\u8bbf\u95ee\u6388\u6743\u5b9e\u4f53") @RequestBody SysAppAuthorizeDto appAuthorizeDto) {
        try {
            return ApiResponse.success((Object)this.sysAppAuthorizeService.addAuthorize(appAuthorizeDto));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @GetMapping(value={"/visit/roleList"})
    @ApiOperation(value="\u83b7\u53d6\u53ef\u8bbf\u95ee\u8be5\u5e94\u7528\u7684\u89d2\u8272\u5217\u8868", notes="\u83b7\u53d6\u53ef\u8bbf\u95ee\u8be5\u5e94\u7528\u7684\u89d2\u8272\u5217\u8868")
    public ApiResponse<List<RoleVo>> getAppRoleList(@ApiParam(value="\u5e94\u7528Id") @RequestParam Long appId) {
        try {
            return this.sysAppAuthorizeService.getAppRoleList(appId);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u5e94\u7528\u7684\u4fe1\u606f", notes="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u5e94\u7528\u7684\u4fe1\u606f")
    @GetMapping(value={"/getAppOrgUser"})
    @AuditLog(moduleName="\u5e94\u7528\u7ef4\u62a4\u4eba\u5458", eventDesc="\u67e5\u8be2\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u5e94\u7528\u7684\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<AppOrgUserVo>> getAppOrgUser(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<AppOrgUserVo> page, @ApiParam(value="\u5e94\u7528\u5173\u8054\u7528\u6237\u67e5\u8be2dto") AppUserQueryDto appUserQueryDto) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.getAppOrgUser(page, appUserQueryDto));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/getContainerAccessAddress"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5e94\u7528\u5730\u5740", notes="\u83b7\u53d6\u7528\u6237\u5e94\u7528\u5730\u5740")
    public ApiResponse<String> getContainerAccessAddress(@RequestBody SysUserAppConfigDto sysUserAppConfigDto) {
        try {
            return ApiResponse.success((String)this.sysApplicationService.getContainerAccessAddress(sysUserAppConfigDto));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @GetMapping(value={"/getApplicationUserList"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u7528\u6237\u5217\u8868", notes="\u83b7\u53d6\u5e94\u7528\u7528\u6237\u5217\u8868")
    public ApiResponse<Page<AppUserInfoVo>> getApplicationUserList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<AppUserInfoVo> page, AppUserQueryDto appUserQueryDto) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.getApplicationUserList(page, appUserQueryDto.getAppId(), appUserQueryDto.getKeyword()));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/appAuthorize"})
    @ApiOperation(value="\u7528\u6237\u5e94\u7528\u6388\u6743", notes="\u7528\u6237\u5e94\u7528\u6388\u6743")
    public ApiResponse<Boolean> addUserAuthorize(@ApiParam(value="\u5e94\u7528\u6388\u6743\u5b9e\u4f53") @RequestBody AppUserAuthorizeDto appAuthorizeDto) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.addUserAuthorize(appAuthorizeDto));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/addUserConfig"})
    @ApiOperation(value="\u4fdd\u5b58\u5e94\u7528\u914d\u7f6e\u7528\u6237\u4fe1\u606f", notes="\u4fdd\u5b58\u5e94\u7528\u914d\u7f6e\u7528\u6237\u4fe1\u606f")
    public ApiResponse<Boolean> addUserConfig(@ApiParam(value="\u5e94\u7528\u914d\u7f6e\u7528\u6237\u5b9e\u4f53") @RequestBody SysUserAppConfigDto sysUserAppConfigDto) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.addUserConfig(sysUserAppConfigDto));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/getUserConfig"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u914d\u7f6e\u7528\u6237\u4fe1\u606f", notes="\u67e5\u8be2\u5e94\u7528\u914d\u7f6e\u7528\u6237\u4fe1\u606f")
    public ApiResponse<SysUserAppConfigVo> getUserConfig(@ApiParam(value="\u5e94\u7528\u914d\u7f6e\u7528\u6237\u5b9e\u4f53") @RequestBody SysUserAppConfigDto sysUserAppConfigDto) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.getUserConfig(sysUserAppConfigDto));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/checkUser"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u4e2d\u662f\u5426\u5b58\u5728\u8be5\u7528\u6237", notes="\u67e5\u8be2\u5e94\u7528\u4e2d\u662f\u5426\u5b58\u5728\u8be5\u7528\u6237")
    public ApiResponse<Boolean> checkUser(@ApiParam(value="\u7528\u6237\u540d") @RequestParam String userAccount) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.checkUser(userAccount));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/syncDevloper"})
    @ApiOperation(value="\u5c06\u7ba1\u7406\u5e73\u53f0\u6240\u9009\u62e9\u4eba\u5458\u540c\u6b65\u5230\u5e94\u7528\u6570\u636e\u5e93", notes="\u5c06\u7ba1\u7406\u5e73\u53f0\u6240\u9009\u62e9\u4eba\u5458\u540c\u6b65\u5230\u5e94\u7528\u6570\u636e\u5e93")
    public ApiResponse<String> syncDevloper(@RequestBody JSONObject jsonObject) {
        try {
            String ids = jsonObject.getString("ids");
            String appId = jsonObject.getString("appId");
            return ApiResponse.success((String)this.sysApplicationService.syncDevloper(ids, appId));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u5e94\u7528\u8fde\u63a5\u5931\u8d25");
        }
    }

    @PostMapping(value={"/importData"})
    @ApiOperation(value="\u5411\u5e94\u7528\u4e2d\u540c\u6b65\u7ba1\u7406\u5e73\u53f0\u7528\u6237\u6570\u636e", notes="\u5411\u5e94\u7528\u4e2d\u540c\u6b65\u7ba1\u7406\u5e73\u53f0\u7528\u6237\u6570\u636e")
    public ApiResponse<String> importData(@ApiParam(value="\u5bfc\u51fa\u7684\u6570\u636e") @RequestBody JSONObject data) {
        try {
            return ApiResponse.success((String)this.sysApplicationService.importData(data));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u5e94\u7528")
    @PostMapping(value={"/importExcelApplication"})
    @CheckPermission(value={"hussarBase:application:importExcelApplication"})
    public ApiResponse importExcelApplication(@RequestParam(value="file") MultipartFile file) throws Exception {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.importExcelApplication(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/downloadTemplate"})
    @CheckPermission(value={"hussarBase:application:downloadTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public void downloadTemplate(HttpServletResponse response, @RequestBody Map map) throws Exception {
        this.sysApplicationService.downloadTemplate(response, map);
    }

    @PostMapping(value={"/obtainChanges"})
    @CheckPermission(value={"hussarBase:application:obtainChanges"})
    @ApiOperation(value="\u83b7\u53d6\u53d8\u66f4\u64cd\u4f5c")
    public ApiResponse<Boolean> obtainChanges(@ApiParam(value="\u83b7\u53d6\u53d8\u66f4") @RequestBody GitServerDto gitServerDto) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.obtainChanges(gitServerDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/abutmentGitlab"})
    @ApiOperation(value="\u65b0\u5e94\u7528\u66f4\u65b0\u6216\u63d0\u4ea4\u53d8\u66f4", notes="\u65b0\u5e94\u7528\u66f4\u65b0\u6216\u63d0\u4ea4\u53d8\u66f4")
    public ApiResponse abutmentGitlab(@ApiParam(value="\u65b0\u5e94\u7528\u66f4\u65b0\u6216\u63d0\u4ea4\u53d8\u66f4") @RequestBody Map<String, Object> data) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.abutmentGitlab(data));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @PostMapping(value={"/commitChanges"})
    @CheckPermission(value={"hussarBase:application:commitChanges"})
    @ApiOperation(value="\u63d0\u4ea4\u53d8\u66f4\u64cd\u4f5c")
    public ApiResponse<Boolean> commitChanges(@ApiParam(value="\u63d0\u4ea4\u53d8\u66f4") @RequestBody GitServerDto gitServerDto) {
        try {
            Boolean flag = this.sysApplicationService.commitChanges(gitServerDto);
            if (flag.booleanValue()) {
                return ApiResponse.success();
            }
            return ApiResponse.fail((String)"\u672a\u83b7\u53d6\u5230\u90e8\u7f72\u4fe1\u606f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u72b6\u6001")
    @GetMapping(value={"/proStatus"})
    public ApiResponse<Boolean> getAppProStatus(@RequestParam Long time) {
        try {
            return ApiResponse.success((Object)this.sysApplicationService.getAppProStatus(time));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.success((Object)false);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u72b6\u6001")
    @GetMapping(value={"/status"})
    public ApiResponse<Boolean> getAppStatus() {
        try {
            return ApiResponse.success((Object)"1".equals(((SysApplication)this.sysApplicationService.list().get(0)).getAppStatus()));
        }
        catch (Exception e) {
            return ApiResponse.success((Object)true);
        }
    }
}

