/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDevopsMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppDevopsDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevops;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevopsService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppResourceService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.DESUtil;
import com.jxdinfo.hussar.common.utils.DevopsUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppDevopsServiceImpl")
public class SysAppDevopsServiceImpl
extends HussarServiceImpl<SysAppDevopsMapper, SysAppDevops>
implements ISysAppDevopsService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppDevopsServiceImpl.class);
    @Value(value="${devops.uri.devops-uri}")
    private String devopsUri;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    private SysAppDevopsMapper sysAppDevopsMapper;
    @Resource
    private ISysDeployService sysDeployService;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    ISysApplicationService sysApplicationService;
    @Resource
    ISysAppResourceService sysAppResourceService;

    public JSONObject createProjectAndPipeline(SysApplication sysApplication, SysAppDeploy sysAppDeploy, String branch) {
        String[] appTypeArray;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> project = new HashMap<String, String>();
        project.put("projectCode", sysApplication.getAppCode());
        project.put("projectName", sysApplication.getAppName());
        String frontType = "";
        for (String appType : appTypeArray = sysApplication.getAppType().split(",")) {
            frontType = "".equals(frontType) ? SysAppDevopsServiceImpl.getAppType(appType) : frontType + "," + SysAppDevopsServiceImpl.getAppType(appType);
        }
        project.put("projectType", frontType);
        project.put("projectCategory", "project");
        project.put("projectTemplateId", "project-template-default");
        dataMap.put("project", project);
        dataMap.put("gitUrl", this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        dataMap.put("branch", branch);
        dataMap.put("templateName", "JXD");
        dataMap.put("databaseType", SysAppDevopsServiceImpl.databaseType(sysAppDeploy.getDatabasetType()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("databaseIp", sysAppDeploy.getDatabaseUrl());
        map.put("databasePort", sysAppDeploy.getDatabasePort());
        map.put("databaseName", sysAppDeploy.getDatabaseName());
        map.put("databaseUser", sysAppDeploy.getDatabaseAccount());
        map.put("databasePassword", DESUtil.encrypt((String)"qddt@2023", (String)sysAppDeploy.getDatabasePassword()));
        int version = 0;
        SysAppDevops sysAppDevops = (SysAppDevops)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)branch));
        version = sysAppDevops != null ? sysAppDevops.getVersion() + 1 : 1;
        map.put("version", "v" + version);
        map.put("releas", sysApplication.getAppCode() + "-" + branch);
        map.put("imageRepo", sysAppDeploy.getAppNamespace());
        map.put("sqlPath", this.getSqlPath(sysAppDeploy.getDatabasetType()));
        dataMap.put("map", map);
        String urlDevops = this.devopsUri + "api/integration/ddm";
        logger.info("\u5bf9\u63a5devops\u521b\u5efa\u9879\u76ee\uff0c\u6784\u5efa\u6d41\u6c34\u7ebf\u63a5\u53e3\u53c2\u6570\uff1aurl\uff1a-------> {};param:----------->{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u5bf9\u63a5devops\u521b\u5efa\u9879\u76ee\uff0c\u6784\u5efa\u6d41\u6c34\u7ebf\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1ajson:-->{},", (Object)json);
        json.put("version", (Object)version);
        json.put("releas", (Object)(sysApplication.getAppCode() + "-" + branch));
        return json;
    }

    public JSONObject executePipeline(String definitionId, String version, String frontType, String isInit, String env, String branch, SysAppDeploy sysAppDeploy) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> project = new HashMap<String, String>();
        project.put("version", version);
        project.put("databaseIp", sysAppDeploy.getDatabaseUrl());
        project.put("databasePort", sysAppDeploy.getDatabasePort());
        project.put("databaseName", sysAppDeploy.getDatabaseName());
        project.put("databaseUser", sysAppDeploy.getDatabaseAccount());
        project.put("databasePassword", DESUtil.encrypt((String)"qddt@2023", (String)sysAppDeploy.getDatabasePassword()));
        project.put("sqlPath", this.getSqlPath(sysAppDeploy.getDatabasetType()));
        project.put("imageRepo", sysAppDeploy.getAppNamespace());
        project.put("branch", branch);
        dataMap.put("buildParams", project);
        dataMap.put("env", env);
        dataMap.put("frontType", frontType);
        dataMap.put("isInit", isInit);
        String urlDevops = this.devopsUri + "api/integration/ddm/" + definitionId + "/execute";
        logger.info("\u5bf9\u63a5devops,\u6267\u884c\u6d41\u6c34\u7ebf\u53c2\u6570\uff1aurlDevops:---------->{}\uff0cdataMap:--------->{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u5bf9\u63a5devops,\u6267\u884c\u6d41\u6c34\u7ebf\u8fd4\u56de\u7ed3\u679cjson:--------->\uff1a{}", (Object)json);
        return json;
    }

    String getSqlPath(String dataType) {
        String sqlPath = "";
        if (HussarUtils.isNotEmpty((Object)dataType)) {
            switch (dataType) {
                case "1": {
                    sqlPath = "\u5168\u91cfsql/ORACLE/qddt-oracle.sql";
                    break;
                }
                case "2": {
                    sqlPath = "\u5168\u91cfsql/MYSQL/qddt-mysql.sql";
                    break;
                }
                case "3": {
                    sqlPath = "\u5168\u91cfsql/DM/qddt-dm.sql";
                    break;
                }
                case "4": {
                    sqlPath = "\u5168\u91cfsql/OSCA/qddt-oscar.sql";
                    break;
                }
                case "5": {
                    sqlPath = "\u5168\u91cfsql/POSTGRE/qddt-postgre.sql";
                    break;
                }
                case "6": {
                    sqlPath = "\u5168\u91cfsql/SQLSERVER/qddt-sqlserver.sql";
                    break;
                }
                case "7": {
                    sqlPath = "\u5168\u91cfsql/KINGBASE/qddt-kingbase.sql";
                    break;
                }
                default: {
                    sqlPath = "\u5168\u91cfsql/MYSQL/qddt-mysql.sql";
                }
            }
        }
        return sqlPath;
    }

    public JSONObject createPipelineByPerson(SysApplication sysApplication, SysAppDeploy sysAppDeploy, String projectId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("projectId", projectId);
        dataMap.put("gitUrl", this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        dataMap.put("branch", sysAppDeploy.getBranchName());
        dataMap.put("templateName", "JXD");
        HashMap<String, String> map = new HashMap<String, String>();
        String userAccount = this.sysUsersService.getUser(sysAppDeploy.getUserId()).getUserAccount();
        map.put("developer", userAccount + "-" + sysAppDeploy.getBranchName());
        int version = 0;
        SysAppDevops sysAppDevops = (SysAppDevops)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeploy.getBranchName()));
        version = sysAppDevops != null ? sysAppDevops.getVersion() + 1 : 1;
        map.put("version", "v" + version);
        map.put("projectCode", sysApplication.getAppCode());
        map.put("releas", sysApplication.getAppCode() + "-" + sysAppDeploy.getBranchName());
        map.put("imageRepo", sysAppDeploy.getAppNamespace());
        map.put("sqlPath", this.getSqlPath(sysAppDeploy.getDatabasetType()));
        dataMap.put("map", map);
        String urlDevops = this.devopsUri + "api/integration/ddm/build/branch";
        logger.info("\u4e2a\u4eba\u5206\u652f\u6784\u5efa\u6d41\u6c34\u7ebf\uff1a\u5bf9\u63a5devops\u53c2\u6570\uff1aurlDevops===============>{},dataMap:===============>{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u4e2a\u4eba\u5206\u652f\u6784\u5efa\u6d41\u6c34\u7ebf\uff0c\u8fd4\u56de\u53c2\u6570\uff1ajson:-->{},", (Object)json);
        json.put("version", (Object)version);
        json.put("releas", (Object)(sysApplication.getAppCode() + "-" + sysAppDeploy.getBranchName()));
        return json;
    }

    private static String databaseType(String databaseType) {
        String name = "";
        if (HussarUtils.isNotEmpty((Object)databaseType)) {
            switch (databaseType) {
                case "1": {
                    name = "oracle";
                    break;
                }
                case "2": {
                    name = "mysql";
                    break;
                }
                case "3": {
                    name = "dameng";
                    break;
                }
                default: {
                    name = "db2";
                }
            }
        }
        return name;
    }

    public JSONObject releaseResource(String relase) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("env", "DEV");
        dataMap.put("relase", relase);
        String urlDevops = this.devopsUri + "/api/integration/ddm/remove/relase";
        logger.info("\u91ca\u653e\u5f00\u53d1\u73af\u5883\u8d44\u6e90\uff0c\u5bf9\u63a5devops\u53c2\u6570\uff1aurlDevops------->{},dataMap--------->{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u91ca\u653e\u5f00\u53d1\u73af\u5883\u8d44\u6e90\uff0c\u5bf9\u63a5devops\u8fd4\u56de\u53c2\u6570\uff1ajson----------------->{}", (Object)json);
        return json;
    }

    private String getBuilddefs(String buildDefinitionId) {
        logger.info("\u8fdb\u5165getBuilddefs---------------------");
        String stageName = "";
        CloseableHttpClient httpclients = null;
        try {
            JSONObject json;
            JSONObject pipelineInstance;
            JSONObject executingStageInstance;
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(this.devopsUri + "api/ci/builddefs/" + buildDefinitionId + "/instances");
            logger.info("\u5bf9\u63a5devops\u67e5\u8be2\u8282\u70b9\u4fe1\u606f\u53c2\u6570\uff1a{}==========", (Object)(this.devopsUri + "api/ci/builddefs/" + buildDefinitionId + "/instances"));
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            logger.info("response", (Object)response);
            HttpEntity httpEntity = response.getEntity();
            if (null == httpEntity) {
                logger.info("\u5bf9\u63a5devops\u67e5\u8be2\u8282\u70b9\u4fe1\u606f\u8fd4\u56de\u7a7a");
                String string = null;
                return string;
            }
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            logger.info("result", (Object)result);
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject == null) {
                logger.info("line312exit");
                String string = null;
                return string;
            }
            JSONArray data = JSONArray.parseArray((String)jsonObject.getString("data"));
            if (data.size() > 0 && (executingStageInstance = JSON.parseObject((String)(pipelineInstance = JSON.parseObject((String)(json = JSON.parseObject((String)data.get(0).toString())).getString("pipelineInstance"))).getString("executingStageInstance"))) != null) {
                stageName = executingStageInstance.getString("stageName");
            }
            logger.info("line324exit");
            String string = stageName;
            return string;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
    }

    public List<Map<String, Object>> getBuilddefAll(Long appId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
        Wrapper sysAppDeployWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().ne((Object)"IS_PUBLISH", (Object)"0")).eq((Object)"DEL_FLAG", (Object)"0")).isNotNull((Object)"IS_PUBLISH")).eq((Object)"APP_ID", (Object)sysApplication.getId());
        List sysAppDeployList = this.sysDeployService.list(sysAppDeployWrapper);
        if (HussarUtils.isEmpty((Object)sysAppDeployList)) {
            logger.info("{}\u8be5\u9879\u76ee\u6682\u65e0\u90e8\u7f72\u4fe1\u606f\uff1a===============", (Object)appId);
            return null;
        }
        logger.info("\u67e5\u8be2\u9879\u76ee{} \u7684\u90e8\u7f72\u4fe1\u606f\uff1a==============={}", (Object)sysApplication.getAppCode(), (Object)sysAppDeployList);
        Object httpclients = null;
        try {
            String isOnline = sysApplication.getIsOnline();
            String personalBrance = sysApplication.getPersonalBrance();
            String branchName = null;
            String env = null;
            for (int i = 0; i < sysAppDeployList.size(); ++i) {
                SysAppDeploy sysAppDeploy = (SysAppDeploy)sysAppDeployList.get(i);
                if ("1".equals(sysAppDeploy.getDeployType())) {
                    branchName = "1".equals(personalBrance) ? "dev" : "master";
                    env = "\u5f00\u53d1\u73af\u5883";
                } else if ("2".equals(sysAppDeploy.getDeployType())) {
                    branchName = sysAppDeploy.getBranchName();
                    env = "\u5f00\u53d1\u73af\u5883-" + this.sysUsersService.getUser(sysAppDeploy.getUserId()).getUserName();
                } else if ("3".equals(sysAppDeploy.getDeployType())) {
                    if ("1".equals(isOnline) || "1".equals(personalBrance)) {
                        branchName = "dev";
                        env = "\u6d4b\u8bd5\u73af\u5883";
                    } else {
                        branchName = "master";
                        env = "\u6b63\u5f0f\u73af\u5883";
                    }
                }
                Wrapper devopsWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId)).eq((Object)"BRANCH", (Object)branchName);
                SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsMapper.selectOne(devopsWrapper);
                HashMap<String, String> map = new HashMap<String, String>();
                if ("2".equals(sysAppDeploy.getIsPublish())) {
                    map.put("env", env);
                    map.put("isPublish", sysAppDeploy.getIsPublish());
                    map.put("projectDeploy", "");
                    if (null == sysAppDevops) {
                        map.put("stageName", "");
                        map.put("devopsStatus", "0");
                    } else {
                        if ("0".equals(sysAppDevops) && "1".equals(sysAppDeploy.getDeployType()) && "2".equals(sysAppDeploy.getDeployType())) {
                            sysAppDeployList.remove(i);
                            --i;
                            logger.info("{}\u8be5\u5e94\u7528\u6784\u5efa\u4fe1\u606f\u4e3a{}\u7684\u90e8\u7f72\u73af\u5883\u5df2\u56de\u6536==============", (Object)sysApplication.getAppCode(), (Object)sysAppDevops.getDevDefinitionId());
                            break;
                        }
                        String definitionId = null;
                        if ("1".equals(sysAppDeploy.getDeployType()) || "2".equals(sysAppDeploy.getDeployType())) {
                            definitionId = sysAppDevops.getDevDefinitionId();
                        } else if ("3".equals(sysAppDeploy.getDeployType())) {
                            definitionId = sysAppDevops.getTestDefinitionId();
                        } else if ("4".equals(sysAppDeploy.getDeployType())) {
                            definitionId = sysAppDevops.getProdDefinitionId();
                        }
                        String stageName = this.getBuilddefs(sysAppDevops.getDevDefinitionId());
                        if (HussarUtils.isNotBlank((CharSequence)stageName) && stageName.contains("9:")) {
                            map.put("projectDeploy", "0");
                        }
                        if (HussarUtils.isBlank((CharSequence)stageName)) {
                            if (null == map.get("projectDeploy")) {
                                map.put("stageName", "");
                                map.put("devopsStatus", "0");
                            } else {
                                map.put("stageName", "");
                                map.put("devopsStatus", "1");
                            }
                        } else {
                            map.put("stageName", this.getBuilddefs(sysAppDevops.getDevDefinitionId()));
                        }
                    }
                    list.add(map);
                    continue;
                }
                map.put("env", env);
                map.put("isPublish", sysAppDeploy.getIsPublish());
                map.put("devopsStatus", sysAppDeploy.getDevopsStatus());
                map.put("stageName", "");
            }
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
        return list;
    }

    private void getDevopsInfo(SysApplication sysApplication, SysAppDeploy sysAppDeploy, List res) {
        Long appId = sysApplication.getId();
        String isOnline = sysApplication.getIsOnline();
        String personalBrance = sysApplication.getPersonalBrance();
        String branchName = null;
        String env = null;
        if ("1".equals(sysAppDeploy.getDeployType())) {
            branchName = "1".equals(personalBrance) ? "dev" : "master";
            env = "\u5f00\u53d1\u73af\u5883";
        } else if ("2".equals(sysAppDeploy.getDeployType())) {
            branchName = sysAppDeploy.getBranchName();
            env = "\u5f00\u53d1\u73af\u5883-" + this.sysUsersService.getUser(sysAppDeploy.getUserId()).getUserName();
        } else if ("3".equals(sysAppDeploy.getDeployType())) {
            if ("1".equals(isOnline) || "1".equals(personalBrance)) {
                branchName = "dev";
                env = "\u6d4b\u8bd5\u73af\u5883";
            } else {
                branchName = "master";
                env = "\u6b63\u5f0f\u73af\u5883";
            }
        }
        Wrapper devopsWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId)).eq((Object)"BRANCH", (Object)branchName);
        SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsMapper.selectOne(devopsWrapper);
        String definitionId = null;
        if (null != sysAppDevops) {
            if ("1".equals(sysAppDeploy.getDeployType()) || "2".equals(sysAppDeploy.getDeployType())) {
                definitionId = sysAppDevops.getDevDefinitionId();
            } else if ("3".equals(sysAppDeploy.getDeployType())) {
                definitionId = sysAppDevops.getTestDefinitionId();
            } else if ("4".equals(sysAppDeploy.getDeployType())) {
                definitionId = sysAppDevops.getProdDefinitionId();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ENV", env);
            map.put("isPublish", sysAppDeploy.getIsPublish());
            map.put("devopsStatus", sysAppDeploy.getDevopsStatus());
            if ("2".equals(sysAppDeploy.getIsPublish())) {
                map.put("stageName", this.getBuilddefs(sysAppDevops.getDevDefinitionId()));
            } else {
                map.put("stageName", "");
            }
            res.add(map);
        } else {
            logger.info("{}\u8be5\u5e94\u7528\u7684{}\u5206\u652f\u65e0devops\u90e8\u7f72\u4fe1\u606f\uff1a===============", (Object)appId, (Object)branchName);
        }
    }

    public Boolean updateStatus(SysAppDevopsDto sysAppDevopsDto) {
        logger.info("devops\u56de\u8c03\u63a5\u53e3\u63a5\u6536\u53c2\u6570\uff1asysAppDevopsDto------{}", (Object)(null == sysAppDevopsDto ? "" : sysAppDevopsDto.toString()));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("PROJECT_ID", sysAppDevopsDto.getProjectId());
        List list = this.sysAppDevopsMapper.selectByMap(param);
        Long appId = null;
        if (HussarUtils.isNotEmpty((Object)list)) {
            appId = ((SysAppDevops)list.get(0)).getAppId();
        }
        if (null == appId) {
            logger.info("devops\u56de\u8c03\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u6709\u8bef\uff1a===================");
            return false;
        }
        String deployType = "";
        if ("DEV".equals(sysAppDevopsDto.getEnv()) && "dev".equals(sysAppDevopsDto.getBranch())) {
            deployType = "1";
        } else if ("DEV".equals(sysAppDevopsDto.getEnv()) && !"dev".equals(sysAppDevopsDto.getBranch())) {
            deployType = "2";
        } else if ("TEST".equals(sysAppDevopsDto.getEnv())) {
            deployType = "3";
        } else if ("PROD".equals(sysAppDevopsDto.getEnv())) {
            deployType = "4";
        }
        SysAppDeploy sysAppDeploy = null;
        sysAppDeploy = "2".equals(deployType) ? (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)appId)).eq(SysAppDeploy::getDeployType, (Object)deployType)).eq(SysAppDeploy::getBranchName, (Object)sysAppDevopsDto.getBranch())).eq(SysAppDeploy::getDelFlag, (Object)"0")) : (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)appId)).eq(SysAppDeploy::getDeployType, (Object)deployType));
        if ("200".equals(sysAppDevopsDto.getStatus())) {
            if (sysAppDeploy != null) {
                sysAppDeploy.setDevopsStatus("1");
                this.sysDeployService.updateById((Object)sysAppDeploy);
            }
        } else if (sysAppDeploy != null) {
            sysAppDeploy.setIsPublish("3");
            this.sysDeployService.updateById((Object)sysAppDeploy);
        }
        return true;
    }

    private static String getAppType(String appType) {
        String type = "";
        type = "1".equals(appType) ? "web" : ("2".equals(appType) ? "app" : ("3".equals(appType) ? "h5" : ""));
        return type;
    }
}

