/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.SysUsersApplicationVo;
import com.jxdinfo.hussar.base.portal.application.constant.AppConstants;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppAuthUserMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppAuthUserDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppDeployDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppAuthUser;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevops;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDomain;
import com.jxdinfo.hussar.base.portal.application.model.SysAppResource;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthUserService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevopsService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDomainService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppResourceService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.base.portal.yamlServer.service.IYamlService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppAuthUserServiceImpl")
public class SysAppAuthUserServiceImpl
extends HussarServiceImpl<SysAppAuthUserMapper, SysAppAuthUser>
implements ISysAppAuthUserService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppAuthUserServiceImpl.class);
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    ISysDeployService sysDeployService;
    @Resource
    IYamlService yamlService;
    @Resource
    IGitlabService gitlabService;
    @Resource
    ISysUserRoleService sysUserRoleService;
    @Resource
    ISysApplicationService sysApplicationService;
    @Resource
    SysAppAuthUserMapper sysAppAuthUserMapper;
    @Resource
    ISysAppDomainService sysAppDomainService;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    private ISysAppResourceService sysAppResourceService;
    @Resource
    private ISysAppDevopsService sysAppDevopsService;

    public List<SysUsersApplicationVo> getUsers(Long appId, String authType) {
        return this.sysAppAuthUserMapper.getUsers(appId, authType);
    }

    public ApiResponse<String> addAuthUser(SysAppAuthUserDto sysAppAuthUserDto) {
        try {
            Long appId = sysAppAuthUserDto.getAppId();
            List userList = sysAppAuthUserDto.getSysAppAuthUserList();
            String authType = sysAppAuthUserDto.getAuthType();
            List authUserList = this.sysAppAuthUserMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId)).eq((Object)"DEL_FLAG", (Object)"0")).eq((Object)"AUTH_TYPE", (Object)authType));
            if (HussarUtils.isNotEmpty((Object)userList) && HussarUtils.isNotEmpty((Object)authUserList)) {
                block2: for (int i = 0; i < authUserList.size(); ++i) {
                    for (int j = 0; j < userList.size(); ++j) {
                        if (!((SysAppAuthUser)authUserList.get(i)).getUserId().equals(((SysAppAuthUser)userList.get(j)).getUserId())) continue;
                        authUserList.remove(i);
                        userList.remove(j);
                        --i;
                        --j;
                        continue block2;
                    }
                }
            }
            this.deleteAndAddUserAuth(authUserList, userList, authType, appId);
            return ApiResponse.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    public ApiResponse<Page<SysAppAuthUser>> getAuthUser(SysAppAuthUserDto sysAppAuthUserDto) {
        Page pager = new Page(sysAppAuthUserDto.getPage().getCurrent(), sysAppAuthUserDto.getPage().getSize());
        return ApiResponse.success(this.sysAppAuthUserMapper.getUserListByUserId((Page<SysAppAuthUser>)pager, sysAppAuthUserDto));
    }

    public Long addDeploy(SysAppDeployDto sysAppDeployDto) {
        Long time = System.currentTimeMillis();
        SysAppDeploy sysAppDeploy = sysAppDeployDto.getSysAppDeploy();
        if (sysAppDeploy != null) {
            sysAppDeploy.setDeployStatus("1");
            sysAppDeploy.setDeployType("2");
            sysAppDeploy.setDelFlag("0");
            sysAppDeploy.setIsPublish("2");
            sysAppDeploy.setDevopsStatus("0");
        }
        Boolean onlineAuth = sysAppDeployDto.getOnlineAuth();
        String token = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId()).getChar1();
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppDeploy.getAppId());
        SysAppDeploy sysAppDeployOld = (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysAppDeploy.getAppId())).eq(SysAppDeploy::getUserId, (Object)sysAppDeploy.getUserId())).eq(SysAppDeploy::getDelFlag, (Object)"0"));
        if (null == sysAppDeployOld) {
            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03\uff1a\u65e7\u90e8\u7f72\u4fe1\u606fsysAppDeployOld===null==============================");
        } else {
            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03\uff1a\u65e7\u90e8\u7f72\u4fe1\u606fsysAppDeployOld=============================={}", (Object)sysAppDeployOld.toString());
        }
        if (null == sysAppDeployOld) {
            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u7b2c\u4e00\u6b21\u90e8\u7f72==============================");
            Long count = this.sysDeployService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysAppDeploy.getAppId())).eq(SysAppDeploy::getBranchName, (Object)sysAppDeploy.getBranchName()));
            if (count > 0L) {
                logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u5206\u652f\u540d\u5df2\u5b58\u5728\uff0c\u4e0d\u505a\u64cd\u4f5c==============================");
                throw new BaseException("\u5206\u652f\u540d\u5df2\u5b58\u5728\uff0c\u4e0d\u505a\u64cd\u4f5c");
            }
            new Thread(() -> {
                try {
                    if (onlineAuth.booleanValue()) {
                        String[] appTypeArray;
                        logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u7b2c\u4e00\u6b21\u90e8\u7f72\uff1a\u66f4\u65b0\u4ee3\u7801\u5230\u672c\u5730==========================");
                        this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), token, "dev");
                        logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u7b2c\u4e00\u6b21\u90e8\u7f72\uff1a\u751f\u6210values\u6a21\u677f\u6587\u4ef6==========================");
                        this.yamlService.createValues(sysAppDeploy, sysApplication.getAppType(), sysApplication.getAppCode(), time, "DEV", sysAppDeploy.getBranchName());
                        logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u7b2c\u4e00\u6b21\u90e8\u7f72\uff1a\u5bf9\u63a5gitlab,\u521b\u5efa\u76f8\u5e94\u7684\u5206\u652f\uff0c\u63d0\u4ea4\u4ee3\u7801==========================");
                        this.gitlabService.createDevByUser(sysApplication.getAppCreateType(), sysApplication.getAppCode(), sysAppDeploy.getBranchName(), token, time);
                        logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u7b2c\u4e00\u6b21\u90e8\u7f72\uff1a\u5bf9\u63a5devops\u5f00\u59cb==========================");
                        SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)"dev"));
                        logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u7b2c\u4e00\u6b21\u90e8\u7f72\uff1a\u4f7f\u7528dev\u5206\u652f\u67e5\u8be2\u67e5\u8be2\u5173\u4e8edevops\u90e8\u7f72\u4fe1\u606f\uff1a=========================={}", (Object)sysAppDevops.toString());
                        SysAppDevops sysAppDevops1 = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeploy.getBranchName()));
                        if (sysAppDevops1 == null) {
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u7b2c\u4e00\u6b21\u90e8\u7f72\uff1a\u5bf9\u63a5devops\u521b\u5efa\u4e2a\u4eba\u6d41\u6c34\u7ebf\u5f00\u59cb\uff1a==========================");
                            JSONObject json = this.sysAppDevopsService.createPipelineByPerson(sysApplication, sysAppDeploy, sysAppDevops.getProjectId());
                            if ("200".equals(json.getString("statusCode"))) {
                                sysAppDevops1 = new SysAppDevops();
                                sysAppDevops1.setAppId(sysApplication.getId());
                                sysAppDevops1.setProjectId(sysAppDevops.getProjectId());
                                sysAppDevops1.setDevDefinitionId(json.getString("definitionId"));
                                sysAppDevops1.setTestDefinitionId("");
                                sysAppDevops1.setProdDefinitionId("");
                                sysAppDevops1.setBranch(sysAppDeploy.getBranchName());
                                sysAppDevops1.setRecoverFlag("1");
                                sysAppDevops1.setEnv("DEV");
                                sysAppDevops1.setVersion(Integer.valueOf(Integer.parseInt(json.get((Object)"version").toString())));
                                sysAppDevops1.setReleas(json.get((Object)"releas").toString());
                                logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u7b2c\u4e00\u6b21\u90e8\u7f72\uff1a\u4fdd\u5b58\u4e2a\u4eba\u5206\u652f\u6784\u5efa\u6d41\u6c34\u7ebf\u4fe1\u606f{}", (Object)sysAppDevops1.toString());
                                this.sysAppDevopsService.save((Object)sysAppDevops1);
                            } else {
                                logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u7b2c\u4e00\u6b21\u90e8\u7f72\uff1a\u5bf9\u63a5devops\uff0c\u6784\u5efa\u4e2a\u4eba\u5206\u652f\u6d41\u6c34\u7ebf\u5931\u8d25\uff1a==========================");
                                return;
                            }
                        }
                        String frontType = "";
                        for (String appType : appTypeArray = sysApplication.getAppType().split(",")) {
                            frontType = "".equals(frontType) ? SysAppAuthUserServiceImpl.getAppType(appType) : frontType + "," + SysAppAuthUserServiceImpl.getAppType(appType);
                        }
                        logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u7b2c\u4e00\u6b21\u90e8\u7f72\uff1a\u5bf9\u63a5devops\uff0c\u6267\u884c\u6d41\u6c34\u7ebf\u5f00\u59cb\uff1a==========================");
                        this.sysAppDevopsService.executePipeline(sysAppDevops1.getDevDefinitionId(), "v" + sysAppDevops1.getVersion(), frontType, "n", "DEV", sysAppDeploy.getBranchName(), sysAppDeploy);
                        this.sysAppResourceService.countApplicationNum(sysApplication.getDevelopResourceId());
                    } else {
                        this.gitlabService.createBranch(sysApplication.getAppCode(), sysAppDeploy.getBranchName(), token);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
                }
            }).start();
            this.sysDeployService.saveSysDeploy(sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain = new SysAppDomain();
                sysAppDomain.setId(sysAppDeploy.getDomainId());
                sysAppDomain.setDomainStatus("1");
                this.sysAppDomainService.updateStatus(sysAppDomain);
            }
        } else {
            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u591a\u6b21\u90e8\u7f72==============================");
            if (sysAppDeploy.getBranchName().equals(sysAppDeployOld.getBranchName())) {
                logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03----\u591a\u6b21\u90e8\u7f72----\u672a\u4fee\u6539\u5206\u652f\u540d\u79f0\uff1a==============================");
                if (onlineAuth.booleanValue()) {
                    new Thread(() -> {
                        try {
                            String[] appTypeArray;
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03------\u591a\u6b21\u90e8\u7f72----\u672a\u4fee\u6539\u5206\u652f\u540d\u79f0:\u66f4\u65b0\u4ee3\u7801\u5230\u672c\u5730==========================");
                            this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), token, sysAppDeploy.getBranchName());
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03------\u591a\u6b21\u90e8\u7f72----\u672a\u4fee\u6539\u5206\u652f\u540d\u79f0:\u751f\u6210values\u6a21\u677f\u6587\u4ef6==========================");
                            this.yamlService.createValues(sysAppDeploy, sysApplication.getAppType(), sysApplication.getAppCode(), time, "DEV", sysAppDeploy.getBranchName());
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03------\u591a\u6b21\u90e8\u7f72----\u672a\u4fee\u6539\u5206\u652f\u540d\u79f0:\u5207\u6362\u5206\u652f\uff0c\u63d0\u4ea4\u4ee3\u7801==========================");
                            this.gitlabService.pushToGit(this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), sysApplication.getAppCode(), sysApplication.getAppDescribe(), sysAppDeploy.getBranchName(), token);
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03-------\u591a\u6b21\u90e8\u7f72----\u672a\u4fee\u6539\u5206\u652f\u540d\u79f0:\u5bf9\u63a5devops\u5f00\u59cb\uff1a==========================");
                            SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)"dev"));
                            SysAppDevops sysAppDevops1 = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeploy.getBranchName()));
                            if (null == sysAppDevops1 || "0".equals(sysAppDevops1.getRecoverFlag())) {
                                this.sysAppResourceService.countApplicationNum(sysApplication.getDevelopResourceId());
                            }
                            if (sysAppDevops1 == null) {
                                logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72----\u672a\u4fee\u6539\u5206\u652f\u540d\u79f0\uff1a\u5f53\u65e0\u6d41\u6c34\u7ebf\u4fe1\u606f\uff0c\u5bf9\u63a5devops\u521b\u5efa\u4e2a\u4eba\u6d41\u6c34\u7ebf\u5f00\u59cb\uff1a==========================");
                                JSONObject json = this.sysAppDevopsService.createPipelineByPerson(sysApplication, sysAppDeploy, sysAppDevops.getProjectId());
                                if ("200".equals(json.getString("statusCode"))) {
                                    sysAppDevops1 = new SysAppDevops();
                                    sysAppDevops1.setAppId(sysApplication.getId());
                                    sysAppDevops1.setProjectId(sysAppDevops.getProjectId());
                                    sysAppDevops1.setDevDefinitionId(json.getString("definitionId"));
                                    sysAppDevops1.setTestDefinitionId("");
                                    sysAppDevops1.setProdDefinitionId("");
                                    sysAppDevops1.setBranch(sysAppDeploy.getBranchName());
                                    sysAppDevops1.setRecoverFlag("1");
                                    sysAppDevops1.setEnv("DEV");
                                    sysAppDevops1.setVersion(Integer.valueOf(Integer.parseInt(json.get((Object)"version").toString())));
                                    sysAppDevops1.setReleas(json.get((Object)"releas").toString());
                                    logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03-----\u591a\u6b21\u90e8\u7f72----\u672a\u4fee\u6539\u5206\u652f\u540d\u79f0\uff1a\u5f53\u65e0\u6d41\u6c34\u7ebf\u4fe1\u606f\uff0c\u7b2c\u4e00\u6b21\u4fdd\u5b58\u5206\u652f\u6784\u5efa\u6d41\u6c34\u7ebf\u4fe1\u606f{}", (Object)sysAppDevops1.toString());
                                    this.sysAppDevopsService.save((Object)sysAppDevops1);
                                } else {
                                    logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03--\u591a\u6b21\u90e8\u7f72----\u672a\u4fee\u6539\u5206\u652f\u540d\u79f0\uff1a\u5f53\u65e0\u6d41\u6c34\u7ebf\u4fe1\u606f\uff0c\u5bf9\u63a5devops\uff0c\u6784\u5efa\u4e2a\u4eba\u5206\u652f\u6d41\u6c34\u7ebf\u5931\u8d25\uff1a==========================");
                                    return;
                                }
                            }
                            String frontType = "";
                            for (String appType : appTypeArray = sysApplication.getAppType().split(",")) {
                                frontType = "".equals(frontType) ? SysAppAuthUserServiceImpl.getAppType(appType) : frontType + "," + SysAppAuthUserServiceImpl.getAppType(appType);
                            }
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72----\u672a\u4fee\u6539\u5206\u652f\u540d\u79f0\uff1a\u6267\u884c\u6d41\u6c34\u7ebf\uff0c\u5bf9\u63a5devops\u521b\u5efa\u4e2a\u4eba\u6d41\u6c34\u7ebf\u5f00\u59cb\uff1a==========================");
                            this.sysAppDevopsService.executePipeline(sysAppDevops1.getDevDefinitionId(), "v" + sysAppDevops1.getVersion(), frontType, "n", "DEV", sysAppDeploy.getBranchName(), sysAppDeploy);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
                        }
                    }).start();
                }
                this.sysDeployService.updateDeploy(sysAppDeploy);
            } else {
                logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72---\u4fee\u6539\u5206\u652f\u540d\uff1a==============================");
                Long count = this.sysDeployService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysAppDeploy.getAppId())).eq(SysAppDeploy::getBranchName, (Object)sysAppDeploy.getBranchName()));
                if (count > 0L) {
                    logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72---\u5206\u652f\u540d\u5df2\u5b58\u5728\uff1a==============================");
                    throw new BaseException("\u5206\u652f\u540d\u5df2\u5b58\u5728\uff0c\u4e0d\u505a\u64cd\u4f5c");
                }
                new Thread(() -> {
                    try {
                        if (onlineAuth.booleanValue()) {
                            String[] appTypeArray;
                            SysAppDevops sysAppDevops1;
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72---\u4fee\u6539\u5206\u652f\u540d\uff1a\u66f4\u65b0\u4ee3\u7801\u5230\u672c\u5730==============================");
                            this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), token, "dev");
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72---\u4fee\u6539\u5206\u652f\u540d\uff1a\u751f\u6210values.yaml\u6a21\u677f\u6587\u4ef6==============================");
                            this.yamlService.createValues(sysAppDeploy, sysApplication.getAppType(), sysApplication.getAppCode(), time, "DEV", sysAppDeploy.getBranchName());
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72---\u4fee\u6539\u5206\u652f\u540d\uff1a\u5bf9\u63a5gitlab,\u521b\u5efa\u76f8\u5e94\u7684\u5206\u652f\uff0c\u63d0\u4ea4\u4ee3\u7801==============================");
                            this.gitlabService.createDevByUser(sysApplication.getAppCreateType(), sysApplication.getAppCode(), sysAppDeploy.getBranchName(), token, time);
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72---\u4fee\u6539\u5206\u652f\u540d\uff1a\u5bf9\u63a5devops\u5f00\u59cb==============================");
                            SysAppDevops devopsOldInfo = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeployOld.getBranchName()));
                            SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)"dev"));
                            if (null != devopsOldInfo) {
                                logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72---\u4fee\u6539\u5206\u652f\u540d\uff1a\u91ca\u653e\u65e7\u5206\u652f\u6d41\u6c34\u7ebf\u90e8\u7f72==============================");
                                this.sysAppDevopsService.releaseResource(sysApplication.getAppCode() + "-" + sysAppDeployOld.getBranchName());
                            }
                            if (null == (sysAppDevops1 = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeploy.getBranchName()))) || "0".equals(sysAppDevops1.getRecoverFlag())) {
                                this.sysAppResourceService.countApplicationNum(sysApplication.getDevelopResourceId());
                            }
                            if (sysAppDevops1 == null) {
                                logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72---\u4fee\u6539\u5206\u652f\u540d\uff1a\u65b0\u5206\u652f\u5bf9\u63a5devops\u521b\u5efa\u6d41\u6c34\u7ebf\u5f00\u59cb\uff1a==============================");
                                JSONObject json = this.sysAppDevopsService.createPipelineByPerson(sysApplication, sysAppDeploy, sysAppDevops.getProjectId());
                                if ("200".equals(json.getString("statusCode"))) {
                                    sysAppDevops1 = new SysAppDevops();
                                    sysAppDevops1.setAppId(sysApplication.getId());
                                    sysAppDevops1.setProjectId(sysAppDevops.getProjectId());
                                    sysAppDevops1.setDevDefinitionId(json.getString("definitionId"));
                                    sysAppDevops1.setTestDefinitionId("");
                                    sysAppDevops1.setProdDefinitionId("");
                                    sysAppDevops1.setBranch(sysAppDeploy.getBranchName());
                                    sysAppDevops1.setRecoverFlag("1");
                                    sysAppDevops1.setEnv("DEV");
                                    sysAppDevops1.setVersion(Integer.valueOf(Integer.parseInt(json.get((Object)"version").toString())));
                                    sysAppDevops1.setReleas(json.get((Object)"releas").toString());
                                    this.sysAppDevopsService.save((Object)sysAppDevops1);
                                } else {
                                    logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72---\u4fee\u6539\u5206\u652f\u540d\uff1a\u65b0\u5206\u652f\u5bf9\u63a5devops\u521b\u5efa\u6d41\u6c34\u7ebf\u5931\u8d25==============================");
                                    return;
                                }
                            }
                            String frontType = "";
                            for (String appType : appTypeArray = sysApplication.getAppType().split(",")) {
                                frontType = "".equals(frontType) ? SysAppAuthUserServiceImpl.getAppType(appType) : frontType + "," + SysAppAuthUserServiceImpl.getAppType(appType);
                            }
                            logger.info("\u4e2a\u4eba\u5206\u652f\u53d1\u5e03---\u591a\u6b21\u90e8\u7f72---\u4fee\u6539\u5206\u652f\u540d\uff1a\u65b0\u5206\u652f\u6267\u884c\u6d41\u6c34\u7ebf\u5f00\u59cb==============================");
                            this.sysAppDevopsService.executePipeline(sysAppDevops1.getDevDefinitionId(), "v" + sysAppDevops1.getVersion(), frontType, "n", "DEV", sysAppDeploy.getBranchName(), sysAppDeploy);
                        } else {
                            this.gitlabService.createBranch(sysApplication.getAppCode(), sysAppDeploy.getBranchName(), token);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
                    }
                }).start();
                this.sysDeployService.updateDelFlag(sysAppDeploy.getAppId(), sysAppDeploy.getUserId());
                sysAppDeploy.setAppDeployId(Long.valueOf(IdWorker.getId((Object)new SysAppDeploy())));
                this.sysDeployService.saveSysDeploy(sysAppDeploy);
            }
            if (!HussarUtils.isEmpty((Object)sysAppDeployOld.getDomainId())) {
                if (!sysAppDeployOld.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(sysAppDeployOld.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.sysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.sysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.sysAppDomainService.updateStatus(sysAppDomain2);
            }
        }
        return time;
    }

    private static String getAppType(String appType) {
        String type = "";
        type = "1".equals(appType) ? "web" : ("2".equals(appType) ? "app" : ("3".equals(appType) ? "h5" : ""));
        return type;
    }

    public Boolean addRoles(String userIds, String userAccounts) {
        List userRoleList = this.sysUserRoleService.selectUserIdByRoleId(String.valueOf(AppConstants.APP_ADMIN_ID));
        if (HussarUtils.isNotEmpty((Object)userIds)) {
            ArrayList<String> userIdList = new ArrayList<String>(Arrays.asList(userIds.split(",")));
            block0: for (int i = 0; i < userRoleList.size(); ++i) {
                for (int j = 0; j < userIdList.size(); ++j) {
                    if (!((String)userRoleList.get(i)).equals(userIdList.get(j))) continue;
                    userRoleList.remove(i);
                    userIdList.remove(j);
                    --i;
                    --j;
                    continue block0;
                }
            }
            this.addUserApplicationAdmin(userIdList);
        }
        this.deleteUserApplicationAdmin(userRoleList);
        return true;
    }

    public List<SysUsersApplicationVo> getRoles() {
        return this.sysAppAuthUserMapper.getRoles();
    }

    public ApiResponse<String> updateAppAuthUser(Long appAuthId, Boolean onlineAuth) {
        logger.info("\u5206\u5f00\u7ebf\u4e0a\u5f00\u53d1\u6743\u9650\uff1aappAuthId\uff1a----{},onlineAuth---->{}", (Object)appAuthId, (Object)onlineAuth);
        try {
            logger.info("\u5f00\u542f\u7ebf\u4e0a\u5f00\u53d1\u6743\u9650\uff1a=================");
            SysAppAuthUser authUser = (SysAppAuthUser)this.getById(appAuthId);
            SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)authUser.getAppId());
            if (onlineAuth.booleanValue()) {
                authUser.setOnlineAuth("1");
                logger.info("\u5f00\u542f\u7ebf\u4e0a\u5f00\u53d1\u6743\u9650\u9879\u76ee\u9080\u8bf7\u4eba\u5458\uff1a=================");
                this.gitlabService.inviteUserJoinGroupOrProject(this.sysUsersService.getUser(authUser.getUserId()).getUserAccount(), this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId()).getChar1(), "projects", sysApplication.getAppCode(), false);
                new Thread(() -> {
                    try {
                        logger.info("\u540c\u6b65\u5f00\u53d1\u4eba\u5458\u4eba\u5458\u5230\u65b0\u5e94\u7528\u6570\u636e\u5e93\uff1a=================");
                        this.sysApplicationService.syncDevloper(String.valueOf(authUser.getUserId()), String.valueOf(authUser.getAppId()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            } else {
                logger.info("\u5173\u95ed\u7ebf\u4e0a\u5f00\u53d1\u6743\u9650\uff1a=================");
                authUser.setOnlineAuth("0");
                logger.info("\u5173\u95ed\u7ebf\u4e0a\u5f00\u53d1\u6743\u9650\u9879\u76ee\u4e2d\u53bb\u9664\u4eba\u5458\uff1a=================");
                this.gitlabService.deleteUserFGroupOrProject(this.sysUsersService.getUser(authUser.getUserId()).getUserAccount(), this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId()).getChar1(), "projects", sysApplication.getAppCode());
                if ("1".equals(sysApplication.getPersonalBrance())) {
                    SysAppDeploy sysAppDeploy = this.sysDeployService.getAppDeplyByAppId(sysApplication.getId(), authUser.getUserId());
                    logger.info("\u5173\u95ed\u7ebf\u4e0a\u5f00\u53d1\u6743\u9650\u90e8\u7f72\u4fe1\u606f\uff1asysAppDeploy\uff1a-----{}", (Object)sysAppDeploy);
                    SysAppDevops devopsInfo = null;
                    if (null != sysAppDeploy) {
                        devopsInfo = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeploy.getBranchName()));
                    }
                    logger.info("\u5173\u95ed\u7ebf\u4e0a\u5f00\u53d1\u6d41\u6c34\u7ebf\u90e8\u7f72\u4fe1\u606f\uff1adevopsInfo\uff1a-----{}", devopsInfo);
                    if (null != sysAppDeploy && null != devopsInfo) {
                        int count = this.sysDeployService.getCountByUserId(sysApplication.getId(), authUser.getUserId());
                        if (count > 0) {
                            SysAppResource sysAppResource = (SysAppResource)this.sysAppResourceService.getById((Serializable)sysApplication.getDevelopResourceId());
                            sysAppResource.setResidueNum(Integer.valueOf(sysAppResource.getResidueNum() + count));
                            sysAppResource.setAssignedNum(Integer.valueOf(sysAppResource.getAssignedNum() - count));
                            this.sysAppResourceService.updateById((Object)sysAppResource);
                            logger.info("\u4fee\u6539\u53d1\u5e03\u72b6\u6001\uff1a=================");
                            this.sysDeployService.updateIsPublishByUserId(sysApplication.getId(), authUser.getUserId());
                        }
                        logger.info("\u5173\u95ed\u5f00\u53d1\u4eba\u5458\u7ebf\u4e0a\u5f00\u53d1\u6743\u9650\uff1a\u91ca\u653e\u90e8\u7f72\u73af\u5883\u8d44\u6e90\u5f00\u59cb\uff1a=================================");
                        this.sysAppDevopsService.releaseResource(sysApplication.getAppCode() + "-" + sysAppDeploy.getBranchName());
                    }
                }
            }
            this.updateById((BaseEntity)authUser);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ApiResponse.success();
    }

    public boolean addAuthUserBatch(List<SysAppAuthUser> sysAppAuthUserList) {
        for (int i = 0; i < sysAppAuthUserList.size(); ++i) {
            this.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)sysAppAuthUserList.get(i).getAppId())).eq((Object)"USER_ID", (Object)sysAppAuthUserList.get(i).getUserId()));
        }
        return this.saveBatch(sysAppAuthUserList);
    }

    public Boolean deleteUserApplicationAdmin(List<String> userRoleList) {
        for (String item : userRoleList) {
            this.sysUserRoleService.deleteByUserIdAndGrantedRole(Long.valueOf(Long.parseLong(item)), AppConstants.APP_ADMIN_ID);
            SysUsers sysUsers = this.sysUsersService.getUser(Long.valueOf(Long.parseLong(item)));
            sysUsers.setChar1("");
            this.sysUsersService.updateById((Object)sysUsers);
        }
        return true;
    }

    public Boolean addUserApplicationAdmin(List<String> userIdList) {
        for (int i = 0; i < userIdList.size(); ++i) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(Long.valueOf(Long.parseLong(userIdList.get(i))));
            sysUserRole.setGrantedRole(AppConstants.APP_ADMIN_ID);
            sysUserRole.setAdminOption("1");
            this.sysUserRoleService.save((Object)sysUserRole);
            SysUsers sysUsers = this.sysUsersService.getUser(Long.valueOf(Long.parseLong(userIdList.get(i))));
            SysUsers superAdmin = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
            sysUsers.setChar1(superAdmin.getChar1());
            this.sysUsersService.updateById((Object)sysUsers);
        }
        return true;
    }

    private void deleteAndAddUserAuth(List<SysAppAuthUser> deleteUserList, List<SysAppAuthUser> addUserList, String authType, Long appId) {
        SysApplication appInfo = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
        if (HussarUtils.isNotEmpty(deleteUserList)) {
            for (SysAppAuthUser item : deleteUserList) {
                item.setDelFlag("1");
                if ("1".equals(authType) && "1".equals(appInfo.getIsOnline())) {
                    this.gitlabService.deleteUserFGroupOrProject(this.sysUsersService.getUser(item.getUserId()).getUserAccount(), this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId()).getChar1(), "projects", appInfo.getAppCode());
                }
                this.sysAppAuthUserMapper.update(item, (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"AUTH_TYPE", (Object)authType)).eq((Object)"APP_ID", (Object)appId)).eq((Object)"USER_ID", (Object)item.getUserId()));
                SysAppDeploy sysAppDeploy = this.sysDeployService.getAppDeplyByAppId(appId, item.getUserId());
                if (sysAppDeploy != null) {
                    SysAppDevops devopsInfo;
                    sysAppDeploy.setIsPublish("0");
                    this.sysDeployService.updateById((Object)sysAppDeploy);
                    if (!"1".equals(appInfo.getPersonalBrance()) || null == (devopsInfo = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)appInfo.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeploy.getBranchName())))) continue;
                    int count = this.sysDeployService.getCountByUserId(appId, item.getUserId());
                    if (count > 0) {
                        SysAppResource sysAppResource = (SysAppResource)this.sysAppResourceService.getById((Serializable)appInfo.getDevelopResourceId());
                        sysAppResource.setResidueNum(Integer.valueOf(sysAppResource.getResidueNum() + count));
                        sysAppResource.setAssignedNum(Integer.valueOf(sysAppResource.getAssignedNum() - count));
                        this.sysAppResourceService.updateById((Object)sysAppResource);
                    }
                    logger.info("\u5e94\u7528\u6388\u6743\uff1a\u5220\u9664\u4eba\u5458id---{}\u91ca\u653e\u4e2a\u4eba\u5206\u652fbranchName--->{}\u90e8\u7f72\u73af\u5883\u8d44\u6e90\u5f00\u59cb\uff1a=================================", (Object)item.getUserId(), (Object)sysAppDeploy.getBranchName());
                    this.sysAppDevopsService.releaseResource(appInfo.getAppCode() + "-" + sysAppDeploy.getBranchName());
                    continue;
                }
                logger.info("\u5e94\u7528\u6388\u6743\uff1a\u8be5\u4eba\u5458{}\u6ca1\u6709\u90e8\u7f72\u4fe1\u606f================", (Object)item.getUserId());
            }
        }
        if (HussarUtils.isNotEmpty(addUserList)) {
            for (SysAppAuthUser item : addUserList) {
                item.setAppId(appId);
                item.setDelFlag("0");
                item.setOnlineAuth("0");
                if (this.sysUserRoleService.getUserRole(item.getUserId(), AppConstants.DEV_ROLE) < 1) {
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(item.getUserId());
                    sysUserRole.setGrantedRole(AppConstants.DEV_ROLE);
                    sysUserRole.setAdminOption("1");
                    this.sysUserRoleService.save((Object)sysUserRole);
                }
                this.save((BaseEntity)item);
            }
        }
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }
}

