/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.model.SysUpgrade;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysUpgradeService;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationGroup;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u589e\u91cf\u5347\u7ea7"})
@RestController(value="com.jxdinfo.hussar.base.portal.application.controller.SysUpgradeController")
@RequestMapping(value={"/hussarBase/application/upgrade/"})
public class SysUpgradeController {
    @Resource
    private ISysUpgradeService sysUpgradeService;
    @Resource
    private ISysApplicationService sysApplicationService;

    @PostMapping(value={"/pageList"})
    @CheckPermission(value={"hussarBase:upgrade:pageList"})
    @ApiOperation(value="\u67e5\u8be2\u589e\u91cf\u5347\u7ea7\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u589e\u91cf\u5347\u7ea7\u5217\u8868\u6570\u636e")
    public ApiResponse<Page<SysUpgrade>> getUpgradeList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @RequestBody JSONObject jsonObject) {
        Page page = (Page)jsonObject.toJavaObject(Page.class);
        SysUpgrade sysUpgrade = (SysUpgrade)jsonObject.toJavaObject(SysUpgrade.class);
        AbstractWrapper queryWrapper = ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEL_FLAG", (Object)"1")).eq(!HussarUtils.isEmpty((Object)sysUpgrade.getUpGradeType()), (Object)"UPGRADE_TYPE", (Object)sysUpgrade.getUpGradeType())).like(!HussarUtils.isEmpty((Object)sysUpgrade.getFileName()), (Object)"FILE_NAME", (Object)sysUpgrade.getFileName())).like(!HussarUtils.isEmpty((Object)sysUpgrade.getVersion()), (Object)"VERSION", (Object)sysUpgrade.getVersion())).like(!HussarUtils.isEmpty((Object)sysUpgrade.getComment()), (Object)"COMMENT", (Object)sysUpgrade.getComment());
        return ApiResponse.success((Object)this.sysUpgradeService.page((IPage)page, (Wrapper)queryWrapper));
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u589e\u91cf\u5347\u7ea7\u6570\u636e", notes="\u65b0\u589e\u589e\u91cf\u5347\u7ea7\u6570\u636e")
    public ApiResponse<Boolean> addSysUpgrade(@ApiParam(value="\u589e\u91cf\u5347\u7ea7\u6570\u636e\u5b9e\u4f53") @RequestBody SysUpgrade sysUpgrade) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FILE_NAME", (Object)sysUpgrade.getFileName())).eq((Object)"DEL_FLAG", (Object)"1");
        if (this.sysUpgradeService.count(queryWrapper) > 0L) {
            return ApiResponse.fail((String)"\u6807\u9898\u5df2\u5b58\u5728");
        }
        return ApiResponse.success((Object)this.sysUpgradeService.save((Object)sysUpgrade));
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u4fee\u6539\u589e\u91cf\u5347\u7ea7\u6570\u636e", notes="\u4fee\u6539\u589e\u91cf\u5347\u7ea7\u6570\u636e")
    public ApiResponse<Boolean> updateTemplate(@ApiParam(value="\u589e\u91cf\u5347\u7ea7\u6570\u636e\u5b9e\u4f53") @RequestBody SysUpgrade sysUpgrade) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FILE_NAME", (Object)sysUpgrade.getFileName())).ne((Object)"UPGRADE_ID", (Object)sysUpgrade.getUpGradeId())).eq((Object)"DEL_FLAG", (Object)"1");
        if (this.sysUpgradeService.count(queryWrapper) > 0L) {
            return ApiResponse.fail((String)"\u6807\u9898\u5df2\u5b58\u5728");
        }
        return ApiResponse.success((Object)this.sysUpgradeService.updateById((Object)sysUpgrade));
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u83b7\u53d6\u5347\u7ea7\u6570\u636e\u8be6\u60c5", notes="\u83b7\u53d6\u5347\u7ea7\u6570\u636e\u8be6\u60c5")
    public ApiResponse<SysUpgrade> getTemplateDetail(@ApiParam(value="\u5347\u7ea7\u6570\u636e\u8be6\u60c5id") @RequestParam Long upgradeId) {
        return ApiResponse.success((Object)this.sysUpgradeService.getById((Serializable)upgradeId));
    }

    @PostMapping(value={"/delete"})
    @CheckPermission(value={"hussarBase:upgrade:delete"})
    @ApiOperation(value="\u5220\u9664\u589e\u91cf\u5347\u7ea7\u6570\u636e", notes="\u5220\u9664\u589e\u91cf\u5347\u7ea7\u6570\u636e")
    public ApiResponse<Boolean> deleteUpgrade(@ApiParam(value="\u589e\u91cf\u5347\u7ea7\u6570\u636eid") @RequestParam String upgradeIdArray) {
        return ApiResponse.success((Object)this.sysUpgradeService.deleteById(upgradeIdArray));
    }

    @PostMapping(value={"/download"})
    @CheckPermission(value={"hussarBase:upgrade:download"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f", notes="\u4e0b\u8f7d\u6a21\u677f")
    public void download(Long id, HttpServletResponse response) {
        this.sysUpgradeService.downloadSysUpgrade(id, response);
    }

    @PostMapping(value={"/import"})
    @CheckPermission(value={"hussarBase:upgrade:import"})
    @ApiOperation(value="\u5bfc\u5165\u5347\u7ea7\u5305", notes="\u5bfc\u5165\u5347\u7ea7\u5305")
    public ApiResponse<Long> importUpgrade(@ApiParam(value="\u5347\u7ea7\u5305") @RequestParam(value="file") MultipartFile file, @ApiParam(value="\u5347\u7ea7\u4fe1\u606f") @Validated @RequestPart SysUpgrade sysUpgrade) throws IOException {
        return ApiResponse.success((Object)this.sysUpgradeService.importSysUpgrade(file, sysUpgrade));
    }

    @PostMapping(value={"/getAllApplication"})
    @CheckPermission(value={"hussarBase:upgrade:getAllApplication"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5e94\u7528", notes="\u67e5\u8be2\u6240\u6709\u5e94\u7528")
    public ApiResponse<Page<SysApplicationGroup>> getAllApplication(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @RequestBody JSONObject jsonObject) {
        Page page = (Page)jsonObject.toJavaObject(Page.class);
        SysApplication sysApplication = (SysApplication)jsonObject.toJavaObject(SysApplication.class);
        sysApplication.setDelFlag("0");
        return ApiResponse.success((Object)this.sysApplicationService.pageList(page, sysApplication));
    }

    @GetMapping(value={"/upgradeApplication"})
    @CheckPermission(value={"hussarBase:upgrade:upgradeApplication"})
    @ApiOperation(value="\u5347\u7ea7\u9009\u4e2d\u5e94\u7528\u7684\u6240\u6709\u5206\u652f", notes="\u5347\u7ea7\u9009\u4e2d\u5e94\u7528\u7684\u6240\u6709\u5206\u652f")
    public ApiResponse<Long> upgradeApplication(@RequestParam String appId, @RequestParam Long upgradeId) {
        if (HussarUtils.isBlank((CharSequence)appId)) {
            return ApiResponse.fail((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5347\u7ea7\u7684\u5e94\u7528");
        }
        return ApiResponse.success((Object)this.sysUpgradeService.upgradeApplication(appId, upgradeId));
    }

    @GetMapping(value={"/autoUpgradeApplication"})
    @CheckPermission(value={"hussarBase:upgrade:autoUpgradeApplication"})
    @ApiOperation(value="\u5f00\u53d1\u4eba\u5458\u81ea\u4e3b\u5347\u7ea7", notes="\u5f00\u53d1\u4eba\u5458\u81ea\u4e3b\u5347\u7ea7")
    public ApiResponse<Long> autoUpgradeApplication(@RequestParam Long appId, @RequestParam Long upgradeId) {
        return ApiResponse.success((Object)this.sysUpgradeService.autoUpgradeApplication(appId, upgradeId));
    }
}

