/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDevopsMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppDevopsDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevops;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevopsService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.DESUtil;
import com.jxdinfo.hussar.common.utils.DevopsUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppDevopsServiceImpl")
public class SysAppDevopsServiceImpl
extends HussarServiceImpl<SysAppDevopsMapper, SysAppDevops>
implements ISysAppDevopsService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppDevopsServiceImpl.class);
    @Value(value="${devops.uri.devops-uri}")
    private String devopsUri;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    private SysAppDevopsMapper sysAppDevopsMapper;
    @Resource
    private ISysDeployService sysDeployService;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    ISysApplicationService sysApplicationService;

    public JSONObject createProjectAndPipeline(SysApplication sysApplication, SysAppDeploy sysAppDeploy, String branch) {
        String[] appTypeArray;
        logger.info("\u7b2c\u4e00\u6b21\u5e94\u7528\u53d1\u5e03\uff1a\u521b\u5efa\u521b\u5efa\u3001\u6d41\u6c34\u7ebf\u521b\u5efa\u6570\u636e\u5e93");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> project = new HashMap<String, String>();
        project.put("projectCode", sysApplication.getAppCode());
        project.put("projectName", sysApplication.getAppName());
        String frontType = "";
        for (String appType : appTypeArray = sysApplication.getAppType().split(",")) {
            frontType = "".equals(frontType) ? SysAppDevopsServiceImpl.getAppType(appType) : frontType + "," + SysAppDevopsServiceImpl.getAppType(appType);
        }
        project.put("projectType", frontType);
        project.put("projectCategory", "project");
        project.put("projectTemplateId", "project-template-default");
        dataMap.put("project", project);
        dataMap.put("gitUrl", this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        dataMap.put("branch", branch);
        dataMap.put("templateName", "JXD");
        dataMap.put("databaseType", SysAppDevopsServiceImpl.databaseType(sysAppDeploy.getDatabasetType()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("databaseIp", sysAppDeploy.getDatabaseUrl());
        map.put("databasePort", sysAppDeploy.getDatabasePort());
        map.put("databaseName", sysAppDeploy.getDatabaseName());
        map.put("databaseUser", sysAppDeploy.getDatabaseAccount());
        map.put("databasePassword", DESUtil.encrypt((String)"qddt@2023", (String)sysAppDeploy.getDatabasePassword()));
        int version = 0;
        SysAppDevops sysAppDevops = (SysAppDevops)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)branch));
        version = sysAppDevops != null ? sysAppDevops.getVersion() + 1 : 1;
        map.put("version", "v" + version);
        map.put("releas", sysApplication.getAppCode() + "-" + branch);
        map.put("imageRepo", sysAppDeploy.getAppNamespace());
        dataMap.put("map", map);
        String urlDevops = this.devopsUri + "api/integration/ddm";
        logger.info("\u5bf9\u63a5devops\u8c03\u7528\u63a5\u53e3\uff1aurl--> {}", (Object)urlDevops);
        logger.info("\u5bf9\u63a5devops\u8c03\u7528\u63a5\u53e3\uff1aparams--> {}", dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u5bf9\u63a5devops\u8fd4\u56de\u53c2\u6570\uff1ajson:-->{},", (Object)json);
        json.put("version", (Object)version);
        json.put("releas", (Object)(sysApplication.getAppCode() + "-" + branch));
        logger.info("\u5bf9\u63a5devops\u8fd4\u56de\u53c2\u6570\u6dfb\u52a0\u53c2\u6570\uff1ajson:-->{},", (Object)json);
        return json;
    }

    public JSONObject executePipeline(String definitionId, String version, String frontType, String isInit, String branch, SysAppDeploy sysAppDeploy) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> project = new HashMap<String, String>();
        project.put("version", version);
        project.put("databaseIp", sysAppDeploy.getDatabaseUrl());
        project.put("databasePort", sysAppDeploy.getDatabasePort());
        project.put("databaseName", sysAppDeploy.getDatabaseName());
        project.put("databaseUser", sysAppDeploy.getDatabaseAccount());
        project.put("databasePassword", DESUtil.encrypt((String)"qddt@2023", (String)sysAppDeploy.getDatabasePassword()));
        dataMap.put("buildParams", project);
        dataMap.put("frontType", frontType);
        dataMap.put("isInit", isInit);
        dataMap.put("imageRepo", sysAppDeploy.getAppNamespace());
        String urlDevops = this.devopsUri + "api/integration/ddm/" + definitionId + "/execute";
        logger.info("\u5bf9\u63a5devops\u6267\u884c\u6d41\u6c34\u7ebfurl:--->urlDevops{}", (Object)urlDevops);
        logger.info("\u5bf9\u63a5devops\u6267\u884c\u6d41\u6c34\u7ebfparam:--->dataMap\uff1a{}", dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u5bf9\u63a5devops\u6267\u884c\u6d41\u6c34\u7ebf\u8fd4\u56de\u7ed3\u679cresult:--->json\uff1a{}", (Object)json);
        return json;
    }

    public JSONObject createPipelineByPerson(SysApplication sysApplication, SysAppDeploy sysAppDeploy, String projectId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("projectId", projectId);
        dataMap.put("gitUrl", this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        dataMap.put("branch", sysAppDeploy.getBranchName());
        dataMap.put("templateName", "JXD");
        HashMap<String, String> map = new HashMap<String, String>();
        String userName = this.sysUsersService.getUser(sysAppDeploy.getUserId()).getUserName();
        map.put("developer", sysApplication.getAppCode() + "-" + userName);
        int version = 0;
        SysAppDevops sysAppDevops = (SysAppDevops)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeploy.getBranchName()));
        version = sysAppDevops != null ? sysAppDevops.getVersion() + 1 : 1;
        map.put("version", "v" + version);
        map.put("projectCode", sysApplication.getAppCode());
        map.put("releas", sysApplication.getAppCode() + "-" + sysAppDeploy.getBranchName());
        dataMap.put("map", map);
        String urlDevops = this.devopsUri + "api/integration/ddm/build/branch";
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        json.put("version", (Object)version);
        json.put("releas", (Object)(sysApplication.getAppCode() + "-" + sysAppDeploy.getBranchName()));
        return json;
    }

    private static String databaseType(String databaseType) {
        String name = "";
        if (HussarUtils.isNotEmpty((Object)databaseType)) {
            switch (databaseType) {
                case "1": {
                    name = "oracle";
                    break;
                }
                case "2": {
                    name = "mysql";
                    break;
                }
                case "3": {
                    name = "dameng";
                    break;
                }
                default: {
                    name = "db2";
                }
            }
        }
        return name;
    }

    public JSONObject releaseResource(String relase) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("env", "DEV");
        dataMap.put("relase", relase);
        String urlDevops = this.devopsUri + "/api/integration/ddm/remove/relase";
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        return json;
    }

    private String getBuilddefs(String buildDefinitionId) {
        String stageName = "";
        CloseableHttpClient httpclients = null;
        try {
            JSONObject json;
            JSONObject pipelineInstance;
            JSONObject executingStageInstance;
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(this.devopsUri + "api/ci/builddefs/" + buildDefinitionId + "/instances");
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject == null) {
                String string = null;
                return string;
            }
            JSONArray data = JSONArray.parseArray((String)jsonObject.getString("data"));
            if (data.size() > 0 && (executingStageInstance = JSON.parseObject((String)(pipelineInstance = JSON.parseObject((String)(json = JSON.parseObject((String)data.get(0).toString())).getString("pipelineInstance"))).getString("executingStageInstance"))) != null) {
                stageName = executingStageInstance.getString("stageName");
            }
            String string = stageName;
            return string;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
    }

    public List<Map<String, Object>> getBuilddefAll(List<SysAppDevops> sysAppDevopsList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String devStageName = "";
        String testStageName = "";
        String prodStageName = "";
        Object httpclients = null;
        try {
            for (SysAppDevops sysAppDevops : sysAppDevopsList) {
                String prodDefinitionId;
                String testDefinitionId;
                SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppDevops.getAppId());
                String devDefinitionId = sysAppDevops.getDevDefinitionId();
                if (devDefinitionId != null) {
                    HashMap<String, String> mapDev = new HashMap<String, String>();
                    devStageName = this.getBuilddefs(devDefinitionId);
                    Wrapper sysAppDeployWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"APP_ID", (Object)sysAppDevops.getAppId());
                    SysAppDeploy sysAppDeploy = (SysAppDeploy)this.sysDeployService.getOne(sysAppDeployWrapper);
                    mapDev.put("appCode", sysApplication.getAppCode());
                    mapDev.put("env", "DEV");
                    mapDev.put("stageName", devStageName);
                    if (sysAppDeploy != null) {
                        mapDev.put("isPublish", sysAppDeploy.getIsPublish());
                    } else {
                        mapDev.put("isPublish", "0");
                    }
                    list.add(mapDev);
                }
                if ((testDefinitionId = sysAppDevops.getTestDefinitionId()) != null) {
                    HashMap<String, String> mapTest = new HashMap<String, String>();
                    testStageName = this.getBuilddefs(testDefinitionId);
                    Wrapper sysAppDeployWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEPLOY_TYPE", (Object)"3")).eq((Object)"APP_ID", (Object)sysAppDevops.getAppId());
                    SysAppDeploy sysAppDeploy = (SysAppDeploy)this.sysDeployService.getOne(sysAppDeployWrapper);
                    mapTest.put("appCode", sysApplication.getAppCode());
                    mapTest.put("env", "TEST");
                    mapTest.put("stageName", testStageName);
                    if (sysAppDeploy != null) {
                        mapTest.put("isPublish", sysAppDeploy.getIsPublish());
                    } else {
                        mapTest.put("isPublish", "0");
                    }
                    list.add(mapTest);
                }
                if ((prodDefinitionId = sysAppDevops.getProdDefinitionId()) == null) continue;
                HashMap<String, String> mapProd = new HashMap<String, String>();
                prodStageName = this.getBuilddefs(prodDefinitionId);
                Wrapper sysAppDeployWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEPLOY_TYPE", (Object)"4")).eq((Object)"APP_ID", (Object)sysAppDevops.getAppId());
                SysAppDeploy sysAppDeploy = (SysAppDeploy)this.sysDeployService.getOne(sysAppDeployWrapper);
                mapProd.put("appCode", sysApplication.getAppCode());
                mapProd.put("env", "PORD");
                mapProd.put("stageName", prodStageName);
                if (sysAppDeploy != null) {
                    mapProd.put("isPublish", sysAppDeploy.getIsPublish());
                } else {
                    mapProd.put("isPublish", "0");
                }
                list.add(mapProd);
            }
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
        return list;
    }

    public Boolean updateStatus(SysAppDevopsDto sysAppDevopsDto) {
        if ("200".equals(sysAppDevopsDto.getStatus())) {
            SysAppDevops sysAppDevops = this.sysAppDevopsMapper.getData(sysAppDevopsDto.getProjectId(), sysAppDevopsDto.getBranch());
            String deployType = "";
            if ("DEV".equals(sysAppDevopsDto.getEnv()) && "dev".equals(sysAppDevopsDto.getBranch())) {
                deployType = "1";
            } else if ("DEV".equals(sysAppDevopsDto.getEnv()) && !"dev".equals(sysAppDevopsDto.getBranch())) {
                deployType = "2";
            } else if ("TEST".equals(sysAppDevopsDto.getEnv())) {
                deployType = "3";
            } else if ("PROD".equals(sysAppDevopsDto.getEnv())) {
                deployType = "4";
            }
            SysAppDeploy sysAppDeploy = (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysAppDevops.getAppId())).eq(SysAppDeploy::getDeployType, (Object)deployType));
            if (sysAppDeploy != null) {
                sysAppDeploy.setIsPublish("1");
                this.sysDeployService.updateById((Object)sysAppDeploy);
            }
            return true;
        }
        return false;
    }

    private static String getAppType(String appType) {
        String type = "";
        type = "1".equals(appType) ? "web" : ("2".equals(appType) ? "app" : ("3".equals(appType) ? "h5" : ""));
        return type;
    }
}

