/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.staff.dao.StaffMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.base.portal.authority.dto.OrganDataAuthorityDto;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.base.portal.authority.vo.OrganDataAuthorityVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.authority.service.impl.sysAppVisitRoleServiceImpl")
public class SysAppVisitRoleOrganDataAuthorityServiceImpl
extends HussarServiceImpl<SysAppVisitRoleOrganDataAuthorityMapper, SysAppVisitRoleOrganDataAuthority>
implements ISysAppVisitRoleOrganDataAuthorityService {
    @Resource
    private StaffMapper staffMapper;

    @HussarTransactional
    public ApiResponse<Boolean> organDataAuthoritySave(OrganDataAuthorityDto organDataAuthorityDto) {
        SysAppVisitRoleOrganDataAuthority organDataAuthority = new SysAppVisitRoleOrganDataAuthority();
        StringBuilder organIdBuilder = new StringBuilder();
        StringBuilder staffIdBuilder = new StringBuilder();
        BeanUtil.copy((Object)organDataAuthorityDto, (Object)organDataAuthority);
        organDataAuthority.setOnlySupOrgan(organDataAuthorityDto.getSupOrgan());
        if (HussarUtils.isNotEmpty((Object)organDataAuthorityDto.getOrganIds())) {
            for (Long organId : organDataAuthorityDto.getOrganIds()) {
                if (organIdBuilder.length() > 0) {
                    organIdBuilder.append(",");
                }
                organIdBuilder.append(organId);
            }
        }
        organDataAuthority.setOrganIdList(organIdBuilder.toString());
        if (HussarUtils.isNotEmpty((Object)organDataAuthorityDto.getStaffIds())) {
            for (Long staffId : organDataAuthorityDto.getStaffIds()) {
                if (staffIdBuilder.length() > 0) {
                    staffIdBuilder.append(",");
                }
                staffIdBuilder.append(staffId);
            }
        }
        organDataAuthority.setStaffIdList(staffIdBuilder.toString());
        this.saveOrUpdate(organDataAuthority, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)organDataAuthorityDto.getRoleId())).eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)organDataAuthorityDto.getFormId()));
        return ApiResponse.success((Object)Boolean.TRUE, (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public ApiResponse<OrganDataAuthorityVo> organDataAuthorityList(Long formId, Long roleId) {
        if (HussarUtils.isNotEmpty((Object)formId) && HussarUtils.isNotEmpty((Object)roleId)) {
            OrganDataAuthorityVo organDataAuthorityVo = new OrganDataAuthorityVo();
            SysAppVisitRoleOrganDataAuthority organDataAuthority = (SysAppVisitRoleOrganDataAuthority)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
            if (HussarUtils.isNotEmpty((Object)organDataAuthority)) {
                BeanUtil.copy((Object)organDataAuthority, (Object)organDataAuthorityVo);
                organDataAuthorityVo.setSupOrgan(organDataAuthority.getOnlySupOrgan());
                if (HussarUtils.isNotEmpty((Object)organDataAuthority.getOrganIdList())) {
                    String[] organIds = organDataAuthority.getOrganIdList().split(",");
                    List organIdList = Arrays.stream(organIds).map(Long::valueOf).collect(Collectors.toList());
                    organDataAuthorityVo.setSimpleOrganVos(this.staffMapper.getSimpleOrgan(organIdList));
                }
                if (HussarUtils.isNotEmpty((Object)organDataAuthority.getStaffIdList())) {
                    String[] staffIds = organDataAuthority.getStaffIdList().split(",");
                    List staffIdList = Arrays.stream(staffIds).map(Long::valueOf).collect(Collectors.toList());
                    organDataAuthorityVo.setSimpleStaffVos(this.staffMapper.getByStaffId(staffIdList));
                }
            }
            return ApiResponse.success((Object)organDataAuthorityVo);
        }
        throw new BaseException("\u8868\u5355id\u6216\u89d2\u8272id\u4e3a\u7a7a");
    }

    public ApiResponse<List<OrganDataAuthorityVo>> formAuthorityOrganData(Long formId) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            List roleOrganDataAuthorities;
            List rolesList;
            SecurityUser user = BaseSecurityUtil.getUser();
            ArrayList<OrganDataAuthorityVo> organDataAuthorityVos = new ArrayList<OrganDataAuthorityVo>();
            if (HussarUtils.isNotEmpty((Object)user) && HussarUtils.isNotEmpty((Object)(rolesList = user.getRolesList())) && HussarUtils.isNotEmpty((Object)(roleOrganDataAuthorities = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).in(SysAppVisitRoleOrganDataAuthority::getRoleId, (Collection)rolesList))))) {
                for (SysAppVisitRoleOrganDataAuthority roleOrganDataAuthority : roleOrganDataAuthorities) {
                    OrganDataAuthorityVo organDataAuthorityVo = new OrganDataAuthorityVo();
                    BeanUtil.copy((Object)roleOrganDataAuthority, (Object)organDataAuthorityVo);
                    organDataAuthorityVo.setSupOrgan(roleOrganDataAuthority.getOnlySupOrgan());
                    if (HussarUtils.isNotEmpty((Object)roleOrganDataAuthority.getOrganIdList())) {
                        String[] organIds = roleOrganDataAuthority.getOrganIdList().split(",");
                        List organIdList = Arrays.stream(organIds).map(Long::valueOf).collect(Collectors.toList());
                        organDataAuthorityVo.setSimpleOrganVos(this.staffMapper.getSimpleOrgan(organIdList));
                    }
                    if (HussarUtils.isNotEmpty((Object)roleOrganDataAuthority.getStaffIdList())) {
                        String[] staffIds = roleOrganDataAuthority.getStaffIdList().split(",");
                        List staffIdList = Arrays.stream(staffIds).map(Long::valueOf).collect(Collectors.toList());
                        organDataAuthorityVo.setSimpleStaffVos(this.staffMapper.getByStaffId(staffIdList));
                    }
                    organDataAuthorityVos.add(organDataAuthorityVo);
                }
            }
            return ApiResponse.success(organDataAuthorityVos);
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }
}

