/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.gitlabServer.controller;

import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitFile;
import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitServerDto;
import com.jxdinfo.hussar.base.portal.gitlabServer.dto.UpdateFileDto;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.exception.BaseGlobalExceptionHandler;
import com.jxdinfo.hussar.common.treemodel.FileTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.ObjectError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"gitlab\u4ea4\u4e92\u63a5\u53e3"})
@RequestMapping(value={"/hussarBase/gitlab"})
public class GitlabController {
    private static final Logger logger = LoggerFactory.getLogger(BaseGlobalExceptionHandler.class);
    @Resource
    IGitlabService gitlabService;

    @ApiOperation(value="\u66f4\u65b0\u4ee3\u7801\u5230\u672c\u5730")
    @PostMapping(value={"/pull"})
    public ApiResponse<String> pull2local(@ApiParam(value="gitlab\u4ed3\u5e93\u4fe1\u606f") @Validated GitServerDto gitServerDto) {
        return ApiResponse.success((String)this.gitlabService.pull2local(gitServerDto));
    }

    @ApiOperation(value="\u63d0\u4ea4\u4ee3\u7801\u5230\u8fdc\u7a0b")
    @PostMapping(value={"/commit"})
    public ApiResponse<String> push2remote(@ApiParam(value="gitlab\u4ed3\u5e93\u4fe1\u606f") @Validated GitServerDto gitServerDto) {
        return ApiResponse.success((String)this.gitlabService.push2remote(gitServerDto));
    }

    @ApiOperation(value="\u63a8\u9001\u4ee3\u7801\u5230\u516c\u5171\u5206\u652f")
    @PostMapping(value={"/push"})
    public ApiResponse<String> merge2dev(@ApiParam(value="gitlab\u4ed3\u5e93\u4fe1\u606f") @Validated @RequestBody GitServerDto gitServerDto) {
        return ApiResponse.success((String)this.gitlabService.merge2dev(gitServerDto));
    }

    @ApiOperation(value="\u5408\u5e76\u4ee3\u7801\u5230\u4e2a\u4eba\u5206\u652f")
    @PostMapping(value={"/merge"})
    public ApiResponse<String> merge2local(@ApiParam(value="gitlab\u4ed3\u5e93\u4fe1\u606f") @Validated @RequestBody GitServerDto gitServerDto) {
        return ApiResponse.success((String)this.gitlabService.merge2local(gitServerDto));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ApiResponse methodArgumentNotValidException(MethodArgumentNotValidException e, HttpServletResponse response) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        this.toJsonContentType(response);
        return ApiResponse.fail((int)BaseExceptionEnum.BUSSINESS_EXCEPTION.getCode(), (String)((ObjectError)e.getBindingResult().getAllErrors().get(0)).getDefaultMessage());
    }

    private void toJsonContentType(HttpServletResponse response) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)response.getContentType(), (CharSequence)"application/json")) {
            response.setContentType("application/json");
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u5e94\u7528")
    @PostMapping(value={"/importApplication"})
    public ApiResponse<String> importApplication(@ApiParam(value="gitlab\u4ed3\u5e93\u4fe1\u606f") @Validated @RequestPart GitServerDto gitServerDto, @ApiParam(value="\u5e94\u7528\u538b\u7f29\u5305") @RequestParam(value="file") MultipartFile file) {
        return this.gitlabService.importApplication(gitServerDto, file);
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9")
    @PostMapping(value={"/getFileContent"})
    public ApiResponse<GitFile> getFileContent(@ApiParam(value="gitlab\u4ed3\u5e93\u4fe1\u606f") @Validated @RequestBody GitServerDto gitServerDto) {
        return ApiResponse.success((Object)this.gitlabService.getFileContent(gitServerDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u76ee\u5f55\u6811")
    @PostMapping(value={"/getAllDirectory"})
    public ApiResponse<List<FileTreeModel>> getAllDirectory(@ApiParam(value="gitlab\u4ed3\u5e93\u4fe1\u606f") @Validated @RequestBody GitServerDto gitServerDto) {
        return ApiResponse.success((Object)this.gitlabService.getAllDirectory(gitServerDto));
    }

    @ApiOperation(value="\u7ba1\u7406\u5e73\u53f0\u7f16\u8f91\u4ee3\u7801\u63d0\u4ea4\u5230gitlab")
    @PostMapping(value={"/updateFileToGitlab"})
    public ApiResponse<String> updateFileToGitlab(@ApiParam(value="gitlab\u4ed3\u5e93\u4fe1\u606f") @Validated @RequestBody UpdateFileDto updateFileDto) {
        return this.gitlabService.updateFileToGitlab(updateFileDto);
    }
}

