/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.resourceMonitor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.base.portal.resourceMonitor.dao.ResourceMonitorMapper;
import com.jxdinfo.hussar.base.portal.resourceMonitor.dto.CloudParamDto;
import com.jxdinfo.hussar.base.portal.resourceMonitor.dto.CloudResourceQueryDto;
import com.jxdinfo.hussar.base.portal.resourceMonitor.enums.CLUSTER_NETWORK;
import com.jxdinfo.hussar.base.portal.resourceMonitor.enums.CPU;
import com.jxdinfo.hussar.base.portal.resourceMonitor.enums.DISK;
import com.jxdinfo.hussar.base.portal.resourceMonitor.enums.MEMORY;
import com.jxdinfo.hussar.base.portal.resourceMonitor.enums.NODE;
import com.jxdinfo.hussar.base.portal.resourceMonitor.enums.POD_NETWORK;
import com.jxdinfo.hussar.base.portal.resourceMonitor.enums.TCP;
import com.jxdinfo.hussar.base.portal.resourceMonitor.service.IResourceMonitorService;
import com.jxdinfo.hussar.base.portal.resourceMonitor.util.OK3HttpClient;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.resourceMonitor.service.impl.ResourceMonitorServiceImpl")
public class ResourceMonitorServiceImpl
implements IResourceMonitorService {
    private static final Logger log = LoggerFactory.getLogger(ResourceMonitorServiceImpl.class);
    @Autowired
    private ResourceMonitorMapper resourceMonitorMapper;

    public JSONObject getClusterMonitor(CloudResourceQueryDto cloudResourceQueryDto) {
        JSONObject result;
        block7: {
            HashMap<String, String> queryParams;
            HashMap<String, String> headerMap;
            String url;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                CloudParamDto params = this.resourceMonitorMapper.getCloudParamDto(cloudResourceQueryDto.getAppId());
                                url = "https://msplatform-dev-tce.gyzq.com.cn/api/v2/clusters/" + params.getCluster() + "/metric/nodes/" + cloudResourceQueryDto.getNode() + "/metrics";
                                String token = "token " + params.getToken();
                                String username = params.getUsername();
                                headerMap = new HashMap<String, String>();
                                headerMap.put("Authorization", token);
                                headerMap.put("username", username);
                                queryParams = new HashMap<String, String>();
                                result = new JSONObject();
                                if (!"cpu".equals(cloudResourceQueryDto.getType())) break block6;
                                for (CPU cpu : CPU.values()) {
                                    String type = cpu.getValue();
                                    queryParams.put("type", type);
                                    this.getResult(result, url, cloudResourceQueryDto.getNode(), queryParams, headerMap);
                                }
                                break block7;
                            }
                            if (!"memory".equals(cloudResourceQueryDto.getType())) break block8;
                            for (MEMORY memory : MEMORY.values()) {
                                String type = memory.getValue();
                                queryParams.put("type", type);
                                this.getResult(result, url, cloudResourceQueryDto.getNode(), queryParams, headerMap);
                            }
                            break block7;
                        }
                        if (!"network".equals(cloudResourceQueryDto.getType())) break block9;
                        for (CLUSTER_NETWORK network : CLUSTER_NETWORK.values()) {
                            String type = network.getValue();
                            queryParams.put("type", type);
                            this.getResult(result, url, cloudResourceQueryDto.getNode(), queryParams, headerMap);
                        }
                        break block7;
                    }
                    if (!"node".equals(cloudResourceQueryDto.getType())) break block10;
                    for (NODE node : NODE.values()) {
                        String type = node.getValue();
                        queryParams.put("type", type);
                        this.getResult(result, url, cloudResourceQueryDto.getNode(), queryParams, headerMap);
                    }
                    break block7;
                }
                if (!"disk".equals(cloudResourceQueryDto.getType())) break block11;
                for (DISK disk : DISK.values()) {
                    String type = disk.getValue();
                    queryParams.put("type", type);
                    this.getResult(result, url, cloudResourceQueryDto.getNode(), queryParams, headerMap);
                }
                break block7;
            }
            if (!"tcp".equals(cloudResourceQueryDto.getType())) break block7;
            for (TCP tcp : TCP.values()) {
                String type = tcp.getValue();
                queryParams.put("type", type);
                this.getResult(result, url, cloudResourceQueryDto.getNode(), queryParams, headerMap);
            }
        }
        return result;
    }

    public JSONObject getContainerMonitor(CloudResourceQueryDto cloudResourceQueryDto) {
        CloudParamDto params = this.resourceMonitorMapper.getCloudParamDto(cloudResourceQueryDto.getAppId());
        String url = "https://msplatform-dev-tce.gyzq.com.cn/api/v2/clusters/" + params.getCluster() + "/metric/instances/" + cloudResourceQueryDto.getPodName() + "/metrics";
        String token = "token " + params.getToken();
        String username = params.getUsername();
        String spaceName = "teamspace";
        String namespace = cloudResourceQueryDto.getNamespace();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", token);
        headerMap.put("username", username);
        headerMap.put(spaceName, namespace);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        JSONObject result = new JSONObject();
        if ("cpu".equals(cloudResourceQueryDto.getType())) {
            String type = CPU.USAGE_RATE.getValue();
            queryParams.put("type", type);
            this.getResult(result, url, cloudResourceQueryDto.getPodName(), queryParams, headerMap);
        } else if ("network".equals(cloudResourceQueryDto.getType())) {
            for (POD_NETWORK PODNetwork : POD_NETWORK.values()) {
                String type = PODNetwork.getValue();
                queryParams.put("type", type);
                this.getResult(result, url, cloudResourceQueryDto.getPodName(), queryParams, headerMap);
            }
        } else if ("filesystem".equals(cloudResourceQueryDto.getType())) {
            String type = "filesystem/usage";
            queryParams.put("type", type);
            this.getResult(result, url, cloudResourceQueryDto.getPodName(), queryParams, headerMap);
        } else if ("memory".equals(cloudResourceQueryDto.getType())) {
            String type = MEMORY.USAGE.getValue();
            queryParams.put("type", type);
            this.getResult(result, url, cloudResourceQueryDto.getPodName(), queryParams, headerMap);
        }
        return result;
    }

    public JSONObject getAlertRecords(CloudResourceQueryDto cloudResourceQueryDto) {
        CloudParamDto params = this.resourceMonitorMapper.getCloudParamDto(cloudResourceQueryDto.getAppId());
        String url = "https://msplatform-dev-tce.gyzq.com.cn/api/v2/clusters/" + params.getCluster() + "/alerts/records";
        String token = "token " + params.getToken();
        String username = params.getUsername();
        String spaceName = "project";
        String namespace = cloudResourceQueryDto.getNamespace();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", token);
        headerMap.put("username", username);
        headerMap.put(spaceName, namespace);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("from", cloudResourceQueryDto.getFrom());
        queryMap.put("size", cloudResourceQueryDto.getSize());
        String res = OK3HttpClient.httpGet(url, queryMap, headerMap);
        JSONObject jsonObject = JSON.parseObject((String)res);
        JSONObject resData = jsonObject.getJSONObject("data");
        return resData;
    }

    public JSONArray getPodList(CloudResourceQueryDto cloudResourceQueryDto) {
        CloudParamDto params = this.resourceMonitorMapper.getCloudParamDto(cloudResourceQueryDto.getAppId());
        String url = "https://msplatform-dev-tce.gyzq.com.cn/api/v2/clusters/" + params.getCluster() + "/native/Pod";
        String token = "token " + params.getToken();
        String username = params.getUsername();
        String spaceName = "project";
        String namespace = cloudResourceQueryDto.getNamespace();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("authorization", token);
        headerMap.put("username", username);
        headerMap.put(spaceName, namespace);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        String res = OK3HttpClient.httpGet(url, queryParams, headerMap);
        JSONObject jsonObject = JSON.parseObject((String)res);
        JSONArray resData = jsonObject.getJSONArray("data");
        return resData;
    }

    private void getResult(JSONObject result, String url, String typeName, Map<String, String> queryParams, Map<String, String> headerMap) {
        String res = OK3HttpClient.httpGet(url, queryParams, headerMap);
        JSONArray metrics = this.getJson(typeName, res);
        String resType = StringUtil.subAfter((CharSequence)queryParams.get("type"), (char)'/', (boolean)false);
        if (HussarUtils.isNotEmpty((Object)metrics)) {
            result.put(resType, (Object)metrics);
        }
    }

    private JSONArray getJson(String typeName, String res) {
        JSONObject jsonObject = JSON.parseObject((String)res).getJSONObject(typeName);
        JSONArray metrics = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)jsonObject) && HussarUtils.isNotEmpty((Object)(metrics = jsonObject.getJSONArray("metrics")))) {
            this.formatTimestamp(metrics);
        }
        return metrics;
    }

    private void formatTimestamp(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String timestamp = jsonObject.getString("timestamp");
            LocalDateTime date = LocalDateTime.parse(timestamp, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            String dateString = date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            jsonArray.getJSONObject(i).put("timestamp", (Object)dateString);
        }
    }
}

