/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.gitlabServer.service.impl;

import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitFile;
import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitServerDto;
import com.jxdinfo.hussar.base.portal.gitlabServer.dto.UpdateFileDto;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.gitlabServer.util.PathToTreeUtils;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.FileTreeModel;
import com.jxdinfo.hussar.common.utils.DevCloudUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.file.ZipFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.gitlab4j.api.CommitsApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.RepositoryApi;
import org.gitlab4j.api.RepositoryFileApi;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.CommitAction;
import org.gitlab4j.api.models.RepositoryFile;
import org.gitlab4j.api.models.TreeItem;
import org.gitlab4j.api.models.User;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.base.portal.gitlabServer.service.impl.GitlabServiceImpl")
public class GitlabServiceImpl
implements IGitlabService {
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    private String frontGitPath;
    private String backGitPath;
    private String mobileGitPath;
    private String frontUri;
    private String backUri;
    private String mobileUri;

    @PostConstruct
    public void init() {
        this.frontGitPath = this.gitlabConfigProperty.getFrontGitPath();
        this.backGitPath = this.gitlabConfigProperty.getBackGitPath();
        this.mobileGitPath = this.gitlabConfigProperty.getMobileGitPath();
        this.frontUri = this.gitlabConfigProperty.getFrontUri();
        this.backUri = this.gitlabConfigProperty.getBackUri();
        this.mobileUri = this.gitlabConfigProperty.getMobileUri();
    }

    public String pull2local(GitServerDto gitServerDto) {
        String branch = gitServerDto.getBranch();
        String accessToken = gitServerDto.getToken();
        DevCloudUtil.pull((String)this.frontUri, (String)this.frontGitPath, (String)branch, (String)accessToken);
        DevCloudUtil.pull((String)this.backUri, (String)this.backGitPath, (String)branch, (String)accessToken);
        DevCloudUtil.pull((String)this.mobileUri, (String)this.mobileGitPath, (String)branch, (String)accessToken);
        return "\u66f4\u65b0\u6210\u529f";
    }

    public String push2remote(GitServerDto gitServerDto) {
        String message = gitServerDto.getMsg();
        if (HussarUtils.isEmpty((Object)message)) {
            message = "\u9ed8\u8ba4\u63a8\u9001\u6d88\u606f";
        }
        String branch = gitServerDto.getBranch();
        String accessToken = gitServerDto.getToken();
        DevCloudUtil.push((String)this.frontUri, (String)this.frontGitPath, (String)message, (String)branch, (String)accessToken);
        DevCloudUtil.push((String)this.backUri, (String)this.backGitPath, (String)message, (String)branch, (String)accessToken);
        DevCloudUtil.push((String)this.mobileUri, (String)this.mobileGitPath, (String)message, (String)branch, (String)accessToken);
        return "\u63d0\u4ea4\u6210\u529f";
    }

    public String merge2dev(GitServerDto gitServerDto) {
        String sourceBranch = gitServerDto.getBranch();
        String title = gitServerDto.getMsg();
        if (HussarUtils.isEmpty((Object)title)) {
            title = "\u5408\u5e76\u4e2a\u4eba\u5206\u652f\u5230dev";
        }
        String accessToken = gitServerDto.getToken();
        String targetBranch = gitServerDto.getPubBranch();
        if (HussarUtils.isBlank((CharSequence)targetBranch)) {
            throw new BaseException("\u516c\u5171\u5206\u652f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DevCloudUtil.merge((String)this.frontUri, (String)sourceBranch, (String)targetBranch, (String)title, (String)accessToken);
        DevCloudUtil.merge((String)this.backUri, (String)sourceBranch, (String)targetBranch, (String)title, (String)accessToken);
        DevCloudUtil.merge((String)this.mobileUri, (String)sourceBranch, (String)targetBranch, (String)title, (String)accessToken);
        return "\u63a8\u9001\u6210\u529f";
    }

    public String merge2local(GitServerDto gitServerDto) {
        String sourceBranch = gitServerDto.getPubBranch();
        if (HussarUtils.isBlank((CharSequence)sourceBranch)) {
            throw new BaseException("\u516c\u5171\u5206\u652f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String targetBranch = gitServerDto.getBranch();
        String accessToken = gitServerDto.getToken();
        DevCloudUtil.merge((String)this.frontUri, (String)sourceBranch, (String)targetBranch, (String)"\u5408\u5e76dev\u5230\u4e2a\u4eba\u5206\u652f", (String)accessToken);
        DevCloudUtil.merge((String)this.backUri, (String)sourceBranch, (String)targetBranch, (String)"\u5408\u5e76dev\u5230\u4e2a\u4eba\u5206\u652f", (String)accessToken);
        DevCloudUtil.merge((String)this.mobileUri, (String)sourceBranch, (String)targetBranch, (String)"\u5408\u5e76dev\u5230\u4e2a\u4eba\u5206\u652f", (String)accessToken);
        return "\u5408\u5e76\u6210\u529f";
    }

    public ApiResponse<String> importApplication(GitServerDto gitServerDto, MultipartFile multipartFile) {
        BaseException exception = new BaseException("\u53d1\u751f\u672a\u77e5\u5f02\u5e38");
        String tempPath = FileUtils.getTempDirectoryPath();
        if (ToolUtil.isEmpty((Object)multipartFile)) {
            exception.setMessage("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            throw exception;
        }
        String fileName = "hussarImportTempZip.zip";
        File outFolder = new File(tempPath + File.separator + "hussarImportUnZip");
        File tempFile = new File(tempPath + File.separator + fileName);
        try {
            multipartFile.transferTo(tempFile);
            File dir = ZipFile.unzip((File)tempFile, (File)outFolder, (Charset)Charset.forName("GBK"));
            Object[] files = dir.listFiles();
            boolean isCheck = true;
            if (ToolUtil.isNotEmpty((Object)files) && files.length == 3) {
                for (Object fileDir : files) {
                    if (!((File)fileDir).isDirectory()) {
                        isCheck = false;
                    } else {
                        switch (((File)fileDir).getName()) {
                            case "hussar-web": 
                            case "hussar-mobile": 
                            case "hussar-front": {
                                break;
                            }
                            default: {
                                isCheck = false;
                            }
                        }
                        if (isCheck) {
                            continue;
                        }
                    }
                    break;
                }
            } else {
                isCheck = false;
            }
            if (!isCheck) {
                exception.setMessage("\u6587\u4ef6\u5185\u5bb9\u4e0d\u6b63\u786e");
                throw exception;
            }
            if (HussarUtils.isEmpty((Object[])files)) {
                exception.setMessage("\u538b\u7f29\u5305\u4e2d\u5185\u5bb9\u4e3a\u7a7a");
                throw exception;
            }
            HashMap<String, String> uri = new HashMap<String, String>();
            uri.put("hussar-web", this.backUri);
            uri.put("hussar-front", this.frontUri);
            uri.put("hussar-mobile", this.mobileUri);
            if (HussarUtils.isNotEmpty((Object)gitServerDto)) {
                DevCloudUtil.upload2Gitlab((File[])files, uri, (String)gitServerDto.getBranch(), (String)gitServerDto.getToken());
            }
            ApiResponse apiResponse = ApiResponse.success((String)"success");
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            exception.setMessage("\u5bfc\u5165\u5e94\u7528\u5f02\u5e38");
            throw exception;
        }
        finally {
            try {
                this.deleteFile(outFolder);
                FileUtils.forceDelete((File)tempFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public GitFile getFileContent(GitServerDto gitServerDto) {
        int index = this.frontUri.indexOf("/", this.frontUri.indexOf("/") + 2) + 1;
        String hostUrl = this.frontUri.substring(0, index);
        GitLabApi gitLabApi = new GitLabApi(hostUrl, gitServerDto.getToken());
        String oldFilePath = gitServerDto.getFilePath();
        String topFilePath = oldFilePath.substring(0, oldFilePath.indexOf("/"));
        String filePath = oldFilePath.substring(oldFilePath.indexOf("/") + 1);
        String projectPath = "";
        switch (topFilePath) {
            case "hussar_front": {
                projectPath = this.frontUri.substring(index);
                break;
            }
            case "hussar_web": {
                projectPath = this.backUri.substring(index);
                break;
            }
            case "hussar_mobile": {
                projectPath = this.mobileUri.substring(index);
                break;
            }
            default: {
                throw new BaseException("\u6587\u4ef6\u8def\u5f84\u9519\u8bef\uff01");
            }
        }
        RepositoryFileApi repositoryFileApi = new RepositoryFileApi(gitLabApi);
        try {
            RepositoryFile repositoryFile = repositoryFileApi.getFile((Object)projectPath, filePath, gitServerDto.getBranch());
            GitFile file = new GitFile();
            String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            file.setFileName(fileName);
            file.setFilePath(oldFilePath);
            file.setFileContent(repositoryFile.getDecodedContentAsString());
            return file;
        }
        catch (GitLabApiException e) {
            throw new BaseException("\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25\uff01");
        }
    }

    public List<FileTreeModel> getAllDirectory(GitServerDto gitServerDto) {
        int index = this.frontUri.indexOf("/", this.frontUri.indexOf("/") + 2) + 1;
        String hostUrl = this.frontUri.substring(0, index);
        GitLabApi gitLabApi = new GitLabApi(hostUrl, gitServerDto.getToken());
        RepositoryApi repositoryApi = new RepositoryApi(gitLabApi);
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        String frontProjectPath = this.frontUri.substring(index);
        String webProjectPath = this.backUri.substring(index);
        String mobileProjectPath = this.mobileUri.substring(index);
        try {
            List webFileList = repositoryApi.getTree((Object)webProjectPath, "/", gitServerDto.getBranch(), Boolean.valueOf(true));
            for (Object item : webFileList) {
                HashMap<String, String> pathMap = new HashMap<String, String>(4);
                pathMap.put("user_real_path", "hussar_web/" + item.getPath());
                mapList.add(pathMap);
            }
            List frontFileList = repositoryApi.getTree((Object)frontProjectPath, "/", gitServerDto.getBranch(), Boolean.valueOf(true));
            for (TreeItem item : frontFileList) {
                HashMap<String, String> pathMap = new HashMap<String, String>(4);
                pathMap.put("user_real_path", "hussar_front/" + item.getPath());
                mapList.add(pathMap);
            }
            List mobileFileList = repositoryApi.getTree((Object)mobileProjectPath, "/", gitServerDto.getBranch(), Boolean.valueOf(true));
            for (TreeItem item : mobileFileList) {
                HashMap<String, String> pathMap = new HashMap<String, String>(4);
                pathMap.put("user_real_path", "hussar_mobile/" + item.getPath());
                mapList.add(pathMap);
            }
        }
        catch (GitLabApiException e) {
            e.printStackTrace();
            throw new BaseException("\u83b7\u53d6\u76ee\u5f55\u5931\u8d25\uff01");
        }
        return PathToTreeUtils.generateData(mapList);
    }

    public ApiResponse<String> updateFileToGitlab(UpdateFileDto updateFileDto) {
        int index = this.frontUri.indexOf("/", this.frontUri.indexOf("/") + 2) + 1;
        String hostUrl = this.frontUri.substring(0, index);
        GitLabApi gitLabApi = new GitLabApi(hostUrl, updateFileDto.getToken());
        CommitsApi commitsApi = new CommitsApi(gitLabApi);
        try {
            Commit commit;
            ArrayList<CommitAction> webCommitActions = new ArrayList<CommitAction>();
            ArrayList<CommitAction> frontCommitActions = new ArrayList<CommitAction>();
            ArrayList<CommitAction> mobileCommitActions = new ArrayList<CommitAction>();
            List fileList = updateFileDto.getFileList();
            String frontProjectPath = "";
            String webProjectPath = "";
            String mobileProjectPath = "";
            block12: for (GitFile file : fileList) {
                CommitAction commitAction = new CommitAction();
                commitAction.setAction(CommitAction.Action.UPDATE);
                String oldFilePath = file.getFilePath();
                String topFilePath = oldFilePath.substring(0, oldFilePath.indexOf("/"));
                String filePath = oldFilePath.substring(oldFilePath.indexOf("/") + 1);
                commitAction.setFilePath(filePath);
                commitAction.setContent(file.getFileContent());
                switch (topFilePath) {
                    case "hussar_front": {
                        frontProjectPath = this.frontUri.substring(index);
                        frontCommitActions.add(commitAction);
                        continue block12;
                    }
                    case "hussar_web": {
                        webProjectPath = this.backUri.substring(index);
                        webCommitActions.add(commitAction);
                        continue block12;
                    }
                    case "hussar_mobile": {
                        mobileProjectPath = this.mobileUri.substring(index);
                        mobileCommitActions.add(commitAction);
                        continue block12;
                    }
                }
                throw new BaseException("\u6587\u4ef6\u8def\u5f84\u9519\u8bef\uff01");
            }
            User user = DevCloudUtil.getUser((String)this.frontUri, (String)updateFileDto.getToken());
            String message = updateFileDto.getMsg();
            if (HussarUtils.isEmpty((Object)message)) {
                message = "\u9ed8\u8ba4\u63a8\u9001\u6d88\u606f";
            }
            if (frontCommitActions.size() > 0) {
                commit = commitsApi.createCommit((Object)frontProjectPath, updateFileDto.getBranch(), message, null, user.getEmail(), user.getName(), frontCommitActions);
            }
            if (webCommitActions.size() > 0) {
                commit = commitsApi.createCommit((Object)webProjectPath, updateFileDto.getBranch(), message, null, user.getEmail(), user.getName(), webCommitActions);
            }
            if (mobileCommitActions.size() > 0) {
                commit = commitsApi.createCommit((Object)mobileProjectPath, updateFileDto.getBranch(), message, null, user.getEmail(), user.getName(), mobileCommitActions);
            }
        }
        catch (GitLabApiException e) {
            throw new BaseException("\u63d0\u4ea4\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01");
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }
}

