/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppAuthorizeMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppAuthorizeDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppAuthorizeVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppAuthorizeServiceImpl")
public class SysAppAuthorizeServiceImpl
extends HussarServiceImpl<SysAppAuthorizeMapper, SysAppAuthorize>
implements ISysAppAuthorizeService {
    @Resource
    private SysAppAuthorizeMapper appAuthorizeMapper;

    @HussarTransactional
    public Boolean addAuthorize(SysAppAuthorizeDto appAuthorizeDto) {
        List roleIds = appAuthorizeDto.getRoleIds();
        if (HussarUtils.isEmpty((Object)roleIds)) {
            throw new HussarException("\u8bf7\u5173\u8054\u89d2\u8272");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysAppAuthorize::getAppId, (Object)appAuthorizeDto.getAppId());
        this.remove((Wrapper)queryWrapper);
        ArrayList appAuthorizeList = Lists.newArrayListWithCapacity((int)10);
        for (Long roleId : roleIds) {
            SysAppAuthorize appAuthorizeT = new SysAppAuthorize();
            appAuthorizeT.setAppId(appAuthorizeDto.getAppId());
            appAuthorizeT.setRoleId(roleId);
            appAuthorizeList.add(appAuthorizeT);
        }
        return this.saveBatch(appAuthorizeList);
    }

    public ApiResponse<List<RoleVo>> getAppRoleList(Long appId) {
        List<SysAppAuthorizeVo> appAuthorizeContainRoleInfo = this.appAuthorizeMapper.getAppAuthorizeContainRoleInfo(appId);
        if (HussarUtils.isEmpty(appAuthorizeContainRoleInfo)) {
            return ApiResponse.success(new ArrayList(), (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        ArrayList roleVos = Lists.newArrayListWithCapacity((int)10);
        for (SysAppAuthorizeVo authorizeVo : appAuthorizeContainRoleInfo) {
            RoleVo roleVo = new RoleVo();
            roleVo.setId(authorizeVo.getRoleId());
            roleVo.setRoleName(authorizeVo.getRoleName());
            roleVos.add(roleVo);
        }
        return ApiResponse.success((Object)roleVos);
    }

    public List<Long> getCurrentUserAuthorityApp() {
        List rolesList = BaseSecurityUtil.getUser().getRolesList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysAppAuthorize::getRoleId, (Collection)rolesList);
        List authorizeList = this.list((Wrapper)queryWrapper);
        Set appIdSet = authorizeList.stream().map(SysAppAuthorize::getAppId).collect(Collectors.toSet());
        return new ArrayList<Long>(appIdSet);
    }
}

