/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.gitlabServer.service.impl;

import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitServerDto;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.DevCloudUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.file.ZipFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.base.portal.gitlabServer.service.impl.GitlabServiceImpl")
public class GitlabServiceImpl
implements IGitlabService {
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    private String frontGitPath;
    private String backGitPath;
    private String mobileGitPath;
    private String frontUri;
    private String backUri;
    private String mobileUri;

    @PostConstruct
    public void init() {
        this.frontGitPath = this.gitlabConfigProperty.getFrontGitPath();
        this.backGitPath = this.gitlabConfigProperty.getBackGitPath();
        this.mobileGitPath = this.gitlabConfigProperty.getMobileGitPath();
        this.frontUri = this.gitlabConfigProperty.getFrontUri();
        this.backUri = this.gitlabConfigProperty.getBackUri();
        this.mobileUri = this.gitlabConfigProperty.getMobileUri();
    }

    public String pull2local(GitServerDto gitServerDto) {
        String branch = gitServerDto.getBranch();
        String accessToken = gitServerDto.getToken();
        DevCloudUtil.pull((String)this.frontUri, (String)this.frontGitPath, (String)branch, (String)accessToken);
        DevCloudUtil.pull((String)this.backUri, (String)this.backGitPath, (String)branch, (String)accessToken);
        DevCloudUtil.pull((String)this.mobileUri, (String)this.mobileGitPath, (String)branch, (String)accessToken);
        return "\u66f4\u65b0\u6210\u529f";
    }

    public String push2remote(GitServerDto gitServerDto) {
        String message = gitServerDto.getMsg();
        if (HussarUtils.isEmpty((Object)message)) {
            message = "\u9ed8\u8ba4\u63a8\u9001\u6d88\u606f";
        }
        String branch = gitServerDto.getBranch();
        String accessToken = gitServerDto.getToken();
        DevCloudUtil.push((String)this.frontUri, (String)this.frontGitPath, (String)message, (String)branch, (String)accessToken);
        DevCloudUtil.push((String)this.backUri, (String)this.backGitPath, (String)message, (String)branch, (String)accessToken);
        DevCloudUtil.push((String)this.mobileUri, (String)this.mobileGitPath, (String)message, (String)branch, (String)accessToken);
        return "\u63d0\u4ea4\u6210\u529f";
    }

    public String merge2dev(GitServerDto gitServerDto) {
        String sourceBranch = gitServerDto.getBranch();
        String title = gitServerDto.getMsg();
        if (HussarUtils.isEmpty((Object)title)) {
            title = "\u5408\u5e76\u4e2a\u4eba\u5206\u652f\u5230dev";
        }
        String accessToken = gitServerDto.getToken();
        String targetBranch = gitServerDto.getPubBranch();
        if (HussarUtils.isBlank((CharSequence)targetBranch)) {
            throw new BaseException("\u516c\u5171\u5206\u652f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DevCloudUtil.merge((String)this.frontUri, (String)sourceBranch, (String)targetBranch, (String)title, (String)accessToken);
        DevCloudUtil.merge((String)this.backUri, (String)sourceBranch, (String)targetBranch, (String)title, (String)accessToken);
        DevCloudUtil.merge((String)this.mobileUri, (String)sourceBranch, (String)targetBranch, (String)title, (String)accessToken);
        return "\u63a8\u9001\u6210\u529f";
    }

    public String merge2local(GitServerDto gitServerDto) {
        String sourceBranch = gitServerDto.getPubBranch();
        if (HussarUtils.isBlank((CharSequence)sourceBranch)) {
            throw new BaseException("\u516c\u5171\u5206\u652f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String targetBranch = gitServerDto.getBranch();
        String accessToken = gitServerDto.getToken();
        DevCloudUtil.merge((String)this.frontUri, (String)sourceBranch, (String)targetBranch, (String)"\u5408\u5e76dev\u5230\u4e2a\u4eba\u5206\u652f", (String)accessToken);
        DevCloudUtil.merge((String)this.backUri, (String)sourceBranch, (String)targetBranch, (String)"\u5408\u5e76dev\u5230\u4e2a\u4eba\u5206\u652f", (String)accessToken);
        DevCloudUtil.merge((String)this.mobileUri, (String)sourceBranch, (String)targetBranch, (String)"\u5408\u5e76dev\u5230\u4e2a\u4eba\u5206\u652f", (String)accessToken);
        return "\u5408\u5e76\u6210\u529f";
    }

    public ApiResponse<String> importApplication(GitServerDto gitServerDto, MultipartFile multipartFile) {
        BaseException exception = new BaseException("\u53d1\u751f\u672a\u77e5\u5f02\u5e38");
        String tempPath = FileUtils.getTempDirectoryPath();
        if (ToolUtil.isEmpty((Object)multipartFile)) {
            exception.setMessage("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            throw exception;
        }
        String fileName = "hussarImportTempZip.zip";
        File outFolder = new File(tempPath + File.separator + "hussarImportUnZip");
        File tempFile = new File(tempPath + File.separator + fileName);
        try {
            multipartFile.transferTo(tempFile);
            File dir = ZipFile.unzip((File)tempFile, (File)outFolder, (Charset)Charset.forName("GBK"));
            Object[] files = dir.listFiles();
            boolean isCheck = true;
            if (ToolUtil.isNotEmpty((Object)files) && files.length == 3) {
                for (Object fileDir : files) {
                    if (!((File)fileDir).isDirectory()) {
                        isCheck = false;
                    } else {
                        switch (((File)fileDir).getName()) {
                            case "hussar-web": 
                            case "hussar-mobile": 
                            case "hussar-front": {
                                break;
                            }
                            default: {
                                isCheck = false;
                            }
                        }
                        if (isCheck) {
                            continue;
                        }
                    }
                    break;
                }
            } else {
                isCheck = false;
            }
            if (!isCheck) {
                exception.setMessage("\u6587\u4ef6\u5185\u5bb9\u4e0d\u6b63\u786e");
                throw exception;
            }
            if (HussarUtils.isEmpty((Object[])files)) {
                exception.setMessage("\u538b\u7f29\u5305\u4e2d\u5185\u5bb9\u4e3a\u7a7a");
                throw exception;
            }
            HashMap<String, String> uri = new HashMap<String, String>();
            uri.put("hussar-web", this.backUri);
            uri.put("hussar-front", this.frontUri);
            uri.put("hussar-mobile", this.mobileUri);
            if (HussarUtils.isNotEmpty((Object)gitServerDto)) {
                DevCloudUtil.upload2Gitlab((File[])files, uri, (String)gitServerDto.getBranch(), (String)gitServerDto.getToken());
            }
            ApiResponse apiResponse = ApiResponse.success((String)"success");
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            exception.setMessage("\u5bfc\u5165\u5e94\u7528\u5f02\u5e38");
            throw exception;
        }
        finally {
            try {
                this.deleteFile(outFolder);
                FileUtils.forceDelete((File)tempFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }
}

