/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.properties;

import com.jxdinfo.hussar.base.portal.gitlabServer.constants.GitConstants;
import java.io.File;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty")
public class GitlabConfigProperty {
    @Value(value="${gitlab.uri.front-uri}")
    private String frontUri;
    @Value(value="${gitlab.uri.back-uri}")
    private String backUri;
    @Value(value="${gitlab.uri.mobile-uri}")
    private String mobileUri;
    @Value(value="${hussar-formdesign.workspace}")
    private String localPath;
    @Value(value="${hussar-formdesign.front-project-path}")
    private String frontPath;
    @Value(value="${hussar-formdesign.back-project-path}")
    private String backPath;
    @Value(value="${hussar-formdesign.mobile-front-project-path}")
    private String mobilePath;

    public String getFrontUri() {
        if (this.frontUri.endsWith(File.separator + ".git")) {
            int index = this.frontUri.indexOf(File.separator + ".git");
            this.frontUri = this.frontUri.substring(0, index);
        }
        return this.frontUri;
    }

    public void setFrontUri(String frontUri) {
        this.frontUri = frontUri;
    }

    public String getBackUri() {
        if (this.backUri.endsWith(File.separator + ".git")) {
            int index = this.backUri.indexOf(File.separator + ".git");
            this.backUri = this.backUri.substring(0, index);
        }
        return this.backUri;
    }

    public void setBackUri(String backUri) {
        this.backUri = backUri;
    }

    public String getMobileUri() {
        if (this.mobileUri.endsWith(File.separator + ".git")) {
            int index = this.mobileUri.indexOf(File.separator + ".git");
            this.mobileUri = this.mobileUri.substring(0, index);
        }
        return this.mobileUri;
    }

    public void setMobileUri(String mobileUri) {
        this.mobileUri = mobileUri;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setFrontPath(String frontPath) {
        this.frontPath = frontPath;
    }

    public void setBackPath(String backPath) {
        this.backPath = backPath;
    }

    public void setMobilePath(String mobilePath) {
        this.mobilePath = mobilePath;
    }

    public String getFrontGitPath() {
        return GitlabConfigProperty.convert(GitlabConfigProperty.convert(this.localPath) + this.frontPath) + ".git";
    }

    public String getBackGitPath() {
        return GitlabConfigProperty.convert(GitlabConfigProperty.convert(this.localPath) + this.backPath) + ".git";
    }

    public String getMobileGitPath() {
        return GitlabConfigProperty.convert(GitlabConfigProperty.convert(this.localPath) + this.mobilePath) + ".git";
    }

    private static String convert(String str) {
        StringBuilder stringBuilder = new StringBuilder(str.replace(GitConstants.TWOSEPATOR, File.separator));
        if (!str.endsWith(File.separator)) {
            stringBuilder.append(File.separator);
        }
        return stringBuilder.toString();
    }
}

