/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDevelopTeamMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDevelopTeamMemberMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppGroupMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.base.portal.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.base.portal.application.dto.AppUserAuthorizeDto;
import com.jxdinfo.hussar.base.portal.application.dto.AppUserQueryDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysUserAppConfigDto;
import com.jxdinfo.hussar.base.portal.application.enums.SysUserRole;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.base.portal.application.model.SysAppGroup;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.vo.AppDevelopTeamMemberVo;
import com.jxdinfo.hussar.base.portal.application.vo.AppOrgUserVo;
import com.jxdinfo.hussar.base.portal.application.vo.AppUserInfoVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppFormTreeVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysUserAppConfigVo;
import com.jxdinfo.hussar.base.portal.form.model.SysForm;
import com.jxdinfo.hussar.base.portal.form.model.SysFormGroup;
import com.jxdinfo.hussar.base.portal.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.base.portal.form.service.ISysFormService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.UnifyPermissionProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysApplicationServiceImpl")
public class SysApplicationServiceImpl
extends HussarServiceImpl<SysApplicationMapper, SysApplication>
implements ISysApplicationService {
    private Logger logger = LoggerFactory.getLogger(SysApplicationServiceImpl.class);
    private static final String TEAMNAME_SUFFIX = "\u5f00\u53d1\u56e2\u961f";
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysIdtableService sysIdTableService;
    @Resource
    private ISysAppRecycleService sysAppRecycleService;
    @Resource
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private SysAppGroupMapper sysAppGroupMapper;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormGroupService sysFormGroupService;
    @Resource
    private ISysFormService formService;
    @Autowired
    private UnifyPermissionProperties appProperties;
    @Autowired
    private ISysResourceMosulesService sysResourceMosulesService;
    @Autowired
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysAppAuthorizeService sysAppAuthorizeService;
    @Resource
    private ISysAppDevelopTeamService developTeamService;
    @Resource
    private SysAppDevelopTeamMapper developTeamMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysAppDevelopTeamMemberService developTeamMemberService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysStruAssistOrganService iSysStruAssistOrganService;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private SysAppDevelopTeamMemberMapper sysAppDevelopTeamMemberMapper;

    public List<SysAppGroupVo> getAppList(String appName) {
        List<Long> appIds = this.getCurrentUserAuthorityApp();
        if (HussarUtils.isEmpty(appIds)) {
            return null;
        }
        List<Object> appList = new ArrayList();
        ArrayList<Long> groupIds = new ArrayList<Long>();
        appList = this.sysApplicationMapper.getAppList(appName, appIds);
        for (SysApplication sysApplication : appList) {
            groupIds.add(sysApplication.getAppGroupId());
        }
        ArrayList<SysAppGroup> sysAppGroups = new ArrayList();
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysAppGroups = this.sysAppGroupMapper.getAppGroup(null, groupIds);
        }
        ArrayList<SysApplicationVo> arrayList = new ArrayList<SysApplicationVo>();
        for (SysApplication sysApplication : appList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)sysApplication, (Object)vo);
            arrayList.add(vo);
        }
        return this.combinedData(arrayList, sysAppGroups);
    }

    public List<SysAppGroupVo> getManageAppList(Long appGroupId, String appName, String appStatus) {
        List<Long> appIds;
        List<SysApplication> appList;
        ArrayList appListVo = Lists.newArrayListWithCapacity((int)10);
        SecurityUser user = BaseSecurityUtil.getUser();
        ArrayList<SysAppGroup> sysAppGroups = new ArrayList();
        if (user.isSuperAdmin() || user.getRolesList().contains((Object)SysUserRole.APPLICATIONADMIN)) {
            appList = this.sysApplicationMapper.getAppListManage(appGroupId, appName, appStatus, null);
            if (HussarUtils.isEmpty((Object)appGroupId) && HussarUtils.isEmpty((Object)appName) && HussarUtils.isEmpty((Object)appStatus)) {
                LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                wrapper.orderByDesc(HussarBaseEntity::getCreateTime);
                sysAppGroups = this.sysAppGroupService.list((Wrapper)wrapper);
            } else {
                ArrayList<Long> groupIds = new ArrayList<Long>();
                for (SysApplication sysApplication : appList) {
                    groupIds.add(sysApplication.getAppGroupId());
                }
                if (HussarUtils.isNotEmpty(groupIds)) {
                    sysAppGroups = this.sysAppGroupMapper.getAppGroup(null, groupIds);
                }
            }
        } else {
            appIds = this.developTeamService.selectAppListByCurrentUser();
            if (HussarUtils.isEmpty((Object)appIds)) {
                return null;
            }
            appList = this.sysApplicationMapper.getAppListManage(appGroupId, appName, appStatus, appIds);
            ArrayList<Long> groupIds = new ArrayList<Long>();
            for (SysApplication sysApplication : appList) {
                groupIds.add(sysApplication.getAppGroupId());
            }
            sysAppGroups = this.sysAppGroupMapper.getAppGroup(BaseSecurityUtil.getUser().getUserId(), groupIds);
        }
        appIds = appList.stream().map(SysApplication::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(appIds)) {
            List<SysAppDevelopTeam> sysAppDevelopTeams = this.developTeamMapper.selectAppDevelopTeamList(appIds);
            Map map = sysAppDevelopTeams.stream().collect(Collectors.toMap(SysAppDevelopTeam::getAppId, Function.identity()));
            for (SysApplication app : appList) {
                SysApplicationVo vo = new SysApplicationVo();
                BeanUtils.copyProperties((Object)app, (Object)vo);
                if (null != map.get(vo.getId())) {
                    vo.setTeamId(((SysAppDevelopTeam)map.get(vo.getId())).getId());
                }
                if (ToolUtil.isNotEmpty((Object)user) && ToolUtil.isNotEmpty((Object)vo)) {
                    vo.setIsCreator(Boolean.valueOf(user.getId().equals(vo.getCreator()) || user.isSuperAdmin()));
                }
                appListVo.add(vo);
            }
        }
        return this.combinedData(appListVo, sysAppGroups);
    }

    @HussarTransactional
    public Boolean addApp(SysApplicationDto sysApplicationDto) {
        List sysApplications = this.sysApplicationMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)sysApplicationDto.getAppCode())).eq(SysApplication::getAppStatus, (Object)"1"));
        if (ToolUtil.isNotEmpty((Object)sysApplications)) {
            throw new BaseException("\u5e94\u7528\u7f16\u7801\u91cd\u590d\uff01");
        }
        Long appId = IdWorker.getId((Object)new SysApplicationDto());
        sysApplicationDto.setId(appId);
        sysApplicationDto.setAppStatus("1");
        sysApplicationDto.setReleaseStatus("0");
        sysApplicationDto.setAppType("2");
        sysApplicationDto.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        String teamName = sysApplicationDto.getAppName() + TEAMNAME_SUFFIX;
        AppDevelopTeamDto developTeamDto = new AppDevelopTeamDto();
        developTeamDto.setAppId(appId);
        developTeamDto.setTeamName(teamName);
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(BaseSecurityUtil.getUser().getId());
        if (!BaseSecurityUtil.getUser().isSuperAdmin()) {
            userList.add(SysUserAndRole.SUPERADMIN.getValue());
        }
        developTeamDto.setUserIds(userList);
        this.developTeamService.saveAppDevelopTeam(developTeamDto);
        return this.save((BaseEntity)sysApplicationDto);
    }

    public Boolean updateApp(SysApplicationDto sysApplicationDto) {
        return this.updateById((BaseEntity)sysApplicationDto);
    }

    @HussarTransactional
    public Boolean deleteApp(Long appId) {
        SysApplication appInfo = (SysApplication)this.getById(appId);
        appInfo.setAppStatus("0");
        return this.updateById((BaseEntity)appInfo);
    }

    public ApiResponse<SysApplicationVo> getAppDetail(Long appId) {
        return ApiResponse.success((Object)this.sysApplicationMapper.getAppDetailContainUserName(appId));
    }

    public SysApplicationVo getAuthorityAppDetail(Long appId) {
        SecurityUser user;
        List dataFormGroup;
        Boolean authorityFlag = this.validateAuthorityByAppId(appId);
        if (!authorityFlag.booleanValue()) {
            throw new HussarException("\u60a8\u6ca1\u6709\u8be5\u5e94\u7528\u7684\u8bbf\u95ee\u6743\u9650");
        }
        boolean designedOrNotFlag = false;
        List dataForm = (List)this.formService.getSysFormByAppId(appId).getData();
        if (HussarUtils.isNotEmpty((Object)dataForm)) {
            designedOrNotFlag = true;
        }
        if (!designedOrNotFlag && HussarUtils.isNotEmpty((Object)(dataFormGroup = (List)this.sysFormGroupService.getFormGroupList(appId).getData()))) {
            designedOrNotFlag = true;
        }
        Boolean hasAuthorityCreateForm = (user = BaseSecurityUtil.getUser()).isSuperAdmin() || user.getRolesList().contains((Object)SysUserRole.APPLICATIONADMIN) ? Boolean.valueOf(true) : this.developTeamService.checkCurrentUserInTeam(appId);
        SysApplicationVo appDetail = this.sysApplicationMapper.getAppDetail(appId);
        appDetail.setDesignedOrNot(Boolean.valueOf(designedOrNotFlag));
        appDetail.setHasAuthorityCreateForm(hasAuthorityCreateForm);
        return appDetail;
    }

    public Boolean updateSecretKey(Long appId) {
        SysApplication sysApplication = new SysApplication();
        sysApplication.setId(appId);
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        return this.updateById((BaseEntity)sysApplication);
    }

    public String getCurrentCode() {
        return this.sysIdTableService.getCurrentCode("APP_CODE", "SYS_APPLICATION");
    }

    public ApiResponse<List<SysAppFormTreeVo>> getAppFormList(Long appId) {
        ArrayList<SysAppFormTreeVo> treeList = new ArrayList<SysAppFormTreeVo>();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            SysApplication sysApplication = (SysApplication)this.getById(appId);
            SysAppFormTreeVo appTreeVo = new SysAppFormTreeVo();
            appTreeVo.setLabel(sysApplication.getAppName());
            appTreeVo.setId(sysApplication.getId().toString());
            appTreeVo.setHasChildren(Boolean.valueOf(true));
            appTreeVo.setType(1);
            treeList.add(appTreeVo);
        } else {
            List applicationList = this.list();
            for (Object sysApplication : applicationList) {
                SysAppFormTreeVo appTreeVo = new SysAppFormTreeVo();
                appTreeVo.setLabel(sysApplication.getAppName());
                appTreeVo.setId(sysApplication.getId().toString());
                appTreeVo.setHasChildren(Boolean.valueOf(true));
                appTreeVo.setType(1);
                treeList.add(appTreeVo);
            }
        }
        LambdaQueryWrapper formWrapper = Wrappers.lambdaQuery();
        formWrapper.eq(HussarUtils.isNotEmpty((Object)appId), SysFormGroup::getAppId, (Object)appId);
        formWrapper.orderByAsc(SysFormGroup::getSeq);
        List formGroupList = this.sysFormGroupService.list((Wrapper)formWrapper);
        for (SysFormGroup sysFormGroup : formGroupList) {
            SysAppFormTreeVo formGroupTreeVo = new SysAppFormTreeVo();
            formGroupTreeVo.setId(sysFormGroup.getId().toString());
            formGroupTreeVo.setLabel(sysFormGroup.getGroupName());
            formGroupTreeVo.setParentId(sysFormGroup.getAppId().toString());
            formGroupTreeVo.setIcon(sysFormGroup.getGroupIcon());
            formGroupTreeVo.setType(2);
            treeList.add(formGroupTreeVo);
        }
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(HussarUtils.isNotEmpty((Object)appId), SysForm::getAppId, (Object)appId);
        queryWrapper2.orderByAsc(SysForm::getSeq);
        List formList = this.sysFormService.list((Wrapper)queryWrapper2);
        for (SysForm sysForm : formList) {
            SysAppFormTreeVo formTreeVo = new SysAppFormTreeVo();
            formTreeVo.setId(sysForm.getId().toString());
            formTreeVo.setLabel(sysForm.getFormName());
            if (HussarUtils.isEmpty((Object)sysForm.getFormGroupId())) {
                formTreeVo.setParentId(sysForm.getAppId().toString());
            } else {
                formTreeVo.setParentId(sysForm.getFormGroupId().toString());
            }
            formTreeVo.setIcon(sysForm.getFormIcon());
            formTreeVo.setType(3);
            treeList.add(formTreeVo);
        }
        return ApiResponse.success((Object)HussarTreeParser.getTreeList(treeList));
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplicationVo sysApplication : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplicationVo> sysApplicationList = new ArrayList<SysApplicationVo>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<SysAppGroupVo>(resultCollect.values());
    }

    public Boolean validateAuthorityByAppId(Long appId) {
        List currentUserRoleList;
        HashSet currentUserRoleSet;
        ApiResponse appRoleList = this.sysAppAuthorizeService.getAppRoleList(appId);
        List roleVoList = (List)appRoleList.getData();
        if (HussarUtils.isEmpty((Object)roleVoList)) {
            return false;
        }
        Set authorityRoleSet = roleVoList.stream().map(RoleVo::getId).collect(Collectors.toSet());
        Sets.SetView intersectionSet = Sets.intersection(authorityRoleSet, currentUserRoleSet = new HashSet(currentUserRoleList = BaseSecurityUtil.getUser().getRolesList()));
        if (HussarUtils.isEmpty((Object)intersectionSet)) {
            return false;
        }
        return true;
    }

    public List<Long> getCurrentUserAuthorityApp() {
        return this.sysAppAuthorizeService.getCurrentUserAuthorityApp();
    }

    public IPage<AppOrgUserVo> getAppOrgUser(Page<AppOrgUserVo> page, AppUserQueryDto appUserQueryDto) {
        SysStru stru;
        SecurityUser user = BaseSecurityUtil.getUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", appUserQueryDto.getOrgId());
        map.put("appId", appUserQueryDto.getAppId());
        map.put("account", SqlQueryUtil.transferSpecialChar((String)appUserQueryDto.getAccount()));
        map.put("name", SqlQueryUtil.transferSpecialChar((String)appUserQueryDto.getName()));
        map.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        String struFid = "/";
        if (HussarUtils.isNotEmpty((Object)appUserQueryDto.getOrgId()) && HussarUtils.isNotEmpty((Object)(stru = (SysStru)this.sysStruMapper.selectById((Serializable)appUserQueryDto.getOrgId())))) {
            struFid = stru.getStruFid();
        }
        map.put("struFid", OrganUtil.convert((String)SqlQueryUtil.transferSpecialChar((String)struFid)));
        Long orgId = appUserQueryDto.getOrgId();
        if (ToolUtil.isNotEmpty((Object)user) && user.isGradeadmin()) {
            Long deptId = user.getDeptId();
            if (ToolUtil.isEmpty((Object)deptId)) {
                return page;
            }
            int checkResult = 1;
            if (ToolUtil.isNotEmpty((Object)orgId) && !"11".equals(String.valueOf(orgId))) {
                checkResult = this.sysStruMapper.checkIsGradeStru(deptId, orgId);
            }
            if (checkResult == 1) {
                if (!ToolUtil.isEmpty((Object)orgId)) {
                    List<AppOrgUserVo> roleOrgUserVoList = this.sysApplicationMapper.getAppOrgUser(page, map);
                    page.setRecords(roleOrgUserVoList);
                    return page;
                }
                List<Object> roleOrgUserVoList = this.sysApplicationMapper.getAppOrgUserNoPage(map);
                roleOrgUserVoList = roleOrgUserVoList.stream().filter(o -> !o.getAccount().contains("admin") && !o.getAccount().contains("hussar")).collect(Collectors.toList());
                Long struId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getEmployeeId();
                Long gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
                List userStruIdList = this.sysStruService.getChildOrgId(gradeParentId, "02");
                userStruIdList.add(BaseSecurityUtil.getUser().getId());
                QueryWrapper sysUsersQueryWrapper = new QueryWrapper();
                sysUsersQueryWrapper.lambda().in(SysUsers::getEmployeeId, (Collection)userStruIdList);
                List userIdList = this.sysUsersService.list((Wrapper)sysUsersQueryWrapper).stream().map(SysUsers::getId).collect(Collectors.toList());
                roleOrgUserVoList = roleOrgUserVoList.stream().filter(o -> userIdList.contains(o.getId())).collect(Collectors.toList());
                int current = Integer.parseInt(String.valueOf(page.getCurrent()));
                int size = Integer.parseInt(String.valueOf(page.getSize()));
                ArrayList<Object> appOrgUserVoLists = new ArrayList<Object>();
                int num = (current - 1) * size;
                if (num < roleOrgUserVoList.size()) {
                    for (int i = (current - 1) * size; i < size * current && num < roleOrgUserVoList.size(); ++num, ++i) {
                        appOrgUserVoLists.add(roleOrgUserVoList.get(i));
                    }
                }
                page.setRecords(appOrgUserVoLists);
                page.setTotal((long)roleOrgUserVoList.size());
            }
        } else {
            page.setRecords(this.sysApplicationMapper.getAppOrgUser(page, map));
        }
        return page;
    }

    public String getContainerAccessAddress(SysUserAppConfigDto sysUserAppConfigDto) {
        String containerAccessAddress = this.sysApplicationMapper.getContainerAccessAddress(sysUserAppConfigDto);
        if (ToolUtil.isNotEmpty((Object)containerAccessAddress)) {
            return containerAccessAddress;
        }
        throw new BaseException("\u8be5\u5e94\u7528\u7528\u6237\u6682\u65e0\u914d\u7f6e\u5bb9\u5668\u5730\u5740\uff01");
    }

    public Page<AppUserInfoVo> getApplicationUserList(Page<AppUserInfoVo> page, Long appId, String userName) {
        return this.sysApplicationMapper.getApplicationUserList(page, appId, userName);
    }

    public Boolean addUserAuthorize(AppUserAuthorizeDto appUserAuthorizeDto) {
        List userIds = appUserAuthorizeDto.getUserIds();
        if (HussarUtils.isEmpty((Object)userIds)) {
            throw new HussarException("\u8bf7\u5173\u8054\u7528\u6237");
        }
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appUserAuthorizeDto.getAppId()));
        this.developTeamMemberService.removeById((Serializable)sysAppDevelopTeam.getId());
        ArrayList<SysAppDevelopTeamMember> sysAppDevelopTeamMembers = new ArrayList<SysAppDevelopTeamMember>();
        for (Long userId : userIds) {
            SysAppDevelopTeamMember sysAppDevelopTeamMember = new SysAppDevelopTeamMember();
            sysAppDevelopTeamMember.setTeamId(sysAppDevelopTeam.getId());
            sysAppDevelopTeamMember.setUserId(userId);
            sysAppDevelopTeamMembers.add(sysAppDevelopTeamMember);
        }
        return this.developTeamMemberService.saveBatch(sysAppDevelopTeamMembers);
    }

    public Boolean addUserConfig(SysUserAppConfigDto sysUserAppConfigDto) {
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)sysUserAppConfigDto.getAppId()));
        SysAppDevelopTeamMember developTeamMember = (SysAppDevelopTeamMember)this.developTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getUserId, (Object)sysUserAppConfigDto.getUserId())).eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        SysApplication sysApplication = (SysApplication)this.sysApplicationMapper.selectById(sysUserAppConfigDto.getAppId());
        sysUserAppConfigDto.setTeamId(sysAppDevelopTeam.getId());
        if (sysApplication.getAppBranch().equals(sysUserAppConfigDto.getUserBranch())) {
            throw new BaseException("\u914d\u7f6e\u7528\u6237\u5e94\u7528\u5206\u652f\u540d\u4e0d\u80fd\u4e0e\u5e94\u7528\u4e3b\u5206\u652f\u540d\u76f8\u540c\uff01");
        }
        if (ToolUtil.isEmpty((Object)developTeamMember)) {
            List developTeamMemberList = this.developTeamMemberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getUserBranch, (Object)sysUserAppConfigDto.getUserBranch())).eq(SysAppDevelopTeamMember::getTeamId, (Object)sysUserAppConfigDto.getTeamId()));
            if (ToolUtil.isNotEmpty((Object)developTeamMemberList)) {
                throw new BaseException("\u914d\u7f6e\u7528\u6237\u5e94\u7528\u5206\u652f\u540d\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            List developTeamMembers = this.developTeamMemberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getContainerAccessAddress, (Object)sysUserAppConfigDto.getContainerAccessAddress())).eq(SysAppDevelopTeamMember::getTeamId, (Object)sysUserAppConfigDto.getTeamId()));
            if (ToolUtil.isNotEmpty((Object)developTeamMembers)) {
                throw new BaseException("\u914d\u7f6e\u7528\u6237\u5bb9\u5668\u5730\u5740\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            List sysAppDevelopTeamMembers = this.developTeamMemberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getNameSpace, (Object)sysUserAppConfigDto.getNameSpace())).eq(SysAppDevelopTeamMember::getTeamId, (Object)sysUserAppConfigDto.getTeamId()));
            if (ToolUtil.isNotEmpty((Object)sysAppDevelopTeamMembers)) {
                throw new BaseException("\u914d\u7f6e\u7528\u6237\u547d\u540d\u7a7a\u95f4\u4e0d\u80fd\u91cd\u590d!");
            }
            sysUserAppConfigDto.setTeamId(sysAppDevelopTeam.getId());
            return this.developTeamMemberService.save((Object)sysUserAppConfigDto);
        }
        List developTeamMemberList = this.developTeamMemberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getUserBranch, (Object)sysUserAppConfigDto.getUserBranch())).ne(SysAppDevelopTeamMember::getId, (Object)developTeamMember.getId())).eq(SysAppDevelopTeamMember::getTeamId, (Object)sysUserAppConfigDto.getTeamId()));
        if (ToolUtil.isNotEmpty((Object)developTeamMemberList)) {
            throw new BaseException("\u914d\u7f6e\u7528\u6237\u5e94\u7528\u5206\u652f\u540d\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        List developTeamMembers = this.developTeamMemberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getContainerAccessAddress, (Object)sysUserAppConfigDto.getContainerAccessAddress())).ne(SysAppDevelopTeamMember::getId, (Object)developTeamMember.getId())).eq(SysAppDevelopTeamMember::getTeamId, (Object)sysUserAppConfigDto.getTeamId()));
        if (ToolUtil.isNotEmpty((Object)developTeamMembers)) {
            throw new BaseException("\u914d\u7f6e\u7528\u6237\u5bb9\u5668\u5730\u5740\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        List sysAppDevelopTeamMembers = this.developTeamMemberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)sysUserAppConfigDto.getTeamId())).eq(SysAppDevelopTeamMember::getNameSpace, (Object)sysUserAppConfigDto.getNameSpace())).ne(SysAppDevelopTeamMember::getId, (Object)developTeamMember.getId()));
        if (ToolUtil.isNotEmpty((Object)sysAppDevelopTeamMembers)) {
            throw new BaseException("\u914d\u7f6e\u7528\u6237\u547d\u540d\u7a7a\u95f4\u4e0d\u80fd\u91cd\u590d!");
        }
        developTeamMember.setUserBranch(sysUserAppConfigDto.getUserBranch());
        developTeamMember.setContainerAccessAddress(sysUserAppConfigDto.getContainerAccessAddress());
        developTeamMember.setNameSpace(sysUserAppConfigDto.getNameSpace());
        return this.developTeamMemberService.updateById((Object)developTeamMember);
    }

    public SysUserAppConfigVo getUserConfig(SysUserAppConfigDto sysUserAppConfigDto) {
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)sysUserAppConfigDto.getAppId()));
        SysAppDevelopTeamMember developTeamMember = (SysAppDevelopTeamMember)this.developTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getUserId, (Object)sysUserAppConfigDto.getUserId())).eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        SysUserAppConfigVo sysUserAppConfigVo = new SysUserAppConfigVo();
        BeanUtils.copyProperties((Object)developTeamMember, (Object)sysUserAppConfigVo);
        return sysUserAppConfigVo;
    }

    public Boolean checkUser(String userAccount) {
        SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaUpdateWrapper().eq(SysUsers::getUserAccount, (Object)userAccount));
        return HussarUtils.isNotEmpty((Object)user);
    }

    @HussarTransactional
    public String syncDevloper(String containerPath) {
        if (containerPath == null || "".equals(containerPath)) {
            throw new BaseException("\u5bb9\u5668\u5730\u5740\u9519\u8bef\uff0c\u540c\u6b65\u7528\u6237\u5230\u5bb9\u5668\u5931\u8d25\uff01");
        }
        List strus = this.sysStruService.list();
        List staffs = this.sysStaffService.list();
        List users = this.sysUsersService.list();
        List sysStruAssistOrgan = this.iSysStruAssistOrganService.list();
        List organs = this.sysOrganService.list();
        List userRoles = this.sysUserRoleService.list();
        HashMap data = new HashMap();
        data.put("strus", strus);
        data.put("organs", organs);
        data.put("staffs", staffs);
        data.put("users", users);
        data.put("sysStruAssistOrgan", sysStruAssistOrgan);
        data.put("userRoles", userRoles);
        String url = containerPath + "/hussarApi/hussarBase/application/importData";
        System.out.println(url);
        this.post(url, data);
        return "success";
    }

    public String importData(Map<String, Object> data) {
        try {
            List strus = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)data.get("strus")), (TypeReference)new TypeReference<List<SysStru>>(){});
            List organs = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)data.get("organs")), (TypeReference)new TypeReference<List<SysOrgan>>(){});
            List staffs = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)data.get("staffs")), (TypeReference)new TypeReference<List<SysStaff>>(){});
            List users = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)data.get("users")), (TypeReference)new TypeReference<List<SysUsers>>(){});
            List sysStruAssistOrgan = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)data.get("sysStruAssistOrgan")), (TypeReference)new TypeReference<List<SysStruAssistOrgan>>(){});
            List userRoles = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)data.get("userRoles")), (TypeReference)new TypeReference<List<com.jxdinfo.hussar.authorization.permit.model.SysUserRole>>(){});
            this.insertOrUpdateList(strus);
            this.insertOrUpdateList(organs);
            this.insertOrUpdateList(staffs);
            this.insertOrUpdateList(users);
            this.insertOrUpdateList(sysStruAssistOrgan);
            Map map = this.sysUserRoleService.saveOrUpdateBatchUserRoles(userRoles);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "fail";
        }
        return "success";
    }

    public List<AppDevelopTeamMemberVo> getAppUserConfigsInfo(String appId) {
        List<SysAppDevelopTeamMember> sysAppDevelopTeamMembers = this.sysAppDevelopTeamMemberMapper.getAppUserConfigsByAppId(appId);
        ArrayList<AppDevelopTeamMemberVo> appDevelopTeamMemberVos = new ArrayList<AppDevelopTeamMemberVo>();
        if (ToolUtil.isEmpty(sysAppDevelopTeamMembers)) {
            return appDevelopTeamMemberVos;
        }
        sysAppDevelopTeamMembers.removeIf(sysAppDevelopTeamMember -> ToolUtil.isEmpty((Object)sysAppDevelopTeamMember.getNameSpace()));
        List list = sysAppDevelopTeamMembers.stream().filter(obj -> ToolUtil.isNotEmpty((Object)obj.getNameSpace())).collect(Collectors.toList());
        for (SysAppDevelopTeamMember sysAppDevelopTeamMember2 : list) {
            AppDevelopTeamMemberVo appDevelopTeamMemberVo = new AppDevelopTeamMemberVo();
            appDevelopTeamMemberVo.setUserBranch(sysAppDevelopTeamMember2.getUserBranch());
            appDevelopTeamMemberVo.setContainerAccessAddress(sysAppDevelopTeamMember2.getContainerAccessAddress());
            appDevelopTeamMemberVo.setNameSpace(sysAppDevelopTeamMember2.getNameSpace());
            appDevelopTeamMemberVos.add(appDevelopTeamMemberVo);
        }
        return appDevelopTeamMemberVos;
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer updateStaff = 0;
        Integer insertStaff = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object object = objects.get(i);
                if (object instanceof SysStru) {
                    SysStru stru = (SysStru)object;
                    if (this.sysEmployeeService.updateById((Object)stru)) {
                        if (stru.getStruType().equals("9")) {
                            n2 = updateStaff;
                            n = updateStaff = Integer.valueOf(updateStaff + 1);
                        }
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysEmployeeService.save((Object)stru);
                        if (stru.getStruType().equals("9")) {
                            n2 = insertStaff;
                            n = insertStaff = Integer.valueOf(insertStaff + 1);
                        }
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrgan) {
                    SysOrgan organ = (SysOrgan)object;
                    if (SqlHelper.retBool((Integer)this.sysOrganMapper.updateById((Object)organ))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganMapper.insert((Object)organ);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysStaff) {
                    SysStaff sysStaff = (SysStaff)object;
                    if (SqlHelper.retBool((Integer)this.sysStaffMapper.updateById((Object)sysStaff))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStaffMapper.insert((Object)sysStaff);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysUsers) {
                    SysUsers sysUsers = (SysUsers)object;
                    if (SqlHelper.retBool((Integer)this.sysUsersMapper.updateById((Object)sysUsers))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysUsersMapper.insert((Object)sysUsers);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysStruAssistOrgan) {
                    SysStruAssistOrgan sysStruAssistOrgan = (SysStruAssistOrgan)object;
                    if (SqlHelper.retBool((Integer)this.sysStruAssistOrganMapper.updateById((Object)sysStruAssistOrgan))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStruAssistOrganMapper.insert((Object)sysStruAssistOrgan);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
        }
        result.put("update", update);
        result.put("updateStaff", updateStaff);
        result.put("insertStaff", insertStaff);
        result.put("insert", insert);
        return result;
    }

    private void post(String url, Map<String, List<?>> map) {
        try {
            HttpResponse res = ((HttpRequest)((HttpRequest)HttpRequest.post((String)url).timeout(90000).contentType("application/json", "UTF-8")).bodyText(IdempotentJsonUtils.toString(map), "application/json", "utf-8")).send();
            res.charset("utf-8");
            if (res.bodyText().equals("fail")) {
                throw new BaseException("\u540c\u6b65\u7528\u6237\u5230\u5bb9\u5668\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            throw new BaseException("\u540c\u6b65\u7528\u6237\u5230\u5bb9\u5668\u5931\u8d25\uff01");
        }
    }
}

