/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.application.dao.FormdesignAppInfoMapper;
import com.jxdinfo.hussar.application.dao.FormdesignAppUserMappingMapper;
import com.jxdinfo.hussar.application.model.FormdesignAppInfo;
import com.jxdinfo.hussar.application.model.FormdesignAppUserMapping;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.app.FormDesignAppInfo;
import com.jxdinfo.hussar.formdesign.app.IApp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IAppImpl
implements IApp {
    @Autowired
    private FormdesignAppInfoMapper formdesignAppInfoMapper;
    @Autowired
    private FormdesignAppUserMappingMapper userMappingMapper;

    public FormDesignAppInfo getAppInfo(String appId) {
        FormdesignAppInfo info = (FormdesignAppInfo)this.formdesignAppInfoMapper.selectById((Serializable)((Object)appId));
        FormDesignAppInfo result = new FormDesignAppInfo();
        result.setAppId(String.valueOf(info.getAppId()));
        result.setAppName(info.getAppName());
        result.setAppDescribe(info.getAppDescribe());
        result.setEnglishName(info.getEnglishName());
        result.setCreateTime(info.getCreateTime());
        result.setTenantId(String.valueOf(info.getTenantId()));
        return result;
    }

    public String getDBNameByAppId(String appId) {
        return null;
    }

    public List<FormDesignAppInfo> listAppInfo(String userId) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId);
        List formdesignAppUserMappings = this.userMappingMapper.selectList((Wrapper)queryWrapper);
        return this.listAppInfoByAppId(formdesignAppUserMappings);
    }

    public List<FormDesignAppInfo> listAllAppInfo(String userId) {
        ArrayList<FormDesignAppInfo> result = new ArrayList<FormDesignAppInfo>();
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId);
        List formdesignAppUserMappings = this.userMappingMapper.selectList((Wrapper)queryWrapper);
        List<FormDesignAppInfo> formDesignAppInfos = this.listAppInfoByAppId(formdesignAppUserMappings);
        if (formDesignAppInfos != null) {
            result.addAll(formDesignAppInfos);
        }
        return result;
    }

    private List<FormDesignAppInfo> listAppInfoByAppId(List<FormdesignAppUserMapping> list) {
        if (ToolUtil.isEmpty(list)) {
            return null;
        }
        List appIds = list.stream().map(FormdesignAppUserMapping::getAppId).collect(Collectors.toList());
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().in((Object)"APP_ID", appIds);
        return this.conversion(this.formdesignAppInfoMapper.selectList((Wrapper)queryWrapper));
    }

    private List<FormDesignAppInfo> conversion(List<FormdesignAppInfo> list) {
        ArrayList<FormDesignAppInfo> result = new ArrayList<FormDesignAppInfo>();
        for (FormdesignAppInfo info : list) {
            FormDesignAppInfo appInfo = new FormDesignAppInfo();
            appInfo.setAppId(String.valueOf(info.getAppId()));
            appInfo.setAppName(info.getAppName());
            appInfo.setAppDescribe(info.getAppDescribe());
            appInfo.setEnglishName(info.getEnglishName());
            appInfo.setCreateTime(info.getCreateTime());
            appInfo.setTenantId(String.valueOf(info.getTenantId()));
            result.add(appInfo);
        }
        return result;
    }
}

