/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.dao.FormdesignAppInfoMapper;
import com.jxdinfo.hussar.application.model.FormdesignAppInfo;
import com.jxdinfo.hussar.application.service.FormdesignAppInfoService;
import com.jxdinfo.hussar.application.service.FormdesignAppUserMappingService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.RmiConnectorService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiConnector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FormdesignAppInfoServiceImpl
extends HussarServiceImpl<FormdesignAppInfoMapper, FormdesignAppInfo>
implements FormdesignAppInfoService {
    @Resource
    private FormdesignAppInfoMapper formdesignAppInfoMapper;
    @Resource
    private FormdesignAppUserMappingService appUserMappingService;
    @Resource
    private RmiConnectorService rmiConnectorService;
    @Value(value="${server.port:8280}")
    private String port;

    public Page<FormdesignAppInfo> hussarQueryPage(Page<FormdesignAppInfo> page, FormdesignAppInfo formdesignAppInfo) {
        List<FormdesignAppInfo> appInfoList;
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long userId = null;
        if (!shiroUser.isSuperAdmin()) {
            userId = shiroUser.getId();
        }
        if (ToolUtil.isNotEmpty(appInfoList = this.formdesignAppInfoMapper.hussarQueryPage(page, formdesignAppInfo, userId))) {
            for (int i = 0; i < appInfoList.size(); ++i) {
                List userMappingList = this.appUserMappingService.hussarQueryByAppId(appInfoList.get(i).getAppId());
                String userMemName = "";
                if (!ToolUtil.isNotEmpty((Object)userMappingList)) continue;
                for (int j = 0; j < userMappingList.size(); ++j) {
                    userMemName = j != userMappingList.size() - 1 ? userMemName + ((String)userMappingList.get(j)).toString() + "," : userMemName + ((String)userMappingList.get(j)).toString();
                }
                appInfoList.get(i).setTeamMemberName(userMemName);
            }
        }
        page.setRecords(appInfoList);
        return page;
    }

    @DSTransactional
    public boolean insertOrUpdate(FormdesignAppInfo formdesignAppInfo) {
        Long insertFlag = formdesignAppInfo.getAppId();
        if (ToolUtil.isEmpty((Object)insertFlag)) {
            formdesignAppInfo.setDataStatus(Integer.valueOf(0));
            formdesignAppInfo.setCreateTime(new Date());
            this.save((BaseEntity)formdesignAppInfo);
            RmiConnector connector = new RmiConnector();
            connector.setConnectorName("\u5e94\u7528\u670d\u52a1\u8fde\u63a5\u5668");
            connector.setConnectorCode("application");
            connector.setIsAuth("0");
            connector.setAuthCode("mp_base");
            connector.setHostUrl("localhost:" + this.port);
            connector.setProtocol("http");
            connector.setConnectorType("api");
            connector.setConnectorStatus("1");
            connector.setRemark("\u5e94\u7528\u670d\u52a1\u8fde\u63a5\u5668");
            connector.setAppId(formdesignAppInfo.getAppId());
            this.rmiConnectorService.saveRmiConnector(connector);
        } else {
            formdesignAppInfo.setModifyTime(new Date());
            this.updateById((BaseEntity)formdesignAppInfo);
        }
        return true;
    }

    public boolean del(List<Long> ids) {
        ArrayList<FormdesignAppInfo> appInfoList = new ArrayList<FormdesignAppInfo>();
        for (int i = 0; i < ids.size(); ++i) {
            FormdesignAppInfo appInfo = new FormdesignAppInfo();
            appInfo.setAppId(ids.get(i));
            appInfo.setDataStatus(Integer.valueOf(1));
            appInfoList.add(appInfo);
        }
        if (ToolUtil.isNotEmpty(appInfoList)) {
            this.updateBatchById(appInfoList, appInfoList.size());
        }
        return true;
    }

    public FormdesignAppInfo formQuery(Long id) {
        FormdesignAppInfo formdesignAppInfo = (FormdesignAppInfo)this.getById(id);
        return formdesignAppInfo;
    }

    public void download(HttpServletResponse httpServletResponse, String fileName) {
        if (ToolUtil.isEmpty((Object)httpServletResponse) || ToolUtil.isEmpty((Object)fileName)) {
            throw new HussarException("\u4e0b\u8f7d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String filePath = ((Object)((Object)this)).getClass().getResource("/empty/" + fileName).getPath();
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(filePath)), 10240);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            httpServletResponse.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            httpServletResponse.setContentType("multipart/form-data");
            IOUtils.copy((InputStream)bis, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            throw new HussarException(BizExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        catch (IOException e) {
            throw new HussarException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }
}

