/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.alibaba.druid.pool.ha.PropertiesUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.applicationmix.constants.AppExportConstants;
import com.jxdinfo.hussar.applicationmix.dao.HussarBaseAppMixFileMapper;
import com.jxdinfo.hussar.applicationmix.dao.SysEyImportAppMixMsgMapper;
import com.jxdinfo.hussar.applicationmix.dao.SysLowCodeAppExtendMapper;
import com.jxdinfo.hussar.applicationmix.dto.CodeGenerator;
import com.jxdinfo.hussar.applicationmix.model.SysAppImportHistory;
import com.jxdinfo.hussar.applicationmix.model.SysAppPackage;
import com.jxdinfo.hussar.applicationmix.model.SysEyImportAppMsg;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.params.ApplicationMixProjectCodeArgs;
import com.jxdinfo.hussar.applicationmix.properties.HussarAppExportProperties;
import com.jxdinfo.hussar.applicationmix.properties.HussarBasePluginProperties;
import com.jxdinfo.hussar.applicationmix.properties.HussarClusterProperties;
import com.jxdinfo.hussar.applicationmix.properties.HussarProduceProperties;
import com.jxdinfo.hussar.applicationmix.qo.AppMixImportHistoryDataset;
import com.jxdinfo.hussar.applicationmix.service.ISysAppFileService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixFileService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixPackageService;
import com.jxdinfo.hussar.applicationmix.service.ISysEyImportAppMixMsgService;
import com.jxdinfo.hussar.applicationmix.service.ISysImportAppMixHistoryService;
import com.jxdinfo.hussar.applicationmix.service.ISysLowCodeAppExtendService;
import com.jxdinfo.hussar.applicationmix.service.impl.CommonMixAppService;
import com.jxdinfo.hussar.applicationmix.util.MavenUtil;
import com.jxdinfo.hussar.applicationmix.util.TarUtil;
import com.jxdinfo.hussar.applicationmix.util.ZipUtil;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.file.StorageDumpLoadService;
import com.jxdinfo.hussar.formdesign.common.file.impl.vue.VuePathServiceImpl;
import com.jxdinfo.hussar.formdesign.common.model.ResultCoreVO;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RestTemplateHttpUtil;
import com.jxdinfo.hussar.formdesign.external.inducts.InductsProjectStoreService;
import com.jxdinfo.hussar.formdesign.external.inducts.InductsTableService;
import com.jxdinfo.hussar.formdesign.importcode.service.PublishService;
import com.jxdinfo.hussar.formdesign.inducts.model.ExportApplicationSource;
import com.jxdinfo.hussar.formdesign.inducts.model.ImportApplicationSource;
import com.jxdinfo.hussar.formdesign.inducts.model.ProjectStoreArgs;
import com.jxdinfo.hussar.formdesign.util.CodeRelocationUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.expansion.core.service.dto.SharePluginInfoDto;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.PluginOperator;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.module.PluginInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.GlobalRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.PluginOperatorInfo;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadAppDto;
import com.jxdinfo.hussar.workflow.manage.engine.WorkflowAppMigrationService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.tools.ant.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.pf4j.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.applicationmix.service.impl.sysAppMixFileServerImpl")
public class SysAppMixFileServerImpl
extends CommonMixAppService
implements ISysAppFileService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppMixFileServerImpl.class);
    private static final String MODULES = "packages" + File.separator + "hussar-remote-";
    private static final String VIEWS = "views";
    private static final String API = "api";
    private static final String VUE_DIST = "dist";
    private static final String SRC = "src";
    private static final String expansion = "";
    private static final String ATTACHMENT_FILENAME = "attachment;filename=";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String FILE_EXCEPTION_MSG = "\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath";
    private static final String STATUS = "status";
    private static final String RESULT_DATA = "data";
    private static final String RESULT_CODE = "code";
    private static final String RESULT_MSG = "msg";
    private static final String RESULT_COUNT = "count";
    private static final String PLUGIN_PATH = "pluginPath";
    private static final String PLUGIN_BACK_UP_PATH = "pluginBackUpPath";
    private static final String VUE_PATH = "vuePath";
    private static final String API_PATH = "apiPath";
    private static final String VUE_BACK_UP_PATH = "vueBackUpPath";
    private static final String API_BACK_UP_PATH = "apiBackUpPath";
    @Autowired
    private FormDesignProperties formdesignProperties;
    @Resource
    private InductsProjectStoreService inductsProjectStoreService;
    @Autowired
    private ISysAppMixFileService isysAppMixFileService;
    @Autowired
    private HussarProduceProperties hussarProduceProperties;
    @Resource
    private HussarAppExportProperties hussarAppExportProperties;
    @Resource
    private InductsTableService inductsTableService;
    @Autowired
    private PublishService publishService;
    @Autowired
    private ISysLowCodeAppExtendService sysLowCodeAppExtendService;
    @Autowired
    private ISysAppMixPackageService appPackageService;
    @Autowired
    private ISysEyImportAppMixMsgService sysEyImportAppMixMsgService;
    @Autowired
    private ISysImportAppMixHistoryService sysImportAppMixHistoryService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Autowired
    private HussarDdlService ddlService;
    @Value(value="${hussar-formdesign.version:v1.0.0}")
    private String systemVersion;
    @Resource
    private HussarClusterProperties hussarClusterProperties;
    @Value(value="${production.rollback-front-path:0}")
    private String rollbackFront;
    @Value(value="${plugin.pluginPath:E:/hussar-plugin/}")
    private String pluginPath;
    @Value(value="${hussar-formdesign.nginx-front-path:/usr/local/var/www/dist}")
    private String nginxFrontPath;
    @Resource
    private HussarBaseAppMixFileMapper hussarBaseAppMixFileMapper;
    @Resource
    private SysEyImportAppMixMsgMapper sysEyImportAppMixMsgMapper;
    @Resource
    private HussarBasePluginProperties hussarBasePluginProperties;
    @Resource
    private SysLowCodeAppExtendMapper sysLowCodeAppExtendMapper;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private ISysFunctionModulesBoService sysFunctionModulesBoService;
    @Resource
    private IHussarBaseResourceService baseResourceBoService;
    @Resource
    private ISysResourceMosulesBoService sysResourceMosulesBoService;
    @Resource
    private ISysFunctionResourcesBoService sysFunctionResourcesBoService;
    @Resource
    private ISysMenuManageBoService sysMenuManageBoService;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Resource
    private StorageDumpLoadService storageDumpLoadService;
    @Value(value="${plugin.pluginPrefix:0}")
    private String pluginPrefix;
    @Value(value="${hussar-formdesign.open-plugin:false}")
    private boolean openPlugin;
    @Value(value="${plugin.modulePath:0}")
    private String modulePath;
    @Value(value="${plugin.prefixName:hussar-plugin}")
    private String prefixName;
    @Value(value="${cluster.clusterType:0}")
    private String clusterType;
    @Value(value="${plugin.pluginParentName:hussar-plugin-parent}")
    private String pluginParentName;
    @Value(value="${cluster.sharePlugin:0}")
    private String sharePlugin;
    @Value(value="${cluster.localPlugin:0}")
    private String localPlugin;
    @Value(value="${cluster.shareFront:0}")
    private String shareFront;
    @Value(value="${cluster.localFront:0}")
    private String localFront;
    @Value(value="${hussar-formdesign.storage.workspace:default}")
    private String defaultDir;
    @Lazy
    @Resource
    private PluginOperator pluginOperator;
    private static final Pattern P = Pattern.compile("[a-zA-z]");
    private static final ThreadLocal<Map<String, Object>> context = ThreadLocal.withInitial(HashMap::new);
    public static final String PRINT_PREFIX = "==============================";

    public void downloadFile(String appId, String importType, HttpServletResponse response) {
        String path = this.isysAppMixFileService.getAppFileDownloadPath(appId, importType);
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        try {
            String newFileName = URLEncoder.encode(file.getName(), "UTF-8");
            response.addHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + newFileName);
            response.setContentType(MULTIPART_FORM_DATA);
            try (BufferedInputStream bism = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), 10240);
                 BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int len;
                int i = bism.available();
                byte[] buff = new byte[i];
                while ((len = bism.read(buff)) > 0) {
                    bos.write(buff, 0, len);
                    bos.flush();
                }
            }
        }
        catch (IOException e) {
            logger.error("\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath=" + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public Long addWaitingCompileTask(Long appId) {
        SysAppPackage sysAppPackage = new SysAppPackage();
        sysAppPackage.setStatus("3");
        sysAppPackage.setAppId(appId);
        sysAppPackage.setCreateTime(LocalDateTime.now());
        this.appPackageService.save((Object)sysAppPackage);
        return sysAppPackage.getId();
    }

    public boolean saveTempPathFile(Long appId, String serverCode, String tempPath, String uuid) {
        String importFileBackUpPath = FileUtil.posixPath((String[])new String[]{this.hussarClusterProperties.getImportFile(), File.separator, serverCode, File.separator, appId.toString(), File.separator, uuid});
        File tempPathOfImportFile = new File(tempPath);
        try {
            File importFileBefore = new File(importFileBackUpPath);
            if (ToolUtil.isNotEmpty((Object)importFileBefore) && importFileBefore.exists()) {
                try {
                    FileUtils.forceDelete((File)importFileBefore);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            FileUtils.copyDirectory((File)tempPathOfImportFile, (File)new File(importFileBackUpPath));
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveImportMsgToTable(SysEyImportAppMsg appImportMsg) {
        try {
            this.sysEyImportAppMixMsgService.save((Object)appImportMsg);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadOffline(String tempPath, String filePath, HttpServletResponse response) {
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        try {
            String newFileName = URLEncoder.encode(file.getName(), "UTF-8");
            response.addHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + newFileName);
            response.setContentType(MULTIPART_FORM_DATA);
            try (BufferedInputStream bism = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), 10240);
                 BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int len;
                int i = bism.available();
                byte[] buff = new byte[i];
                while ((len = bism.read(buff)) > 0) {
                    bos.write(buff, 0, len);
                    bos.flush();
                }
            }
        }
        catch (IOException e) {
            logger.error("\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath=" + file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            try {
                File tempFile = new File(tempPath);
                FileUtils.forceDelete((File)tempFile);
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                logger.info("\u5173\u6d41\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
    }

    public Map<String, Object> importApp(MultipartFile multipartFile, Long appId, String type) throws Exception {
        Map<String, Object> returnMap;
        File temp;
        block10: {
            Map<String, Object> map;
            Map metaMap;
            block9: {
                File metaFile;
                block8: {
                    temp = null;
                    returnMap = new HashMap<String, Object>();
                    InputStream inputStream = multipartFile.getInputStream();
                    temp = Files.createTempDirectory("appImport" + appId, new FileAttribute[0]).toFile();
                    File tempFile = new File(temp.getAbsolutePath() + File.separator + appId + ".zip");
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
                    ZipUtil.unzip(tempFile.getAbsolutePath(), temp.getAbsolutePath() + File.separator);
                    metaFile = new File(temp + File.separator + "meta.json");
                    if (metaFile.exists()) break block8;
                    returnMap.put(STATUS, false);
                    returnMap.put(RESULT_MSG, "\u521d\u59cb\u5316\u5305\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
                    HashMap<String, Object> hashMap = returnMap;
                    this.deleteTempFileWithoutWorkFlow(temp);
                    return hashMap;
                }
                byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
                metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
                if (metaMap != null) break block9;
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, "meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                HashMap<String, Object> hashMap = returnMap;
                this.deleteTempFileWithoutWorkFlow(temp);
                return hashMap;
            }
            try {
                String importType;
                String string = importType = metaMap.get("importType") == null ? expansion : metaMap.get("importType").toString();
                if ("0".equals(importType) || "2".equals(importType)) {
                    returnMap = this.initAppToOffline(appId, temp, metaMap, returnMap);
                    break block10;
                }
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, "\u521d\u59cb\u5316\u5305\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5f53\u524d\u73af\u5883\u9700\u8981\u7684\u5305\uff01");
                map = returnMap;
            }
            catch (Exception e) {
                try {
                    if (ToolUtil.isNotEmpty(temp) && temp.exists()) {
                        FileUtils.forceDelete((File)temp);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    this.deleteTempFileWithoutWorkFlow(temp);
                    throw throwable;
                }
            }
            this.deleteTempFileWithoutWorkFlow(temp);
            return map;
        }
        this.deleteTempFileWithoutWorkFlow(temp);
        return returnMap;
    }

    private Map<String, Object> initAppToOffline(Long appId, File temp, Map<String, Object> metaMap, Map<String, Object> returnMap) throws Exception {
        File tar;
        String md5;
        String appName = metaMap.get("appName") == null ? expansion : metaMap.get("appName").toString();
        String tenantId = metaMap.get("tenantId") == null ? expansion : metaMap.get("tenantId").toString();
        String javaPath = metaMap.get("javaPath") == null ? expansion : metaMap.get("javaPath").toString();
        String sign = metaMap.get("sign") == null ? expansion : metaMap.get("sign").toString();
        String dsName = metaMap.get("ds") == null ? expansion : metaMap.get("ds").toString();
        Map metaInfo = metaMap.get("metaInfo") == null ? null : (Map)metaMap.get("metaInfo");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.sysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        if (ToolUtil.isNotEmpty((Object)metaInfo)) {
            Map<String, String> sysMetaInfo = this.getSysMetaInfo(appId);
            for (String name : metaInfo.keySet()) {
                if (!ToolUtil.isNotEmpty((Object)sysMetaInfo.get(name)) || ((String)metaInfo.get(name)).equals(sysMetaInfo.get(name))) continue;
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, "\u5b58\u5728\u540c\u540d\u4f46\u4e0d\u540c\u6765\u6e90\u7684\u6a21\u5757\u3001\u9875\u9762\u6216\u5de5\u4f5c\u6d41\uff0c\u4e0d\u53ef\u5bfc\u5165");
                return returnMap;
            }
        }
        if (!(md5 = ZipUtil.getMd5((tar = new File(temp + File.separator + appName + ".tar")).getAbsolutePath())).equals(sign)) {
            returnMap.put(STATUS, false);
            returnMap.put(RESULT_MSG, "\u521d\u59cb\u5316\u5305\u5df2\u88ab\u4fee\u6539\uff01");
            return returnMap;
        }
        TarUtil.unTar(tar, temp.getAbsolutePath() + File.separator);
        File axe = new File(temp.getAbsolutePath() + File.separator + "god_axe");
        ExportApplicationSource exportApplicationSource = this.getExportApplicationSource(appName, tenantId, javaPath, dsName);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        ImportApplicationSource importApplicationSource = this.getImportApplicationSource(appInfo.getAppEnglishName(), tenantCode);
        HashMap<String, Object> storeReserveMap = new HashMap<String, Object>();
        storeReserveMap.put("appId", appId);
        ProjectStoreArgs projectStoreArgs = this.getProjectStoreArgs(exportApplicationSource, importApplicationSource, axe, storeReserveMap);
        this.inductsProjectStoreService.handlerProjectStore(JSON.parseObject((String)JSON.toJSONString((Object)projectStoreArgs)));
        this.inductsProjectStoreService.importProjectStore(appId.toString(), axe.getAbsolutePath());
        File defaultCss = new File(FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), this.defaultDir}));
        this.storageDumpLoadService.load(this.defaultDir, defaultCss);
        ApplicationMixProjectCodeArgs applicationMixProjectCodeArgs = this.getProjectCodeArgs(exportApplicationSource, importApplicationSource, temp, null);
        this.handlerProjectCode(applicationMixProjectCodeArgs);
        String appType = this.sysLowCodeAppExtendMapper.getMixAppTypeById(appId);
        WorkflowLoadAppDto workflowLoadAppDto = new WorkflowLoadAppDto();
        workflowLoadAppDto.setAppType(appType);
        workflowLoadAppDto.setAppCode(appInfo.getAppEnglishName());
        workflowLoadAppDto.setAppId(appId.toString());
        workflowLoadAppDto.setImportType("2");
        workflowLoadAppDto.setFilePath(temp.getAbsolutePath() + File.separator + "workflow");
        if (new File(workflowLoadAppDto.getFilePath()).exists()) {
            WorkflowAppMigrationService.loadApp((WorkflowLoadAppDto)workflowLoadAppDto);
        }
        returnMap = this.importData(temp, tenantCode, dsName, false);
        returnMap.put(STATUS, true);
        this.publishService.resourceBatch(appId.toString());
        SysLowCodeAppExtend appExtend = new SysLowCodeAppExtend();
        appExtend.setAppId(appId);
        appExtend.setAppEnglishName(appInfo.getAppEnglishName());
        appInfo.setIsInit("1");
        this.sysLowCodeAppExtendService.updateById((Object)appInfo);
        logger.info("\u5e94\u7528\uff1a{}\u521d\u59cb\u5316\u6210\u529f", (Object)appInfo.getAppEnglishName());
        return returnMap;
    }

    public void handlerProjectCode(ApplicationMixProjectCodeArgs applicationMixProjectCodeArgs) throws Exception {
        CountDownLatch fileCountDownLatch = new CountDownLatch(6);
        CountDownLatch dirUpdateCountDownLatch = new CountDownLatch(1);
        logger.debug("[{}]{}\uff1a\u5f00\u59cb\u8f6c\u6362", (Object)applicationMixProjectCodeArgs.getZipDir(), (Object)System.currentTimeMillis());
        File zipDir = applicationMixProjectCodeArgs.getZipDir();
        File java = new File(zipDir, "java");
        File vue = new File(zipDir, "vue");
        File mobileVue = new File(zipDir, AppExportConstants.MOBILE_VUE);
        File api = new File(zipDir, API);
        File mobileApi = new File(zipDir, AppExportConstants.MOBILE_API);
        File mobileRouter = new File(zipDir, AppExportConstants.MOBILE_ROUTER);
        new Thread(() -> {
            try {
                this.updateDir(zipDir, applicationMixProjectCodeArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                dirUpdateCountDownLatch.countDown();
            }
        }).start();
        dirUpdateCountDownLatch.await();
        this.updateFile(java, "java", applicationMixProjectCodeArgs, fileCountDownLatch);
        this.updateFile(vue, "vue", applicationMixProjectCodeArgs, fileCountDownLatch);
        this.updateFile(mobileVue, AppExportConstants.MOBILE_VUE, applicationMixProjectCodeArgs, fileCountDownLatch);
        this.updateFile(api, API, applicationMixProjectCodeArgs, fileCountDownLatch);
        this.updateFile(mobileApi, AppExportConstants.MOBILE_API, applicationMixProjectCodeArgs, fileCountDownLatch);
        this.updateFile(mobileRouter, AppExportConstants.MOBILE_ROUTER, applicationMixProjectCodeArgs, fileCountDownLatch);
        logger.debug("[" + new Date() + "]{" + applicationMixProjectCodeArgs.getZipDir() + "}\uff1a\u8f6c\u6362\u7ed3\u675f");
        fileCountDownLatch.await();
        logger.debug("[{}]------------\u51c6\u5907\u5199\u51fa\u6587\u4ef6---------------", (Object)System.currentTimeMillis());
        String javaPath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)applicationMixProjectCodeArgs.getImportApplicationSource().getTenantId()), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)applicationMixProjectCodeArgs.getImportApplicationSource().getTenantId()) + "-" + AppContextUtil.asIdentifier((String)applicationMixProjectCodeArgs.getImportApplicationSource().getAppName())});
        String mobileApiPath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileFrontApiPath()});
        String mobileRouterPath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileFrontRouterPath()});
        String vuePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), MODULES + AppContextUtil.asIdentifier((String)applicationMixProjectCodeArgs.getImportApplicationSource().getTenantId()) + "-" + AppContextUtil.asIdentifier((String)applicationMixProjectCodeArgs.getImportApplicationSource().getAppName()), SRC});
        String mobileVuePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath()});
        if (java.exists()) {
            ExportApplicationSource exportApplicationSource = applicationMixProjectCodeArgs.getExportApplicationSource();
            ImportApplicationSource importApplicationSource = applicationMixProjectCodeArgs.getImportApplicationSource();
            String javaSrcPath = importApplicationSource.getJavaPath().replace(".", File.separator);
            String tenantId = importApplicationSource.getTenantId();
            String appName = importApplicationSource.getAppName();
            String exportTenantCodeLow = AppContextUtil.asIdentifier((String)exportApplicationSource.getTenantId()).toLowerCase();
            File[] files = java.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File[] outermostDirectory = this.findOutermostDirectory(java, exportTenantCodeLow).listFiles();
                for (int j = 0; j < outermostDirectory.length; ++j) {
                    String[] split = files[i].getName().split("-");
                    split[1] = AppContextUtil.asIdentifier((String)tenantId);
                    StringBuffer sb = new StringBuffer();
                    for (int x = 0; x < split.length; ++x) {
                        if (x == split.length - 1) {
                            sb.append(split[x]);
                            continue;
                        }
                        sb.append(split[x]).append("-");
                    }
                    javaPath = javaPath + File.separator + sb.toString() + File.separator + SRC + File.separator + "main" + File.separator + "java" + javaSrcPath + File.separator + AppContextUtil.asIdentifier((String)tenantId) + File.separator + appName;
                    FileUtils.copyDirectory((File)outermostDirectory[j], (File)new File(javaPath));
                }
            }
        }
        if (vue.exists()) {
            FileUtils.copyDirectory((File)vue, (File)new File(vuePath));
            this.inductsProjectStoreService.webPrefixCommon();
        }
        if (mobileVue.exists()) {
            FileUtils.copyDirectory((File)mobileVue, (File)new File(mobileVuePath));
        }
        if (mobileApi.exists()) {
            FileUtils.copyDirectory((File)mobileApi, (File)new File(mobileApiPath));
        }
        if (mobileRouter.exists()) {
            FileUtils.copyDirectory((File)mobileRouter, (File)new File(mobileRouterPath));
            this.inductsProjectStoreService.h5PrefixCommon();
        }
        logger.debug("[{}]----------\u5199\u51fa\u6587\u4ef6\u7ed3\u675f--------------", (Object)System.currentTimeMillis());
    }

    private void updateFile(File dirPath, String type, ApplicationMixProjectCodeArgs applicationMixProjectCodeArgs, CountDownLatch countDownLatch) {
        new Thread(() -> {
            try {
                ArrayList<File> files = new ArrayList<File>();
                this.getFile(dirPath, files);
                ImportApplicationSource importApplicationSource = applicationMixProjectCodeArgs.getImportApplicationSource();
                ExportApplicationSource exportApplicationSource = applicationMixProjectCodeArgs.getExportApplicationSource();
                CodeRelocationUtil.Placement target = this.getPlacement(importApplicationSource.getAppName(), importApplicationSource.getDsName(), importApplicationSource.getJavaPath(), importApplicationSource.getTenantId());
                CodeRelocationUtil.Placement source = this.getPlacement(exportApplicationSource.getAppName(), exportApplicationSource.getDsName(), exportApplicationSource.getJavaPath(), exportApplicationSource.getTenantId());
                for (File file : files) {
                    if (!file.exists()) continue;
                    CodeRelocationUtil.Result relocate = null;
                    String content = null;
                    try {
                        content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                        CodeRelocationUtil.SourceType sourceType = "java".equals(type) ? (file.getName().endsWith(".xml") ? CodeRelocationUtil.SourceType.MAPPER : CodeRelocationUtil.SourceType.JAVA) : ("vue".equals(type) ? CodeRelocationUtil.SourceType.VUE : CodeRelocationUtil.SourceType.JS);
                        relocate = CodeRelocationUtil.relocate((CodeRelocationUtil.SourceType)sourceType, (String)content, (CodeRelocationUtil.Placement)source, (CodeRelocationUtil.Placement)target, null);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (relocate == null) continue;
                    content = relocate.getContent();
                    try {
                        FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8", (boolean)false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                countDownLatch.countDown();
            }
        }).start();
    }

    private void getFile(File file, List<File> files) {
        if (file.isDirectory()) {
            File[] fs = file.listFiles();
            if (com.jxdinfo.hussar.formdesign.common.util.ToolUtil.isNotEmpty((Object)fs)) {
                for (File f : fs) {
                    this.getFile(f, files);
                }
            }
        } else if (!file.getName().endsWith(".class")) {
            files.add(file);
        }
    }

    private void updateDir(File file, ApplicationMixProjectCodeArgs applicationMixProjectCodeArgs) throws IOException {
        File[] fs;
        ImportApplicationSource importApplicationSource = applicationMixProjectCodeArgs.getImportApplicationSource();
        ExportApplicationSource exportApplicationSource = applicationMixProjectCodeArgs.getExportApplicationSource();
        for (File f : fs = file.listFiles()) {
            File[] tenantFiles;
            if (!f.isDirectory()) continue;
            boolean isJava = "java".equals(f.getName());
            for (File tenantFile : tenantFiles = f.listFiles()) {
                String newAppName;
                String oldAppName;
                if (tenantFile.getName().equalsIgnoreCase(this.tenantCodeDirname(exportApplicationSource.getTenantId()))) {
                    try {
                        File[] appFiles;
                        File tenantNewFile = this.rename(f, tenantFile.getName(), this.tenantCodeDirname(importApplicationSource.getTenantId()), isJava);
                        for (File appFile : appFiles = tenantNewFile.listFiles()) {
                            if (!appFile.getName().equalsIgnoreCase(this.appNameDirname(exportApplicationSource.getAppName()))) continue;
                            this.rename(tenantNewFile, appFile.getName(), this.appNameDirname(importApplicationSource.getAppName()), isJava);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!tenantFile.getName().contains("application") || (oldAppName = exportApplicationSource.getAppName()).equals(newAppName = importApplicationSource.getAppName())) continue;
                String newFilePath = tenantFile.getName().replace(oldAppName, newAppName);
                File newFile = new File(f, newFilePath);
                FileUtils.copyDirectory((File)tenantFile, (File)newFile);
                FileUtils.deleteDirectory((File)tenantFile);
            }
        }
    }

    private File rename(File parent, String oldName, String newName, boolean isJava) throws IOException {
        if (isJava) {
            newName = newName.toLowerCase();
        }
        File oldFile = new File(parent, oldName);
        if (newName.equals(oldName)) {
            return oldFile;
        }
        File newFile = new File(parent, newName);
        if (!oldFile.exists()) {
            throw new FileNotFoundException(oldFile.getPath());
        }
        if (newFile.exists()) {
            throw new FileAlreadyExistsException(newFile.getPath());
        }
        if (!oldFile.renameTo(newFile)) {
            throw new IOException("failed to rename " + oldName + " to " + newName);
        }
        return newFile;
    }

    private String tenantCodeDirname(String tenantCode) {
        return AppContextUtil.asIdentifier((String)tenantCode);
    }

    private String appNameDirname(String appName) {
        return AppContextUtil.asIdentifier((String)appName);
    }

    private CodeRelocationUtil.Placement getPlacement(String appName, String dsName, String backPackagePrefix, String tenantCode) {
        CodeRelocationUtil.Placement placement = new CodeRelocationUtil.Placement();
        placement.setAppName(appName);
        placement.setDsName(dsName);
        placement.setBackPackagePrefix(backPackagePrefix);
        if (HussarUtils.isEmpty((Object)tenantCode)) {
            tenantCode = "0";
        }
        placement.setTenantCode(tenantCode);
        return placement;
    }

    private Map<String, String> getSysMetaInfo(Long appId) throws IOException {
        String codePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getAbsoluteOfflineWorkspaceRoot(), appId.toString(), this.formdesignProperties.getProjectRootPath(), this.formdesignProperties.getProjectCodePath()});
        File[] codeFiles = new File(codePath).listFiles();
        HashMap<String, String> sysMetaInfo = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty((Object)codeFiles)) {
            for (File file : codeFiles) {
                if (!file.getName().endsWith(".meta") || file.getName().contains("appsStore")) continue;
                long fileLength = file.length();
                byte[] fileContent = new byte[(int)fileLength];
                try (FileInputStream in = new FileInputStream(file);){
                    in.read(fileContent);
                }
                JSONObject modelObject = JSON.parseObject((String)new String(fileContent, StandardCharsets.UTF_8));
                sysMetaInfo.put(file.getName(), modelObject.getString("id"));
            }
        }
        return sysMetaInfo;
    }

    private ExportApplicationSource getExportApplicationSource(String appName, String tenantId, String javaPath, String dsName) {
        ExportApplicationSource exportApplicationSource = new ExportApplicationSource();
        exportApplicationSource.setAppName(appName);
        exportApplicationSource.setTenantId(tenantId);
        exportApplicationSource.setJavaPath(javaPath);
        exportApplicationSource.setDsName(dsName);
        return exportApplicationSource;
    }

    private void deleteTempFileWithoutWorkFlow(File temp) throws IOException {
        File[] childFiles;
        if (ToolUtil.isNotEmpty((Object)temp) && temp.exists() && ToolUtil.isNotEmpty((Object)(childFiles = temp.listFiles()))) {
            File workflow = new File(temp.getAbsolutePath() + File.separator + "workflow");
            for (File file : childFiles) {
                if (workflow.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                FileUtils.forceDelete((File)file);
            }
        }
    }

    private ImportApplicationSource getImportApplicationSource(String appName, String serverCode) {
        ImportApplicationSource importApplicationSource = new ImportApplicationSource();
        importApplicationSource.setAppName(appName);
        importApplicationSource.setTenantId(serverCode);
        importApplicationSource.setJavaPath(this.formdesignProperties.getJavaPath());
        String dsName = HussarUtils.isNotEmpty((Object)serverCode) ? this.getAppDsName(serverCode) : "master";
        importApplicationSource.setDsName(dsName);
        return importApplicationSource;
    }

    public String getAppDsName(String serverCode) {
        String dsName = null;
        boolean tenantOpen = TenantCacheUtil.openTenant();
        if (tenantOpen) {
            dsName = Optional.ofNullable(serverCode).flatMap(code -> Optional.ofNullable(this.sysTenantService.getTenantByTenantCode(code)).map(HussarTenantDefinition::getConnName)).orElse(null);
        }
        return dsName;
    }

    public Map<String, Object> importProduceApp(MultipartFile multipartFile, Long appId) {
        Map<String, Object> returnMap = new HashMap<String, Object>();
        String msg = "\u5bfc\u5165\u5305";
        File temp = null;
        try {
            InputStream inputStream = multipartFile.getInputStream();
            temp = Files.createTempDirectory("appImport" + appId, new FileAttribute[0]).toFile();
            String tempZipName = multipartFile.getOriginalFilename();
            String safeFileName = new File(tempZipName).getName();
            if (!safeFileName.matches("^(?!(.*[\\\\/]|^)[.]{2}[\\\\/]|.*[\\\\/][.]{2}$|.*[\\\\/]\\.{1}[\\\\/]).+$")) {
                throw new HussarException("\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5");
            }
            if (tempZipName.endsWith(".hussar")) {
                tempZipName = tempZipName.substring(0, tempZipName.length() - 7);
            }
            File tempFile = new File(temp.getAbsolutePath() + File.separator + tempZipName + ".zip");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            ZipUtil.unzip(tempFile.getAbsolutePath(), temp.getAbsolutePath() + File.separator);
            File metaFile = new File(temp + File.separator + "meta.json");
            if (!metaFile.exists()) {
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, msg + "\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
                return returnMap;
            }
            byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
            Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
            if (metaMap == null) {
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, "meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                return returnMap;
            }
            String appName = metaMap.get("appName") == null ? expansion : metaMap.get("appName").toString();
            String tenantId = metaMap.get("tenantId") == null ? expansion : metaMap.get("tenantId").toString();
            String importType = metaMap.get("importType") == null ? expansion : metaMap.get("importType").toString();
            String sign = metaMap.get("sign") == null ? expansion : metaMap.get("sign").toString();
            String version = metaMap.get("version") == null ? expansion : metaMap.get("version").toString();
            Map metaInfo = metaMap.get("metaInfo") == null ? null : (Map)metaMap.get("metaInfo");
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
            SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.sysLowCodeAppExtendService.getOne((Wrapper)wrapper);
            if (ToolUtil.isNotEmpty((Object)metaInfo)) {
                Map<String, String> sysMetaInfo = this.getSysMetaInfo(appId);
                for (String name : metaInfo.keySet()) {
                    if (!ToolUtil.isNotEmpty((Object)sysMetaInfo.get(name)) || ((String)metaInfo.get(name)).equals(sysMetaInfo.get(name))) continue;
                    returnMap.put(STATUS, false);
                    returnMap.put(RESULT_MSG, "\u5b58\u5728\u540c\u540d\u4e0d\u540c\u6765\u6e90\u6a21\u5757\u3001\u9875\u9762\u6216\u5de5\u4f5c\u6d41\uff0c\u4e0d\u53ef\u5bfc\u5165");
                    return returnMap;
                }
            }
            if (!this.systemVersion.equals(version)) {
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, "\u7cfb\u7edf\u7248\u672c\u4e0e" + msg + "\u7684\u7cfb\u7edf\u7248\u672c\u4e0d\u4e00\u81f4\uff01");
                return returnMap;
            }
            if (!"1".equals(importType)) {
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, msg + "\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5f53\u524d\u73af\u5883\u9700\u8981\u7684\u5305\uff01");
                return returnMap;
            }
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            String tenantCode = servletRequestAttributes.getRequest().getHeader("tcode");
            if (HussarUtils.isEmpty((Object)tenantCode)) {
                tenantCode = expansion;
            }
            if (!appInfo.getAppEnglishName().equals(appName)) {
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, "\u5e94\u7528\u82f1\u6587\u540d\u79f0\u4e0e" + msg + "\u7684\u5e94\u7528\u82f1\u6587\u540d\u79f0\u4e0d\u4e00\u81f4\uff01");
                return returnMap;
            }
            File tar = new File(temp + File.separator + appName + ".tar");
            String md5 = ZipUtil.getMd5(tar.getAbsolutePath());
            logger.info("\u751f\u4ea7\u73af\u5883\u5bfc\u5165\uff1aMD5={}", (Object)md5);
            if (!md5.equals(sign)) {
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, msg + "\u5df2\u88ab\u4fee\u6539\uff01");
                return returnMap;
            }
            TarUtil.unTar(tar, temp.getAbsolutePath() + File.separator);
            returnMap = this.importData(temp, tenantCode, expansion, false);
            returnMap.put(STATUS, true);
            returnMap.put("tempPath", temp.getAbsolutePath());
            returnMap.put("appId", appId);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            try {
                if (temp.exists()) {
                    FileUtils.forceDelete((File)temp);
                }
            }
            catch (IOException ioException) {
                logger.error(ioException.getMessage());
            }
        }
        return returnMap;
    }

    public Object getCompileList(String page, String limit, Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
            List list = this.appPackageService.getCompileList(pages, map);
            resultMap.put(RESULT_COUNT, pages.getTotal());
            resultMap.put(RESULT_DATA, list);
            resultMap.put(RESULT_CODE, 0);
            return resultMap;
        }
        resultMap.put(RESULT_DATA, null);
        resultMap.put(RESULT_CODE, "500");
        resultMap.put(RESULT_MSG, "\u53c2\u6570\u4e0d\u7b26");
        resultMap.put(RESULT_COUNT, null);
        return resultMap;
    }

    public Object getQueueMsgList() {
        boolean tenantOpen;
        String column = "IMPORT_STATUS";
        HashMap<String, List> resultMap = new HashMap<String, List>();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)column, (Object)"0")).or()).eq((Object)column, (Object)"1")).or()).eq((Object)column, (Object)"2")).or()).eq((Object)column, (Object)"3");
        queryWrapper.orderByAsc((Object)"IMPORT_START_TIME");
        List list = this.sysEyImportAppMixMsgService.list((Wrapper)queryWrapper);
        List idList = list.stream().map(SysEyImportAppMsg::getServerId).collect(Collectors.toList());
        List serverInfoList = new ArrayList();
        if (HussarUtils.isNotEmpty(idList) && (tenantOpen = TenantCacheUtil.openTenant())) {
            serverInfoList = this.sysTenantService.list((Wrapper)Wrappers.lambdaQuery().in(SysTenant::getId, idList));
        }
        HashMap<Long, SysTenant> map = new HashMap<Long, SysTenant>();
        if (HussarUtils.isNotEmpty(serverInfoList)) {
            for (SysTenant item : serverInfoList) {
                map.put(item.getId(), item);
            }
            for (SysEyImportAppMsg sysEyImportAppMsg : list) {
                Long serverId = sysEyImportAppMsg.getServerId();
                SysTenant serverInfo = (SysTenant)map.get(serverId);
                if (!HussarUtils.isNotEmpty((Object)serverInfo)) continue;
                sysEyImportAppMsg.setServerName(serverInfo.getTenantName());
            }
        }
        resultMap.put(RESULT_DATA, list);
        return resultMap;
    }

    public ApiResponse<Map<String, Object>> queryImportHistory(AppMixImportHistoryDataset appMixImportHistoryDataSet) {
        String url = this.hussarProduceProperties.getProducePath();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + "hussarApi/application/appFile/getSyncingImportStatus";
        this.sysImportAppMixHistoryService.updateSyncStatus(url, Long.valueOf(Long.parseLong(appMixImportHistoryDataSet.getAppIdEqual())));
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        Page pager = new Page((long)appMixImportHistoryDataSet.getCurrent(), (long)appMixImportHistoryDataSet.getSize());
        List list = this.sysImportAppMixHistoryService.queryImportHistory(pager, appMixImportHistoryDataSet);
        result.put(RESULT_COUNT, pager.getTotal());
        result.put(RESULT_DATA, list);
        result.put(RESULT_CODE, "0");
        return ApiResponse.success(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAndCompileApp(String tempPath, String serverCode, Long appId, String sql, List<String> coverList, Long compileId, String serverName) throws IOException {
        long time0;
        MixAppInfoVo appInfo;
        block16: {
            appInfo = this.sysLowCodeAppExtendMapper.getMixAppInfo(appId);
            String appEnglishName = appInfo.getAppEnglishName();
            time0 = System.currentTimeMillis();
            File temp = new File(tempPath);
            try {
                long time1 = System.currentTimeMillis();
                this.backUpAppFiles(appId, serverCode);
                long time2 = System.currentTimeMillis();
                logger.info("{}-BackUp files:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time2 - time1) / 1000L + "s", PRINT_PREFIX});
                File axe = new File(temp.getAbsolutePath() + File.separator + "god_axe");
                long time3 = System.currentTimeMillis();
                if ("21".equals(appInfo.getAppType())) {
                    File metaFile = new File(temp + File.separator + "meta.json");
                    byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
                    Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
                    String javaPath = metaMap.get("javaPath") == null ? expansion : metaMap.get("javaPath").toString();
                    String dsName = metaMap.get("ds") == null ? expansion : metaMap.get("ds").toString();
                    ExportApplicationSource exportApplicationSource = this.getExportApplicationSource(appEnglishName, serverCode, javaPath, dsName);
                    ImportApplicationSource importApplicationSource = this.getImportApplicationSource(appEnglishName, serverCode);
                    HashMap<String, Object> storeReserveMap = new HashMap<String, Object>();
                    storeReserveMap.put("appId", appId);
                    ProjectStoreArgs projectStoreArgs = this.getProjectStoreArgs(exportApplicationSource, importApplicationSource, axe, storeReserveMap);
                    this.inductsProjectStoreService.handlerProjectStore(JSONObject.parseObject((String)JSONObject.toJSONString((Object)projectStoreArgs)));
                }
                this.inductsProjectStoreService.importProjectStore(appId.toString(), axe.getAbsolutePath());
                if ("21".equals(appInfo.getAppType())) {
                    try {
                        this.publishService.resourceBatch(appId.toString());
                    }
                    catch (Exception e) {
                        logger.error("\u6269\u5c55\u5f00\u53d1\u5305\u5bfc\u5165\uff0c\u53d1\u5e03\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                    }
                }
                long time4 = System.currentTimeMillis();
                logger.info("{}-Load axe files:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time4 - time3) / 1000L + "s", PRINT_PREFIX});
                File funResMenuFile = new File(temp.getAbsolutePath() + File.separator + AppExportConstants.FUN_RES_MENU + File.separator + AppExportConstants.FUN_RES_MENU_JSON);
                if (funResMenuFile.exists()) {
                    this.importFunResMenu(appId, funResMenuFile);
                }
                WorkflowLoadAppDto workflowLoadAppDto = new WorkflowLoadAppDto();
                workflowLoadAppDto.setAppType(appInfo.getAppType());
                workflowLoadAppDto.setAppCode(appEnglishName);
                workflowLoadAppDto.setAppId(appId.toString());
                workflowLoadAppDto.setImportType("1");
                workflowLoadAppDto.setFilePath(temp.getAbsolutePath() + File.separator + "workflow");
                WorkflowAppMigrationService.loadApp((WorkflowLoadAppDto)workflowLoadAppDto);
                long time7 = System.currentTimeMillis();
                File jar = this.importCode(temp, appInfo, serverCode);
                long time8 = System.currentTimeMillis();
                logger.info("{}-Import code:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time8 - time7) / 1000L + "s", PRINT_PREFIX});
                long time9 = System.currentTimeMillis();
                if (ToolUtil.isNotEmpty((Object)sql)) {
                    this.inductsTableService.executeSql(sql);
                }
                long time10 = System.currentTimeMillis();
                logger.info("{}-Execute sql:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time10 - time9) / 1000L + "s", PRINT_PREFIX});
                this.sysEyImportAppMixMsgService.setImportStatusTwo(compileId);
                long time13 = System.currentTimeMillis();
                if (!this.compileFront(appEnglishName, serverCode, compileId, tempPath).booleanValue()) {
                    throw new BaseException("\u524d\u7aef\u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
                }
                long time14 = System.currentTimeMillis();
                logger.info("{}-Compile front code:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time14 - time13) / 1000L, "s=============================="});
                long time15 = System.currentTimeMillis();
                long time16 = System.currentTimeMillis();
                logger.info("{}-Maven package:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time16 - time15) / 1000L, "s=============================="});
                this.sysEyImportAppMixMsgService.setImportStatusThree(compileId);
                if (jar.exists()) {
                    logger.info("\u9879\u76ee\u90e8\u7f72\u65b9\u5f0f{}", (Object)this.clusterType);
                    if ("0".equals(this.clusterType)) {
                        HussarTenantDefinition tenantDefinition = this.tenantCommonService.parse();
                        String pluginId = AppContextUtil.asIdentifier((String)tenantDefinition.getTenantCode()) + "-" + AppContextUtil.asIdentifier((String)appEnglishName);
                        long time17 = System.currentTimeMillis();
                        this.loadPluginJar(pluginId, jar);
                        long time18 = System.currentTimeMillis();
                        logger.info(PRINT_PREFIX + appEnglishName + "-Load plugin jar:" + (time18 - time17) / 1000L + "s" + PRINT_PREFIX);
                    } else {
                        long time23 = System.currentTimeMillis();
                        this.clusterLoadPluginJar(jar, serverCode, appEnglishName, jar.getName(), compileId);
                        long time24 = System.currentTimeMillis();
                        logger.info(PRINT_PREFIX + appEnglishName + "-Cluster load files:" + (time24 - time23) / 1000L + "s" + PRINT_PREFIX);
                    }
                    this.sysEyImportAppMixMsgService.setImportStatusFour(compileId);
                }
                this.updateCompileStatus(compileId, "1", null);
                SysEyImportAppMsg dbd = (SysEyImportAppMsg)this.sysEyImportAppMixMsgService.getById((Serializable)compileId);
                if ("\u540c\u6b65".equals(dbd.getAppFrom())) {
                    if (ToolUtil.isNotEmpty((Object)temp) && temp.exists()) {
                        FileUtils.forceDelete((File)temp);
                    }
                    break block16;
                }
                this.deleteTempFileWithoutZipAndAddHistory(temp, appId);
            }
            catch (Exception e) {
                block17: {
                    try {
                        e.printStackTrace();
                        this.updateCompileStatus(compileId, "2", this.getErrorInfoFromException(e));
                        this.rollbackPluginFile(appId, serverCode);
                        this.rollbackOrDeleteAppFile(appId, serverCode, true);
                        this.sysEyImportAppMixMsgService.setFailReason(compileId, e.getMessage());
                        if (!ToolUtil.isNotEmpty((Object)temp) || !temp.exists()) break block17;
                        FileUtils.forceDelete((File)temp);
                    }
                    catch (Throwable throwable) {
                        long time25 = System.currentTimeMillis();
                        logger.info("{}-Total:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time25 - time0) / 1000L + "s", PRINT_PREFIX});
                        throw throwable;
                    }
                }
                long time25 = System.currentTimeMillis();
                logger.info("{}-Total:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time25 - time0) / 1000L + "s", PRINT_PREFIX});
            }
        }
        long time25 = System.currentTimeMillis();
        logger.info("{}-Total:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time25 - time0) / 1000L + "s", PRINT_PREFIX});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAndCompileAppWithSecurity(String tempPath, String serverCode, Long appId, String sql, List<String> coverList, Long compileId, String serverName, Integer securityLevel) throws IOException {
        MixAppInfoVo appInfo = this.sysLowCodeAppExtendMapper.getMixAppInfo(appId);
        String appEnglishName = appInfo.getAppEnglishName();
        long time0 = System.currentTimeMillis();
        File temp = new File(tempPath);
        try {
            long time1 = System.currentTimeMillis();
            this.backUpAppFiles(appId, serverCode);
            long time2 = System.currentTimeMillis();
            logger.info("{}-BackUp files:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time2 - time1) / 1000L + "s", PRINT_PREFIX});
            File axe = new File(temp.getAbsolutePath() + File.separator + "god_axe");
            long time3 = System.currentTimeMillis();
            if ("21".equals(appInfo.getAppType())) {
                File metaFile = new File(temp + File.separator + "meta.json");
                byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
                Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
                String javaPath = metaMap.get("javaPath") == null ? expansion : metaMap.get("javaPath").toString();
                String dsName = metaMap.get("ds") == null ? expansion : metaMap.get("ds").toString();
                String originTenantCode = metaMap.get("tenantId") == null ? expansion : metaMap.get("tenantId").toString();
                ExportApplicationSource exportApplicationSource = this.getExportApplicationSource(appEnglishName, originTenantCode, javaPath, dsName);
                ImportApplicationSource importApplicationSource = this.getImportApplicationSource(appEnglishName, serverCode);
                HashMap<String, Object> storeReserveMap = new HashMap<String, Object>();
                storeReserveMap.put("appId", appId);
                ProjectStoreArgs projectStoreArgs = this.getProjectStoreArgs(exportApplicationSource, importApplicationSource, axe, storeReserveMap);
                this.inductsProjectStoreService.handlerProjectStore(JSONObject.parseObject((String)JSONObject.toJSONString((Object)projectStoreArgs)));
            }
            this.inductsProjectStoreService.importProjectStore(appId.toString(), axe.getAbsolutePath());
            File funResMenuFile = new File(temp.getAbsolutePath() + File.separator + AppExportConstants.FUN_RES_MENU + File.separator + AppExportConstants.FUN_RES_MENU_JSON);
            if (funResMenuFile.exists()) {
                this.importFunResMenu(appId, funResMenuFile);
            }
            if ("21".equals(appInfo.getAppType())) {
                try {
                    this.publishService.resourceBatch(appId.toString());
                }
                catch (Exception e) {
                    logger.error("\u6269\u5c55\u5f00\u53d1\u5305\u5bfc\u5165\uff0c\u53d1\u5e03\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
            long time4 = System.currentTimeMillis();
            logger.info("{}-Load axe files:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time4 - time3) / 1000L + "s", PRINT_PREFIX});
            WorkflowLoadAppDto workflowLoadAppDto = new WorkflowLoadAppDto();
            workflowLoadAppDto.setAppType(appInfo.getAppType());
            workflowLoadAppDto.setAppCode(appEnglishName);
            workflowLoadAppDto.setAppId(appId.toString());
            workflowLoadAppDto.setImportType("1");
            workflowLoadAppDto.setFilePath(temp.getAbsolutePath() + File.separator + "workflow");
            WorkflowAppMigrationService.loadApp((WorkflowLoadAppDto)workflowLoadAppDto);
            long time7 = System.currentTimeMillis();
            File jar = this.importCode(temp, appInfo, serverCode);
            long time8 = System.currentTimeMillis();
            logger.info("{}-Import code:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time8 - time7) / 1000L + "s", PRINT_PREFIX});
            long time9 = System.currentTimeMillis();
            if (ToolUtil.isNotEmpty((Object)sql)) {
                this.inductsTableService.executeSql(sql);
            }
            long time10 = System.currentTimeMillis();
            logger.info("{}-Execute sql:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time10 - time9) / 1000L + "s", PRINT_PREFIX});
            this.sysEyImportAppMixMsgService.setImportStatusTwo(compileId);
            long time13 = System.currentTimeMillis();
            if (!this.compileFront(appEnglishName, serverCode, compileId, tempPath).booleanValue()) {
                throw new BaseException("\u524d\u7aef\u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            }
            long time14 = System.currentTimeMillis();
            logger.info("{}-Compile front code:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time14 - time13) / 1000L, "s=============================="});
            long time15 = System.currentTimeMillis();
            long time16 = System.currentTimeMillis();
            logger.info("{}-Maven package:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time16 - time15) / 1000L, "s=============================="});
            this.sysEyImportAppMixMsgService.setImportStatusThree(compileId);
            Map<String, Object> threadMap = context.get();
            if (HussarUtils.isNotEmpty((Object)jar) && jar.exists()) {
                logger.info("\u9879\u76ee\u90e8\u7f72\u65b9\u5f0f{}", (Object)this.clusterType);
                String pluginId = threadMap.get("pluginId") + "-" + threadMap.get("version");
                if ("22".equals(appInfo.getAppType())) {
                    pluginId = (String)threadMap.get("pluginId");
                }
                if ("0".equals(this.clusterType)) {
                    long time17 = System.currentTimeMillis();
                    this.loadPluginJar(pluginId, jar);
                    long time18 = System.currentTimeMillis();
                    logger.info(PRINT_PREFIX + appInfo.getAppEnglishName() + "-Load plugin jar:" + (time18 - time17) / 1000L + "s" + PRINT_PREFIX);
                } else {
                    long time23 = System.currentTimeMillis();
                    this.clusterLoadPluginJar(jar, serverCode, appEnglishName, pluginId, compileId);
                    long time24 = System.currentTimeMillis();
                    logger.info(PRINT_PREFIX + appInfo.getAppEnglishName() + "-Cluster load files:" + (time24 - time23) / 1000L + "s" + PRINT_PREFIX);
                }
                this.sysEyImportAppMixMsgService.setImportStatusFour(compileId);
            }
            this.updateCompileStatus(compileId, "1", null);
            SysEyImportAppMsg dbd = (SysEyImportAppMsg)this.sysEyImportAppMixMsgService.getById((Serializable)compileId);
            if ("\u540c\u6b65".equals(dbd.getAppFrom())) {
                if (ToolUtil.isNotEmpty((Object)temp) && temp.exists()) {
                    FileUtils.forceDelete((File)temp);
                }
            } else {
                this.deleteTempFileWithoutZipAndAddHistory(temp, appId, securityLevel);
            }
            context.remove();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (!(e instanceof BaseException)) {
                    this.updateCompileStatus(compileId, "2", this.getErrorInfoFromException(e));
                }
                this.rollbackPluginFile(appId, serverCode);
                this.rollbackOrDeleteAppFile(appId, serverCode, true);
                this.sysEyImportAppMixMsgService.setFailReason(compileId, e.getMessage());
                if (ToolUtil.isNotEmpty((Object)temp) && temp.exists()) {
                    FileUtils.forceDelete((File)temp);
                }
                context.remove();
            }
            catch (Throwable throwable) {
                context.remove();
                long time25 = System.currentTimeMillis();
                logger.info("{}-Total:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time25 - time0) / 1000L + "s", PRINT_PREFIX});
                throw throwable;
            }
            long time25 = System.currentTimeMillis();
            logger.info("{}-Total:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time25 - time0) / 1000L + "s", PRINT_PREFIX});
        }
        long time25 = System.currentTimeMillis();
        logger.info("{}-Total:{}{}", new Object[]{PRINT_PREFIX + appInfo.getAppEnglishName(), (time25 - time0) / 1000L + "s", PRINT_PREFIX});
    }

    private void rollbackPluginFile(Long appId, String serverCode) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appId, serverCode);
        String pluginPath = pathMap.get(PLUGIN_PATH);
        String pluginBackUpPath = pathMap.get(PLUGIN_BACK_UP_PATH);
        File pluginFile = new File(pluginPath);
        File pluginBackUpFile = new File(pluginBackUpPath);
        if (pluginFile.exists()) {
            FileUtils.forceDelete((File)pluginFile);
        }
        if (pluginBackUpFile.exists()) {
            FileUtils.copyDirectory((File)pluginBackUpFile, (File)new File(pluginPath));
        }
    }

    private String getErrorInfoFromException(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "\r\n" + sw.toString() + "\r\n";
        }
        catch (Exception e2) {
            return "bad getErrorInfoFromException";
        }
    }

    private void deleteTempFileWithoutZipAndAddHistory(File temp, Long appId) throws IOException {
        File[] childFiles;
        if (ToolUtil.isNotEmpty((Object)temp) && temp.exists() && ToolUtil.isNotEmpty((Object)(childFiles = temp.listFiles()))) {
            for (File file : childFiles) {
                if (file.getName().endsWith(".zip")) {
                    SysAppImportHistory sysAppImportHistory = new SysAppImportHistory();
                    sysAppImportHistory.setAppId(appId);
                    sysAppImportHistory.setCompileId(this.sysEyImportAppMixMsgMapper.newestImportHistoryIdByAppId(appId));
                    String packageName = file.getName();
                    packageName = packageName.substring(0, packageName.length() - 4) + ".hussar";
                    sysAppImportHistory.setSyncStatus("0");
                    sysAppImportHistory.setPackagePath(file.getAbsolutePath());
                    sysAppImportHistory.setImportTime(new Timestamp(System.currentTimeMillis()));
                    sysAppImportHistory.setPackageName(packageName);
                    this.sysImportAppMixHistoryService.saveOrUpdate((Object)sysAppImportHistory);
                    continue;
                }
                FileUtils.forceDelete((File)file);
            }
        }
    }

    private void deleteTempFileWithoutZipAndAddHistory(File temp, Long appId, Integer securityLevel) throws IOException {
        File[] childFiles;
        if (ToolUtil.isNotEmpty((Object)temp) && temp.exists() && ToolUtil.isNotEmpty((Object)(childFiles = temp.listFiles()))) {
            for (File file : childFiles) {
                if (file.getName().endsWith(".zip")) {
                    SysAppImportHistory sysAppImportHistory = new SysAppImportHistory();
                    sysAppImportHistory.setAppId(appId);
                    sysAppImportHistory.setCompileId(this.sysEyImportAppMixMsgMapper.newestImportHistoryIdByAppId(appId));
                    String packageName = file.getName();
                    packageName = packageName.substring(0, packageName.length() - 4) + ".hussar";
                    sysAppImportHistory.setSyncStatus("0");
                    sysAppImportHistory.setPackagePath(file.getAbsolutePath());
                    sysAppImportHistory.setImportTime(new Timestamp(System.currentTimeMillis()));
                    sysAppImportHistory.setPackageName(packageName);
                    sysAppImportHistory.setSecurityLevel(securityLevel);
                    this.sysImportAppMixHistoryService.saveOrUpdate((Object)sysAppImportHistory);
                    continue;
                }
                FileUtils.forceDelete((File)file);
            }
        }
    }

    private void updateCompileStatus(Long compileId, String status, String msg) {
        SysAppPackage sysAppPackage = (SysAppPackage)this.appPackageService.getById((Serializable)compileId);
        if (ToolUtil.isNotEmpty((Object)sysAppPackage) && !"2".equals(sysAppPackage.getStatus())) {
            sysAppPackage.setStatus(status);
            if (ToolUtil.isNotEmpty((Object)msg)) {
                sysAppPackage.setErrorMsg(msg);
            }
            this.appPackageService.updateById((Object)sysAppPackage);
        }
    }

    private void clusterLoadPluginJar(File jar, String serverCode, String appEnglishName, String pluginId, Long compileId) throws Exception {
        List<String> arrayList = this.hussarBaseAppMixFileMapper.getAllClusterAddress();
        logger.info("\u5df2\u914d\u7f6e\u96c6\u7fa4\u8282\u70b9\uff1a{}", (Object)org.apache.commons.lang3.StringUtils.join(arrayList, (String)","));
        if (HussarUtils.isNotEmpty(arrayList)) {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            for (String string : arrayList) {
                String url = string + "/application/appFile/synchronousImport";
                MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", jar.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)jar)).addFormDataPart("tenantId", serverCode).addFormDataPart("appEnglishName", appEnglishName).addFormDataPart("compileId", compileId.toString()).addFormDataPart("pluginId", pluginId).build();
                Request request = new Request.Builder().url(url).method("POST", (RequestBody)body).build();
                Response response = client.newCall(request).execute();
                if (HussarUtils.isEmpty((Object)response)) {
                    this.sysEyImportAppMixMsgService.setFailReason(compileId, string + "\u8282\u70b9\u5206\u53d1\u5931\u8d25\uff01");
                    this.updateCompileStatusCluster(compileId, "2", string + "\u8282\u70b9\u5206\u53d1\u5931\u8d25\uff01");
                    continue;
                }
                if (HussarUtils.equals((Object)ResultCode.SUCCESS.getCode(), (Object)response.code())) continue;
                this.sysEyImportAppMixMsgService.setFailReason(compileId, response.message());
                this.updateCompileStatusCluster(compileId, "2", string + "\u8282\u70b9\u5206\u53d1\u5931\u8d25\uff01" + response.message());
            }
        } else {
            this.sysEyImportAppMixMsgService.setFailReason(compileId, "\u96c6\u7fa4\u8282\u70b9\u672a\u914d\u7f6e");
            this.updateCompileStatus(compileId, "2", "\u96c6\u7fa4\u8282\u70b9\u672a\u914d\u7f6e");
            throw new Exception("\u96c6\u7fa4\u8282\u70b9\u672a\u914d\u7f6e");
        }
    }

    private void updateCompileStatusCluster(Long compileId, String status, String msg) {
        SysAppPackage sysAppPackage = (SysAppPackage)this.appPackageService.getById((Serializable)compileId);
        if (ToolUtil.isNotEmpty((Object)sysAppPackage)) {
            sysAppPackage.setStatus(status);
            if (ToolUtil.isNotEmpty((Object)msg)) {
                if (ToolUtil.isNotEmpty((Object)sysAppPackage.getErrorMsg())) {
                    sysAppPackage.setErrorMsg(msg + sysAppPackage.getErrorMsg());
                } else {
                    sysAppPackage.setErrorMsg(msg);
                }
            }
            this.appPackageService.updateById((Object)sysAppPackage);
        }
    }

    public void uploadLocalJarFile(File localJar) {
        try {
            logger.info("\u672c\u5730jar\u8def\u5f84\uff1a{},\u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)localJar.getAbsolutePath(), (Object)localJar.length());
            File shareJarFile = new File(this.hussarClusterProperties.getSharePlugin(), File.separator + localJar.getName());
            FileUtils.copyFile((File)localJar, (File)shareJarFile);
            logger.info("\u4e0a\u4f20\u6210\u529f\uff0c\u4e0a\u4f20jar\u8def\u5f84{}\uff1a,\u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)shareJarFile.getAbsolutePath(), (Object)shareJarFile.length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertPlugin(Path backUpPath) throws Exception {
        File backUpJar = backUpPath.toFile();
        if (backUpJar.exists()) {
            String[] names = backUpJar.getName().split("_");
            StringBuffer sb = new StringBuffer();
            for (int i = 2; i < names.length; ++i) {
                sb.append(names[i]);
            }
            File jar = new File(backUpJar.getParentFile(), sb.toString());
            try {
                FileUtils.copyFile((File)backUpJar, (File)jar);
                this.uploadPluginAndStart(jar);
            }
            finally {
                FileUtils.forceDelete((File)jar);
            }
        }
    }

    private void loadPluginJar(String pluginId, File jar) throws Exception {
        boolean isRevert = false;
        Path backUpPath = null;
        try {
            PluginInfo pluginInfo = this.pluginOperator.getPluginInfo(pluginId);
            if (ToolUtil.isNotEmpty((Object)pluginInfo)) {
                isRevert = true;
                this.pluginOperator.uninstall(pluginId, false);
            }
            this.uploadPluginAndStart(jar);
        }
        catch (Exception e) {
            PluginInfo pluginInfo = this.pluginOperator.getPluginInfo(pluginId);
            if (HussarUtils.isEmpty((Object)pluginInfo) && isRevert && backUpPath != null) {
                this.revertPlugin(backUpPath);
            }
            throw e;
        }
    }

    private synchronized void uploadPluginAndStart(File jar) throws Exception {
        Path jarPath = jar.toPath();
        String pluginId = null;
        try {
            PluginInfo pluginInfo = this.pluginOperator.load(jarPath);
            if (pluginInfo == null) {
                logger.error("Plugin '{}' install failure, this pluginInfo id is empty.", pluginId);
                throw new NullPointerException("Plugin " + pluginId + " install failure, this pluginInfo id is empty");
            }
            PluginDescriptor pluginDescriptor = pluginInfo.getPluginDescriptor();
            if (pluginDescriptor == null) {
                logger.error("Plugin install failure.");
                throw new NullPointerException("Plugin install failure");
            }
            pluginId = pluginDescriptor.getPluginId();
            GlobalRegistryInfo.addOperatorPluginInfo((String)pluginId, (PluginOperatorInfo.OperatorType)PluginOperatorInfo.OperatorType.INSTALL, (boolean)true);
            if (!this.pluginOperator.start(pluginId)) {
                this.pluginOperator.uninstall(pluginId, false);
                throw new Exception("Plugin" + pluginId + " start failure");
            }
            logger.info("Plugin '{}' install success", (Object)pluginId);
        }
        catch (Exception var2) {
            try {
                logger.error("Plugin '{}' install failure. {}", pluginId, (Object)var2);
                if (!ObjectUtils.isEmpty(pluginId)) {
                    try {
                        this.pluginOperator.uninstall(pluginId, false);
                    }
                    catch (Exception var3) {
                        logger.error("Plugin '{}' uninstall failure. {}", (Object)pluginId, (Object)var3.getMessage());
                    }
                }
                throw var2;
            }
            catch (Throwable throwable) {
                if (!ObjectUtils.isEmpty(pluginId)) {
                    GlobalRegistryInfo.setOperatorPluginInfo(pluginId, (boolean)false);
                }
                throw throwable;
            }
        }
        if (!ObjectUtils.isEmpty((Object)pluginId)) {
            GlobalRegistryInfo.setOperatorPluginInfo((String)pluginId, (boolean)false);
        }
    }

    private File mavenPackage(String serverCode, String appName) throws IOException, MavenInvocationException, XmlPullParserException {
        Serializable serializable;
        MavenXpp3Reader reader;
        String appPomPath;
        String modulePath;
        block40: {
            String tenantAndApp = AppContextUtil.asIdentifier((String)serverCode) + "-" + AppContextUtil.asIdentifier((String)appName);
            modulePath = FileUtil.posixPath((String[])new String[]{this.pluginPath, this.pluginPrefix + AppContextUtil.asIdentifier((String)serverCode), this.pluginPrefix + tenantAndApp});
            appPomPath = FileUtil.posixPath((String[])new String[]{this.pluginPath, this.pluginPrefix + AppContextUtil.asIdentifier((String)serverCode), this.pluginPrefix + tenantAndApp, this.pluginPrefix + tenantAndApp + "-application"});
            String parentPom = this.pluginPath + File.separator + "pom.xml";
            reader = new MavenXpp3Reader();
            try (FileInputStream fis = new FileInputStream(parentPom);){
                Model model = reader.read((InputStream)fis);
                List modules = model.getModules();
                String moduleName = this.pluginPrefix + AppContextUtil.asIdentifier((String)serverCode) + File.separator + this.pluginPrefix + tenantAndApp;
                if (modules.contains(moduleName)) break block40;
                modules.add(moduleName);
                MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                serializable = null;
                try (FileWriter fileWriter = new FileWriter(parentPom);){
                    mavenXpp3Writer.write((Writer)fileWriter, model);
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
            }
        }
        String pom = FileUtil.posixPath((String[])new String[]{modulePath, "pom.xml"});
        MavenUtil.modulePackage(new File(pom));
        String appPom = FileUtil.posixPath((String[])new String[]{appPomPath, "pom.xml"});
        try (FileInputStream fis = new FileInputStream(appPom);){
            String finalName;
            Model model = reader.read((InputStream)fis);
            Build build = model.getBuild();
            String string = finalName = build == null ? expansion : build.getFinalName();
            if (ToolUtil.isNotEmpty((Object)finalName)) {
                serializable = new File(new File(appPomPath, "target"), finalName + ".jar");
                return serializable;
            }
            String moduleId = model.getArtifactId();
            String version = model.getVersion();
            File file = new File(new File(appPomPath, "target"), moduleId + ".jar");
            return file;
        }
    }

    private void compileQueue(Long appId, String serverCode, Long compileId, String tempPath) throws IOException, InterruptedException {
        this.preCompileFront(appId, serverCode, compileId, tempPath);
    }

    private void rollbackOrDeleteAppFile(Long appId, String serverCode, boolean isRollback) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appId, serverCode);
        String vuePath = pathMap.get(VUE_PATH);
        String apiPath = pathMap.get(API_PATH);
        String vueBackUpPath = pathMap.get(VUE_BACK_UP_PATH);
        String apiBackUpPath = pathMap.get(API_BACK_UP_PATH);
        File vueFile = new File(vuePath);
        File apiFile = new File(apiPath);
        File vueBackFile = new File(vueBackUpPath);
        File apiBackFile = new File(apiBackUpPath);
        if (isRollback) {
            if (vueFile.exists()) {
                FileUtils.forceDelete((File)vueFile);
            }
            if (apiFile.exists()) {
                FileUtils.forceDelete((File)apiFile);
            }
            if (vueBackFile.exists()) {
                FileUtils.copyDirectory((File)vueBackFile, (File)new File(vuePath));
            }
            if (apiBackFile.exists()) {
                FileUtils.copyDirectory((File)apiBackFile, (File)new File(apiPath));
            }
        }
    }

    public void preCompileFront(Long appId, String serverCode, Long compileId, String tempPath) throws IOException, InterruptedException {
        SysAppPackage sysAppPackage = (SysAppPackage)this.appPackageService.getById((Serializable)compileId);
        if (ToolUtil.isEmpty((Object)sysAppPackage)) {
            this.rollbackOrDeleteAppFile(appId, serverCode, true);
            return;
        }
        sysAppPackage.setStatus("0");
        this.appPackageService.updateById((Object)sysAppPackage);
        boolean flag = this.compile(sysAppPackage, tempPath);
        if (flag) {
            while (true) {
                block6: {
                    try {
                        Map<String, Object> result = this.preCheckCompile(appId, serverCode, compileId);
                        if (((Boolean)result.get("success")).booleanValue()) break;
                        if (ToolUtil.isNotEmpty((Object)result.get(RESULT_MSG))) {
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        sysAppPackage.setStatus("2");
                        this.appPackageService.updateById((Object)sysAppPackage);
                        this.rollbackOrDeleteAppFile(appId, serverCode, true);
                        this.rollbackFront();
                    }
                    break;
                }
                Thread.sleep(5000L);
            }
        }
    }

    public Map<String, Object> preCheckCompile(Long appId, String serverCode, Long compileId) throws IOException {
        String successMsg = "success";
        SysAppPackage sysAppPackage = (SysAppPackage)this.appPackageService.getById((Serializable)compileId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)sysAppPackage)) {
            String url = this.hussarProduceProperties.getPackagePath() + "compilingCheck";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("compileId", sysAppPackage.getId().toString());
            ResultCoreVO resultVO = RestTemplateHttpUtil.sendPostRequest((String)url, params);
            Map data = (Map)resultVO.getData();
            Boolean finished = (Boolean)data.get("finished");
            if (finished.booleanValue()) {
                map.put(successMsg, resultVO.isSucceed());
                if (resultVO.isSucceed()) {
                    this.rollbackOrDeleteAppFile(appId, serverCode, false);
                } else {
                    sysAppPackage.setStatus("2");
                    sysAppPackage.setErrorMsg(data.get(RESULT_MSG).toString());
                    map.put(RESULT_MSG, data.get(RESULT_MSG));
                    this.rollbackOrDeleteAppFile(appId, serverCode, true);
                    this.rollbackFront();
                    this.rollbackPluginFile(appId, serverCode);
                }
                this.appPackageService.updateById((Object)sysAppPackage);
            } else {
                map.put(successMsg, false);
            }
        } else {
            map.put(successMsg, true);
        }
        return map;
    }

    private void rollbackFront() throws IOException {
        String rollbackFrontPath = FileUtil.posixPath((String[])new String[]{this.rollbackFront});
        String distPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getWebPath(), VUE_DIST});
        File staticFile = new File(rollbackFrontPath);
        if (staticFile.exists()) {
            FileUtils.cleanDirectory((File)staticFile);
        }
        FileUtils.copyDirectory((File)new File(distPath), (File)new File(rollbackFrontPath));
    }

    private boolean compile(SysAppPackage sysAppPackage, String tempPath) throws IOException {
        String staticPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getStaticPath()});
        String distPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getWebPath(), VUE_DIST});
        File staticDir = new File(staticPath);
        FileUtils.forceMkdir((File)staticDir);
        File distDir = new File(distPath);
        FileUtils.forceMkdir((File)distDir);
        FileUtils.copyDirectory((File)staticDir, (File)distDir);
        if (ToolUtil.isEmpty((Object)sysAppPackage)) {
            sysAppPackage = new SysAppPackage();
            sysAppPackage.setStatus("0");
            sysAppPackage.setCreateTime(LocalDateTime.now());
            sysAppPackage.setCreatorId(BaseSecurityUtil.getUser().getId());
            this.appPackageService.save((Object)sysAppPackage);
        }
        String url = this.hussarProduceProperties.getPackagePath() + "singlePageBuild";
        ArrayList<String> appFileList = new ArrayList<String>();
        String vue = FileUtil.posixPath((String[])new String[]{tempPath, File.separator, "vue"});
        String api = FileUtil.posixPath((String[])new String[]{tempPath, File.separator, API});
        String css = FileUtil.posixPath((String[])new String[]{tempPath, File.separator, AppExportConstants.CSS});
        SysAppMixFileServerImpl.getAllFileName(vue, appFileList);
        SysAppMixFileServerImpl.getAllFileName(api, appFileList);
        SysAppMixFileServerImpl.getAllFileName(css, appFileList);
        ArrayList<String> appFilePath = new ArrayList<String>();
        boolean flag = false;
        for (String s : appFileList) {
            String sb = StringUtils.removePrefix((String)s.replace("\\", "/"), (String)(tempPath + "/vue"));
            String sb2 = StringUtils.removePrefix((String)s.replace("\\", "/"), (String)(tempPath + "/api"));
            String sb3 = StringUtils.removePrefix((String)s.replace("\\", "/"), (String)(tempPath + "/css"));
            if (s.contains(API)) {
                appFilePath.add(FileUtil.posixPath((String[])new String[]{".", this.formdesignProperties.getFrontApiPath(), sb2}));
                flag = true;
            }
            if (s.contains("vue")) {
                appFilePath.add(FileUtil.posixPath((String[])new String[]{".", this.formdesignProperties.getVueCodePath(), sb}));
                flag = true;
            }
            if (!s.contains(AppExportConstants.CSS)) continue;
            appFilePath.add(FileUtil.posixPath((String[])new String[]{".", this.formdesignProperties.getCssCodePath(), sb3}));
        }
        if (flag) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("compileId", sysAppPackage.getId().toString());
            params.put("appFileList", ((Object)appFilePath).toString());
            params.put("outputPath", staticPath);
            RestTemplateHttpUtil.sendPostRequest((String)url, params);
        }
        return flag;
    }

    public static void getAllFileName(String path, List<String> filePath) {
        File[] files;
        File file = new File(path);
        if (file.exists() && (files = file.listFiles()).length > 0) {
            for (File a : files) {
                if (a.isDirectory()) {
                    SysAppMixFileServerImpl.getAllFileName(a.getAbsolutePath(), filePath);
                    continue;
                }
                filePath.add(a.getAbsolutePath());
            }
        }
    }

    private File importCode(File temp, MixAppInfoVo appInfo, String tenantId) throws Exception {
        File jar = null;
        HashMap<String, String> threadMap = new HashMap<String, String>();
        File jarFile = new File(temp, "java" + File.separator + "pluginJar.jar");
        if (jarFile.exists()) {
            String uninstallId;
            PluginInfo pluginInfo;
            String appEnglishName = appInfo.getAppEnglishName();
            String unzipJarPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), "java" + File.separator + "pluginJar" + File.separator});
            ZipUtil.unzip(jarFile.getAbsolutePath(), unzipJarPath);
            File importProperties = FileUtils.getFile((File)new File(unzipJarPath), (String[])new String[]{"plugin.properties"});
            Properties properties = PropertiesUtils.loadProperties((String)importProperties.getAbsolutePath());
            String pluginId = properties.getProperty("plugin.id");
            threadMap.put("pluginId", pluginId);
            String originVersion = properties.getProperty("plugin.version");
            String version = this.dealWithVersion(originVersion);
            threadMap.put("version", version);
            String newJarName = AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)appEnglishName);
            File renameJar = new File(temp, "java" + File.separator + newJarName + ".jar");
            String active = this.hussarBasePluginProperties.getRunMode();
            if ("dev".equals(active)) {
                String currentDate = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                renameJar = new File(temp, "java" + File.separator + appEnglishName + "-" + currentDate + ".jar");
            }
            this.rePackage(jarFile.toPath(), renameJar.toPath(), rePackage -> {
                if (!"22".equals(appInfo.getAppType())) {
                    String pluginIdVersion = pluginId + "-" + version;
                    rePackage.setProperty("plugin.id", pluginIdVersion);
                }
                return rePackage;
            });
            File destDir = new File(this.hussarProduceProperties.getPluginPath() + File.separator + version);
            if ("21".equals(appInfo.getAppType()) && "dev".equals(active)) {
                destDir = new File(this.hussarProduceProperties.getHybridExtraPath());
            }
            if ("22".equals(appInfo.getAppType())) {
                destDir = new File(this.hussarProduceProperties.getPluginPath() + File.separator + AppContextUtil.asIdentifier((String)tenantId));
            }
            try {
                String standardApplicationName;
                SharePluginInfoDto sharePluginInfoDto;
                SharePluginInfoDto record = this.sharePluginService.queryPluginInfo(tenantId, appEnglishName);
                if (HussarUtils.isEmpty((Object)record) || !version.equals(record.getAppVersion())) {
                    if (HussarUtils.isNotEmpty((Object)record)) {
                        this.sharePluginService.removePluginInfo(tenantId, appEnglishName);
                    }
                    SharePluginInfoDto pluginInfoDto = new SharePluginInfoDto();
                    pluginInfoDto.setSharePluginId(pluginId);
                    pluginInfoDto.setTenantCode(tenantId);
                    pluginInfoDto.setAppCode(appEnglishName);
                    pluginInfoDto.setAppName(appInfo.getAppName());
                    pluginInfoDto.setAppVersion(version);
                    pluginInfoDto.setRunMode(active);
                    String pluginParentPath = new File(this.hussarProduceProperties.getPluginPath()).getParent();
                    String pluginBackUpPath = FileUtil.posixPath((String[])new String[]{pluginParentPath, "hussar-plugin-back"});
                    pluginInfoDto.setBackupPluginPath(pluginBackUpPath);
                    HussarTenantDefinition tenantByTenantCode = this.sysTenantService.getTenantByTenantCode(tenantId);
                    if (HussarUtils.isNotEmpty((Object)tenantByTenantCode)) {
                        pluginInfoDto.setConnName(tenantByTenantCode.getConnName());
                    }
                    if (!"22".equals(appInfo.getAppType())) {
                        this.sharePluginService.savePluginInfo(pluginInfoDto);
                        this.addChildExpansionModule(appInfo.getId(), appEnglishName + "_extension", true);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)record)) {
                    SharePluginInfoDto queryDto = new SharePluginInfoDto();
                    queryDto.setAppVersion(record.getAppVersion());
                    queryDto.setSharePluginId(record.getSharePluginId());
                    List oldSharePluginList = this.sharePluginService.queryPluginInfoList(queryDto);
                    if (oldSharePluginList.isEmpty()) {
                        this.pluginOperator.uninstall(record.getSharePluginId() + "-" + record.getAppVersion(), false);
                    }
                }
                if ("22".equals(appInfo.getAppType()) && HussarUtils.isNotEmpty((Object)(sharePluginInfoDto = this.sharePluginService.queryPluginInfo(tenantId, standardApplicationName = appEnglishName.length() >= 10 ? appEnglishName.substring(0, appEnglishName.length() - 10) : appEnglishName)))) {
                    sharePluginInfoDto.setExpansionPluginId(pluginId);
                    this.sharePluginService.savePluginInfo(sharePluginInfoDto);
                }
            }
            catch (Exception record) {
                // empty catch block
            }
            if ("prod".equals(active) && ToolUtil.isNotEmpty((Object)(pluginInfo = this.pluginOperator.getPluginInfo(uninstallId = "22".equals(appInfo.getAppType()) ? pluginId : pluginId + "-" + version)))) {
                this.pluginOperator.uninstall(uninstallId, false);
            }
            FileUtils.copyFileToDirectory((File)renameJar, (File)destDir);
            jar = new File(this.hussarProduceProperties.getPluginPath() + File.separator + version, renameJar.getName());
            if ("22".equals(appInfo.getAppType())) {
                jar = new File(this.hussarProduceProperties.getPluginPath() + File.separator + AppContextUtil.asIdentifier((String)tenantId), renameJar.getName());
            }
        }
        context.set(threadMap);
        return jar;
    }

    private String dealWithVersion(String version) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < version.length(); ++i) {
            char ch = version.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') && ch != '_') continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    private void importPlugin(File java, String appName, String tenantId) throws IOException, XmlPullParserException {
        String applicationSuffix = "-application";
        String modulePath = FileUtil.posixPath((String[])new String[]{this.pluginPath, this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)appName)});
        File module = new File(modulePath);
        String appPath = FileUtil.posixPath((String[])new String[]{this.pluginPath, this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)appName), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)appName) + applicationSuffix});
        File application = new File(appPath);
        File applicationJava = new File(java, this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)appName) + applicationSuffix);
        String apiPath = FileUtil.posixPath((String[])new String[]{this.pluginPath, this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)appName), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)appName) + "-api"});
        File api = new File(apiPath);
        File apiJava = new File(java, this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)appName) + "-api");
        this.updateApiFile(apiJava, api, applicationJava, application);
        this.updatePluinFile(applicationJava, application, appName, tenantId);
        FileUtils.copyDirectory((File)java, (File)module);
    }

    private void updateApiFile(File apiJava, File apiModule, File applicationJava, File applicationModule) throws IOException, XmlPullParserException {
        boolean isApiExist = apiModule.exists();
        boolean isAppExist = applicationModule.exists();
        File apiPom = new File(apiJava, "pom.xml");
        File appPom = new File(applicationJava, "pom.xml");
        if (isApiExist && isAppExist) {
            this.updateApiPomFile(apiJava, apiModule, applicationModule, apiPom, appPom);
        }
    }

    private void updateApiPomFile(File apiJava, File apiModule, File applicationModule, File apiPom, File appPom) throws IOException, XmlPullParserException {
        File apiModulePom = FileUtils.getFile((File)apiModule, (String[])new String[]{"pom.xml"});
        File appModulePom = FileUtils.getFile((File)applicationModule, (String[])new String[]{"pom.xml"});
        if (apiModulePom.exists() && appModulePom.exists()) {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            try (FileInputStream oldApiFis = new FileInputStream(apiModulePom);
                 FileInputStream newApiFis = new FileInputStream(apiPom);
                 FileInputStream newAppFis = new FileInputStream(appPom);){
                Model oldApiModel = reader.read((InputStream)oldApiFis);
                Model newApiModel = reader.read((InputStream)newApiFis);
                Model newAppModel = reader.read((InputStream)newAppFis);
                String oldApiPomVersion = oldApiModel.getVersion();
                if (ToolUtil.isEmpty((Object)oldApiPomVersion)) {
                    newApiModel.setVersion("1.0.0-RELEASE");
                } else {
                    int pomIndex = oldApiPomVersion.indexOf(".");
                    int pomVersion = Integer.parseInt(oldApiPomVersion.substring(0, pomIndex)) + 1;
                    String newApiPomVersion = pomVersion + oldApiPomVersion.substring(pomIndex);
                    newApiModel.setVersion(newApiPomVersion);
                    String apiArtifactId = oldApiModel.getArtifactId();
                    List dependencies = newAppModel.getDependencies();
                    if (HussarUtils.isNotEmpty((Object)dependencies)) {
                        for (Dependency dependency : dependencies) {
                            String artifactId = dependency.getArtifactId();
                            if (!artifactId.equals(apiArtifactId)) continue;
                            dependency.setVersion(newApiPomVersion);
                            break;
                        }
                    }
                }
                MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                try (FileWriter apiWriter = new FileWriter(apiPom);
                     FileWriter appWriter = new FileWriter(appPom);){
                    mavenXpp3Writer.write((Writer)apiWriter, newApiModel);
                    mavenXpp3Writer.write((Writer)appWriter, newAppModel);
                }
            }
        }
    }

    private void updatePluinFile(File java, File module, String appName, String tenantId) throws IOException, XmlPullParserException {
        boolean isExist = module.exists();
        File pom = new File(java, "pom.xml");
        if (!pom.exists()) {
            this.createPluginFile(java, appName, tenantId);
            return;
        }
        if (isExist) {
            this.updateConfigFile(java, module, pom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPluginFile(File java, String appName, String tenantId) throws IOException {
        String tempPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getWebPath(), this.hussarProduceProperties.getJavaPath(), "templates"});
        File temp = Files.createTempDirectory("java" + tenantId + appName, new FileAttribute[0]).toFile();
        try {
            String tempJavaPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), this.formdesignProperties.getJavaCodePath()});
            FileUtils.copyDirectory((File)java, (File)new File(tempJavaPath));
            FileUtils.forceDelete((File)java);
            java.mkdirs();
            String appEnglishName = AppContextUtil.asIdentifier((String)appName);
            String tenantCode = AppContextUtil.asIdentifier((String)tenantId);
            String appNameLow = appEnglishName.toLowerCase();
            String tenantCodeLow = tenantCode.toLowerCase();
            HashMap<String, String> paramMap = new HashMap<String, String>(8);
            paramMap.put("tenantCode", tenantCodeLow);
            paramMap.put("applicationCode", appNameLow);
            String javaPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), this.formdesignProperties.getJavaCodePath(), this.formdesignProperties.getJavaPath(), tenantCodeLow, appNameLow});
            String configPath = FileUtil.posixPath((String[])new String[]{javaPath, "config"});
            CodeGenerator configBeanGen = new CodeGenerator("ConfigBean.ftl", paramMap, tempPath, configPath, "ConfigBean.java");
            configBeanGen.gen();
            String appPath = tenantCodeLow + "/" + appNameLow;
            paramMap.put("applicationPath", appPath);
            CodeGenerator mybatisConfigGen = new CodeGenerator("PluginMybatisPlusConfiguration.ftl", paramMap, tempPath, configPath, "PluginMybatisPlusConfiguration.java");
            CodeGenerator pluginConfigrationGen = new CodeGenerator("pluginConfigrationGen.ftl", paramMap, tempPath, configPath, "PluginConfigration.java");
            mybatisConfigGen.gen();
            pluginConfigrationGen.gen();
            String newAppName = appEnglishName;
            String appFirst = appEnglishName.substring(0, 1);
            if (P.matcher(appFirst).find()) {
                newAppName = appFirst.toUpperCase() + appEnglishName.substring(1);
            }
            String tenantUp = tenantCode;
            String tenantFist = tenantCode.substring(0, 1);
            if (!"_".equals(tenantFist)) {
                tenantUp = tenantFist.toUpperCase() + tenantCode.substring(1);
            }
            String className = tenantUp + newAppName + "ParamsPlugin";
            paramMap.put("className", className);
            CodeGenerator basePluginGen = new CodeGenerator("ParamsPlugin.ftl", paramMap, tempPath, javaPath, className + ".java");
            basePluginGen.gen();
            String propertiesPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), "src/main/resources"});
            String pluginId = tenantCode + "-" + appEnglishName;
            String provider = BaseSecurityUtil.getUser().getAccount();
            String pluginClass = FileUtil.posixPath((String[])new String[]{this.formdesignProperties.getJavaPath(), tenantCodeLow, appNameLow, className}).replace("/", ".");
            if (pluginClass.startsWith(".")) {
                pluginClass = pluginClass.substring(1);
            }
            paramMap.put("id", pluginId);
            paramMap.put("class", pluginClass);
            paramMap.put("provider", provider);
            paramMap.put("description", expansion);
            CodeGenerator propertiesGen = new CodeGenerator("plugin.ftl", paramMap, tempPath, propertiesPath, "plugin.properties");
            propertiesGen.gen();
            paramMap.put("artifactId", this.pluginPrefix + tenantCode + "-" + appEnglishName);
            paramMap.put("pluginParentName", this.pluginParentName);
            CodeGenerator pomGen = new CodeGenerator("appPom.ftl", paramMap, tempPath, java.getAbsolutePath(), "pom.xml");
            pomGen.gen();
            FileUtils.copyDirectory((File)temp, (File)java);
        }
        finally {
            FileUtils.forceDelete((File)temp);
        }
    }

    private void updateConfigFile(File java, File module, File pom) throws IOException, XmlPullParserException {
        block39: {
            File modulePom = FileUtils.getFile((File)module, (String[])new String[]{"pom.xml"});
            File moduleProperties = FileUtils.getFile((File)module, (String[])new String[]{"src/main/resources", "plugin.properties"});
            File importProperties = FileUtils.getFile((File)java, (String[])new String[]{"src/main/resources", "plugin.properties"});
            if (moduleProperties.exists() && modulePom.exists()) {
                Properties properties = PropertiesUtils.loadProperties((String)moduleProperties.getAbsolutePath());
                String oldVersion = properties.getProperty("plugin.version");
                int index = oldVersion.lastIndexOf(".");
                int version = Integer.parseInt(oldVersion.substring(index + 1)) + 1;
                String newVersion = oldVersion.substring(0, index + 1) + version;
                this.updateProperty(importProperties, "plugin.version", newVersion);
                MavenXpp3Reader reader = new MavenXpp3Reader();
                try (FileInputStream oldFis = new FileInputStream(modulePom);
                     FileInputStream newFis = new FileInputStream(pom);){
                    Model oldModel = reader.read((InputStream)oldFis);
                    Model newModel = reader.read((InputStream)newFis);
                    Properties pomProperties = newModel.getProperties();
                    pomProperties.setProperty("plugin.version", newVersion);
                    String oldPomVersion = oldModel.getVersion();
                    if (ToolUtil.isEmpty((Object)oldPomVersion)) {
                        newModel.setVersion("1.0.0-RELEASE");
                    } else {
                        int pomIndex = oldPomVersion.indexOf(".");
                        int pomVersion = Integer.parseInt(oldPomVersion.substring(0, pomIndex)) + 1;
                        String newPomVersion = pomVersion + oldPomVersion.substring(pomIndex);
                        newModel.setVersion(newPomVersion);
                    }
                    MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                    try (FileWriter writer = new FileWriter(pom);){
                        mavenXpp3Writer.write((Writer)writer, newModel);
                        break block39;
                    }
                }
            }
            this.updateProperty(importProperties, "plugin.version", "v1.0.0");
        }
    }

    private void updateProperty(File properties, String key, String value) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (FileInputStream fis = new FileInputStream(properties);
             InputStreamReader inputReader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader bf = new BufferedReader(inputReader);){
            String str;
            while ((str = bf.readLine()) != null) {
                String name;
                if (!str.contains("#") && str.contains("=") && key.equals(name = str.substring(0, str.indexOf("=")).trim())) {
                    arrayList.add(key + "=" + value);
                    continue;
                }
                arrayList.add(str);
            }
            try (FileOutputStream fos = new FileOutputStream(properties);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                 BufferedWriter bw = new BufferedWriter(osw);){
                for (String s : arrayList) {
                    bw.write(s);
                    bw.newLine();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void importJavaCode(File java, String appName, String tenantId) throws IOException {
        String parentModulePath = FileUtil.posixPath((String[])new String[]{this.modulePath, this.prefixName, this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId)});
        File parentModule = new File(parentModulePath);
        if (!parentModule.exists()) {
            parentModule.mkdirs();
        }
        String tenantAndApp = AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)appName);
        String pluginName = this.pluginPrefix + tenantAndApp;
        File pluginModule = new File(parentModule, pluginName);
        if (!pluginModule.exists()) {
            parentModule.mkdirs();
        }
        String javaPath = FileUtil.posixPath((String[])new String[]{pluginModule.getAbsolutePath(), this.formdesignProperties.getJavaCodePath()});
        FileUtils.copyDirectory((File)java, (File)new File(javaPath));
    }

    private ProjectStoreArgs getProjectStoreArgs(ExportApplicationSource exportApplicationSource, ImportApplicationSource importApplicationSource, File axe, Map<String, Object> reserveMap) {
        ProjectStoreArgs projectStoreArgs = new ProjectStoreArgs();
        projectStoreArgs.setAxeDir(axe);
        projectStoreArgs.setExportApplicationSource(exportApplicationSource);
        projectStoreArgs.setImportApplicationSource(importApplicationSource);
        projectStoreArgs.setReserveMap(reserveMap);
        return projectStoreArgs;
    }

    private void backUpAppFiles(Long appId, String serverCode) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appId, serverCode);
        String pluginPath = pathMap.get(PLUGIN_PATH);
        File plugin = new File(pluginPath);
        String pluginBackUpPath = pathMap.get(PLUGIN_BACK_UP_PATH);
        if (plugin.exists()) {
            FileUtils.copyDirectory((File)plugin, (File)new File(pluginBackUpPath));
        }
    }

    public Map<String, String> getAppFilePath(Long appId, String serverCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.sysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        String tenantDir = AppContextUtil.asIdentifier((String)serverCode);
        String enName = AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName());
        String appPath = tenantDir + File.separator + enName;
        String vuePath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getFrontPath(), this.hussarAppExportProperties.getVueCodePath(), MODULES, appPath, VIEWS});
        String apiPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getFrontPath(), this.hussarAppExportProperties.getFrontApiPath(), MODULES, appPath, API});
        String tenantAndApp = tenantDir + "-" + enName;
        String pluginPath = FileUtil.posixPath((String[])new String[]{this.pluginPath, this.pluginPrefix + tenantDir, this.pluginPrefix + tenantAndApp});
        String frontBackUpPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getWebPath(), "frontBackUp", enName});
        String vueBackUpPath = FileUtil.posixPath((String[])new String[]{frontBackUpPath, this.hussarAppExportProperties.getVueCodePath(), MODULES, appPath, VIEWS});
        String apiBackUpPath = FileUtil.posixPath((String[])new String[]{frontBackUpPath, this.hussarAppExportProperties.getFrontApiPath(), MODULES, appPath, API});
        String pluginParentPath = new File(this.pluginPath).getParent();
        String pluginBackUpPath = FileUtil.posixPath((String[])new String[]{pluginParentPath, "hussar-plugin-back", this.pluginPrefix + tenantDir, this.pluginPrefix + tenantAndApp});
        HashMap<String, String> pathMap = new HashMap<String, String>();
        pathMap.put(VUE_PATH, vuePath);
        pathMap.put(API_PATH, apiPath);
        pathMap.put("frontBackUpPath", frontBackUpPath);
        pathMap.put(VUE_BACK_UP_PATH, vueBackUpPath);
        pathMap.put(API_BACK_UP_PATH, apiBackUpPath);
        pathMap.put(PLUGIN_PATH, pluginPath);
        pathMap.put(PLUGIN_BACK_UP_PATH, pluginBackUpPath);
        return pathMap;
    }

    private ApplicationMixProjectCodeArgs getProjectCodeArgs(ExportApplicationSource exportApplicationSource, ImportApplicationSource importApplicationSource, File zipDir, Map<String, Object> reserveMap) {
        ApplicationMixProjectCodeArgs applicationMixProjectCodeArgs = new ApplicationMixProjectCodeArgs();
        applicationMixProjectCodeArgs.setZipDir(zipDir);
        applicationMixProjectCodeArgs.setExportApplicationSource(exportApplicationSource);
        applicationMixProjectCodeArgs.setImportApplicationSource(importApplicationSource);
        applicationMixProjectCodeArgs.setReserveMap(reserveMap);
        return applicationMixProjectCodeArgs;
    }

    private Map<String, Object> importData(File file, String serverCode, String dsName, boolean isSync) {
        File dataFile = new File(file.getAbsolutePath(), "tableInfo" + File.separator + "tableInfo.json");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        ArrayList<JSONObject> addTableResultList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> modifyTableResults = new ArrayList<JSONObject>();
        if (dataFile.exists()) {
            try {
                byte[] bytes = FileUtils.readFileToByteArray((File)dataFile);
                Map tableStructures = (Map)SerializeUtils.deserialize((byte[])bytes);
                if (tableStructures != null) {
                    for (String s : tableStructures.keySet()) {
                        logger.info("\u751f\u4ea7\u73af\u5883\u5bfc\u5165\uff1as={}", (Object)s);
                        List tableStructure = (List)JSON.parseObject((String)((String)tableStructures.get(s)), (TypeReference)new TypeReference<List<TableInfo>>(){}, (Feature[])new Feature[0]);
                        s = this.getAppDsName(serverCode);
                        if (HussarUtils.isEmpty((Object)serverCode)) {
                            s = "master";
                        }
                        try {
                            this.generateSql(tableStructure, s, serverCode, sqlMap, addTableResultList, modifyTableResults);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error(e.getMessage());
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.error("\u751f\u4ea7\u73af\u5883\u5bfc\u5165\uff1a{}", (Object)e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        dataMap.put("sql", JSON.toJSONString(sqlMap));
        dataMap.put("createTables", addTableResultList);
        dataMap.put("alterTables", modifyTableResults);
        return dataMap;
    }

    private void generateSql(List<TableInfo> tableStructure, String dataSource, String serverCode, Map<String, String> sqlMap, List<JSONObject> addTableResultList, List<JSONObject> modifyTableResults) {
        StringBuilder sql = new StringBuilder();
        JSONObject addTables = new JSONObject();
        ArrayList<String> addTableName = new ArrayList<String>();
        addTables.put("dataSourceName", (Object)dataSource);
        addTables.put("tableNames", addTableName);
        JSONObject editTables = new JSONObject();
        HashMap<String, List<String>> tableMessage = new HashMap<String, List<String>>();
        editTables.put("dataSourceName", (Object)dataSource);
        editTables.put("tableMessage", tableMessage);
        for (TableInfo tableInfo : tableStructure) {
            try {
                Optional newTableInfo = DataModelUtil.filterTable((String)dataSource, (String)"BASE TABLE", (String)tableInfo.getName());
                if (!newTableInfo.isPresent()) {
                    String createTableSql = this.ddlService.getDdlSql(this.getCreateTableParam(tableInfo, dataSource, addTableName), new ArrayList(), null);
                    sql.append(createTableSql);
                    continue;
                }
                String updateTableSql = this.ddlService.getDdlSql(this.getUpdateTableParam(tableInfo, (TableInfo)newTableInfo.get(), dataSource, tableMessage), this.getColumnDto(((TableInfo)newTableInfo.get()).getFields()), tableInfo.getName());
                sql.append(updateTableSql);
            }
            catch (Exception e) {
                logger.error("\u6267\u884c\u5bfc\u5165SQL\u51fa\u9519:{}", (Throwable)e);
            }
        }
        addTableResultList.add(addTables);
        modifyTableResults.add(editTables);
        sqlMap.put(dataSource, sql.toString());
    }

    private List<ColumnInfoDto> getColumnDto(List<TableField> tableFields) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (TableField tableField : tableFields) {
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(tableField.getName());
            columnInfo.setColumnComment(tableField.getComment());
            columnInfo.setRequired("0");
            if ("PRI".equals(tableField.getPrimarys())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
                columnInfo.setPrimarys("1");
            } else {
                columnInfo.setPk("0");
            }
            if (tableField.getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataIsEmpty(Integer.valueOf(tableField.getDataIsEmpty() ? 1 : 0));
            columnInfo.setDataLength(Long.valueOf(tableField.getDataLength()));
            columnInfo.setDataDot(Integer.valueOf(tableField.getDataDot()));
            columnInfo.setDataType(tableField.getType().toUpperCase());
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    private MetadataParam getUpdateTableParam(TableInfo tableInfo, TableInfo newTableInfo, String dataSource, Map<String, List<String>> tableMessage) {
        ArrayList<String> messageList = new ArrayList<String>();
        MetadataParam param = new MetadataParam();
        param.setDeletedCols(new ArrayList());
        param.setColumnInfo(new ArrayList());
        List<ColumnInfoDto> columnDto = this.getColumnDto(tableInfo.getFields());
        param.setTableInfo(this.getTableInfoDto(tableInfo, dataSource, columnDto));
        this.mcontrastWith(tableInfo, newTableInfo, messageList, param);
        if (!messageList.isEmpty()) {
            tableMessage.put(tableInfo.getName(), messageList);
        }
        return param;
    }

    private void mcontrastWith(TableInfo tableInfo, TableInfo newTableInfo, List<String> tableMessage, MetadataParam param) {
        String columnPattern = "%s\u5217\uff1a%s(%s)";
        ArrayList<ColumnInfoDto> columnInfoDtos = new ArrayList<ColumnInfoDto>();
        ArrayList<TableField> editField = new ArrayList<TableField>();
        ArrayList<TableField> delField = new ArrayList<TableField>();
        Map addFieldsMap = tableInfo.getFields().stream().collect(Collectors.toMap(TableField::getName, Function.identity(), (k1, k2) -> k1));
        block0: for (Object oldField : newTableInfo.getFields()) {
            boolean flag = false;
            for (TableField newField : tableInfo.getFields()) {
                if (!HussarUtils.equals((Object)oldField.getName(), (Object)newField.getName())) continue;
                flag = true;
                addFieldsMap.remove(oldField.getName());
                if (HussarUtils.equals((Object)oldField.getType().toLowerCase(), (Object)newField.getType().toLowerCase()) && oldField.getDataIsEmpty() == newField.getDataIsEmpty() && oldField.getDataLength() == newField.getDataLength() && oldField.getDataDot() == newField.getDataDot() && HussarUtils.equals((Object)oldField.getComment(), (Object)newField.getComment()) && HussarUtils.equals((Object)"PRI", (Object)oldField.getPrimarys()) == HussarUtils.equals((Object)"PRI", (Object)newField.getPrimarys())) continue block0;
                tableMessage.add(String.format(columnPattern, "\u4fee\u6539", oldField.getName(), oldField.getComment()));
                editField.add(newField);
            }
        }
        if (HussarUtils.isNotEmpty(editField)) {
            List<ColumnInfoDto> editFieldColumnDto = this.getColumnDto(editField);
            for (ColumnInfoDto columnInfoDto : editFieldColumnDto) {
                columnInfoDto.setOperation("edit");
            }
            columnInfoDtos.addAll(editFieldColumnDto);
        }
        if (HussarUtils.isNotEmpty(addFieldsMap.values())) {
            ArrayList<TableField> addField = new ArrayList<TableField>(addFieldsMap.values());
            List<ColumnInfoDto> addFieldColumnDto = this.getColumnDto(addField);
            for (ColumnInfoDto columnInfoDto : addFieldColumnDto) {
                tableMessage.add(String.format("%s\u5217\uff1a%s(%s)", "\u65b0\u589e", columnInfoDto.getColumnName(), columnInfoDto.getColumnComment()));
                columnInfoDto.setOperation("add");
            }
            columnInfoDtos.addAll(addFieldColumnDto);
        }
        if (HussarUtils.isNotEmpty(delField)) {
            param.setDeletedCols(this.getColumnDto(delField));
        }
        param.setColumnInfo(columnInfoDtos);
    }

    private MetadataParam getCreateTableParam(TableInfo tableInfo, String dataSource, List<String> addTableName) {
        addTableName.add(tableInfo.getName());
        MetadataParam param = new MetadataParam();
        List<ColumnInfoDto> columnDto = this.getColumnDto(tableInfo.getFields());
        param.setTableInfo(this.getTableInfoDto(tableInfo, dataSource, columnDto));
        param.setColumnInfo(columnDto);
        return param;
    }

    private TableInfoDto getTableInfoDto(TableInfo tableInfo, String dataSource, List<ColumnInfoDto> columnDto) {
        TableInfoDto tableDto = new TableInfoDto();
        tableDto.setTableName(tableInfo.getName());
        tableDto.setPollName(dataSource);
        tableDto.setTableAlias(tableInfo.getName());
        tableDto.setTableDec(tableInfo.getComment());
        tableDto.setColumnList(HussarUtils.copyProperties(columnDto, MetadataColumn.class));
        return tableDto;
    }

    private File findOutermostDirectory(File dir, String targetName) {
        LinkedList<File> queue = new LinkedList<File>();
        queue.offer(dir);
        File outermostDirectory = null;
        while (!queue.isEmpty()) {
            File currentDir = (File)queue.poll();
            File[] files = currentDir.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (!file.isDirectory()) continue;
                if (file.getName().equals(targetName)) {
                    outermostDirectory = file;
                }
                queue.offer(file);
            }
        }
        return outermostDirectory;
    }

    public void downloadHistoryPackage(HttpServletResponse response, Long historyId) {
        SysAppImportHistory importHistory = this.sysImportAppMixHistoryService.queryByHistoryId(historyId);
        String path = importHistory.getPackagePath();
        File file = new File(path);
        if (!file.exists()) {
            response.setContentType("no file");
            return;
        }
        response.addHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + importHistory.getPackageName());
        response.setContentType(MULTIPART_FORM_DATA);
        try (BufferedInputStream bism = new BufferedInputStream(new FileInputStream(file), 10240);
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            int len = 0;
            int i = bism.available();
            byte[] buff = new byte[i];
            while ((len = bism.read(buff)) > 0) {
                bos.write(buff, 0, len);
                bos.flush();
            }
        }
        catch (IOException e) {
            logger.error("\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath=" + file.getAbsolutePath(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> synchronousImport(MultipartFile file, String appEnglisName, String tenantId, String compileId, String pluginId) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        InputStream inputStream = file.getInputStream();
        File temp = Files.createTempDirectory("appImportJar" + compileId, new FileAttribute[0]).toFile();
        File shareJar = new File(temp.getAbsolutePath() + File.separator + file.getOriginalFilename());
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)shareJar);
        try {
            if (shareJar.exists()) {
                logger.info("\u83b7\u53d6\u5171\u4eabjar\u5305\u6210\u529f\uff0c\u5730\u5740\u4e3a\uff1a" + shareJar.getAbsolutePath() + ",\u6587\u4ef6\u5927\u5c0f\uff1a" + shareJar.length());
                File localJar = new File(FileUtil.posixPath((String[])new String[]{this.localPlugin, File.separator + shareJar.getName()}));
                FileUtils.copyFile((File)shareJar, (File)localJar);
                logger.info("\u62c9\u53d6\u5171\u4eabjar\u5230\u672c\u5730\u6210\u529f\uff0c\u5730\u5740\u4e3a\uff1a" + localJar.getAbsolutePath() + ",\u6587\u4ef6\u5927\u5c0f\uff1a" + localJar.length());
                this.loadPluginJar(pluginId, localJar);
                logger.info("\u542f\u52a8\u672c\u5730jar\u5305\u6210\u529f");
            }
            map.put("success", true);
            map.put(RESULT_MSG, "\u5b89\u88c5\u63d2\u4ef6\u6210\u529f\uff01");
            this.sysEyImportAppMixMsgService.setImportStatusFour(Long.valueOf(compileId));
        }
        catch (IOException e1) {
            map.put("success", false);
            map.put(RESULT_MSG, "\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff01");
            e1.printStackTrace();
            this.sysEyImportAppMixMsgService.setFailReason(Long.valueOf(compileId), e1.getMessage());
        }
        catch (Exception e) {
            map.put("success", false);
            map.put(RESULT_MSG, "\u5b89\u88c5\u63d2\u4ef6\u5931\u8d25\uff0c\u5df2\u56de\u6eda\u5907\u4efd\u63d2\u4ef6jar\u5305\uff01");
            e.printStackTrace();
            this.sysEyImportAppMixMsgService.setFailReason(Long.valueOf(compileId), e.getMessage());
        }
        finally {
            FileUtils.forceDelete((File)temp);
        }
        return map;
    }

    public void importAndCompile(Map<String, Object> map) {
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean importMsgFlag = false;
        String tempPath = ToolUtil.isNotEmpty((Object)map.get("tempPath")) ? map.get("tempPath").toString() : expansion;
        this.checkFilePath(tempPath);
        Long appId = Long.parseLong(ToolUtil.isNotEmpty((Object)map.get("appId")) ? map.get("appId").toString() : null);
        String appName = ToolUtil.isNotEmpty((Object)map.get("appName")) ? map.get("appName").toString() : expansion;
        String sql = ToolUtil.isNotEmpty((Object)map.get("sql")) ? map.get("sql").toString() : expansion;
        String keys = ToolUtil.isNotEmpty((Object)map.get("keys")) ? map.get("keys").toString() : expansion;
        String serverCode = ToolUtil.isNotEmpty((Object)map.get("tenantCode")) ? map.get("tenantCode").toString() : user.getTenantCode();
        Long compileId = this.addWaitingCompileTask(appId);
        boolean saveTempPathFileFlag = this.saveTempPathFile(appId, serverCode, tempPath, compileId.toString());
        if (saveTempPathFileFlag) {
            File temp = new File(tempPath);
            if (ToolUtil.isNotEmpty((Object)temp) && temp.exists()) {
                try {
                    FileUtils.forceDelete((File)temp);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            SysEyImportAppMsg appImportMsg = new SysEyImportAppMsg();
            appImportMsg.setId(compileId);
            appImportMsg.setAppId(appId);
            appImportMsg.setImportAppName(appName);
            appImportMsg.setImportMsgSql(sql);
            appImportMsg.setImportMsgKeys(keys);
            appImportMsg.setServerCode(serverCode);
            appImportMsg.setImportStartTime(new Date());
            appImportMsg.setImportStatus("0");
            appImportMsg.setLoadFlag("0");
            appImportMsg.setImportUserId(user.getId());
            appImportMsg.setImportUserName(user.getUserName());
            appImportMsg.setServerName(user.getTenantName());
            importMsgFlag = this.saveImportMsgToTable(appImportMsg);
        }
        if (!importMsgFlag) {
            throw new HussarException("\u4fdd\u5b58\u5bfc\u5165\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SysEyImportAppMsg eyImportAppMsg = (SysEyImportAppMsg)this.sysEyImportAppMixMsgService.getById((Serializable)compileId);
        if (HussarUtils.isEmpty((Object)eyImportAppMsg)) {
            return;
        }
        boolean flag = this.sysEyImportAppMixMsgService.setImportStatusOne(eyImportAppMsg.getId());
        if (flag) {
            try {
                String importFileBackUpPath = FileUtil.posixPath((String[])new String[]{this.hussarClusterProperties.getImportFile(), File.separator, eyImportAppMsg.getServerCode(), File.separator, eyImportAppMsg.getAppId().toString(), File.separator, eyImportAppMsg.getId().toString()});
                this.importAndCompileAppWithSecurity(importFileBackUpPath, eyImportAppMsg.getServerCode(), eyImportAppMsg.getAppId(), eyImportAppMsg.getImportMsgSql(), Arrays.asList(eyImportAppMsg.getImportMsgKeys().split(",")), eyImportAppMsg.getId(), eyImportAppMsg.getServerName(), eyImportAppMsg.getSecurityLevel());
            }
            catch (Exception e) {
                this.sysEyImportAppMixMsgService.setFailReason(eyImportAppMsg.getId(), e.getMessage());
                this.sysEyImportAppMixMsgService.setImportStatusFive(eyImportAppMsg.getId());
                throw new HussarException("\u5e94\u7528\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    public Map<String, Object> importExpansionApp(MultipartFile multipartFile, Long appId) throws Exception {
        File temp = null;
        Map<String, Object> returnMap = new HashMap<String, Object>();
        try {
            String importType;
            InputStream inputStream = multipartFile.getInputStream();
            temp = Files.createTempDirectory("appImport" + appId, new FileAttribute[0]).toFile();
            File tempFile = new File(temp.getAbsolutePath() + File.separator + appId + ".zip");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            ZipUtil.unzip(tempFile.getAbsolutePath(), temp.getAbsolutePath() + File.separator);
            File metaFile = new File(temp + File.separator + "meta.json");
            if (!metaFile.exists()) {
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, "\u521d\u59cb\u5316\u5305\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
                return returnMap;
            }
            byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
            Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
            if (metaMap == null) {
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, "meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                return returnMap;
            }
            String string = importType = metaMap.get("importType") == null ? expansion : metaMap.get("importType").toString();
            if (!"0".equals(importType) && !"2".equals(importType)) {
                returnMap.put(STATUS, false);
                returnMap.put(RESULT_MSG, "\u521d\u59cb\u5316\u5305\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5f53\u524d\u73af\u5883\u9700\u8981\u7684\u5305\uff01");
                return returnMap;
            }
            returnMap = this.initExpansionAppToOffline(appId, temp, metaMap, returnMap);
        }
        catch (Exception e) {
            if (ToolUtil.isNotEmpty(temp) && temp.exists()) {
                FileUtils.forceDelete((File)temp);
            }
            throw e;
        }
        return returnMap;
    }

    public ApiResponse<Object> importProduceAppNew(MultipartFile file, Long appId, String appEnglishName, String tCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
        long count = this.sysLowCodeAppExtendService.count((Wrapper)wrapper);
        if (count <= 0L) {
            MixAppInfoVo appInfo = this.sysLowCodeAppExtendMapper.getMixAppInfoByCode(appEnglishName);
            if (HussarUtils.isEmpty((Object)appInfo)) {
                return ApiResponse.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728");
            }
            appId = appInfo.getId();
        }
        AppContextUtil.setAppId((String)String.valueOf(appId));
        try {
            Map<String, Object> data = this.importProduceApp(file, appId);
            boolean flag = (Boolean)data.get(STATUS);
            if (flag) {
                data.put("tenantCode", tCode);
                this.importAndCompile(data);
                return ApiResponse.success(data);
            }
            return ApiResponse.fail((String)data.get(RESULT_MSG).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5e94\u7528\u5bfc\u5165\u5931\u8d25");
        }
    }

    public ApiResponse<Object> importProduceAppForTenant(MultipartFile file, Long appId, String appEnglishName, String tenantCode, String oldConnName, String oldTenantCode) {
        ApiResponse<Object> response = this.importProduceAppNew(file, appId, appEnglishName, tenantCode);
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HussarHttpServletRequest hussarHttpServletRequest = new HussarHttpServletRequest(servletRequestAttributes.getRequest());
        hussarHttpServletRequest.addHeader("tcode", oldTenantCode);
        ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)hussarHttpServletRequest);
        RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
        HussarContextHolder.setTenant((String)oldConnName, (String)oldTenantCode);
        return response;
    }

    private Map<String, Object> initExpansionAppToOffline(Long appId, File temp, Map<String, Object> metaMap, Map<String, Object> returnMap) throws Exception {
        String appName = metaMap.get("appName") == null ? expansion : metaMap.get("appName").toString();
        String tenantId = metaMap.get("tenantId") == null ? expansion : metaMap.get("tenantId").toString();
        String javaPath = metaMap.get("javaPath") == null ? expansion : metaMap.get("javaPath").toString();
        String sign = metaMap.get("sign") == null ? expansion : metaMap.get("sign").toString();
        File tar = new File(temp + File.separator + appName + ".tar");
        String serviceNameZip = metaMap.get("serviceName") == null ? expansion : metaMap.get("serviceName").toString();
        String dsName = metaMap.get("ds") == null ? expansion : metaMap.get("ds").toString();
        String md5 = ZipUtil.getMd5(tar.getAbsolutePath());
        if (!md5.equals(sign)) {
            returnMap.put(STATUS, false);
            returnMap.put(RESULT_MSG, "\u521d\u59cb\u5316\u5305\u5df2\u88ab\u4fee\u6539\uff01");
            return returnMap;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.sysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        String appNameNow = appInfo.getAppEnglishName();
        this.addChildExpansionModule(appId, appNameNow, false);
        TarUtil.unTar(tar, temp.getAbsolutePath() + File.separator);
        File axe = new File(temp.getAbsolutePath() + File.separator + "god_axe");
        ExportApplicationSource exportApplicationSource = this.getExportApplicationSource(appName, tenantId, javaPath, dsName);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        ImportApplicationSource importApplicationSource = this.getImportApplicationSource(appInfo.getAppEnglishName(), tenantCode);
        HashMap<String, Object> storeReserveMap = new HashMap<String, Object>();
        storeReserveMap.put("appId", appId);
        ProjectStoreArgs projectStoreArgs = this.getProjectStoreArgs(exportApplicationSource, importApplicationSource, axe, storeReserveMap);
        projectStoreArgs.getReserveMap().put("serviceNameZip", serviceNameZip);
        this.inductsProjectStoreService.handlerProjectStore(JSONObject.parseObject((String)JSONObject.toJSONString((Object)projectStoreArgs)));
        this.inductsProjectStoreService.importProjectStore(appId.toString(), axe.getAbsolutePath());
        File expansionJava = new File(temp.getAbsolutePath() + File.separator + "java");
        File expansionResource = new File(temp.getAbsolutePath() + File.separator + "resources");
        File expansionVue = new File(temp.getAbsolutePath() + File.separator + "vue");
        String expansionModulePath = this.getExpansionModulePath(appNameNow);
        String expansionPath = MODULES + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appNameNow) + File.separator + SRC;
        String expansionVuePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), expansionPath}) + expansion;
        String relativeRPath = "src.main.resources";
        String expansionResourcePath = expansionModulePath + File.separator + relativeRPath.replace(".", File.separator);
        String expansionJavaPath = FileUtil.posixPath((String[])new String[]{expansionModulePath, VuePathServiceImpl.formDesignProperties.getJavaCodePath(), VuePathServiceImpl.formDesignProperties.getJavaPath(), SysAppMixFileServerImpl.getAppBackCodePrefixByAppId(appInfo)});
        String appType = this.sysLowCodeAppExtendMapper.getMixAppTypeById(appId);
        WorkflowLoadAppDto workflowLoadAppDto = new WorkflowLoadAppDto();
        workflowLoadAppDto.setAppType(appType);
        workflowLoadAppDto.setAppCode(appInfo.getAppEnglishName());
        workflowLoadAppDto.setAppId(appId.toString());
        workflowLoadAppDto.setImportType("2");
        workflowLoadAppDto.setFilePath(temp.getAbsolutePath() + File.separator + "workflow");
        if (new File(workflowLoadAppDto.getFilePath()).exists()) {
            WorkflowAppMigrationService.loadApp((WorkflowLoadAppDto)workflowLoadAppDto);
        }
        if (expansionJava.exists()) {
            SysAppMixFileServerImpl.copyToDirectoryNotExpansion(expansionJava, new File(expansionJavaPath));
        }
        if (expansionResource.exists()) {
            SysAppMixFileServerImpl.copyToDirectory(expansionResource, new File(expansionResourcePath));
        }
        if (expansionVue.exists()) {
            SysAppMixFileServerImpl.copyToDirectory(expansionVue, new File(expansionVuePath));
        }
        logger.info("\u6269\u5c55\u5e94\u7528\uff1a{}\u5bfc\u5165\u6210\u529f", (Object)appName);
        returnMap.put(STATUS, true);
        return returnMap;
    }

    private static void copyToDirectory(File srcDir, File destDir) throws IOException {
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (file.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)file, (File)destDir);
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    private static void copyToDirectoryNotExpansion(File srcDir, File destDir) throws IOException {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (file.isDirectory()) {
                File newDestDir = new File(destDir, file.getName());
                if (!newDestDir.exists()) {
                    newDestDir.mkdirs();
                }
                SysAppMixFileServerImpl.copyToDirectoryNotExpansion(file, newDestDir);
                continue;
            }
            SysAppMixFileServerImpl.modifyFilePaths(file, tenantCode.toLowerCase());
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    public static void modifyFilePaths(File file, String tenantCode) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String javaPath = VuePathServiceImpl.formDesignProperties.getJavaPath().replaceAll("^/+|/+$", expansion).replace("/", ".");
        boolean modified = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                String originalLine = line;
                if (line.trim().startsWith("package " + javaPath)) {
                    line = SysAppMixFileServerImpl.modifyPath(line, javaPath, tenantCode);
                } else if (line.trim().startsWith("import " + javaPath)) {
                    line = SysAppMixFileServerImpl.modifyPath(line, javaPath, tenantCode);
                }
                if (!line.equals(originalLine)) {
                    modified = true;
                }
                lines.add(line);
            }
        }
        if (modified) {
            var6_6 = null;
            try (FileWriter writer = new FileWriter(file);){
                for (String line : lines) {
                    writer.write(line + System.lineSeparator());
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
    }

    private static String modifyPath(String path, String javaPath, String tenantCode) {
        String afterBase = path.substring(path.indexOf(javaPath) + javaPath.length());
        String[] parts = afterBase.split("\\.");
        if (parts.length >= 2) {
            parts[1] = AppContextUtil.asIdentifier((String)tenantCode);
        }
        StringBuilder newPath = new StringBuilder();
        newPath.append(path.substring(0, path.indexOf(javaPath) + javaPath.length()));
        for (int i = 1; i < parts.length; ++i) {
            newPath.append(".").append(parts[i]);
        }
        return newPath.toString();
    }

    public static String getAppBackCodePrefixByAppId(SysLowCodeAppExtend appInfo) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        return appInfo == null ? null : FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName())}).toLowerCase();
    }

    private String getExpansionModulePath(String applicationName) {
        String expansionModulePath = null;
        if (this.pluginPrefix != null && this.modulePath != null) {
            String absolutePath = this.modulePath;
            int end = absolutePath.lastIndexOf(File.separator);
            if (end != absolutePath.length() - 1) {
                absolutePath = absolutePath + File.separator;
            }
            String prefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)this.prefixName) ? this.prefixName : "hussar-plugin");
            File module = new File(prefixPath);
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            if (ToolUtil.isEmpty((Object)securityUser)) {
                throw new BaseException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            if (module.exists()) {
                String userCode = securityUser.getTenantCode();
                String tenantCode = AppContextUtil.asIdentifier((String)userCode);
                String tenantPath = prefixPath + File.separator + this.pluginPrefix + tenantCode;
                String tenAndApp = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)applicationName);
                expansionModulePath = tenantPath + File.separator + this.pluginPrefix + tenAndApp + expansion;
            }
        }
        return expansionModulePath;
    }

    private void checkFilePath(String tempPath) {
        String regex = "^(?!(.*[\\\\/]|^)[.]{2}[\\\\/]|.*[\\\\/][.]{2}$|.*[\\\\/]\\.{1}[\\\\/]).+$";
        if (!tempPath.matches(regex)) {
            throw new HussarException("\u8def\u5f84\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
    }

    private void importFunResMenu(Long appId, File file) throws IOException, ClassNotFoundException {
        List sysMenus;
        List sysFunctionResources;
        List sysResourceModules;
        List sysResources;
        List sysFunctionModules;
        byte[] meta = FileUtils.readFileToByteArray((File)file);
        Map funResMenuMap = (Map)SerializeUtils.deserialize((byte[])meta);
        if (HussarUtils.isEmpty((Object)funResMenuMap)) {
            return;
        }
        List sysFunctions = (List)funResMenuMap.get("sysFunctions");
        if (HussarUtils.isNotEmpty((Object)sysFunctions)) {
            sysFunctions.forEach(fun -> fun.setAppId(appId));
            this.sysFunctionsBoService.saveOrUpdateList(sysFunctions);
        }
        if (HussarUtils.isNotEmpty((Object)(sysFunctionModules = (List)funResMenuMap.get("sysFunctionModules")))) {
            sysFunctionModules.forEach(functionModules -> functionModules.setAppId(appId));
            this.sysFunctionModulesBoService.saveOrUpdateList(sysFunctionModules);
        }
        if (HussarUtils.isNotEmpty((Object)(sysResources = (List)funResMenuMap.get("sysResources")))) {
            sysResources.forEach(resource -> resource.setAppId(appId));
            this.baseResourceBoService.saveOrUpdateList(sysResources);
        }
        if (HussarUtils.isNotEmpty((Object)(sysResourceModules = (List)funResMenuMap.get("sysResourceModules")))) {
            sysResourceModules.forEach(resourceModules -> resourceModules.setAppId(appId));
            this.sysResourceMosulesBoService.saveOrUpdateList(sysResourceModules);
        }
        if (HussarUtils.isNotEmpty((Object)(sysFunctionResources = (List)funResMenuMap.get("sysFunctionResources")))) {
            this.sysFunctionResourcesBoService.saveOrUpdateList(sysFunctionResources);
        }
        if (HussarUtils.isNotEmpty((Object)(sysMenus = (List)funResMenuMap.get("sysMenus")))) {
            this.sysMenuManageBoService.saveOrUpdateList(sysMenus);
        }
    }

    private void rePackage(Path src, Path dst, Function<Properties, Properties> customizer) throws IOException {
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(src, new OpenOption[0]));
             ZipOutputStream zipOutput = new ZipOutputStream(Files.newOutputStream(dst, new OpenOption[0]));){
            ZipEntry entryInput;
            while ((entryInput = zipInput.getNextEntry()) != null) {
                ZipEntry entryOutput = new ZipEntry(entryInput.getName());
                entryOutput.setTime(entryInput.getTime());
                entryOutput.setComment(entryInput.getComment());
                entryOutput.setExtra(entryInput.getExtra());
                zipOutput.putNextEntry(entryOutput);
                if (HussarUtils.equals((Object)"plugin.properties", (Object)entryInput.getName())) {
                    Properties pluginProps = new Properties();
                    pluginProps.load(zipInput);
                    pluginProps = customizer.apply(pluginProps);
                    pluginProps.store(zipOutput, null);
                } else {
                    IOUtils.copy((InputStream)zipInput, (OutputStream)zipOutput);
                    zipInput.closeEntry();
                }
                zipOutput.closeEntry();
            }
        }
    }

    private String replacePluginId(String pluginId, int position, String tenantCode) {
        int count;
        if (pluginId == null || pluginId.isEmpty() || position < 1) {
            return pluginId;
        }
        String tenantIdentifier = AppContextUtil.asIdentifier((String)tenantCode);
        logger.info("\u66ff\u6362\u7b2c{}\u4e2a\u4e2d\u5212\u7ebf\u524d\u5185\u5bb9, \u79df\u6237code: {}", (Object)position, (Object)tenantCode);
        int index = -1;
        for (count = 0; count < position && (index = pluginId.indexOf(45, index + 1)) != -1; ++count) {
        }
        if (index != -1 && count == position) {
            return tenantIdentifier + pluginId.substring(index);
        }
        return pluginId;
    }

    private Boolean compileFront(String appEnglishName, String serverCode, Long compileId, String tempPath) throws Exception {
        Map<String, Object> threadMap = context.get();
        String version = (String)threadMap.get("version");
        if ("0".equals(this.clusterType)) {
            File distPathFile = new File(tempPath + File.separator + "vue" + File.separator + VUE_DIST + ".hussar");
            if (distPathFile.exists()) {
                String ngPath = this.nginxFrontPath + File.separator + AppContextUtil.asIdentifier((String)serverCode) + File.separator;
                File ngFileDir = new File(ngPath);
                if (!ngFileDir.exists()) {
                    ngFileDir.mkdirs();
                }
                String unzipDist = tempPath + File.separator + "vue" + File.separator + VUE_DIST + File.separator;
                ZipUtil.unzip(distPathFile.getAbsolutePath(), unzipDist);
                File distWithOutVersion = new File(unzipDist + AppContextUtil.asIdentifier((String)appEnglishName));
                File distWithVersion = new File(unzipDist + AppContextUtil.asIdentifier((String)appEnglishName) + "_" + version);
                distWithOutVersion.renameTo(distWithVersion);
                FileUtils.copyDirectoryToDirectory((File)distWithVersion, (File)ngFileDir);
                File ngFile = new File(ngFileDir + File.separator + VUE_DIST + ".hussar");
                if (ngFile.exists()) {
                    ngFile.delete();
                }
            }
        } else {
            File temp = new File(tempPath);
            File[] childFiles = temp.listFiles();
            File zipFile = null;
            assert (childFiles != null);
            for (File file : childFiles) {
                if (!file.getName().endsWith(".zip")) continue;
                zipFile = file;
            }
            if (zipFile == null) {
                throw new HussarException("\u672a\u627e\u5230zip\u6587\u4ef6");
            }
            List<String> arrayList = this.hussarBaseAppMixFileMapper.getAllClusterAddress();
            logger.info("\u5df2\u914d\u7f6e\u96c6\u7fa4\u8282\u70b9\uff1a{}", (Object)org.apache.commons.lang3.StringUtils.join(arrayList, (String)","));
            if (HussarUtils.isNotEmpty(arrayList)) {
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                for (String string : arrayList) {
                    String url = string + "/hussarBase/application/mix/compileFront";
                    MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", zipFile.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)zipFile)).addFormDataPart("appCode", appEnglishName).addFormDataPart("serverCode", serverCode).addFormDataPart("compileId", compileId.toString()).addFormDataPart("serviceName", expansion).addFormDataPart("version", version).build();
                    Request request = new Request.Builder().url(url).method("POST", (RequestBody)body).build();
                    Response response = client.newCall(request).execute();
                    if (ToolUtil.isEmpty((Object)response)) {
                        this.sysEyImportAppMixMsgService.setFailReason(compileId, string + "\u8282\u70b9\u5206\u53d1\u5931\u8d25\uff01");
                        this.updateCompileStatusCluster(compileId, "2", string + "\u8282\u70b9\u5206\u53d1\u5931\u8d25\uff01");
                        continue;
                    }
                    if (!HussarUtils.equals((Object)ResultCode.SUCCESS.getCode(), (Object)response.code())) {
                        this.sysEyImportAppMixMsgService.setFailReason(compileId, response.message());
                        this.updateCompileStatusCluster(compileId, "2", string + "\u8282\u70b9\u5206\u53d1\u5931\u8d25\uff01" + response.message());
                    }
                    response.close();
                }
            } else {
                this.sysEyImportAppMixMsgService.setFailReason(compileId, "\u96c6\u7fa4\u8282\u70b9\u672a\u914d\u7f6e");
                this.updateCompileStatus(compileId, "2", "\u96c6\u7fa4\u8282\u70b9\u672a\u914d\u7f6e");
                throw new Exception("\u96c6\u7fa4\u8282\u70b9\u672a\u914d\u7f6e");
            }
        }
        return true;
    }
}

