/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamMemberCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppRecycleCommonMapper;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.application.util.NacosUtil;
import com.jxdinfo.hussar.applicationmix.dao.SysLowCodeAppExtendMapper;
import com.jxdinfo.hussar.applicationmix.model.SysAppDataSource;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.service.ISysAppDataSourceService;
import com.jxdinfo.hussar.applicationmix.service.impl.CommonMixAppService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.AppIdUpdateDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.applicationmix.service.impl.HussarLowCodeExtendCallBackServiceImpl")
public class HussarLowCodeExtendCallBackServiceImpl
extends CommonMixAppService
implements IHussarAppCallBackService {
    private static final Logger logger = LoggerFactory.getLogger(HussarLowCodeExtendCallBackServiceImpl.class);
    private static final String APP_TYPE = "22";
    @Resource
    private SysLowCodeAppExtendMapper sysLowCodeAppExtendMapper;
    @Resource
    private ISysAppDataSourceService sysAppDataSourceService;
    @Resource
    private SysAppRecycleCommonMapper sysAppRecycleCommonMapper;
    @Resource
    private SysAppDevelopTeamCommonMapper developTeamMapper;
    @Resource
    private SysAppDevelopTeamMemberCommonMapper developTeamMemberMapper;

    public String getAppType() {
        return APP_TYPE;
    }

    public void deleteApp(SysApplication app) {
        Long appId = app.getId();
        this.sysAppRecycleCommonMapper.deleteById((Serializable)appId);
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        this.developTeamMapper.deleteById((Serializable)sysAppDevelopTeam.getId());
        this.developTeamMemberMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        this.sysLowCodeAppExtendMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppId, (Object)appId));
        this.sysAppDataSourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDataSource::getAppId, (Object)appId));
        HussarCacheUtil.evict((String)"app_info", (Object)app.getId());
    }

    public void beforeDeleteApp(SysApplication app) {
        MixAppInfoVo mixAppInfo = this.sysLowCodeAppExtendMapper.getMixAppInfo(app.getId());
        try {
            this.godAxeModelService.resetAppIdToStandardVersion(mixAppInfo.getAppEnglishName());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public void addApp(SysApplication app) {
        Long count;
        Map extendParams = app.getExtendParams();
        String isInit = (String)extendParams.get("isInit");
        String appEnglishName = (String)extendParams.get("appEnglishName");
        List dbIds = (List)extendParams.get("dbIds");
        if (NacosUtil.isMicroService()) {
            String serviceName = app.getServiceName();
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("appId", null);
            queryParams.put("appEnglishName", appEnglishName);
            queryParams.put("serviceName", serviceName);
            count = this.sysLowCodeAppExtendMapper.getCountWithServiceName(queryParams);
        } else {
            count = this.sysLowCodeAppExtendMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppEnglishName, (Object)appEnglishName));
        }
        if (count > 0L) {
            throw new BaseException("\u5e94\u7528\u82f1\u6587\u540d\u91cd\u590d");
        }
        SysLowCodeAppExtend appExtend = new SysLowCodeAppExtend();
        appExtend.setAppId(app.getId());
        appExtend.setIsInit(isInit);
        appExtend.setAppEnglishName(appEnglishName);
        this.sysLowCodeAppExtendMapper.insert(appExtend);
        try {
            AppIdUpdateDto appIdUpdateDto = new AppIdUpdateDto();
            appIdUpdateDto.setAppCode(appEnglishName);
            appIdUpdateDto.setAppId(String.valueOf(app.getId()));
            this.godAxeModelService.updateAppId(appIdUpdateDto);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (HussarUtils.isNotEmpty((Object)dbIds)) {
            ArrayList<SysAppDataSource> list = new ArrayList<SysAppDataSource>();
            for (Object dbId : dbIds) {
                SysAppDataSource source = new SysAppDataSource();
                source.setAppId(app.getId());
                source.setDbId(Long.valueOf(Long.parseLong(String.valueOf(dbId))));
                list.add(source);
            }
            this.sysAppDataSourceService.saveBatch(list);
        }
        String active = this.hussarBasePluginProperties.getRunMode();
        String environment = "2";
        if ("dev".equals(active)) {
            environment = "2";
        } else if ("prod".equals(active)) {
            environment = "3";
        }
        if ("2".equals(environment) && !NacosUtil.isMicroService()) {
            this.addChildExpansionModule(app.getId(), appEnglishName, false);
        }
    }

    public void updateApp(SysApplication app) {
        Map extendParams = app.getExtendParams();
        List dbIds = (List)extendParams.get("dbIds");
        this.sysAppDataSourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDataSource::getAppId, (Object)app.getId()));
        if (HussarUtils.isNotEmpty((Object)dbIds)) {
            ArrayList<SysAppDataSource> list = new ArrayList<SysAppDataSource>();
            for (Object dbId : dbIds) {
                SysAppDataSource source = new SysAppDataSource();
                source.setAppId(app.getId());
                source.setDbId(Long.valueOf(Long.parseLong(String.valueOf(dbId))));
                list.add(source);
            }
            this.sysAppDataSourceService.saveBatch(list);
        }
        String active = this.hussarBasePluginProperties.getRunMode();
        String environment = "2";
        if ("dev".equals(active)) {
            environment = "2";
        } else if ("prod".equals(active)) {
            environment = "3";
        }
        if ("2".equals(environment) && !NacosUtil.isMicroService()) {
            SysLowCodeAppExtend appExtend = (SysLowCodeAppExtend)this.sysLowCodeAppExtendMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppId, (Object)app.getId()));
            this.addChildExpansionModule(app.getId(), appExtend.getAppEnglishName(), false);
        }
        HussarCacheUtil.evict((String)"app_info", (Object)app.getId());
    }

    public void deleteRecycleApp(SysAppRecycle appRecycle) {
    }

    public void beforeDeleteRecycleApp(SysAppRecycle appRecycle) {
    }

    public void revertRecycleApp(SysAppRecycle appRecycle) {
    }
}

