/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.runner;

import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixImportCtrlService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class AppImportCtrlJob
implements BasicProcessor {
    private Logger logger = LoggerFactory.getLogger(AppImportCtrlJob.class);
    @Lazy
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    private static final IHussarBaseAppMixImportCtrlService HUSSAR_BASE_APP_MIX_IMPORT_CTRL_SERVICE = (IHussarBaseAppMixImportCtrlService)SpringContextHolder.getBean(IHussarBaseAppMixImportCtrlService.class);

    public ProcessResult process(TaskContext taskContext) throws Exception {
        String tenantCode = taskContext.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode) || "0".equals(tenantCode)) {
            boolean tenantOpen = TenantCacheUtil.openTenant();
            HashSet<String> connNameList = new HashSet<String>();
            Map normalTenants = new HashMap<String, DefaultTenant>();
            if (tenantOpen) {
                Set tenantConnNameList = this.sysTenantService.getConnNameList();
                if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                    connNameList.addAll(tenantConnNameList);
                }
                normalTenants = this.sysTenantService.getNormalTenants();
            } else {
                connNameList.add("master");
                normalTenants.put("master", new DefaultTenant());
            }
            for (String connName : connNameList) {
                HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
                if (hussarTenantDefinition == null) {
                    throw new BaseException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a" + connName + "\u7684\u79df\u6237");
                }
                HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
                HUSSAR_BASE_APP_MIX_IMPORT_CTRL_SERVICE.doJob(connName);
                HussarContextHolder.remove();
            }
        }
        return new ProcessResult(true, "success");
    }
}

