/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.applicationmix.dto.QueryAppDto;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixFileMircoService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixGroupService;
import com.jxdinfo.hussar.applicationmix.service.ISysApplicationMixService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppGroupVo;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.applicationmix.vo.TenantPluginInfoVO;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.expansion.core.service.SharePluginService;
import com.jxdinfo.hussar.support.expansion.core.service.dto.SharePluginInfoDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7cfb\u7edf\u5e94\u7528"})
@RestController(value="com.jxdinfo.hussar.applicationmix.controller.HussarBaseApplicationMixController")
@RequestMapping(value={"/hussarBase/application/mix"})
public class HussarBaseApplicationMixController {
    @Resource
    ISysApplicationMixService sysApplicationMixService;
    @Resource
    ISysApplicationService sysApplicationService;
    @Resource
    ISysAppMixGroupService sysAppMixGroupService;
    @Resource
    private ISysAppMixFileMircoService appFileService;
    @Autowired(required=false)
    private SharePluginService sharePluginService;

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5e94\u7528\u5220\u9664", notes="\u5e94\u7528\u5220\u9664")
    public ApiResponse<Boolean> deleteApp(@ApiParam(value="\u5e94\u7528id") @RequestParam Long id) {
        return ApiResponse.success((Object)this.sysApplicationMixService.deleteApp(id));
    }

    @GetMapping(value={"/manage/appPageList"})
    @AuditLog(moduleName="\u5e94\u7528\u7ef4\u62a4\u5217\u8868\u67e5\u8be2", eventDesc="\u5e94\u7528\u7ef4\u62a4\u5206\u9875\u5217\u8868\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<MixAppInfoVo>> appPageList(@ApiParam(value="\u5206\u9875\u53c2\u6570") PageInfo pageInfo, QueryAppDto appDto) {
        return ApiResponse.success((Object)this.sysApplicationMixService.appPageList(pageInfo, appDto));
    }

    @GetMapping(value={"/manage/appList"})
    @AuditLog(moduleName="\u5e94\u7528\u7ef4\u62a4\u5217\u8868\u67e5\u8be2", eventDesc="\u5e94\u7528\u7ef4\u62a4\u5217\u8868\u67e5\u8be2(\u67e5\u8be2\u5168\u90e8)", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<MixAppGroupVo>> appList(QueryAppDto appDto) {
        return ApiResponse.success((Object)this.sysApplicationMixService.appList(appDto));
    }

    @GetMapping(value={"/checkSameAppEnglishName"})
    @AuditLog(moduleName="\u5e94\u7528\u82f1\u6587\u540d\u662f\u5426\u91cd\u590d", eventDesc="\u5e94\u7528\u82f1\u6587\u540d\u662f\u5426\u91cd\u590d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> checkSameAppEnglishName(QueryAppDto appDto) {
        return ApiResponse.success((Object)this.sysApplicationMixService.checkSameAppEnglishName(appDto));
    }

    @GetMapping(value={"/group/deleteBatch"})
    @ApiOperation(value="\u5220\u9664\u5206\u7ec4", notes="\u5220\u9664\u5206\u7ec4")
    public ApiResponse<Boolean> deleteGroupBatch(@RequestParam String groupId) {
        return this.sysAppMixGroupService.deleteGroupBatch(groupId);
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u8be6\u60c5", notes="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u8be6\u60c5")
    public ApiResponse<MixAppInfoVo> getAppDetail(@ApiParam(value="\u5e94\u7528Id") @RequestParam Long appId) {
        return ApiResponse.success((Object)this.sysApplicationMixService.getAppDetail(appId));
    }

    @PostMapping(value={"/compileFront"})
    public Boolean compileFront(@RequestParam(value="file") MultipartFile file, @RequestParam(value="appCode") String appCode, @RequestParam(value="serverCode") String serverCode, @RequestParam(value="compileId") Long compileId, @RequestParam(value="serviceName") String serviceName, @RequestParam(value="version") String version) throws IOException, InterruptedException {
        return this.appFileService.compileFront(file, appCode, serverCode, compileId, serviceName, version);
    }

    @GetMapping(value={"dropDownList"})
    public ApiResponse<List<SysApplication>> dropDownList(@RequestParam(value="type") String type) {
        return ApiResponse.success((Object)this.sysApplicationMixService.dropDownList(type));
    }

    @GetMapping(value={"getTenantPluginList"})
    public ApiResponse<List<SharePluginInfoDto>> getTenantPluginList(@RequestParam(value="tenantCode") String tenantCode) {
        SharePluginInfoDto queryDto = new SharePluginInfoDto();
        queryDto.setTenantCode(tenantCode);
        return ApiResponse.success((Object)this.sharePluginService.queryPluginInfoList(queryDto));
    }

    @GetMapping(value={"getTenantPluginInfo"})
    public ApiResponse<Page<TenantPluginInfoVO>> getTenantPluginInfo(PageInfo pageInfo, @RequestParam(value="tenantName", required=false) String tenantName) {
        return ApiResponse.success((Object)this.sysApplicationMixService.getTenantPluginInfo(pageInfo, tenantName));
    }
}

