/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamMemberCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppGroupCommonMapper;
import com.jxdinfo.hussar.application.dao.SysApplicationCommonMapper;
import com.jxdinfo.hussar.application.factory.HussarApplicationCallBackFactory;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysAppOperationLog;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.applicationmix.dao.SysAppDataSourceMapper;
import com.jxdinfo.hussar.applicationmix.dao.SysLowCodeAppExtendMapper;
import com.jxdinfo.hussar.applicationmix.dto.QueryAppDto;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.service.ISysApplicationMixService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppGroupVo;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.applicationmix.vo.TenantPluginInfoVO;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.expansion.db.share.service.PluginInfoService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.applicationmix.service.impl.sysApplicationMixServiceImpl")
public class SysApplicationMixServiceImpl
extends HussarServiceImpl<SysApplicationCommonMapper, SysApplication>
implements ISysApplicationMixService {
    private static final String APP_ID = "appId";
    private static final String APP_ENGLISH_NAME = "appEnglishName";
    private static final String SERVICE_NAME = "serviceName";
    @Resource
    private ISysAppDevelopTeamService developTeamService;
    @Resource
    private ISysAppOperationLogService sysAppOperationLogService;
    @Resource
    private SysLowCodeAppExtendMapper sysLowCodeAppExtendMapper;
    @Resource
    private SysAppDevelopTeamMemberCommonMapper teamMemberCommonMapper;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private SysAppGroupCommonMapper sysAppGroupCommonMapper;
    @Resource
    private SysAppDataSourceMapper sysAppDataSourceMapper;
    @Resource
    private PluginInfoService pluginInfoService;
    private static Long TENANT_SYSTEM_ADMIN_ROLE = 1450715195867925063L;
    private static Long SYSTEM_ADMIN_ROLE = 1450785135866925067L;
    private static Long TENANT_SECURITYADMIN_ROLE = 1450785935166925011L;
    private static Long SECURITYADMIN_ROLE = 1450785135866925068L;

    @HussarTransactional
    public Boolean deleteApp(Long appId) {
        SysApplication appInfo = (SysApplication)this.getById(appId);
        HussarApplicationCallBackFactory.beforeDeleteApp((SysApplication)appInfo);
        boolean flag = this.removeById(appId);
        this.sysAppOperationLogService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysAppOperationLog::getOperationType, (Object)"1")).eq(SysAppOperationLog::getAppId, (Object)appId));
        HussarApplicationCallBackFactory.deleteApp((SysApplication)appInfo);
        return flag;
    }

    public Boolean checkSameAppEnglishName(QueryAppDto appDto) {
        Long appId = appDto.getAppId();
        String appEnglishName = appDto.getAppEnglishName();
        String serviceName = appDto.getServiceName();
        if (HussarUtils.isEmpty((Object)appId)) {
            if (HussarUtils.isNotBlank((CharSequence)serviceName)) {
                HashMap<String, Object> queryParams = new HashMap<String, Object>();
                queryParams.put(APP_ID, null);
                queryParams.put(APP_ENGLISH_NAME, appEnglishName);
                queryParams.put(SERVICE_NAME, serviceName);
                Long count = this.sysLowCodeAppExtendMapper.getCountWithServiceName(queryParams);
                return count <= 0L;
            }
            Long count = this.sysLowCodeAppExtendMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppEnglishName, (Object)appEnglishName));
            return count <= 0L;
        }
        if (HussarUtils.isNotBlank((CharSequence)serviceName)) {
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put(APP_ID, appId);
            queryParams.put(APP_ENGLISH_NAME, appEnglishName);
            queryParams.put(SERVICE_NAME, serviceName);
            Long count = this.sysLowCodeAppExtendMapper.getCountWithServiceName(queryParams);
            return count <= 0L;
        }
        Long count = this.sysLowCodeAppExtendMapper.selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysLowCodeAppExtend::getAppId, (Object)appId)).eq(SysLowCodeAppExtend::getAppEnglishName, (Object)appEnglishName));
        return count <= 0L;
    }

    public Page<MixAppInfoVo> appPageList(PageInfo pageInfo, QueryAppDto appDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("appName", SqlQueryUtil.transferSpecialChar((String)appDto.getAppName()));
        queryParams.put("groupName", SqlQueryUtil.transferSpecialChar((String)appDto.getGroupName()));
        queryParams.put(SERVICE_NAME, SqlQueryUtil.transferSpecialChar((String)appDto.getServiceName()));
        queryParams.put("memberName", SqlQueryUtil.transferSpecialChar((String)appDto.getMemberName()));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<MixAppInfoVo> appInfoList = this.sysLowCodeAppExtendMapper.appList((Page<MixAppInfoVo>)page, queryParams);
        if (ToolUtil.isNotEmpty(appInfoList)) {
            SecurityUser loginUser = BaseSecurityUtil.getUser();
            List teamIds = appInfoList.stream().map(MixAppInfoVo::getTeamId).distinct().collect(Collectors.toList());
            List members = this.teamMemberCommonMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysAppDevelopTeamMember::getTeamId, teamIds));
            List userIds = members.stream().map(SysAppDevelopTeamMember::getUserId).distinct().collect(Collectors.toList());
            Map teamUserIdMap = members.stream().collect(Collectors.groupingBy(SysAppDevelopTeamMember::getTeamId, Collectors.mapping(SysAppDevelopTeamMember::getUserId, Collectors.toList())));
            Map userInfoMap = this.hussarBaseUserBoService.getUserInfo(userIds);
            for (MixAppInfoVo appInfoVo : appInfoList) {
                List userIdList;
                Long teamId = appInfoVo.getTeamId();
                if (HussarUtils.isNotEmpty((Object)teamId) && HussarUtils.isNotEmpty(userIdList = teamUserIdMap.get(teamId))) {
                    StringBuilder userMemName = new StringBuilder();
                    for (int j = 0; j < userIdList.size(); ++j) {
                        Long userId = (Long)userIdList.get(j);
                        if (userId == -1L) continue;
                        if (j != userIdList.size() - 1) {
                            userMemName.append(((SysUsers)userInfoMap.get(userId)).getUserName()).append(",");
                            continue;
                        }
                        userMemName.append(((SysUsers)userInfoMap.get(userId)).getUserName());
                    }
                    appInfoVo.setTeamMemberName(userMemName.toString());
                }
                if (!HussarUtils.isNotEmpty((Object)loginUser)) continue;
                appInfoVo.setTenantId(loginUser.getTenantId());
                appInfoVo.setTenantName(loginUser.getTenantName());
                appInfoVo.setTenantCode(loginUser.getTenantCode());
            }
        }
        page.setRecords(appInfoList);
        return page;
    }

    public List<MixAppGroupVo> appList(QueryAppDto appDto) {
        List sysAppGroups;
        List<MixAppInfoVo> appList;
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("appName", SqlQueryUtil.transferSpecialChar((String)appDto.getAppName()));
        queryParams.put("appGroupId", appDto.getAppGroupId());
        queryParams.put(SERVICE_NAME, SqlQueryUtil.transferSpecialChar((String)appDto.getServiceName()));
        queryParams.put("appTypes", appDto.getAppTypes());
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        if (!"2".equals(appDto.getAppStatus())) {
            queryParams.put("appStatus", appDto.getAppStatus());
        } else {
            queryParams.put("appStatus", null);
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.isSuperAdmin() || user.getRolesList().contains(TenantConstant.ADMIN_ROLE) || user.getRolesList().contains(TENANT_SYSTEM_ADMIN_ROLE) || user.getRolesList().contains(SYSTEM_ADMIN_ROLE) || user.getRolesList().contains(TENANT_SECURITYADMIN_ROLE) || user.getRolesList().contains(SECURITYADMIN_ROLE)) {
            queryParams.put("appIds", null);
            appList = this.sysLowCodeAppExtendMapper.getAppList(queryParams);
            sysAppGroups = this.sysAppGroupCommonMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().orderByAsc(SysAppGroup::getSEQ)).orderByAsc(HussarBaseEntity::getCreateTime));
        } else {
            List appIds = this.developTeamService.selectAppListByCurrentUser();
            if (HussarUtils.isEmpty((Object)appIds)) {
                return Collections.emptyList();
            }
            queryParams.put("appIds", appIds);
            appList = this.sysLowCodeAppExtendMapper.getAppList(queryParams);
            if (HussarUtils.isEmpty(appList)) {
                return Collections.emptyList();
            }
            Set groupIds = appList.stream().map(SysApplication::getAppGroupId).collect(Collectors.toSet());
            sysAppGroups = this.sysAppGroupCommonMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysAppGroup::getId, groupIds)).orderByAsc(SysAppGroup::getSEQ)).orderByAsc(HussarBaseEntity::getCreateTime));
        }
        return this.combinedDataNew(appList, sysAppGroups);
    }

    public MixAppInfoVo getAppDetail(Long appId) {
        MixAppInfoVo appInfo = this.sysLowCodeAppExtendMapper.getMixAppInfo(appId);
        List<Long> dbIds = this.sysAppDataSourceMapper.getDatasourceIdsByAppId(appId);
        dbIds = dbIds.stream().distinct().collect(Collectors.toList());
        appInfo.setDbIds(dbIds);
        return appInfo;
    }

    public List<SysApplication> dropDownList(String type) {
        return this.list((Wrapper)Wrappers.lambdaQuery().eq(HussarUtils.isNotEmpty((Object)type), SysApplication::getAppType, (Object)type));
    }

    private List<MixAppGroupVo> combinedDataNew(List<MixAppInfoVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), MixAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, appGroupVo -> appGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        if (HussarUtils.isEmpty(appList)) {
            return new ArrayList<MixAppGroupVo>(resultCollect.values());
        }
        for (MixAppInfoVo mixAppInfoVo : appList) {
            MixAppGroupVo mixAppGroupVo = (MixAppGroupVo)resultCollect.get(mixAppInfoVo.getAppGroupId());
            if (HussarUtils.isEmpty((Object)mixAppGroupVo)) continue;
            if (HussarUtils.isNotEmpty((Object)mixAppGroupVo.getAppInfoVoList())) {
                mixAppGroupVo.getAppInfoVoList().add(mixAppInfoVo);
            }
            if (!HussarUtils.isEmpty((Object)mixAppGroupVo.getAppInfoVoList())) continue;
            ArrayList<MixAppInfoVo> appInfoVoList = new ArrayList<MixAppInfoVo>();
            appInfoVoList.add(mixAppInfoVo);
            mixAppGroupVo.setAppInfoVoList(appInfoVoList);
        }
        return new ArrayList<MixAppGroupVo>(resultCollect.values());
    }

    public Page<TenantPluginInfoVO> getTenantPluginInfo(PageInfo pageInfo, String tenantName) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)tenantName)) {
            queryParams.put("tenantName", tenantName);
        }
        List<TenantPluginInfoVO> voList = this.sysLowCodeAppExtendMapper.getTenantPluginInfo((Page<TenantPluginInfoVO>)page, queryParams);
        page.setRecords(voList);
        return page;
    }
}

