/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamMemberCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppRecycleCommonMapper;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.application.util.NacosUtil;
import com.jxdinfo.hussar.applicationmix.dao.SysLowCodeAppExtendMapper;
import com.jxdinfo.hussar.applicationmix.model.SysAppDataSource;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.service.ISysAppDataSourceService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.applicationmix.service.impl.HussarLowCodeStandardAppCallBackServiceImpl")
public class HussarLowCodeStandardAppCallBackServiceImpl
implements IHussarAppCallBackService {
    private static final Logger logger = LoggerFactory.getLogger(HussarLowCodeStandardAppCallBackServiceImpl.class);
    private static final String APP_TYPE = "21";
    private static final String APP_SUFFIX = "_extension";
    @Resource
    private SysLowCodeAppExtendMapper sysLowCodeAppExtendMapper;
    @Resource
    private ISysAppDataSourceService sysAppDataSourceService;
    @Resource
    private SysAppRecycleCommonMapper sysAppRecycleCommonMapper;
    @Resource
    private SysAppDevelopTeamCommonMapper developTeamMapper;
    @Resource
    private SysAppDevelopTeamMemberCommonMapper developTeamMemberMapper;
    @Resource
    private GodAxeModelService godAxeModelService;

    public String getAppType() {
        return APP_TYPE;
    }

    public void deleteApp(SysApplication app) {
        Long appId = app.getId();
        this.sysAppRecycleCommonMapper.deleteById((Serializable)appId);
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        this.developTeamMapper.deleteById((Serializable)sysAppDevelopTeam.getId());
        this.developTeamMemberMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        this.sysLowCodeAppExtendMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppId, (Object)appId));
        this.sysAppDataSourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDataSource::getAppId, (Object)appId));
        HussarCacheUtil.evict((String)"app_info", (Object)app.getId());
    }

    public void beforeDeleteApp(SysApplication app) {
        MixAppInfoVo mixAppInfo = this.sysLowCodeAppExtendMapper.getMixAppInfo(app.getId());
        if (HussarUtils.isNotEmpty((Object)mixAppInfo)) {
            Long count = this.sysLowCodeAppExtendMapper.selectCount((Wrapper)Wrappers.lambdaQuery().eq(SysLowCodeAppExtend::getAppEnglishName, (Object)(mixAppInfo.getAppEnglishName() + APP_SUFFIX)));
            if (count > 0L) {
                throw new HussarException("\u8be5\u5e94\u7528\u5b58\u5728\u6269\u5c55\u5e94\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            }
            try {
                this.godAxeModelService.deleteModelByAppCode(mixAppInfo.getAppEnglishName());
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    public void addApp(SysApplication app) {
        Long count;
        Map extendParams = app.getExtendParams();
        String isInit = (String)extendParams.get("isInit");
        String appEnglishName = (String)extendParams.get("appEnglishName");
        List dbIds = (List)extendParams.get("dbIds");
        if (NacosUtil.isMicroService()) {
            String serviceName = app.getServiceName();
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("appId", null);
            queryParams.put("appEnglishName", appEnglishName);
            queryParams.put("serviceName", serviceName);
            count = this.sysLowCodeAppExtendMapper.getCountWithServiceName(queryParams);
        } else {
            count = this.sysLowCodeAppExtendMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppEnglishName, (Object)appEnglishName));
        }
        if (count > 0L) {
            throw new BaseException("\u5e94\u7528\u82f1\u6587\u540d\u91cd\u590d");
        }
        SysLowCodeAppExtend appExtend = new SysLowCodeAppExtend();
        appExtend.setAppId(app.getId());
        appExtend.setIsInit(isInit);
        appExtend.setAppEnglishName(appEnglishName);
        this.sysLowCodeAppExtendMapper.insert(appExtend);
        if (HussarUtils.isNotEmpty((Object)dbIds)) {
            ArrayList<SysAppDataSource> list = new ArrayList<SysAppDataSource>();
            for (Object dbId : dbIds) {
                SysAppDataSource source = new SysAppDataSource();
                source.setAppId(app.getId());
                source.setDbId(Long.valueOf(Long.parseLong(String.valueOf(dbId))));
                list.add(source);
            }
            this.sysAppDataSourceService.saveBatch(list);
        }
    }

    public void updateApp(SysApplication app) {
        Map extendParams = app.getExtendParams();
        List dbIds = (List)extendParams.get("dbIds");
        this.sysAppDataSourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDataSource::getAppId, (Object)app.getId()));
        if (HussarUtils.isNotEmpty((Object)dbIds)) {
            ArrayList<SysAppDataSource> list = new ArrayList<SysAppDataSource>();
            for (Object dbId : dbIds) {
                SysAppDataSource source = new SysAppDataSource();
                source.setAppId(app.getId());
                source.setDbId(Long.valueOf(Long.parseLong(String.valueOf(dbId))));
                list.add(source);
            }
            this.sysAppDataSourceService.saveBatch(list);
        }
        HussarCacheUtil.evict((String)"app_info", (Object)app.getId());
    }

    public void deleteRecycleApp(SysAppRecycle appRecycle) {
    }

    public void beforeDeleteRecycleApp(SysAppRecycle appRecycle) {
    }

    public void revertRecycleApp(SysAppRecycle appRecycle) {
    }
}

