/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.applicationmix.dao.HussarBaseAppMixFileMapper;
import com.jxdinfo.hussar.applicationmix.dao.SysEyImportAppMixMsgMapper;
import com.jxdinfo.hussar.applicationmix.model.AppMixImportStatusEnum;
import com.jxdinfo.hussar.applicationmix.model.SysEyImportAppMsg;
import com.jxdinfo.hussar.applicationmix.service.ISysEyImportAppMixMsgService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class SysEyImportAppMixMsgServiceImpl
extends HussarServiceImpl<SysEyImportAppMixMsgMapper, SysEyImportAppMsg>
implements ISysEyImportAppMixMsgService {
    @Resource
    private HussarBaseAppMixFileMapper appFileMapper;
    @Value(value="${cluster.clusterType:0}")
    private String clusterType;

    public AppMixImportStatusEnum checkInportStatus() {
        return null;
    }

    public SysEyImportAppMsg getEyImportAppMsg() {
        QueryWrapper queryWrapper0 = new QueryWrapper();
        ((QueryWrapper)queryWrapper0.eq((Object)"IMPORT_STATUS", (Object)"0")).orderByAsc((Object)"IMPORT_START_TIME");
        List list0 = this.list((Wrapper)queryWrapper0);
        return (SysEyImportAppMsg)list0.get(0);
    }

    public boolean setImportStatusOne(Long compileId) {
        InetAddress localHost = this.getLocalhost();
        if (ToolUtil.isEmpty((Object)localHost)) {
            return false;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"IMPORT_STATUS", (Object)"1");
        updateWrapper.set((Object)"IP_ADDRESS", (Object)localHost.getHostAddress());
        updateWrapper.eq((Object)"ID", (Object)compileId);
        this.update((Wrapper)updateWrapper);
        return true;
    }

    private InetAddress getLocalhost() {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return localHost;
        }
        return localHost;
    }

    public void setImportStatusFive(Long compileId) {
        this.setImportStatus(compileId, "5");
    }

    public boolean isImportStatusExpect45Only0() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"IMPORT_STATUS", (Object)"1")).or()).eq((Object)"IMPORT_STATUS", (Object)"2")).or()).eq((Object)"IMPORT_STATUS", (Object)"3");
        List list = this.list((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            return false;
        }
        QueryWrapper queryWrapper0 = new QueryWrapper();
        queryWrapper0.eq((Object)"IMPORT_STATUS", (Object)"0");
        List list0 = this.list((Wrapper)queryWrapper0);
        return !list0.isEmpty();
    }

    @HussarTransactional
    public void setImportStatusTwo(Long compileId) {
        this.setImportStatus(compileId, "2");
    }

    @HussarTransactional
    public void setImportStatusThree(Long compileId) {
        this.setImportStatus(compileId, "3");
    }

    private void setImportStatus(Long compileId, String num) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"IMPORT_STATUS", (Object)num);
        updateWrapper.eq((Object)"ID", (Object)compileId);
        try {
            this.update((Wrapper)updateWrapper);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @HussarTransactional
    public void setImportStatusFour(Long compileId) {
        if ("0".equals(this.clusterType)) {
            this.setImportStatus(compileId, "4");
        } else {
            SysEyImportAppMsg one = this.loadFlagAddOne(compileId);
            if (this.isLoadFlagAll(one)) {
                one.setImportStatus("4");
            }
            this.updateById((BaseEntity)one);
        }
    }

    public void checkAppImportMsg() {
        InetAddress localhost = this.getLocalhost();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"IMPORT_STATUS", (Object)"1")).or()).eq((Object)"IMPORT_STATUS", (Object)"2")).or()).eq((Object)"IMPORT_STATUS", (Object)"3");
        List list = this.list((Wrapper)queryWrapper);
        String hostAddress = localhost.getHostAddress();
        ArrayList<SysEyImportAppMsg> failList = new ArrayList<SysEyImportAppMsg>();
        for (SysEyImportAppMsg sysEyImportAppMsg : list) {
            String ipAddress = sysEyImportAppMsg.getIpAddress();
            if (!hostAddress.equals(ipAddress)) continue;
            sysEyImportAppMsg.setImportStatus("5");
            failList.add(sysEyImportAppMsg);
        }
        if (!failList.isEmpty()) {
            this.updateBatchById(failList);
        }
    }

    @HussarTransactional
    public void setFailReason(Long id, String message) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"IMPORT_FAIL_REASON", (Object)message);
        updateWrapper.set((Object)"IMPORT_STATUS", (Object)"5");
        updateWrapper.eq((Object)"ID", (Object)id);
        this.update((Wrapper)updateWrapper);
    }

    public Object getSyncingImportStatus(Long compileId) {
        SysEyImportAppMsg sysEyImportAppMsg = (SysEyImportAppMsg)this.getById(compileId);
        if (ToolUtil.isNotEmpty((Object)sysEyImportAppMsg)) {
            return JSONObject.toJSON((Object)sysEyImportAppMsg);
        }
        return null;
    }

    private boolean isLoadFlagAll(SysEyImportAppMsg one) {
        List<String> arrayList = this.appFileMapper.getAllClusterAddress();
        int newLoadFlag = Integer.parseInt(one.getLoadFlag());
        return newLoadFlag >= arrayList.size();
    }

    private SysEyImportAppMsg loadFlagAddOne(Long compileId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ID", (Object)compileId);
        SysEyImportAppMsg one = (SysEyImportAppMsg)this.getOne((Wrapper)queryWrapper);
        String LoadFlag = one.getLoadFlag();
        int LoadFlagInt = Integer.parseInt(LoadFlag);
        int newLoadFlag = LoadFlagInt + 1;
        one.setLoadFlag(newLoadFlag + "");
        return one;
    }
}

