/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.applicationmix.dao.SysAppDataSourceMapper;
import com.jxdinfo.hussar.applicationmix.model.SysAppDataSource;
import com.jxdinfo.hussar.applicationmix.service.ISysAppDataSourceBoService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppDataSourceService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysAppDataSourceBoServiceImpl
implements ISysAppDataSourceBoService {
    @Autowired
    private ISysAppDataSourceService appDataSourceService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Autowired
    private DatasourceService datasourceService;
    @Resource
    private SysAppDataSourceMapper sysAppDataSourceMapper;

    public List<SysDataSource> getDatasourceByAppId(Long id) {
        SecurityUser user;
        ArrayList result = Lists.newArrayList();
        boolean tenantOpen = this.hussarTenantProperties.isEnabled() && this.tenantCommonService != null;
        String connName = "master";
        if (tenantOpen && HussarUtils.isNotEmpty((Object)(user = BaseSecurityUtil.getUser())) && HussarUtils.isNotEmpty((Object)user.getTenantCode())) {
            connName = user.getConnName();
        }
        SysDataSourceDto mainDataSource = this.datasourceService.getDataSourceByConnName(connName);
        result.add(mainDataSource);
        List appDataSources = this.appDataSourceService.list(connName, (Wrapper)new LambdaQueryWrapper().eq(SysAppDataSource::getAppId, (Object)id));
        if (HussarUtils.isNotEmpty((Object)appDataSources)) {
            List dbId = appDataSources.stream().map(SysAppDataSource::getDbId).collect(Collectors.toList());
            result.addAll(this.datasourceService.listByIds(dbId));
        }
        return result;
    }
}

