/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.springframework.util.DigestUtils;
import org.springframework.util.ResourceUtils;

public class ZipUtil {
    private static int BUFFERSIZE = 1024;

    public static void zip(String sourceFileName, String zipFileName) throws Exception {
        System.out.println("\u5f00\u59cb\u538b\u7f29...");
        ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(Paths.get(zipFileName, new String[0]), new OpenOption[0]));
        File sourceFile = new File(sourceFileName);
        ZipUtil.compress(out, sourceFile, "");
        out.close();
        System.out.println("\u538b\u7f29\u5b8c\u6210\uff01");
    }

    public static void compress(ZipOutputStream out, File sourceFile, String base) throws Exception {
        if (sourceFile.isDirectory()) {
            File[] flist = sourceFile.listFiles();
            if (flist != null) {
                if (flist.length == 0) {
                    System.out.println(base + "/");
                    out.putNextEntry(new ZipEntry(base + "/"));
                } else {
                    for (File file : flist) {
                        ZipUtil.compress(out, file, base + "/" + file.getName());
                    }
                }
            }
        } else {
            out.putNextEntry(new ZipEntry(base));
            FileInputStream fos = new FileInputStream(sourceFile);
            try (BufferedInputStream bis = new BufferedInputStream(fos);){
                int len;
                byte[] buf = new byte[1024];
                System.out.println(base);
                while ((len = bis.read(buf, 0, 1024)) != -1) {
                    out.write(buf, 0, len);
                }
            }
            fos.close();
        }
    }

    public static String getMd5(String path) {
        String md5 = null;
        try (FileInputStream inputStream = new FileInputStream(ResourceUtils.getFile((String)path));){
            md5 = DigestUtils.md5DigestAsHex((InputStream)inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> unzip(String fileName, String path) throws IOException {
        FileOutputStream fos = null;
        InputStream is = null;
        ZipFile zf = null;
        ArrayList<String> filePaths = new ArrayList<String>();
        try {
            zf = new ZipFile(new File(fileName));
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                int len;
                ZipEntry zn = en.nextElement();
                if (zn.isDirectory()) continue;
                is = zf.getInputStream(zn);
                File f = new File(path + zn.getName());
                File file = f.getParentFile();
                file.mkdirs();
                fos = new FileOutputStream(path + zn.getName());
                byte[] bufer = new byte[BUFFERSIZE];
                while (-1 != (len = is.read(bufer))) {
                    fos.write(bufer, 0, len);
                }
                filePaths.add(path + zn.getName());
            }
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
                if (null != fos) {
                    fos.close();
                }
                if (null != zf) {
                    zf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return filePaths;
    }
}

