/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.applicationmix.constants.AppExportConstants;
import com.jxdinfo.hussar.applicationmix.model.SysAppPackage;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.properties.HussarAppExportProperties;
import com.jxdinfo.hussar.applicationmix.properties.HussarProduceProperties;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixFileMircoService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixInfoService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixPackageService;
import com.jxdinfo.hussar.applicationmix.service.ISysEyImportAppMixMsgService;
import com.jxdinfo.hussar.applicationmix.service.ISysImportAppMixHistoryService;
import com.jxdinfo.hussar.applicationmix.util.TarUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.constant.ExportResourceConstant;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.file.ZipUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service
public class SysAppMixFileMircoServerImpl
implements ISysAppMixFileMircoService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppMixFileMircoServerImpl.class);
    private static final String MODULES = "modules";
    private static final String VIEWS = "views";
    private static final String API = "api";
    @Autowired
    private FormDesignProperties formdesignProperties;
    @Autowired
    private HussarProduceProperties hussarProduceProperties;
    @Resource
    private HussarAppExportProperties hussarAppExportProperties;
    @Autowired
    private ISysAppMixInfoService sysAppInfoService;
    @Autowired
    private ISysAppMixPackageService appPackageService;
    @Autowired
    private ISysEyImportAppMixMsgService ISysEyImportAppMixMsgService;
    @Autowired
    private ISysImportAppMixHistoryService ISysImportAppMixHistoryService;
    @Value(value="${plugin.pluginPrefix:0}")
    private String pluginPrefix;
    @Value(value="${hussar-formdesign.open-plugin:false}")
    private boolean openPlugin;
    @Value(value="${plugin.modulePath:0}")
    private String modulePath;
    @Value(value="${plugin.prefixName:hussar-plugin}")
    private String prefixName;
    @Value(value="${cluster.clusterType:0}")
    private String clusterType;
    @Value(value="${plugin.pluginParentName:hussar-plugin-parent}")
    private String pluginParentName;
    @Value(value="${plugin.pluginPath:E:/hussar-plugin/}")
    private String pluginPath;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${hussar-formdesign.page-build-address:localhost:8989}")
    private String pageBuildIp;
    @Value(value="${hussar-formdesign.nginx-package-path:G:/nginx-1.26.2/nginx-1.26.2/html/static/js}")
    private String nginxPackagePath;
    private static final Pattern p = Pattern.compile("[a-zA-z]");
    public static final String PRINT_PREFIX = "==============================";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean compileFront(MultipartFile file, Long appId, String serverCode, Long compileId, String serviceName) throws IOException, InterruptedException {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.sysAppInfoService.getOne((Wrapper)wrapper);
        InputStream inputStream = file.getInputStream();
        File temp = Files.createTempDirectory("appImportFront" + appId, new FileAttribute[0]).toFile();
        try {
            File tempFile = new File(temp.getAbsolutePath() + File.separator + appId + ".zip");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            ZipUtil.unzip((String)tempFile.getAbsolutePath(), (String)(temp.getAbsolutePath() + File.separator));
            File tar = new File(temp + File.separator + appInfo.getAppEnglishName() + ".tar");
            TarUtil.unTar(tar, temp.getAbsolutePath() + File.separator);
            this.backUpAppFiles(appInfo.getAppEnglishName(), serverCode, serviceName);
            this.importCode(temp, false);
            Map<String, String> pathMap = this.getAppFilePath(appInfo.getAppEnglishName(), serverCode, serviceName);
            String vuePathss = pathMap.get("vuePath");
            String[] vueFiles = this.getVueFiles(vuePathss);
            Boolean bl = this.sendPostRequest(vueFiles);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.updateCompileStatus(compileId, "2", this.getErrorInfoFromException(e));
            this.rollbackOrDeleteAppFile(appInfo.getAppEnglishName(), serverCode, serviceName, true);
            this.ISysEyImportAppMixMsgService.setFailReason(compileId, e.getMessage());
            Boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.forceDelete((File)temp);
        }
    }

    private String[] getVueFiles(String directoryPath) throws IOException {
        List<String> vuePathList;
        Path dirPath = Paths.get(directoryPath, new String[0]);
        try (Stream<Path> stream = Files.walk(dirPath, new FileVisitOption[0]);){
            vuePathList = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".vue")).map(path -> {
                String vuePath = path.toString();
                int srcIndex = vuePath.indexOf("src");
                if (srcIndex != -1) {
                    vuePath = vuePath.substring(srcIndex);
                }
                return "./" + vuePath.replace(File.separator, "/");
            }).collect(Collectors.toList());
        }
        return vuePathList.toArray(new String[0]);
    }

    private Boolean sendPostRequest(String[] vuePaths) throws Exception {
        URL url = new URL("http://" + this.pageBuildIp + "/singlePageBuild");
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"appFileList", (Object)this.arrayToJson(vuePaths));
        request.set((Object)"outputPath", (Object)this.nginxPackagePath);
        String result = (String)this.restTemplate.postForObject(url.toURI(), (Object)request, String.class);
        logger.info("\u524d\u53f0\u8fd4\u56de\u7f16\u8bd1\u7ed3\u679c\uff1a{}" + result);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url.toURI(), (Object)request, String.class);
        logger.info("responseEntity.getBody() = {}", responseEntity.getBody());
        return JSON.parseObject((String)((String)responseEntity.getBody())).getBoolean("succeed");
    }

    private String arrayToJson(String[] array) {
        if (array == null || array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < array.length; ++i) {
            sb.append("\"");
            sb.append(array[i]);
            sb.append("\"");
            if (i >= array.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private void backUpAppFiles(String appName, String serverCode, String serviceName) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appName, serverCode, serviceName);
        String vuePath = pathMap.get("vuePath");
        String apiPath = pathMap.get("apiPath");
        File vue = new File(vuePath);
        File api = new File(apiPath);
        String vueBackUpPath = pathMap.get("vueBackUpPath");
        String apiBackUpPath = pathMap.get("apiBackUpPath");
        if (vue.exists()) {
            FileUtils.copyDirectory((File)vue, (File)new File(vueBackUpPath));
        }
        if (api.exists()) {
            FileUtils.copyDirectory((File)api, (File)new File(apiBackUpPath));
        }
    }

    private Map<String, String> getAppFilePath(String appName, String serverCode, String serviceName) {
        String tenantDir = AppContextUtil.asIdentifier((String)serverCode);
        String enName = AppContextUtil.asIdentifier((String)appName);
        serviceName = AppContextUtil.asIdentifier((String)serviceName);
        String appPath = tenantDir + File.separator + serviceName + File.separator + enName;
        String vuePath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getFrontPath(), this.hussarAppExportProperties.getVueCodePath(), MODULES, appPath, VIEWS});
        String apiPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getFrontPath(), this.hussarAppExportProperties.getFrontApiPath(), MODULES, appPath, API});
        String tenantAndSer = tenantDir + "-" + serviceName;
        String tenantAndApp = tenantDir + "-" + serviceName + "-" + enName;
        String pluginPath = FileUtil.posixPath((String[])new String[]{this.pluginPath, this.pluginPrefix + tenantDir, this.pluginPrefix + tenantAndSer, this.pluginPrefix + tenantAndApp});
        String frontBackUpPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getWebPath(), "frontBackUp", tenantDir, serviceName, enName});
        String vueBackUpPath = FileUtil.posixPath((String[])new String[]{frontBackUpPath, this.hussarAppExportProperties.getVueCodePath(), MODULES, appPath, VIEWS});
        String apiBackUpPath = FileUtil.posixPath((String[])new String[]{frontBackUpPath, this.hussarAppExportProperties.getFrontApiPath(), MODULES, appPath, API});
        String pluginParentPath = new File(this.pluginPath).getParent();
        String pluginBackUpPath = FileUtil.posixPath((String[])new String[]{pluginParentPath, "hussar-plugin-back", this.pluginPrefix + tenantDir, this.pluginPrefix + tenantAndSer, this.pluginPrefix + tenantAndApp});
        HashMap<String, String> pathMap = new HashMap<String, String>();
        pathMap.put("vuePath", vuePath);
        pathMap.put("apiPath", apiPath);
        pathMap.put("frontBackUpPath", frontBackUpPath);
        pathMap.put("vueBackUpPath", vueBackUpPath);
        pathMap.put("apiBackUpPath", apiBackUpPath);
        pathMap.put("pluginPath", pluginPath);
        pathMap.put("pluginBackUpPath", pluginBackUpPath);
        return pathMap;
    }

    private void importCode(File temp, boolean offline) throws IOException {
        String cssPath;
        String vuePath;
        String apiPath;
        File vue = new File(temp, ExportResourceConstant.VUE);
        File api = new File(temp, ExportResourceConstant.API);
        File css = new File(temp, AppExportConstants.CSS);
        File prefixCommon = new File(temp, MODULES);
        if (offline) {
            apiPath = FileUtil.posixPath((String[])new String[]{this.formdesignProperties.getFrontProjectPath(), this.formdesignProperties.getFrontApiPath()});
            vuePath = FileUtil.posixPath((String[])new String[]{this.formdesignProperties.getFrontProjectPath(), this.formdesignProperties.getVueCodePath()});
            cssPath = FileUtil.posixPath((String[])new String[]{this.formdesignProperties.getFrontProjectPath(), this.formdesignProperties.getCssCodePath()});
        } else {
            vuePath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getFrontPath(), this.formdesignProperties.getVueCodePath(), MODULES});
            apiPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getFrontPath(), this.formdesignProperties.getFrontApiPath(), MODULES});
            cssPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getFrontPath(), this.formdesignProperties.getCssCodePath()});
        }
        if (vue.exists()) {
            FileUtils.copyDirectory((File)vue, (File)new File(vuePath));
        }
        if (api.exists()) {
            FileUtils.copyDirectory((File)api, (File)new File(apiPath));
        }
        if (css.exists()) {
            FileUtils.copyDirectory((File)css, (File)new File(cssPath));
        }
        if (prefixCommon.exists()) {
            FileUtils.copyDirectory((File)prefixCommon, (File)new File(vuePath));
        }
    }

    private void updateCompileStatus(Long compileId, String status, String msg) {
        SysAppPackage sysAppPackage = (SysAppPackage)this.appPackageService.getById((Serializable)compileId);
        if (ToolUtil.isNotEmpty((Object)sysAppPackage) && !"2".equals(sysAppPackage.getStatus())) {
            sysAppPackage.setStatus(status);
            if (ToolUtil.isNotEmpty((Object)msg)) {
                sysAppPackage.setErrorMsg(msg);
            }
            this.appPackageService.updateById((Object)sysAppPackage);
        }
    }

    private void rollbackOrDeleteAppFile(String appName, String serverCode, String serviceName, boolean isRollback) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appName, serverCode, serviceName);
        String vuePath = pathMap.get("vuePath");
        String apiPath = pathMap.get("apiPath");
        String vueBackUpPath = pathMap.get("vueBackUpPath");
        String apiBackUpPath = pathMap.get("apiBackUpPath");
        File vueFile = new File(vuePath);
        File apiFile = new File(apiPath);
        File vueBackFile = new File(vueBackUpPath);
        File apiBackFile = new File(apiBackUpPath);
        if (isRollback) {
            if (vueFile.exists()) {
                FileUtils.forceDelete((File)vueFile);
            }
            if (apiFile.exists()) {
                FileUtils.forceDelete((File)apiFile);
            }
            if (vueBackFile.exists()) {
                FileUtils.copyDirectory((File)vueBackFile, (File)new File(vuePath));
            }
            if (apiBackFile.exists()) {
                FileUtils.copyDirectory((File)apiBackFile, (File)new File(apiPath));
            }
        }
    }

    private String getErrorInfoFromException(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "\r\n" + sw + "\r\n";
        }
        catch (Exception e2) {
            return "bad getErrorInfoFromException";
        }
    }
}

