/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamMemberCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppRecycleCommonMapper;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.application.util.NacosUtil;
import com.jxdinfo.hussar.applicationmix.dao.SysLowCodeAppExtendMapper;
import com.jxdinfo.hussar.applicationmix.dto.CodeGenerator;
import com.jxdinfo.hussar.applicationmix.model.SysAppDataSource;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.service.ISysAppDataSourceService;
import com.jxdinfo.hussar.applicationmix.service.impl.CommonMixAppService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.expansion.core.service.dto.SharePluginInfoDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.applicationmix.service.impl.hussarLowCodeAppCallBackServiceImpl")
public class HussarLowCodeAppCallBackServiceImpl
extends CommonMixAppService
implements IHussarAppCallBackService {
    private static final Logger logger = LoggerFactory.getLogger(HussarLowCodeAppCallBackServiceImpl.class);
    private static final String APP_TYPE = "2";
    @Resource
    private SysLowCodeAppExtendMapper sysLowCodeAppExtendMapper;
    @Resource
    private ISysAppDataSourceService sysAppDataSourceService;
    @Resource
    private SysAppRecycleCommonMapper sysAppRecycleCommonMapper;
    @Resource
    private SysAppDevelopTeamCommonMapper developTeamMapper;
    @Resource
    private SysAppDevelopTeamMemberCommonMapper developTeamMemberMapper;
    @Resource
    private GodAxeModelService godAxeModelService;

    public String getAppType() {
        return APP_TYPE;
    }

    public void deleteApp(SysApplication app) {
        Long appId = app.getId();
        this.sysAppRecycleCommonMapper.deleteById((Serializable)appId);
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        this.developTeamMapper.deleteById((Serializable)sysAppDevelopTeam.getId());
        this.developTeamMemberMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        this.sysLowCodeAppExtendMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppId, (Object)appId));
        this.sysAppDataSourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDataSource::getAppId, (Object)appId));
        HussarCacheUtil.evict((String)"app_info", (Object)app.getId());
    }

    public void beforeDeleteApp(SysApplication app) {
        try {
            MixAppInfoVo mixAppInfo = this.sysLowCodeAppExtendMapper.getMixAppInfo(app.getId());
            if (HussarUtils.isNotEmpty((Object)mixAppInfo)) {
                this.godAxeModelService.deleteModelByAppCode(mixAppInfo.getAppEnglishName());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public void addApp(SysApplication app) {
        Long count;
        Map extendParams = app.getExtendParams();
        String isInit = (String)extendParams.get("isInit");
        String appEnglishName = (String)extendParams.get("appEnglishName");
        List dbIds = (List)extendParams.get("dbIds");
        if (NacosUtil.isMicroService()) {
            String serviceName = app.getServiceName();
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("appId", null);
            queryParams.put("appEnglishName", appEnglishName);
            queryParams.put("serviceName", serviceName);
            count = this.sysLowCodeAppExtendMapper.getCountWithServiceName(queryParams);
        } else {
            count = this.sysLowCodeAppExtendMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppEnglishName, (Object)appEnglishName));
        }
        if (count > 0L) {
            throw new BaseException("\u5e94\u7528\u82f1\u6587\u540d\u91cd\u590d");
        }
        SysLowCodeAppExtend appExtend = new SysLowCodeAppExtend();
        appExtend.setAppId(app.getId());
        appExtend.setIsInit(isInit);
        appExtend.setAppEnglishName(appEnglishName);
        this.sysLowCodeAppExtendMapper.insert(appExtend);
        if (HussarUtils.isNotEmpty((Object)dbIds)) {
            ArrayList<SysAppDataSource> list = new ArrayList<SysAppDataSource>();
            for (Object dbId : dbIds) {
                SysAppDataSource source = new SysAppDataSource();
                source.setAppId(app.getId());
                source.setDbId(Long.valueOf(Long.parseLong(String.valueOf(dbId))));
                list.add(source);
            }
            this.sysAppDataSourceService.saveBatch(list);
        }
        String active = this.hussarBasePluginProperties.getRunMode();
        String environment = APP_TYPE;
        if ("dev".equals(active)) {
            environment = APP_TYPE;
        } else if ("prod".equals(active)) {
            environment = "3";
        }
        if (APP_TYPE.equals(environment) && !NacosUtil.isMicroService()) {
            this.addChildModule(appEnglishName, app.getAppName());
        }
    }

    public void updateApp(SysApplication app) {
        Map extendParams = app.getExtendParams();
        List dbIds = (List)extendParams.get("dbIds");
        this.sysAppDataSourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDataSource::getAppId, (Object)app.getId()));
        if (HussarUtils.isNotEmpty((Object)dbIds)) {
            ArrayList<SysAppDataSource> list = new ArrayList<SysAppDataSource>();
            for (Object dbId : dbIds) {
                SysAppDataSource source = new SysAppDataSource();
                source.setAppId(app.getId());
                source.setDbId(Long.valueOf(Long.parseLong(String.valueOf(dbId))));
                list.add(source);
            }
            this.sysAppDataSourceService.saveBatch(list);
        }
        String active = this.hussarBasePluginProperties.getRunMode();
        String environment = APP_TYPE;
        if ("dev".equals(active)) {
            environment = APP_TYPE;
        } else if ("prod".equals(active)) {
            environment = "3";
        }
        if (APP_TYPE.equals(environment) && !NacosUtil.isMicroService()) {
            SysLowCodeAppExtend appExtend = (SysLowCodeAppExtend)this.sysLowCodeAppExtendMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppId, (Object)app.getId()));
            this.addChildModule(appExtend.getAppEnglishName(), app.getAppName());
        }
        HussarCacheUtil.evict((String)"app_info", (Object)app.getId());
    }

    public void deleteRecycleApp(SysAppRecycle appRecycle) {
    }

    public void beforeDeleteRecycleApp(SysAppRecycle appRecycle) {
    }

    public void revertRecycleApp(SysAppRecycle appRecycle) {
    }

    private void addChildModule(String applicationName, String chineseName) {
        String pluginPrefix = this.hussarBasePluginProperties.getPluginPrefix();
        String modulePath = this.hussarBasePluginProperties.getModulePath();
        String prefixName = this.hussarBasePluginProperties.getPrefixName();
        String appPrefixName = this.hussarBasePluginProperties.getAppPrefixName();
        String pluginParentName = this.hussarBasePluginProperties.getPluginParentName();
        String packageVersion = this.hussarBasePluginProperties.getPackageVersion();
        this.executeScript(false, applicationName);
        if (pluginPrefix != null && modulePath != null) {
            String absolutePath = modulePath;
            int end = absolutePath.lastIndexOf(File.separator);
            if (end != absolutePath.length() - 1) {
                absolutePath = absolutePath + File.separator;
            }
            String prefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)prefixName) ? prefixName : "hussar-plugin");
            String appPrefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)appPrefixName) ? appPrefixName : "hussar-web");
            File module = new File(prefixPath);
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            if (ToolUtil.isEmpty((Object)securityUser)) {
                throw new BaseException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            if (module.exists()) {
                String userCode = securityUser.getTenantCode();
                String tenantCode = AppContextUtil.asIdentifier((String)userCode);
                String applicationCode = AppContextUtil.asIdentifier((String)applicationName);
                String account = securityUser.getAccount();
                String tenantPath = prefixPath + File.separator + pluginPrefix + tenantCode;
                String tenAndApp = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)applicationName);
                String tenantAppPath = tenantPath + File.separator + pluginPrefix + tenAndApp;
                String applicationPath = tenantPath + File.separator + pluginPrefix + tenAndApp + File.separator + pluginPrefix + tenAndApp + "-application";
                String apiPath = tenantPath + File.separator + pluginPrefix + tenAndApp + File.separator + pluginPrefix + tenAndApp + "-api";
                File application = new File(tenantAppPath);
                if (!application.exists()) {
                    application.mkdirs();
                    String relativeRPath = "src.main.resources";
                    String resourcePath = appPrefixPath + File.separator + relativeRPath.replace(".", File.separator);
                    String relativeMainPath = "src.main";
                    String mainPath = applicationPath + File.separator + relativeMainPath.replace(".", File.separator);
                    String mainApiPath = apiPath + File.separator + relativeMainPath.replace(".", File.separator);
                    String templatePath = resourcePath + File.separator + "templates";
                    String tenantCodeLow = tenantCode.toLowerCase();
                    String applicationCodeLow = applicationCode.toLowerCase();
                    HashMap<String, String> apiPomParam = new HashMap<String, String>();
                    apiPomParam.put("artifactId", pluginPrefix + tenAndApp + "-api");
                    apiPomParam.put("pluginParentName", pluginPrefix + tenAndApp);
                    apiPomParam.put("pluginVersion", packageVersion);
                    String apiPomTName = "apiPom.ftl";
                    String apiPomFName = "pom.xml";
                    CodeGenerator apiPomGen = new CodeGenerator(apiPomTName, apiPomParam, templatePath, apiPath, apiPomFName);
                    apiPomGen.gen();
                    String relativeApiPath = "java.com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLow;
                    String apiFolderPath = mainApiPath + File.separator + relativeApiPath.replace(".", File.separator);
                    File directory = new File(apiFolderPath);
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    String relativeConfigPath = "java.com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLow + ".config";
                    String configPath = mainPath + File.separator + relativeConfigPath.replace(".", File.separator);
                    String configBeanTName = "PluginMybatisPlusConfiguration.ftl";
                    String configBeanFName = "PluginMybatisPlusConfiguration.java";
                    String appPath = tenantCodeLow + "/" + applicationCodeLow;
                    HashMap<String, String> configParams = new HashMap<String, String>();
                    configParams.put("tenantCode", tenantCodeLow);
                    configParams.put("applicationCode", applicationCodeLow);
                    configParams.put("applicationPath", appPath);
                    CodeGenerator configBeanGen = new CodeGenerator(configBeanTName, configParams, templatePath, configPath, configBeanFName);
                    configBeanGen.gen();
                    String dbConfigBeanTName = "pluginConfigrationGen.ftl";
                    String dbConfigBeanFName = "PluginConfigration.java";
                    HashMap<String, String> dbConfigParams = new HashMap<String, String>();
                    dbConfigParams.put("tenantCode", tenantCodeLow);
                    dbConfigParams.put("applicationCode", applicationCodeLow);
                    CodeGenerator dbConfigBeanGen = new CodeGenerator(dbConfigBeanTName, dbConfigParams, templatePath, configPath, dbConfigBeanFName);
                    dbConfigBeanGen.gen();
                    String relativeParamsPath = "java.com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLow;
                    String paramsPath = mainPath + File.separator + relativeParamsPath.replace(".", File.separator);
                    String newAppName = applicationName;
                    Pattern p = Pattern.compile("[a-zA-z]");
                    String appFirst = applicationName.substring(0, 1);
                    if (p.matcher(appFirst).find()) {
                        newAppName = appFirst.toUpperCase() + applicationName.substring(1);
                    }
                    String tenantUp = tenantCode;
                    String tenantFist = tenantCode.substring(0, 1);
                    if (!"_".equals(tenantFist)) {
                        tenantUp = tenantFist.toUpperCase() + tenantCode.substring(1);
                    }
                    String className = tenantUp + newAppName + "ParamsPlugin";
                    String paramsTName = "ParamsPlugin.ftl";
                    String paramsFName = className + ".java";
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("className", className);
                    params.put("tenantCode", tenantCodeLow);
                    params.put("applicationCode", applicationCodeLow);
                    CodeGenerator paramsGen = new CodeGenerator(paramsTName, params, templatePath, paramsPath, paramsFName);
                    paramsGen.gen();
                    String pluginPath = mainPath + File.separator + "resources";
                    String pluginTName = "plugin.ftl";
                    String pluginFName = "plugin.properties";
                    String classPath = "com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLow + "." + className;
                    HashMap<String, String> pluginParam = new HashMap<String, String>();
                    pluginParam.put("id", tenAndApp);
                    pluginParam.put("class", classPath);
                    pluginParam.put("provider", account);
                    pluginParam.put("description", chineseName);
                    CodeGenerator pluginGen = new CodeGenerator(pluginTName, pluginParam, templatePath, pluginPath, pluginFName);
                    pluginGen.gen();
                    pluginParam.put("id", tenAndApp);
                    pluginParam.put("class", classPath);
                    pluginParam.put("provider", account);
                    pluginParam.put("artifactId", pluginPrefix + tenAndApp + "-application");
                    pluginParam.put("apiArtifactId", pluginPrefix + tenAndApp + "-api");
                    pluginParam.put("pluginParentName", ToolUtil.isNotEmpty((Object)pluginParentName) ? pluginParentName : "hussar-plugin-parent");
                    pluginParam.put("pluginVersion", packageVersion);
                    String appPomTName = "appPom.ftl";
                    String appPomFName = "pom.xml";
                    CodeGenerator appPomGen = new CodeGenerator(appPomTName, pluginParam, templatePath, applicationPath, appPomFName);
                    appPomGen.gen();
                    HashMap<String, String> pluginPomParam = new HashMap<String, String>();
                    pluginPomParam.put("pluginVersion", packageVersion);
                    pluginPomParam.put("artifactId", pluginPrefix + tenAndApp);
                    pluginPomParam.put("applicationArtifactId", pluginPrefix + tenAndApp + "-application");
                    pluginPomParam.put("apiArtifactId", pluginPrefix + tenAndApp + "-api");
                    String pluginPomTName = "pluginPom.ftl";
                    String pluginPomFName = "pom.xml";
                    CodeGenerator pluginPomGen = new CodeGenerator(pluginPomTName, pluginPomParam, templatePath, tenantAppPath, pluginPomFName);
                    pluginPomGen.gen();
                    String pomUrl = absolutePath + prefixName + File.separator + "pom.xml";
                    String moduleName = pluginPrefix + tenantCode + File.separator + pluginPrefix + tenAndApp;
                    this.editPomXml(pomUrl, moduleName);
                    try {
                        SharePluginInfoDto pluginInfoDto = new SharePluginInfoDto();
                        pluginInfoDto.setSharePluginId(tenAndApp);
                        pluginInfoDto.setTenantCode(userCode);
                        pluginInfoDto.setAppCode(applicationName);
                        pluginInfoDto.setAppName(chineseName);
                        pluginInfoDto.setAppVersion("");
                        pluginInfoDto.setRunMode(this.hussarBasePluginProperties.getRunMode());
                        String pluginParentPath = new File(this.hussarProduceProperties.getPluginPath()).getParent();
                        String pluginBackUpPath = FileUtil.posixPath((String[])new String[]{pluginParentPath, "hussar-plugin-back"});
                        pluginInfoDto.setBackupPluginPath(pluginBackUpPath);
                        HussarTenantDefinition tenantByTenantCode = this.sysTenantService.getTenantByTenantCode(userCode);
                        if (HussarUtils.isNotEmpty((Object)tenantByTenantCode)) {
                            pluginInfoDto.setConnName(tenantByTenantCode.getConnName());
                        }
                        this.sharePluginService.savePluginInfo(pluginInfoDto);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        logger.warn("\u6587\u4ef6\u6a21\u5757\u751f\u6210\u5931\u8d25");
    }
}

