/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.applicationmix.dto.DownloadFilePathDto;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.properties.HussarClusterProperties;
import com.jxdinfo.hussar.applicationmix.qo.AppMixImportHistoryDataset;
import com.jxdinfo.hussar.applicationmix.service.IBatchImportAppService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppFileService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixFileService;
import com.jxdinfo.hussar.applicationmix.service.ISysEyImportAppMixMsgService;
import com.jxdinfo.hussar.applicationmix.service.ISysLowCodeAppExtendService;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.external.inducts.InductsTableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/application/appFile"})
public class HussarBaseApplicationMixFileController {
    @Autowired
    private ISysAppFileService appFileService;
    @Autowired
    private ISysLowCodeAppExtendService sysLowCodeAppExtendService;
    @Autowired
    private ISysAppMixFileService isysAppMixFileService;
    @Resource
    private InductsTableService inductsTableService;
    @Resource
    private ISysEyImportAppMixMsgService sysEyImportAppMixMsgService;
    @Resource
    private HussarClusterProperties hussarClusterProperties;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired
    private IBatchImportAppService batchImportAppService;

    @GetMapping(value={"/checkExportFile"})
    public Boolean checkExportFile(String tempPath) {
        boolean flag = false;
        if (tempPath == null) {
            return flag;
        }
        File file = new File(tempPath);
        if (file.exists()) {
            flag = true;
        }
        return flag;
    }

    @PostMapping(value={"/download"})
    public void downloadFile(HttpServletResponse response) {
        String appId = HttpKit.getRequest().getParameter("appId") == null ? "" : HttpKit.getRequest().getParameter("appId");
        String importType = HttpKit.getRequest().getParameter("type") == null ? "" : HttpKit.getRequest().getParameter("type");
        this.appFileService.downloadFile(appId, importType, response);
    }

    @PostMapping(value={"/downloadOffline"})
    public void downloadOffline(HttpServletResponse response, @RequestBody DownloadFilePathDto downloadFilePathDto) {
        this.appFileService.downloadOffline(downloadFilePathDto.getTempPath(), downloadFilePathDto.getFilePath(), response);
    }

    @PostMapping(value={"/importApp"})
    public ApiResponse<Object> importApp(MultipartFile file, Long appId, String type) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.sysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        AppContextUtil.setAppId((String)appId.toString());
        if (ToolUtil.isEmpty((Object)appInfo)) {
            return ApiResponse.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        try {
            Map data = this.appFileService.importApp(file, appId, type);
            boolean flag = (Boolean)data.get("status");
            if (flag) {
                return ApiResponse.success((Object)data);
            }
            return ApiResponse.fail((String)data.get("msg").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5e94\u7528\u5bfc\u5165\u5931\u8d25");
        }
    }

    @PostMapping(value={"/executeSql"})
    public ApiResponse<Object> executeSql(@RequestBody Map<String, Object> map) {
        String sql = map.get("sql").toString();
        if (ToolUtil.isNotEmpty((Object)sql)) {
            this.inductsTableService.executeSql(sql);
            return ApiResponse.success((String)"sql\u6267\u884c\u6210\u529f");
        }
        return ApiResponse.fail((String)"sql\u6267\u884c\u5931\u8d25");
    }

    @PostMapping(value={"/importProduceApp"})
    public ApiResponse<Object> importProduceApp(MultipartFile file, Long appId, @RequestParam(value="appCode", required=false) String appCode, HttpServletRequest request) {
        String tCode = request.getHeader("tcode");
        return this.appFileService.importProduceAppNew(file, appId, appCode, tCode);
    }

    @PostMapping(value={"/compileList"})
    public ApiResponse<Object> compileList(@RequestBody Map<String, Object> body) {
        String page = body.get("current") == null ? null : body.get("current").toString();
        String limit = body.get("size") == null ? null : body.get("size").toString();
        Object result = this.appFileService.getCompileList(page, limit, body);
        return ApiResponse.success((Object)result);
    }

    @PostMapping(value={"/checkExportStatus"})
    public ApiResponse<Object> checkExportStatus(@RequestBody Map<String, Object> map) {
        String ids = map.get("ids").toString();
        if (ToolUtil.isEmpty((Object)ids)) {
            return ApiResponse.fail((String)"\u5e94\u7528id\u96c6\u5408\u548c\u5bfc\u51fa\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.isysAppMixFileService.getExportInfo(ids.split(",")));
    }

    @PostMapping(value={"/beforeImportAndCompile"})
    public ApiResponse<Object> beforeImportAndCompile(@RequestBody Map<String, Object> map) {
        return ApiResponse.success();
    }

    @PostMapping(value={"/queueMsgList"})
    public ApiResponse<Object> getQueueMsgList() {
        Object result = this.appFileService.getQueueMsgList();
        return ApiResponse.success((Object)result);
    }

    @PostMapping(value={"/queryImportHistory"})
    public ApiResponse<Map<String, Object>> queryImportHistory(@RequestBody AppMixImportHistoryDataset appMixImportHistoryDataSet) {
        return this.appFileService.queryImportHistory(appMixImportHistoryDataSet);
    }

    @PostMapping(value={"/getSyncingImportStatus"})
    public Object getSyncingImportStatus(@RequestParam(value="compileId") Long compileId) {
        return this.sysEyImportAppMixMsgService.getSyncingImportStatus(compileId);
    }

    @GetMapping(value={"/downloadHistoryPackage"})
    public void downloadHistoryPackage(HttpServletResponse response) {
        Long historyId = Long.parseLong(HttpKit.getRequest().getParameter("historyId"));
        this.appFileService.downloadHistoryPackage(response, historyId);
    }

    @PostMapping(value={"/synchronousImport"})
    public ApiResponse<Object> synchronousImport(@RequestParam(value="file") MultipartFile file, @RequestParam(value="appEnglishName") String appEnglisName, @RequestParam(value="tenantId") String tenantId, @RequestParam(value="compileId") String compileId, @RequestParam(value="pluginId") String pluginId) throws IOException {
        Map map = this.appFileService.synchronousImport(file, appEnglisName, tenantId, compileId, pluginId);
        if ("true".equals(String.valueOf(map.get("success")))) {
            return ApiResponse.success((String)String.valueOf(map.get("msg")));
        }
        return ApiResponse.fail((String)String.valueOf(map.get("msg")));
    }

    @PostMapping(value={"/importExpansionApp"})
    public ApiResponse<Object> importExpansionApp(MultipartFile file, Long appId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.sysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        AppContextUtil.setAppId((String)appId.toString());
        if (ToolUtil.isEmpty((Object)appInfo)) {
            return ApiResponse.fail((String)"\u539f\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        try {
            this.appFileService.importExpansionApp(file, appId);
            return ApiResponse.success((String)"\u6269\u5c55\u5e94\u7528\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u6269\u5c55\u5e94\u7528\u5bfc\u5165\u5931\u8d25");
        }
    }

    @PostMapping(value={"/batchImport"})
    public ApiResponse batchImport(@RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="appId") Long appId, @RequestParam(value="tenantCode") String tenantCode, HttpServletRequest request) throws IOException {
        File temp = Files.createTempDirectory("batchImport" + Objects.requireNonNull(multipartFile.getName()), new FileAttribute[0]).toFile();
        File file = new File(temp.getAbsolutePath() + File.separator + multipartFile.getName() + ".hussar");
        FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)file);
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            this.batchImportAppService.batchImport(file, appId, tenantCode);
            try {
                FileUtils.deleteDirectory((File)temp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return ApiResponse.success((String)"\u6279\u91cf\u5bfc\u5165\u5f00\u59cb\u6267\u884c");
    }
}

