/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.applicationmix.constants.AppExportConstants;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.properties.HussarAppExportProperties;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixExportService;
import com.jxdinfo.hussar.applicationmix.service.ISysLowCodeAppExtendService;
import com.jxdinfo.hussar.applicationmix.util.TarUtil;
import com.jxdinfo.hussar.applicationmix.util.ZipUtil;
import com.jxdinfo.hussar.applicationmix.vo.ExportParamVO;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.formdesign.common.config.StorageContext;
import com.jxdinfo.hussar.formdesign.common.constant.ExportResourceConstant;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.export.ExportProjectStoreService;
import com.jxdinfo.hussar.formdesign.external.export.ExportTableService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class HussarBaseAppMixExportServiceImpl
implements IHussarBaseAppMixExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseAppMixExportServiceImpl.class);
    private static final String MODULES = "modules";
    private static final String VIEWS = "views";
    private static final String API = "api";
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private HussarAppExportProperties hussarAppExportProperties;
    @Resource
    private ISysLowCodeAppExtendService iSysLowCodeAppExtendService;
    @Resource
    private StorageContext storageContext;
    @Resource
    private StorageService storageService;
    @Autowired(required=false)
    private IHussarBaseTenantService hussarBaseTenantService;
    @Resource
    private ExportTableService exportTableService;
    @Resource
    private ExportProjectStoreService exportProjectStoreService;

    public Map<String, List<JSONObject>> resourceTree(String appId) {
        HashMap<String, List<JSONObject>> treeMap = new HashMap<String, List<JSONObject>>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.iSysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)appInfo)) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        String vuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), this.hussarAppExportProperties.getVueCodePath(), MODULES, this.getGeneratorFilePathPrefixByAppId(appInfo), VIEWS});
        String mobileVuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String apiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), this.hussarAppExportProperties.getFrontApiPath(), MODULES, this.getGeneratorFilePathPrefixByAppId(appInfo), API});
        String mobileApiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String mobileRouterPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String apiClassFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()) + "-api", this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        String appClassFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()) + "-application", this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        ArrayList<JSONObject> classFileObjects = new ArrayList<JSONObject>();
        String appStoreName = this.getAppStoreName(appId);
        if (ToolUtil.isEmpty((Object)appStoreName)) {
            appStoreName = "appsStore";
        }
        this.addJavaFile(appInfo, apiClassFilePath, classFileObjects, appStoreName);
        this.addJavaFile(appInfo, appClassFilePath, classFileObjects, appStoreName);
        String vueFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), this.hussarAppExportProperties.getVueCodePath(), MODULES, this.getGeneratorFilePathPrefixByAppId(appInfo), VIEWS});
        String absAppNameVue = FileUtil.posixPath((String[])new String[]{vueFilePath, appStoreName});
        ArrayList<JSONObject> vueFileObjects = new ArrayList<JSONObject>();
        File[] vueFiles = new File(vueFilePath).listFiles();
        this.iterateFiles(vueFileObjects, vueFiles, vuePathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameVue)));
        String mobileVueFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String absAppNameMobileVue = FileUtil.posixPath((String[])new String[]{mobileVueFilePath, appStoreName});
        ArrayList<JSONObject> mobileVueFileObjects = new ArrayList<JSONObject>();
        File[] mobileVueFiles = new File(mobileVueFilePath).listFiles();
        this.iterateFiles(mobileVueFileObjects, mobileVueFiles, mobileVuePathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameMobileVue)));
        String apiJsFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), this.hussarAppExportProperties.getFrontApiPath(), MODULES, this.getGeneratorFilePathPrefixByAppId(appInfo), API});
        String absAppNameApiJs = FileUtil.posixPath((String[])new String[]{apiJsFilePath, appStoreName.toLowerCase()});
        ArrayList<JSONObject> apiFileObjects = new ArrayList<JSONObject>();
        File[] apiFiles = new File(apiJsFilePath).listFiles();
        this.iterateFiles(apiFileObjects, apiFiles, apiPathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameApiJs)));
        String mobileApiJsFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String absAppNameMobileApiJs = FileUtil.posixPath((String[])new String[]{mobileApiJsFilePath, appStoreName.toLowerCase()});
        ArrayList<JSONObject> mobileApiFileObjects = new ArrayList<JSONObject>();
        File[] mobileApiFiles = new File(mobileApiJsFilePath).listFiles();
        this.iterateFiles(mobileApiFileObjects, mobileApiFiles, mobileApiPathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameMobileApiJs)));
        String mobileRouterJsFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String absAppNameMobileRouterJs = FileUtil.posixPath((String[])new String[]{mobileRouterJsFilePath, appStoreName.toLowerCase()});
        ArrayList<JSONObject> mobileRouterFileObjects = new ArrayList<JSONObject>();
        File[] mobileRouterFiles = new File(mobileRouterJsFilePath).listFiles();
        this.iterateFiles(mobileRouterFileObjects, mobileRouterFiles, mobileRouterPathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameMobileRouterJs)));
        treeMap.put("java", classFileObjects);
        treeMap.put("vue", vueFileObjects);
        treeMap.put("mobileVue", mobileVueFileObjects);
        treeMap.put(API, apiFileObjects);
        treeMap.put("mobileApi", mobileApiFileObjects);
        treeMap.put("mobileRouter", mobileRouterFileObjects);
        try {
            treeMap.put("tableInfo", this.exportTableService.resourceTree());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return treeMap;
    }

    private void addJavaFile(SysLowCodeAppExtend appInfo, String appClassFilePath, List<JSONObject> classFileObjects, String appStoreName) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        File[] appClassFile = new File(appClassFilePath).listFiles();
        String absAppName = FileUtil.posixPath((String[])new String[]{appClassFilePath, appStoreName.toLowerCase()});
        this.iterateFiles(classFileObjects, appClassFile, appClassFilePath, classFile -> {
            String removePrefix = FileUtil.removePrefix((String)File.separator, (String)classFile.getAbsolutePath().substring(FileUtil.removePrefix((String)File.separator, (String)appClassFilePath).length()));
            return AppExportConstants.CONFIG.equals(removePrefix) || ToolUtil.pathFomatterByOS((String)classFile.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppName)) || AppExportConstants.paramPlugin((String)tenantCode, (String)appInfo.getAppEnglishName()).equals(removePrefix);
        });
    }

    private String getGeneratorFilePathPrefixByAppId(SysLowCodeAppExtend appInfo) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        return appInfo == null ? null : FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName())});
    }

    public static String getAppBackCodePrefixByAppId(SysLowCodeAppExtend appInfo) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        return appInfo == null ? null : FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName())}).toLowerCase();
    }

    private String pathToId(String prefix, String abPath) {
        return FilenameUtils.removeExtension((String)abPath.substring(prefix.length() - 1)).replaceAll("/", "").replaceAll("\\\\", "");
    }

    private void iterateFiles(List<JSONObject> fileObjects, File[] files, String prefix, Predicate<File> exclusion) {
        String finalPrefix = prefix = FileUtil.removePrefix((String)File.separator, (String)prefix);
        Optional.ofNullable(files).ifPresent(nullableFiles -> {
            for (File classFile : nullableFiles) {
                if (exclusion.test(classFile)) continue;
                JSONObject classFileObject = new JSONObject();
                String path = FileUtil.removePrefix((String)File.separator, (String)classFile.getAbsolutePath());
                String parentPath = FileUtil.removePrefix((String)File.separator, (String)classFile.getParentFile().getAbsolutePath());
                String id = this.pathToId(finalPrefix, path);
                String parentId = this.pathToId(finalPrefix, parentPath);
                if (classFile.getName().endsWith(".js")) {
                    id = id + "js";
                }
                String parent = parentPath.equals(finalPrefix) ? "#" : parentId;
                classFileObject.put("id", (Object)id);
                classFileObject.put("parent", (Object)parent);
                classFileObject.put("name", (Object)classFile.getName());
                classFileObject.put("path", (Object)classFile.getPath());
                if (classFile.isDirectory()) {
                    classFileObject.put("type", (Object)"Module");
                    fileObjects.add(classFileObject);
                    this.iterateFiles(fileObjects, classFile.listFiles(), finalPrefix, file -> false);
                    continue;
                }
                classFileObject.put("type", (Object)classFile.getName().substring(classFile.getName().indexOf(".") + 1));
                fileObjects.add(classFileObject);
            }
        });
    }

    public Map<String, String> export(ExportParamVO exportParamVO, HttpServletResponse response) throws Exception {
        long start = System.currentTimeMillis();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)exportParamVO.getAppId());
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.iSysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)appInfo)) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String appName = appInfo.getAppEnglishName();
        String vuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), this.hussarAppExportProperties.getVueCodePath(), MODULES});
        String mobileVuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath()});
        String apiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), this.hussarAppExportProperties.getFrontApiPath(), MODULES});
        String mobileApiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath()});
        String mobileRouterPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath()});
        String hussar = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getWorkspace(), ExportResourceConstant.RESOURCE_CACHE, ToolUtil.splicingBySeparator((String)ExportResourceConstant.UNDERLINE, (String[])new String[]{tenantCode, appName, DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss")})});
        String tar = FileUtil.posixPath((String[])new String[]{hussar, appName});
        String javaPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.JAVA});
        String vuePath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.VUE});
        String mobileVuePath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_VUE});
        String apiPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.API});
        String mobileApiPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_API});
        String mobileRouterPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_ROUTER});
        String tableInfoPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.TABLEINFO});
        String projectStorePath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.PROJECT_STORE});
        String modulesPath = FileUtil.posixPath((String[])new String[]{tar, MODULES});
        File tarDir = new File(tar);
        File hussarDir = new File(hussar);
        String zipFilePath = hussarDir.getAbsolutePath() + ExportResourceConstant._HUSSAR;
        int as = zipFilePath.lastIndexOf(File.separator) + 1;
        String tempPath = zipFilePath.substring(0, as) + appName + start;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tempPath", tempPath);
        map.put("filePath", zipFilePath);
        try {
            boolean wpdFlag = ToolUtil.isNotEmpty((Object)exportParamVO.getVues()) || ToolUtil.isNotEmpty((Object)exportParamVO.getApis());
            boolean flowFlag = ToolUtil.isNotEmpty((Object)exportParamVO.getConfigs()) || ToolUtil.isNotEmpty((Object)exportParamVO.getPermissions());
            this.exportProjectStoreService.export(exportParamVO.getAppId(), projectStorePath, wpdFlag, flowFlag);
            String javaFilePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName)});
            String apiJavaFilePathPrefix = FileUtil.posixPath((String[])new String[]{javaFilePathPrefix, this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-api"});
            String appJavaFilePathPrefix = FileUtil.posixPath((String[])new String[]{javaFilePathPrefix, this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-application"});
            String pomPath = FileUtil.posixPath((String[])new String[]{javaFilePathPrefix, AppExportConstants.POM});
            String apiPomPath = FileUtil.posixPath((String[])new String[]{apiJavaFilePathPrefix, AppExportConstants.POM});
            String appPomPath = FileUtil.posixPath((String[])new String[]{appJavaFilePathPrefix, AppExportConstants.POM});
            String codePath = FileUtil.posixPath((String[])new String[]{appJavaFilePathPrefix, this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
            String configPath = FileUtil.posixPath((String[])new String[]{codePath, AppExportConstants.CONFIG});
            String paramsPluginPath = FileUtil.posixPath((String[])new String[]{codePath, AppExportConstants.paramPlugin((String)tenantCode, (String)appName)});
            String resourcesPath = FileUtil.posixPath((String[])new String[]{appJavaFilePathPrefix, this.hussarAppExportProperties.getResourcesPath()});
            String prefixCommonPath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), this.hussarAppExportProperties.getVueCodePath(), MODULES, this.getGeneratorFilePathPrefixByAppId(appInfo), "prefixCommon.js"});
            this.copyFilesToTemp(exportParamVO.getJavas(), FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(pomPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(apiPomPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(appPomPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(configPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(paramsPluginPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(resourcesPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(prefixCommonPath, FileUtil.addSuffix((String)vuePathPrefix), modulesPath);
            this.copyFilesToTemp(exportParamVO.getVues(), FileUtil.addSuffix((String)vuePathPrefix), vuePath);
            this.copyFilesToTemp(exportParamVO.getMobileVues(), FileUtil.addSuffix((String)mobileVuePathPrefix), mobileVuePath);
            this.copyFilesToTemp(exportParamVO.getApis(), FileUtil.addSuffix((String)apiPathPrefix), apiPath);
            this.copyFilesToTemp(exportParamVO.getMobileApis(), FileUtil.addSuffix((String)mobileApiPathPrefix), mobileApiPath);
            this.copyFilesToTemp(exportParamVO.getMobileRouters(), FileUtil.addSuffix((String)mobileRouterPathPrefix), mobileRouterPath);
            Map tableStructureMap = this.exportTableService.exportTables(exportParamVO.getTableInfos());
            File tableStructureFile = new File(FileUtil.posixPath((String[])new String[]{tableInfoPath, ExportResourceConstant.TABLE_INFO_JSON}));
            FileUtils.writeByteArrayToFile((File)tableStructureFile, (byte[])SerializeUtils.serialize((Object)tableStructureMap));
            this.zipAndDownload(tarDir, hussarDir, tenantCode, appName, hussar, response, 1, exportParamVO.getAppId(), tempPath);
            long end = System.currentTimeMillis();
            LOGGER.info("\u5bfc\u51fa\u81f3\u751f\u4ea7\u8017\u65f6========================>{}", (Object)String.format("%.3fs", (double)Math.abs(end - start) / 1000.0));
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51fa\u81f3\u751f\u4ea7\u73af\u5883\u51fa\u9519:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return map;
    }

    public Map<String, String> exportOffline(ExportParamVO exportParamVO, HttpServletResponse response) throws Exception {
        long start = System.currentTimeMillis();
        if (ToolUtil.isEmpty((Object)exportParamVO.getAppId())) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)exportParamVO.getAppId());
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.iSysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)appInfo)) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String appName = appInfo.getAppEnglishName();
        String vuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), this.hussarAppExportProperties.getVueCodePath(), MODULES, this.getGeneratorFilePathPrefixByAppId(appInfo), VIEWS});
        String mobileVuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String apiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), this.hussarAppExportProperties.getFrontApiPath(), MODULES, this.getGeneratorFilePathPrefixByAppId(appInfo), API});
        String mobileApiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String mobileRouterPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String javaPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-application", this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        String apiJavaPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-api", this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        String hussar = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), ExportResourceConstant.RESOURCE_CACHE, ToolUtil.splicingBySeparator((String)ExportResourceConstant.UNDERLINE, (String[])new String[]{tenantCode, appName, DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss")})});
        String zipFilePath = new File(hussar).getAbsolutePath() + ExportResourceConstant._HUSSAR;
        int as = zipFilePath.lastIndexOf(File.separator) + 1;
        String tempPath = zipFilePath.substring(0, as) + appName + start;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tempPath", tempPath);
        map.put("filePath", zipFilePath);
        try {
            String tar = FileUtil.posixPath((String[])new String[]{hussar, appName});
            String vuePath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.VUE, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appName), VIEWS});
            String mobileVuePath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_VUE, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appName)});
            String apiPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.API, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appName), API});
            String mobileApiPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_API, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appName)});
            String mobileRouterPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_ROUTER, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appName)});
            String javaPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.JAVA});
            String tableInfoPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.TABLEINFO});
            String projectStorePath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.PROJECT_STORE});
            String appsStoreName = this.getAppStoreName(exportParamVO.getAppId());
            if (ToolUtil.isEmpty((Object)appsStoreName)) {
                appsStoreName = "appsStore";
            }
            this.exportProjectStoreService.exportOffLine(exportParamVO.getAppId(), projectStorePath);
            if (new File(javaPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotPlugin(new File(javaPathPrefix), new File(javaPath + File.separator + this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-application" + this.formDesignProperties.getJavaCodePath() + this.formDesignProperties.getJavaPath() + File.separator + HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)), AppExportConstants.paramPlugin((String)AppContextUtil.asIdentifier((String)tenantCode), (String)AppContextUtil.asIdentifier((String)appName)), appsStoreName);
            }
            if (new File(apiJavaPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotPlugin(new File(apiJavaPathPrefix), new File(javaPath + File.separator + this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-api" + this.formDesignProperties.getJavaCodePath() + this.formDesignProperties.getJavaPath() + File.separator + HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)), AppExportConstants.paramPlugin((String)AppContextUtil.asIdentifier((String)tenantCode), (String)AppContextUtil.asIdentifier((String)appName)), appsStoreName);
            }
            if (new File(vuePathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotContains(new File(vuePathPrefix), new File(vuePath), appsStoreName);
            }
            if (new File(mobileVuePathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotContains(new File(mobileVuePathPrefix), new File(mobileVuePath), appsStoreName);
            }
            if (new File(apiPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotContains(new File(apiPathPrefix), new File(apiPath), appsStoreName);
            }
            if (new File(mobileApiPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotContains(new File(mobileApiPathPrefix), new File(mobileApiPath), appsStoreName);
            }
            if (new File(mobileRouterPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotContains(new File(mobileRouterPathPrefix), new File(mobileRouterPath), appsStoreName);
            }
            Map tableStructureMap = this.exportTableService.exportTables();
            File tableStructureFile = new File(FileUtil.posixPath((String[])new String[]{tableInfoPath, ExportResourceConstant.TABLE_INFO_JSON}));
            FileUtils.writeByteArrayToFile((File)tableStructureFile, (byte[])SerializeUtils.serialize((Object)tableStructureMap));
            this.zipAndDownload(new File(tar), new File(hussar), tenantCode, appName, hussar, response, 2, exportParamVO.getAppId(), tempPath);
            long end = System.currentTimeMillis();
            LOGGER.info("\u8de8\u79df\u6237\u5bfc\u51fa\u81f3\u7ebf\u4e0b\u73af\u5883\u8017\u65f6========================>{}", (Object)String.format("%.3fs", (double)Math.abs(end - start) / 1000.0));
        }
        catch (Exception e) {
            LOGGER.info("\u5bfc\u51fa\u81f3\u7ebf\u4e0b\u73af\u5883\u51fa\u9519:{}", (Object)e.getMessage());
        }
        return map;
    }

    private static void copyToDirectoryButNotPlugin(File srcDir, File destDir, String pluginApplicationName, String appStoreName) throws IOException {
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (AppExportConstants.CONFIG.equals(file.getName()) || pluginApplicationName.equals(file.getName()) || appStoreName.equalsIgnoreCase(file.getName())) continue;
            if (file.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)file, (File)destDir);
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    private static void copyToDirectoryButNotContains(File srcDir, File destDir, String appStoreName) throws IOException {
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (appStoreName.equalsIgnoreCase(file.getName())) continue;
            if (file.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)file, (File)destDir);
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    private void copyFilesToTemp(String absolutePaths, String prefix, String tempPath) throws IOException {
        if (ToolUtil.isNotEmpty((Object)absolutePaths)) {
            List codeFilePaths = ToolUtil.stringToList((String)absolutePaths);
            for (String path : codeFilePaths) {
                File file = new File(path);
                if (!file.exists()) continue;
                String relativePath = path.substring(prefix.length() - 1, path.length() - file.getName().length());
                File tempDir = new File(FileUtil.posixPath((String[])new String[]{tempPath, relativePath}));
                this.mkdir(tempDir);
                if (file.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)file, (File)tempDir);
                    continue;
                }
                FileUtils.copyFileToDirectory((File)file, (File)tempDir);
            }
        }
    }

    private void zipAndDownload(File tarDir, File hussarDir, String tenantId, String appName, String hussar, HttpServletResponse response, int importType, String appId, String tempPath) throws Exception {
        String tarPath = tarDir.getAbsolutePath() + ExportResourceConstant._TAR;
        File[] files = tarDir.listFiles();
        if (ToolUtil.isNotEmpty((Object)files)) {
            List<String> filePaths = Arrays.stream(files).map(File::getAbsolutePath).collect(Collectors.toList());
            TarUtil.execute(filePaths, tarPath);
        }
        FileUtils.deleteDirectory((File)tarDir);
        String codePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getAbsoluteOfflineWorkspaceRoot(), appId, this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath()});
        File[] codeFiles = new File(codePath).listFiles();
        HashMap<String, String> metaInfo = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty((Object)codeFiles)) {
            for (File file : codeFiles) {
                if (!file.getName().endsWith(".meta") || file.getName().contains("appsStore")) continue;
                long fileLength = file.length();
                byte[] fileContent = new byte[(int)fileLength];
                try (FileInputStream in = new FileInputStream(file);){
                    in.read(fileContent);
                }
                JSONObject modelObject = JSON.parseObject((String)new String(fileContent, StandardCharsets.UTF_8));
                metaInfo.put(file.getName(), modelObject.getString("id"));
            }
        }
        HussarTenantDefinition tenantDefinition = this.hussarBaseTenantService.getTenantByTenantCode(tenantId);
        JSONObject meta = new JSONObject();
        meta.put("tenantId", (Object)tenantId);
        meta.put("appName", (Object)appName);
        meta.put("javaPath", (Object)this.formDesignProperties.getJavaPath());
        meta.put("ds", (Object)(tenantDefinition == null ? "master" : tenantDefinition.getConnName()));
        meta.put("appId", (Object)appId);
        meta.put("importType", (Object)importType);
        meta.put("sign", (Object)ZipUtil.getMd5(tarPath));
        meta.put("version", (Object)this.hussarAppExportProperties.getVersion());
        meta.put("metaInfo", metaInfo);
        File metaFile = new File(FileUtil.posixPath((String[])new String[]{hussar, ExportResourceConstant.META_JSON}));
        FileUtils.writeByteArrayToFile((File)metaFile, (byte[])SerializeUtils.serialize((Object)meta));
        this.zipFile(hussarDir, ExportResourceConstant._HUSSAR, tempPath);
    }

    public void mkdir(File ... files) throws IOException {
        for (File file : files) {
            if (file.exists()) continue;
            FileUtils.forceMkdir((File)file);
        }
    }

    public void zipFile(File zipTempFile, String zipSuffix, String tempPath) throws Exception {
        String zipFilePath = zipTempFile.getAbsolutePath() + zipSuffix;
        File zipFile = new File(zipFilePath);
        if (!zipFile.exists()) {
            zipFile.getParentFile().mkdir();
        }
        ZipUtil.zip(zipTempFile.getAbsolutePath(), zipFilePath);
        File file = new File(tempPath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileUtils.deleteDirectory((File)zipTempFile);
    }

    private String getAppStoreName(String appId) {
        StorageResult storageResult = (StorageResult)this.storageContext.with(null, appId, null, () -> this.storageService.downloadByUuid(CategoryEnum.META, "d37c273c-d0ca-4f46-a1b1-0aa62754dcb3"));
        byte[] resultData = (byte[])storageResult.getData();
        Optional<Object> data = Optional.ofNullable(storageResult.getData());
        if (data.isPresent()) {
            JSONObject jsonObject = JSON.parseObject((String)new String((byte[])data.get(), StandardCharsets.UTF_8));
            return (String)jsonObject.get((Object)"name");
        }
        return "";
    }
}

