/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.jxdinfo.hussar.applicationmix.dao.HussarBaseAppMixFileMapper;
import com.jxdinfo.hussar.applicationmix.model.SysApplicationFile;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixFileService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysApplicationMixFileServiceImpl
extends HussarServiceImpl<HussarBaseAppMixFileMapper, SysApplicationFile>
implements ISysAppMixFileService {
    private final HussarBaseAppMixFileMapper appFileMapper;

    @Autowired
    public SysApplicationMixFileServiceImpl(HussarBaseAppMixFileMapper hussarBaseAppMixFileMapper) {
        this.appFileMapper = hussarBaseAppMixFileMapper;
    }

    public String getAppFileDownloadPath(String appId, String importType) {
        String path = this.appFileMapper.getDownloadPath(appId, importType);
        if (ToolUtil.isEmpty((Object)path)) {
            return null;
        }
        return path;
    }

    public Integer isExportingByAppId(String appId, String importType) {
        Integer num = this.appFileMapper.getExportingByAppId(appId, importType);
        if (num == null) {
            return 0;
        }
        return num;
    }

    public List<Map<String, Object>> getExportInfo(String[] appIds) {
        ArrayList<Map<String, Object>> infoList = new ArrayList<Map<String, Object>>();
        for (String appId : appIds) {
            SysApplicationFile sysApplicationFile;
            String[] idAndType = appId.split("_");
            if (idAndType.length == 1 || (sysApplicationFile = this.appFileMapper.getNewExportInfo(idAndType[0], idAndType[1])) == null || "0".equals(sysApplicationFile.getFileStatus())) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("appId", appId);
            map.put("appName", sysApplicationFile.getAppName());
            map.put("result", "1".equals(sysApplicationFile.getFileStatus()));
            map.put("errorMsg", sysApplicationFile.getErrorMsg());
            infoList.add(map);
        }
        return infoList;
    }

    public List<SysApplicationFile> getAppFileByImportType(Long appId, String importType) {
        return this.appFileMapper.getAppFileByImportType(appId, importType);
    }
}

