/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.applicationmix.dao.HussarBaseUserAppZCMapper;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixUserZCService;
import com.jxdinfo.hussar.applicationmix.service.ISysLowCodeAppExtendService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@HussarTokenDs
@Service
public class SysAppMixUserZCServiceImpl
implements ISysAppMixUserZCService {
    @Autowired
    private ISysApplicationService sysApplicationServiceImpl;
    @Autowired
    private ISysLowCodeAppExtendService sysLowCodeAppExtendService;
    @Resource
    private HussarBaseUserAppZCMapper hussarBaseUserAppZCMapper;

    public Page<MixAppInfoVo> hussarQueryPage(PageInfo pageInfo, String appName, String groupName) {
        Page result = HussarPageUtils.convert((PageInfo)pageInfo);
        String appNameLike = appName == null ? "" : appName.trim();
        String groupNameLike = groupName == null ? "" : groupName.trim();
        Long userId = BaseSecurityUtil.getUser().getUserId();
        Long tenantId = BaseSecurityUtil.getUser().getTenantId();
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String tenantName = BaseSecurityUtil.getUser().getTenantName();
        List<MixAppInfoVo> mixAppUserZCVoList = this.hussarBaseUserAppZCMapper.hussarQueryPage(result, appNameLike, groupNameLike, userId);
        for (MixAppInfoVo mixAppInfoVo : mixAppUserZCVoList) {
            mixAppInfoVo.setTenantId(tenantId);
            mixAppInfoVo.setTenantCode(tenantCode);
            mixAppInfoVo.setTenantName(tenantName);
        }
        result.setRecords(mixAppUserZCVoList);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean del(String ids) {
        if (ids != null && !ids.equals("")) {
            List<String> idstr = Arrays.asList(ids.split(","));
            List idList = idstr.stream().map(Long::parseLong).collect(Collectors.toList());
            List sysApplicationList = this.sysApplicationServiceImpl.listByIds(idList);
            for (SysApplication sysApplication : sysApplicationList) {
                LambdaQueryWrapper sysApplicationLambdaQueryWrapper = new LambdaQueryWrapper();
                sysApplicationLambdaQueryWrapper.eq(SysLowCodeAppExtend::getAppId, (Object)sysApplication.getId());
                this.sysLowCodeAppExtendService.remove((Wrapper)sysApplicationLambdaQueryWrapper);
            }
            this.sysApplicationServiceImpl.removeByIds(idList);
            return true;
        }
        return false;
    }
}

