/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.controller;

import com.jxdinfo.hussar.applicationmix.service.IHussarBaseApplicationDatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/application/datasource"})
public class HussarBaseApplicationDatasourceController {
    @Autowired
    private IHussarBaseApplicationDatasourceService hussarBaseApplicationDatasourceService;

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f", notes="\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f")
    @PostMapping(value={"/remove"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"application:datasource:remove"})
    public ApiResponse<SysDataSource> remove(@ApiParam(value="\u6570\u636e\u6e90id") @RequestBody List<String> ids) {
        this.hussarBaseApplicationDatasourceService.deleteDataSource(ids);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u67e5\u8be2\u6570\u636e\u6e90", notes="\u6839\u636e\u7c7b\u578b\u67e5\u8be2\u6570\u636e\u6e90")
    @GetMapping(value={"/getListByType"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u7c7b\u578b\u67e5\u8be2\u6570\u636e\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysDataSource>> getListByType(@ApiParam(value="\u6570\u636e\u6e90\u7c7b\u578b") @RequestParam(value="datasourceType") String datasourceType, @ApiParam(value="\u79df\u6237\u7f16\u7801") @RequestParam(required=false, value="tenantCode") String tenantCode) {
        return ApiResponse.success((Object)this.hussarBaseApplicationDatasourceService.getListByType(datasourceType, tenantCode));
    }
}

