/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.controller;

import com.jxdinfo.hussar.applicationmix.dto.QueryOrganTreeDto;
import com.jxdinfo.hussar.applicationmix.dto.QueryTeamUserDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.applicationmix.controller.hussarBaseAppInvorkController")
@RequestMapping(value={"/rest"})
public class HussarBaseAppInvorkController {
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;

    @PostMapping(value={"/orgTree"})
    @AuditLog(moduleName="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganUserTreeVo>> orgTree(@RequestBody QueryOrganTreeDto queryOrganTreeDto) {
        List parentOrganIds = queryOrganTreeDto.getParentOrganIds();
        Boolean needParentOrganInfo = queryOrganTreeDto.getNeedParentOrganInfo();
        Integer resultType = queryOrganTreeDto.getResultType();
        List userTreeVos = this.hussarBaseUserBoService.lazyOrganUserTree(parentOrganIds, needParentOrganInfo, resultType);
        return ApiResponse.success((Object)userTreeVos);
    }

    @PostMapping(value={"/getUsersByOrganUser"})
    @AuditLog(moduleName="\u6839\u636e\u7ec4\u7ec7id(\u83b7\u53d6\u7ec4\u7ec7\u53ca\u5b50\u7ec4\u7ec7\u4e0b\u7528\u6237)\u3001\u7528\u6237id\u5217\u8868\u83b7\u53d6\u7528\u6237\u5217\u8868(\u9700\u53bb\u91cd)", eventDesc="\u6839\u636e\u7ec4\u7ec7id(\u83b7\u53d6\u7ec4\u7ec7\u53ca\u5b50\u7ec4\u7ec7\u4e0b\u7528\u6237)\u3001\u7528\u6237id\u5217\u8868\u83b7\u53d6\u7528\u6237\u5217\u8868(\u9700\u53bb\u91cd)", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<UserVo>> getUsersByOrganUser(@RequestBody QueryTeamUserDto queryTeamUserDto) {
        List result = this.hussarBaseUserBoService.getUsersByOrganUser(queryTeamUserDto.getOrganIds(), queryTeamUserDto.getUserIds());
        return ApiResponse.success((Object)result);
    }
}

