/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamMemberCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppRecycleCommonMapper;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.applicationmix.dao.SysLowCodeAppExtendMapper;
import com.jxdinfo.hussar.applicationmix.dto.CodeGenerator;
import com.jxdinfo.hussar.applicationmix.model.SysAppDataSource;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.service.ISysAppDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.applicationmix.service.impl.hussarLowCodeAppCallBackServiceImpl")
public class HussarLowCodeAppCallBackServiceImpl
implements IHussarAppCallBackService {
    private static final Logger logger = LoggerFactory.getLogger(HussarLowCodeAppCallBackServiceImpl.class);
    private static final String APP_TYPE = "2";
    @Resource
    private SysLowCodeAppExtendMapper sysLowCodeAppExtendMapper;
    @Resource
    private ISysAppDataSourceService sysAppDataSourceService;
    @Resource
    private SysAppRecycleCommonMapper sysAppRecycleCommonMapper;
    @Resource
    private SysAppDevelopTeamCommonMapper developTeamMapper;
    @Resource
    private SysAppDevelopTeamMemberCommonMapper developTeamMemberMapper;
    @Value(value="${hussar-formdesign.open-plugin:false}")
    private String openPlugin;
    @Value(value="${spring.profiles.active}")
    private String active;
    @Value(value="${plugin.pluginPrefix:}")
    private String pluginPrefix;
    @Value(value="${plugin.modulePath:}")
    private String modulePath;
    @Value(value="${plugin.prefixName:}")
    private String prefixName;
    @Value(value="${plugin.appPrefixName:}")
    private String appPrefixName;
    @Value(value="${plugin.pluginParentName:}")
    private String pluginParentName;
    @Value(value="${plugin.packageVersion:}")
    private String packageVersion;

    public String getAppType() {
        return APP_TYPE;
    }

    public void deleteApp(SysApplication app) {
        Long appId = app.getId();
        this.sysAppRecycleCommonMapper.deleteById((Serializable)appId);
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        this.developTeamMapper.deleteById((Serializable)sysAppDevelopTeam.getId());
        this.developTeamMemberMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        this.sysLowCodeAppExtendMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppId, (Object)appId));
        this.sysAppDataSourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDataSource::getAppId, (Object)appId));
    }

    public void beforeDeleteApp(SysApplication app) {
    }

    public void addApp(SysApplication app) {
        Map extendParams = app.getExtendParams();
        String isInit = (String)extendParams.get("isInit");
        String appEnglishName = (String)extendParams.get("appEnglishName");
        List dbIds = (List)extendParams.get("dbIds");
        Long count = this.sysLowCodeAppExtendMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppEnglishName, (Object)appEnglishName));
        if (count > 0L) {
            throw new BaseException("\u5e94\u7528\u82f1\u6587\u540d\u91cd\u590d");
        }
        SysLowCodeAppExtend appExtend = new SysLowCodeAppExtend();
        appExtend.setAppId(app.getId());
        appExtend.setIsInit(isInit);
        appExtend.setAppEnglishName(appEnglishName);
        this.sysLowCodeAppExtendMapper.insert(appExtend);
        if (HussarUtils.isNotEmpty((Object)dbIds)) {
            ArrayList<SysAppDataSource> list = new ArrayList<SysAppDataSource>();
            for (Object dbId : dbIds) {
                SysAppDataSource source = new SysAppDataSource();
                source.setAppId(app.getId());
                source.setDbId(Long.valueOf(Long.parseLong(String.valueOf(dbId))));
                list.add(source);
            }
            this.sysAppDataSourceService.saveBatch(list);
        }
        if ("true".equals(this.openPlugin)) {
            String environment = "";
            Integer type = LicenseInfo.getLicenseType();
            environment = "dev".equals(this.active) && type == 1 ? "1" : ("produce".equals(this.active) && type == 1 ? "3" : APP_TYPE);
            if (APP_TYPE.equals(environment) && !this.isMicroService()) {
                this.addChildModule(appEnglishName, app.getAppName());
            }
        }
    }

    public void updateApp(SysApplication app) {
        Map extendParams = app.getExtendParams();
        List dbIds = (List)extendParams.get("dbIds");
        this.sysAppDataSourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDataSource::getAppId, (Object)app.getId()));
        if (HussarUtils.isNotEmpty((Object)dbIds)) {
            ArrayList<SysAppDataSource> list = new ArrayList<SysAppDataSource>();
            for (Object dbId : dbIds) {
                SysAppDataSource source = new SysAppDataSource();
                source.setAppId(app.getId());
                source.setDbId(Long.valueOf(Long.parseLong(String.valueOf(dbId))));
                list.add(source);
            }
            this.sysAppDataSourceService.saveBatch(list);
        }
        if ("true".equals(this.openPlugin)) {
            String environment = "";
            Integer type = LicenseInfo.getLicenseType();
            environment = "dev".equals(this.active) && type == 1 ? "1" : ("produce".equals(this.active) && type == 1 ? "3" : APP_TYPE);
            if (APP_TYPE.equals(environment) && !this.isMicroService()) {
                SysLowCodeAppExtend appExtend = (SysLowCodeAppExtend)this.sysLowCodeAppExtendMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysLowCodeAppExtend::getAppId, (Object)app.getId()));
                this.addChildModule(appExtend.getAppEnglishName(), app.getAppName());
            }
        }
    }

    public void deleteRecycleApp(SysAppRecycle appRecycle) {
    }

    public void beforeDeleteRecycleApp(SysAppRecycle appRecycle) {
    }

    public void revertRecycleApp(SysAppRecycle appRecycle) {
    }

    private boolean isMicroService() {
        String className = "org.springframework.cloud.openfeign.FeignClient";
        try {
            ClassUtils.forName((String)className, (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addChildModule(String applicationName, String chineseName) {
        if (this.pluginPrefix != null && this.modulePath != null) {
            String absolutePath = this.modulePath;
            int end = absolutePath.lastIndexOf(File.separator);
            if (end != absolutePath.length() - 1) {
                absolutePath = absolutePath + File.separator;
            }
            String prefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)this.prefixName) ? this.prefixName : "hussar-plugin");
            String appPrefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)this.appPrefixName) ? this.appPrefixName : "hussar-web");
            File module = new File(prefixPath);
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            if (ToolUtil.isEmpty((Object)securityUser)) {
                throw new BaseException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            if (module.exists()) {
                String userCode = securityUser.getTenantCode();
                String tenantCode = AppContextUtil.asIdentifier((String)userCode);
                String applicationCode = AppContextUtil.asIdentifier((String)applicationName);
                String account = securityUser.getAccount();
                String tenantPath = prefixPath + File.separator + this.pluginPrefix + tenantCode;
                String tenAndApp = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)applicationName);
                String tenantAppPath = tenantPath + File.separator + this.pluginPrefix + tenAndApp;
                String applicationPath = tenantPath + File.separator + this.pluginPrefix + tenAndApp + File.separator + this.pluginPrefix + tenAndApp + "-application";
                String apiPath = tenantPath + File.separator + this.pluginPrefix + tenAndApp + File.separator + this.pluginPrefix + tenAndApp + "-api";
                File application = new File(tenantAppPath);
                if (!application.exists()) {
                    application.mkdirs();
                    String relativeRPath = "src.main.resources";
                    String resourcePath = appPrefixPath + File.separator + relativeRPath.replace(".", File.separator);
                    String relativeMainPath = "src.main";
                    String mainPath = applicationPath + File.separator + relativeMainPath.replace(".", File.separator);
                    String mainApiPath = apiPath + File.separator + relativeMainPath.replace(".", File.separator);
                    String templatePath = resourcePath + File.separator + "templates";
                    String tenantCodeLow = tenantCode.toLowerCase();
                    String applicationCodeLow = applicationCode.toLowerCase();
                    HashMap<String, String> apiPomParam = new HashMap<String, String>();
                    apiPomParam.put("artifactId", this.pluginPrefix + tenAndApp + "-api");
                    apiPomParam.put("pluginParentName", this.pluginPrefix + tenAndApp);
                    apiPomParam.put("pluginVersion", this.packageVersion);
                    String apiPomTName = "apiPom.ftl";
                    String apiPomFName = "pom.xml";
                    CodeGenerator apiPomGen = new CodeGenerator(apiPomTName, apiPomParam, templatePath, apiPath, apiPomFName);
                    apiPomGen.gen();
                    String relativeApiPath = "java.com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLow;
                    String apiFolderPath = mainApiPath + File.separator + relativeApiPath.replace(".", File.separator);
                    File directory = new File(apiFolderPath);
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    String relativeConfigPath = "java.com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLow + ".config";
                    String configPath = mainPath + File.separator + relativeConfigPath.replace(".", File.separator);
                    String configBeanTName = "PluginMybatisPlusConfiguration.ftl";
                    String configBeanFName = "PluginMybatisPlusConfiguration.java";
                    String appPath = tenantCodeLow + "/" + applicationCodeLow;
                    HashMap<String, String> configParams = new HashMap<String, String>();
                    configParams.put("tenantCode", tenantCodeLow);
                    configParams.put("applicationCode", applicationCodeLow);
                    configParams.put("applicationPath", appPath);
                    CodeGenerator configBeanGen = new CodeGenerator(configBeanTName, configParams, templatePath, configPath, configBeanFName);
                    configBeanGen.gen();
                    String dbConfigBeanTName = "pluginConfigrationGen.ftl";
                    String dbConfigBeanFName = "PluginConfigration.java";
                    HashMap<String, String> dbConfigParams = new HashMap<String, String>();
                    dbConfigParams.put("tenantCode", tenantCodeLow);
                    dbConfigParams.put("applicationCode", applicationCodeLow);
                    CodeGenerator dbConfigBeanGen = new CodeGenerator(dbConfigBeanTName, dbConfigParams, templatePath, configPath, dbConfigBeanFName);
                    dbConfigBeanGen.gen();
                    String relativeParamsPath = "java.com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLow;
                    String paramsPath = mainPath + File.separator + relativeParamsPath.replace(".", File.separator);
                    String newAppName = applicationName;
                    Pattern p = Pattern.compile("[a-zA-z]");
                    String appFirst = applicationName.substring(0, 1);
                    if (p.matcher(appFirst).find()) {
                        newAppName = appFirst.toUpperCase() + applicationName.substring(1);
                    }
                    String tenantUp = tenantCode;
                    String tenantFist = tenantCode.substring(0, 1);
                    if (!"_".equals(tenantFist)) {
                        tenantUp = tenantFist.toUpperCase() + tenantCode.substring(1);
                    }
                    String className = tenantUp + newAppName + "ParamsPlugin";
                    String paramsTName = "ParamsPlugin.ftl";
                    String paramsFName = className + ".java";
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("className", className);
                    params.put("tenantCode", tenantCodeLow);
                    params.put("applicationCode", applicationCodeLow);
                    CodeGenerator paramsGen = new CodeGenerator(paramsTName, params, templatePath, paramsPath, paramsFName);
                    paramsGen.gen();
                    String pluginPath = mainPath + File.separator + "resources";
                    String pluginTName = "plugin.ftl";
                    String pluginFName = "plugin.properties";
                    String classPath = "com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLow + "." + className;
                    HashMap<String, String> pluginParam = new HashMap<String, String>();
                    pluginParam.put("id", tenAndApp);
                    pluginParam.put("class", classPath);
                    pluginParam.put("provider", account);
                    pluginParam.put("description", chineseName);
                    CodeGenerator pluginGen = new CodeGenerator(pluginTName, pluginParam, templatePath, pluginPath, pluginFName);
                    pluginGen.gen();
                    pluginParam.put("id", tenAndApp);
                    pluginParam.put("class", classPath);
                    pluginParam.put("provider", account);
                    pluginParam.put("artifactId", this.pluginPrefix + tenAndApp + "-application");
                    pluginParam.put("apiArtifactId", this.pluginPrefix + tenAndApp + "-api");
                    pluginParam.put("pluginParentName", ToolUtil.isNotEmpty((Object)this.pluginParentName) ? this.pluginParentName : "hussar-plugin-parent");
                    pluginParam.put("pluginVersion", this.packageVersion);
                    String appPomTName = "appPom.ftl";
                    String appPomFName = "pom.xml";
                    CodeGenerator appPomGen = new CodeGenerator(appPomTName, pluginParam, templatePath, applicationPath, appPomFName);
                    appPomGen.gen();
                    HashMap<String, String> pluginPomParam = new HashMap<String, String>();
                    pluginPomParam.put("pluginVersion", this.packageVersion);
                    pluginPomParam.put("artifactId", this.pluginPrefix + tenAndApp);
                    pluginPomParam.put("applicationArtifactId", this.pluginPrefix + tenAndApp + "-application");
                    pluginPomParam.put("apiArtifactId", this.pluginPrefix + tenAndApp + "-api");
                    String pluginPomTName = "pluginPom.ftl";
                    String pluginPomFName = "pom.xml";
                    CodeGenerator pluginPomGen = new CodeGenerator(pluginPomTName, pluginPomParam, templatePath, tenantAppPath, pluginPomFName);
                    pluginPomGen.gen();
                    String pomUrl = absolutePath + this.prefixName + File.separator + "pom.xml";
                    String moduleName = this.pluginPrefix + tenantCode + File.separator + this.pluginPrefix + tenAndApp;
                    this.editPomXml(pomUrl, moduleName);
                }
            }
        }
        logger.warn("\u6587\u4ef6\u6a21\u5757\u751f\u6210\u5931\u8d25");
    }

    private void editPomXml(String pomUrl, String moduleName) {
        logger.info("pomUrl:{}", (Object)pomUrl);
        System.getProperty("java.classpath");
        try (FileReader fis = new FileReader(pomUrl);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)fis);
            List modules = model.getModules();
            if (!modules.contains(moduleName)) {
                modules.add(moduleName);
                model.setModules(modules);
            }
            try (FileWriter writer = new FileWriter(pomUrl);){
                MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                mavenXpp3Writer.write((Writer)writer, model);
            }
        }
        catch (Exception e) {
            logger.info("\u5f80\u6839\u76ee\u5f55\u7684pom\u6587\u4ef6\u4e2d\u52a0\u5165{}\u51fa\u9519:{}}", (Object)moduleName, (Object)e.getMessage());
        }
    }
}

