/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamMemberCommonMapper;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.applicationmix.dao.SysLowCodeAppExtendMapper;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.app.FormDesignAppInfo;
import com.jxdinfo.hussar.formdesign.app.IApp;
import com.jxdinfo.hussar.formdesign.datasource.FormDesignDataSource;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.applicationmix.service.impl.hussarBaseAppMixImpl")
public class HussarBaseAppMixImpl
implements IApp {
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Autowired
    private SysLowCodeAppExtendMapper sysLowCodeAppExtendMapper;
    @Autowired
    private SysAppDevelopTeamCommonMapper sysAppDevelopTeamCommonMapper;
    @Autowired
    private SysAppDevelopTeamMemberCommonMapper sysAppDevelopTeamMemberCommonMapper;

    public FormDesignAppInfo getAppInfo(String appId) {
        MixAppInfoVo info = this.sysLowCodeAppExtendMapper.getMixAppInfo(Long.parseLong(appId));
        if (info == null) {
            return new FormDesignAppInfo();
        }
        FormDesignAppInfo result = new FormDesignAppInfo();
        result.setObjId(String.valueOf(info.getId()));
        result.setName(info.getAppName());
        result.setAppDescribe(info.getAppDescribe());
        result.setEnglishName(info.getAppEnglishName());
        result.setCreateTime(Date.from(info.getCreateTime().atZone(ZoneId.systemDefault()).toInstant()));
        result.setServiceName(info.getServiceName());
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        result.setTenantName(loginUser.getTenantName());
        result.setTenantCode(loginUser.getTenantCode());
        return result;
    }

    public String getDBNameByAppId(String appId) {
        return "";
    }

    public List<FormDesignAppInfo> listAppInfo(String userId) {
        return this.listAppInfoByUserId(Long.valueOf(userId));
    }

    public FormDesignDataSource getDefaultByAppId(String appId) {
        return null;
    }

    public List<FormDesignAppInfo> listAllAppInfo(String userId) {
        return this.listAppInfoByUserId(Long.valueOf(userId));
    }

    private List<FormDesignAppInfo> listAppInfoByUserId(Long userId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("userId", userId);
        ArrayList<String> appTypes = new ArrayList<String>();
        appTypes.add("2");
        queryParams.put("appTypes", appTypes);
        List<MixAppInfoVo> appList = this.sysLowCodeAppExtendMapper.getMixAppList(queryParams);
        if (ToolUtil.isEmpty(appList)) {
            return new ArrayList<FormDesignAppInfo>();
        }
        return this.conversion(appList);
    }

    private List<FormDesignAppInfo> conversion(List<MixAppInfoVo> list) {
        ArrayList<FormDesignAppInfo> result = new ArrayList<FormDesignAppInfo>();
        for (MixAppInfoVo info : list) {
            FormDesignAppInfo appInfo = new FormDesignAppInfo();
            appInfo.setObjId(String.valueOf(info.getId()));
            appInfo.setName(info.getAppName());
            appInfo.setAppDescribe(info.getAppDescribe());
            appInfo.setEnglishName(info.getAppEnglishName());
            appInfo.setCreateTime(Date.from(info.getCreateTime().atZone(ZoneId.systemDefault()).toInstant()));
            SecurityUser loginUser = BaseSecurityUtil.getUser();
            appInfo.setTenantName(loginUser.getTenantName());
            result.add(appInfo);
        }
        return result;
    }
}

