/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.applicationmix.dto.DownloadFilePathDto;
import com.jxdinfo.hussar.applicationmix.model.SysEyImportAppMsg;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.qo.AppMixImportHistoryDataset;
import com.jxdinfo.hussar.applicationmix.service.ISysAppFileService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppMixFileService;
import com.jxdinfo.hussar.applicationmix.service.ISysEyImportAppMixMsgService;
import com.jxdinfo.hussar.applicationmix.service.ISysLowCodeAppExtendService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.external.inducts.InductsTableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/application/appFile"})
public class HussarBaseApplicationMixFileController {
    @Autowired
    private ISysAppFileService appFileService;
    @Autowired
    private ISysLowCodeAppExtendService sysLowCodeAppExtendService;
    @Autowired
    private ISysAppMixFileService isysAppMixFileService;
    @Resource
    private InductsTableService inductsTableService;
    @Resource
    private ISysEyImportAppMixMsgService ISysEyImportAppMixMsgService;

    @GetMapping(value={"/checkExportFile"})
    public Boolean checkExportFile(String tempPath) {
        boolean flag = false;
        if (tempPath == null) {
            return flag;
        }
        File file = new File(tempPath);
        if (file.exists()) {
            flag = true;
        }
        return flag;
    }

    @PostMapping(value={"/download"})
    public void downloadFile(HttpServletResponse response) {
        String appId = HttpKit.getRequest().getParameter("appId") == null ? "" : HttpKit.getRequest().getParameter("appId");
        String importType = HttpKit.getRequest().getParameter("type") == null ? "" : HttpKit.getRequest().getParameter("type");
        this.appFileService.downloadFile(appId, importType, response);
    }

    @PostMapping(value={"/downloadOffline"})
    public void downloadOffline(HttpServletResponse response, @RequestBody DownloadFilePathDto downloadFilePathDto) {
        this.appFileService.downloadOffline(downloadFilePathDto.getTempPath(), downloadFilePathDto.getFilePath(), response);
    }

    @PostMapping(value={"/importApp"})
    public ApiResponse<Object> importApp(MultipartFile file, Long appId, String type) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.sysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        AppContextUtil.setAppId((String)appId.toString());
        if (ToolUtil.isEmpty((Object)appInfo)) {
            return ApiResponse.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        try {
            Map data = this.appFileService.importApp(file, appId, type);
            boolean flag = (Boolean)data.get("status");
            if (flag) {
                return ApiResponse.success((Object)data);
            }
            return ApiResponse.fail((String)data.get("msg").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5e94\u7528\u5bfc\u5165\u5931\u8d25");
        }
    }

    @PostMapping(value={"/executeSql"})
    public ApiResponse<Object> executeSql(@RequestBody Map<String, Object> map) {
        String sql = map.get("sql").toString();
        if (ToolUtil.isNotEmpty((Object)sql)) {
            this.inductsTableService.executeSql(sql);
            return ApiResponse.success((String)"sql\u6267\u884c\u6210\u529f");
        }
        return ApiResponse.fail((String)"sql\u6267\u884c\u5931\u8d25");
    }

    @PostMapping(value={"/importProduceApp"})
    public ApiResponse<Object> importProduceApp(MultipartFile file, Long appId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)appId);
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.sysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        AppContextUtil.setAppId((String)appId.toString());
        if (ToolUtil.isEmpty((Object)appInfo)) {
            return ApiResponse.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        try {
            Map data = this.appFileService.importProduceApp(file, appId);
            boolean flag = (Boolean)data.get("status");
            if (flag) {
                return ApiResponse.success((Object)data);
            }
            return ApiResponse.fail((String)data.get("msg").toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5e94\u7528\u5bfc\u5165\u5931\u8d25");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/compileList"})
    public ApiResponse<Object> compileList(@RequestBody Map<String, Object> body) {
        String page = body.get("current") == null ? null : body.get("current").toString();
        String limit = body.get("size") == null ? null : body.get("size").toString();
        Object result = this.appFileService.getCompileList(page, limit, body);
        return ApiResponse.success((Object)result);
    }

    @PostMapping(value={"/checkExportStatus"})
    public ApiResponse<Object> checkExportStatus(@RequestBody Map<String, Object> map) {
        String ids = map.get("ids").toString();
        if (ToolUtil.isEmpty((Object)ids)) {
            return ApiResponse.fail((String)"\u5e94\u7528id\u96c6\u5408\u548c\u5bfc\u51fa\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.isysAppMixFileService.getExportInfo(ids.split(",")));
    }

    @PostMapping(value={"/beforeImportAndCompile"})
    public ApiResponse<Object> beforeImportAndCompile(@RequestBody Map<String, Object> map) {
        Long compileId;
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean importMsgFlag = false;
        String tempPath = ToolUtil.isNotEmpty((Object)map.get("tempPath")) ? map.get("tempPath").toString() : "";
        Long appId = Long.parseLong(ToolUtil.isNotEmpty((Object)map.get("appId")) ? map.get("appId").toString() : null);
        String appName = ToolUtil.isNotEmpty((Object)map.get("appName")) ? map.get("appName").toString() : "";
        String sql = ToolUtil.isNotEmpty((Object)map.get("sql")) ? map.get("sql").toString() : "";
        String keys = ToolUtil.isNotEmpty((Object)map.get("keys")) ? map.get("keys").toString() : "";
        String serverCode = ToolUtil.isNotEmpty((Object)map.get("tenantCode")) ? map.get("tenantCode").toString() : user.getTenantCode();
        boolean saveTempPathFileFlag = this.appFileService.saveTempPathFile(appId, serverCode, tempPath, (compileId = this.appFileService.addWaitingCompileTask(appId)).toString());
        if (saveTempPathFileFlag) {
            File temp = new File(tempPath);
            if (ToolUtil.isNotEmpty((Object)temp) && temp.exists()) {
                try {
                    FileUtils.forceDelete((File)temp);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            SysEyImportAppMsg appImportMsg = new SysEyImportAppMsg();
            appImportMsg.setId(compileId);
            appImportMsg.setAppId(appId);
            appImportMsg.setImportAppName(appName);
            appImportMsg.setImportMsgSql(sql);
            appImportMsg.setImportMsgKeys(keys);
            appImportMsg.setServerCode(serverCode);
            appImportMsg.setImportStartTime(new Date());
            appImportMsg.setImportStatus("0");
            appImportMsg.setLoadFlag("0");
            appImportMsg.setImportUserId(user.getId());
            appImportMsg.setImportUserName(user.getUserName());
            appImportMsg.setServerName(user.getTenantName());
            importMsgFlag = this.appFileService.saveImportMsgToTable(appImportMsg);
        }
        return ApiResponse.status((boolean)importMsgFlag);
    }

    @RequestMapping(value={"/queueMsgList"})
    public ApiResponse<Object> getQueueMsgList() {
        Object result = this.appFileService.getQueueMsgList();
        return ApiResponse.success((Object)result);
    }

    @PostMapping(value={"/queryImportHistory"})
    public ApiResponse<Map<String, Object>> queryImportHistory(@RequestBody AppMixImportHistoryDataset appMixImportHistoryDataSet) {
        return this.appFileService.queryImportHistory(appMixImportHistoryDataSet);
    }

    @PostMapping(value={"/getSyncingImportStatus"})
    public Object getSyncingImportStatus(@RequestParam(value="compileId") Long compileId) {
        return this.ISysEyImportAppMixMsgService.getSyncingImportStatus(compileId);
    }
}

