/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.dto.UserAppDevEnvDto;
import com.jxdinfo.hussar.application.dto.UserAppEnvDto;
import com.jxdinfo.hussar.application.dto.UserDevEnvDto;
import com.jxdinfo.hussar.application.model.UserDevEnv;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.service.IUserDevEnvService;
import com.jxdinfo.hussar.application.service.IUserEnvPortService;
import com.jxdinfo.hussar.application.vo.HussarApplicationVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.deploy.service.IHussarDeployService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/application/userDevEnv"})
public class UserDevEnvController
extends HussarBaseController<UserDevEnv, IUserDevEnvService> {
    @Resource
    private IUserDevEnvService userDevEnvService;
    @Resource
    private IHussarDeployService hussarDeployService;
    @Resource
    private IUserEnvPortService userEnvPortService;
    @Resource
    private IUserEnvPortService iUserEnvPortService;
    @Resource
    private ISysApplicationService applicationService;

    @GetMapping(value={"/addAppDropdown"})
    public ApiResponse<List<HussarApplicationVo>> addAppDropdown() {
        return ApiResponse.success((Object)this.userDevEnvService.addAppDropdown());
    }

    @GetMapping(value={"/initEnv"})
    public ApiResponse<String> initEnv() throws Exception {
        return this.userDevEnvService.initEnv();
    }

    @PostMapping(value={"/addAppToEnv"})
    public ApiResponse<String> addAppToEnv(@RequestBody List<UserAppEnvDto> userAppEnvList) throws Exception {
        return this.userDevEnvService.addAppToEnv(userAppEnvList);
    }

    @GetMapping(value={"/delAppFromEnv"})
    public ApiResponse<String> delAppFromEnv(@RequestParam(value="envId") String id) throws Exception {
        return this.userDevEnvService.delAppFromEnv(id);
    }

    @GetMapping(value={"getList"})
    public ApiResponse<Page<UserDevEnvDto>> getList(@RequestParam(value="current") Integer current, @RequestParam(value="size") Integer size) {
        return ApiResponse.success((Object)this.userDevEnvService.getList(current, size));
    }

    @GetMapping(value={"gitOperation"})
    public ApiResponse<String> gitOperation(@RequestParam(value="type") Integer type) throws Exception {
        return this.userDevEnvService.gitOperation(type);
    }

    @GetMapping(value={"startEnv"})
    public ApiResponse<Boolean> startEnv() {
        return this.userDevEnvService.startEnv();
    }

    @GetMapping(value={"stopEnv"})
    public ApiResponse<Boolean> stopEnv() {
        return this.userDevEnvService.stopEnv();
    }

    @GetMapping(value={"restartEnv"})
    public ApiResponse<Boolean> restartEnv() {
        return this.userDevEnvService.restartEnv();
    }

    @GetMapping(value={"getEnvStatus"})
    public ApiResponse<String> getEnvStatus(@RequestParam(value="tenantCode", required=false) String tenantCode) {
        return this.userDevEnvService.getEnvStatus(tenantCode);
    }

    @GetMapping(value={"isInit"})
    public ApiResponse<Boolean> isInit() {
        return this.userDevEnvService.isInit();
    }

    @GetMapping(value={"getIfEnvIp"})
    public ApiResponse<String> getIfEnvIp(@RequestParam(value="userId") Long userId) {
        return ApiResponse.success((Object)this.userDevEnvService.getIfEnvIp(userId), (String)TranslateUtil.getTranslateName((String)"USER_ENV_GET_STATUS", (String)"\u83b7\u53d6\u5f00\u5173\u72b6\u6001\u6210\u529f"));
    }

    @PostMapping(value={"changeIfEnvIp"})
    public ApiResponse<Boolean> changeIfEnvIp(@RequestBody UserAppDevEnvDto userAppDevEnvDto) {
        return ApiResponse.success((Object)this.userDevEnvService.changeIfEnvIp(userAppDevEnvDto), (String)TranslateUtil.getTranslateName((String)"USER_ENV_CHANGE_METHOD", (String)"\u4fee\u6539\u5f00\u53d1\u65b9\u5f0f\u6210\u529f"));
    }

    @GetMapping(value={"getUserDevEnvIp"})
    public ApiResponse<String> getUserDevEnvIp(@RequestParam(value="userId") Long userId) {
        return ApiResponse.success((Object)this.userDevEnvService.getUserDevEnvIp(userId), (String)TranslateUtil.getTranslateName((String)"USER_ENV_GET_CERTAIN_IP", (String)"\u83b7\u53d6\u6307\u5b9aIP\u6210\u529f"));
    }

    @PostMapping(value={"changeUserDevEnvIp"})
    public ApiResponse<Boolean> changeUserDevEnvIp(@RequestBody UserDevEnvDto userDevEnvDto) {
        return ApiResponse.success((Object)this.userDevEnvService.changeUserDevEnvIp(userDevEnvDto), (String)TranslateUtil.getTranslateName((String)"USER_ENV_EDIT_CERTAIN_IP", (String)"\u4fee\u6539\u6307\u5b9aIP\u6210\u529f"));
    }

    private void putEnvCache(String val) {
        HussarCacheUtil.put((String)"hussar_application", (Object)("user_env_states" + BaseSecurityUtil.getUser().getUserId()), (Object)val);
    }

    private void getEnvCache() {
        HussarCacheUtil.get((String)"hussar_application", (Object)("user_env_states" + BaseSecurityUtil.getUser().getUserId()));
    }

    @GetMapping(value={"/checkMergeRequest"})
    @AuditLog(moduleName="\u4e2a\u4eba\u73af\u5883", eventDesc="\u6821\u9a8c\u5f53\u524d\u5206\u652f\u662f\u5426\u5b58\u5728\u5408\u5e76\u8bf7\u6c42", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> checkMergeRequest() {
        return this.userDevEnvService.checkMergeRequest();
    }
}

