/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.application.constant.TenantAppConstant;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.model.UserDevEnv;
import com.jxdinfo.hussar.application.properties.HussarTemplateFileProperties;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.application.service.IHussarApplicationService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.IUserDevEnvService;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.impl.SysMenuManageServiceImpl;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.properties.HussarSystemIdProperties;
import com.jxdinfo.hussar.code.plus.model.SysCodeRule;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.deploy.dto.DeployGitDto;
import com.jxdinfo.hussar.deploy.service.IHussarDeployService;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.model.GitDto;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.GitlabUtil;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.tenantLowAppCallBackService")
public class TenantLowAppCallBackServiceImpl
implements IHussarAppCallBackService {
    private static Logger logger = LoggerFactory.getLogger(TenantLowAppCallBackServiceImpl.class);
    private static final String DEPENDENCIES_STR = "dependencies";
    @Resource
    private IHussarApplicationService hussarApplicationService;
    @Resource
    private ISysUserRoleService userRoleService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysResourceMosulesService sysResourceModulesService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private SysMenuManageServiceImpl sysMenuService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private ISysCodeRuleService sysCodeRuleService;
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicTypeService sysDicTypeService;
    @Resource
    private ISysDicSingleService sysDicSingleService;
    @Resource
    private ISysAppDevelopTeamService appDevelopTeamService;
    @Resource
    private ISysAppDevelopTeamMemberService appDevelopTeamMemberService;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private IUserDevEnvService userDevEnvService;
    @Autowired(required=false)
    private IHussarBaseTenantService hussarBaseTenantService;
    @Resource
    private IHussarDeployService hussarDeployService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private HussarTemplateFileProperties templateFileProperties;
    @Resource
    private HussarSystemIdProperties hussarSystemIdProperties;

    public String getAppType() {
        return "20";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApp(SysApplication app) {
        this.hussarApplicationService.createAppGroup(app);
        SysUserRole userRole = new SysUserRole();
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        Long userId = userDetails.getUserId();
        String tenantCode = userDetails.getTenantCode();
        SysUserRole record = (SysUserRole)this.userRoleService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_DEVELOP_ROLE));
        if (HussarUtils.isEmpty((Object)record)) {
            userRole.setUserId(userId);
            userRole.setGrantedRole(TenantConstant.APP_DEVELOP_ROLE);
            userRole.setAdminOption("1");
            userRole.setCreateTime(LocalDateTime.now());
            userRole.setCreator(userId);
            userRole.setLastTime(LocalDateTime.now());
            userRole.setLastEditor(userId);
            this.userRoleService.save((Object)userRole);
        }
        String string = tenantCode;
        synchronized (string) {
            this.hussarApplicationService.pushAppToGit(app);
        }
    }

    public void deleteApp(SysApplication app) {
        String tenantPath = this.templateFileProperties.getTenantPath();
        String branch = this.templateFileProperties.getBranch();
        String templateBack = this.templateFileProperties.getTemplateBack();
        String templateFront = this.templateFileProperties.getTemplateFront();
        String frontStartModule = this.templateFileProperties.getFrontStartModule();
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        SecurityUser user = BaseSecurityUtil.getUser();
        Executor asyncExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        this.deleteAllAppRelatedTableData(app);
        this.deleteTeamMember(app);
        this.userDevEnvService.remove((Wrapper)new LambdaQueryWrapper().eq(UserDevEnv::getAppId, (Object)app.getId()));
        asyncExecutor.execute(() -> {
            HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
            String localRepPath = tenantPath + templateBack;
            localRepPath = localRepPath.replace("{tenantCode}", tenantCode);
            String localRepPathOfApp = localRepPath + File.separator + app.getAppCode();
            String localRepPathOfAppFront = tenantPath + templateFront + File.separator + "apps" + File.separator + app.getAppCode();
            localRepPathOfAppFront = localRepPathOfAppFront.replace("{tenantCode}", tenantCode);
            String viewJsPath = tenantPath + templateFront + frontStartModule + File.separator + "src" + File.separator + "views" + File.separator + "views.js";
            viewJsPath = viewJsPath.replace("{tenantCode}", tenantCode);
            String pomPath = tenantPath + templateBack + File.separator + "pom.xml";
            pomPath = pomPath.replace("{tenantCode}", tenantCode);
            try {
                this.deleteDirectory(localRepPathOfApp);
                this.deleteDirectory(localRepPathOfAppFront);
                String frontPath = tenantPath + templateFront + frontStartModule + File.separator + TenantAppConstant.PACKAGE_JSON;
                frontPath = frontPath.replace("{tenantCode}", tenantCode);
                try {
                    this.deleteDependencyFromPackageJson(frontPath, app.getAppCode());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.deleteAppView(app.getAppCode(), viewJsPath);
                this.removeDependencyAndModule(app.getAppCode(), pomPath);
                logger.info("Directory deleted successfully.");
            }
            catch (IOException e) {
                logger.error("Failed to delete directory: " + localRepPathOfApp);
                logger.error(e.getMessage());
            }
            GitDto gitDto = new GitDto();
            gitDto.setBranch(branch);
            gitDto.setCommitMsg(TranslateUtil.getTranslateName((String)"APP_LOW_DELETE_APP_UPDATE_DIR", (String)"\u5220\u9664\u5e94\u7528\uff0c\u66f4\u65b0\u76ee\u5f55"));
            gitDto.setPath(tenantPath.replace("{tenantCode}", tenantCode));
            gitDto.setTenantCode(tenantCode);
            HussarTenantDefinition tenantByTenantCode = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
            gitDto.setAccessToken(tenantByTenantCode.getGitToken());
            gitDto.setGitUri(tenantByTenantCode.getGitUrl());
            GitlabUtil.pushToGit((GitDto)gitDto);
            DeployGitDto deployGitDto = new DeployGitDto();
            deployGitDto.setAccessToken(tenant.getGitToken());
            deployGitDto.setGitUri(tenant.getGitUrl());
            deployGitDto.setBranch(user.getAccount());
            deployGitDto.setTenantCode(tenantCode);
            deployGitDto.setUserId(user.getUserId());
            deployGitDto.setAppCode(app.getAppCode());
            deployGitDto.setCommitMsg(TranslateUtil.getTranslateName((String)"APP_LOW_UPDATE_POM_DELETE_DEPENDENCY", (String)"\u66f4\u65b0application\u7684Pom\u6587\u4ef6\uff0c\u5220\u9664\u5e94\u7528\u4f9d\u8d56"));
            try {
                this.hussarDeployService.deleteAppDependenceInPom(deployGitDto);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
    }

    public void beforeDeleteApp(SysApplication app) {
        super.beforeDeleteApp(app);
    }

    public void updateApp(SysApplication app) {
        this.updateAppGroupName(app.getId(), app.getAppName());
        if (HussarUtils.isNotBlank((CharSequence)app.getAppName())) {
            this.userDevEnvService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(UserDevEnv::getAppName, (Object)app.getAppName())).eq(UserDevEnv::getAppId, (Object)app.getId()));
        }
    }

    public void deleteRecycleApp(SysAppRecycle appRecycle) {
        super.deleteRecycleApp(appRecycle);
    }

    public void beforeDeleteRecycleApp(SysAppRecycle appRecycle) {
        super.beforeDeleteRecycleApp(appRecycle);
    }

    public void revertRecycleApp(SysAppRecycle appRecycle) {
        SysApplication sysApplication = new SysApplication();
        sysApplication.setId(appRecycle.getId());
        sysApplication.setAppName(appRecycle.getAppName());
        sysApplication.setAppCode(appRecycle.getAppCode());
        this.hussarApplicationService.createAppGroup(sysApplication);
        if (this.templateFileProperties.getMonolithicArchitecture().booleanValue()) {
            this.hussarApplicationService.pushAppToGit(sysApplication);
        }
        LocalDateTime now = LocalDateTime.now();
        Long appId = appRecycle.getId();
        SysAppDevelopTeam appDevelopTeam = (SysAppDevelopTeam)this.appDevelopTeamService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (null != appDevelopTeam) {
            List teamMemberVos = this.appDevelopTeamMemberService.listAppDevelopTeamMember(appDevelopTeam.getId());
            teamMemberVos.forEach(vo -> {
                List developRole;
                Long userId = vo.getId();
                List appDevelopRole = this.userRoleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_DEVELOP_ROLE));
                if (CollectionUtils.isEmpty((Collection)appDevelopRole)) {
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(userId);
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    sysUserRole.setCreator(userId);
                    sysUserRole.setLastEditor(userId);
                    sysUserRole.setLastTime(now);
                    sysUserRole.setCreateTime(now);
                    sysUserRole.setGrantedRole(TenantConstant.APP_DEVELOP_ROLE);
                    this.sysRolesService.delAuthCacheInfo(userId);
                    this.userRoleService.save((Object)sysUserRole);
                }
                if (CollectionUtils.isEmpty((Collection)(developRole = this.userRoleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.DEVELOP_ROLE.getValue()))))) {
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(userId);
                    sysUserRole.setGrantedRole(SysUserAndRole.DEVELOP_ROLE.getValue());
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    sysUserRole.setCreator(userId);
                    sysUserRole.setLastEditor(userId);
                    sysUserRole.setLastTime(now);
                    sysUserRole.setCreateTime(now);
                    this.sysRolesService.delAuthCacheInfo(userId);
                    this.userRoleService.save((Object)sysUserRole);
                }
            });
        }
    }

    private void deleteAllAppRelatedTableData(SysApplication sysApplication) {
        Long appId = sysApplication.getId();
        List sysResources = this.sysResourcesService.list((Wrapper)new LambdaQueryWrapper().eq(SysResources::getAppId, (Object)appId));
        List resourceIds = sysResources.stream().map(SysResources::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(resourceIds)) {
            this.sysResourcesService.removeByIds(resourceIds);
        }
        this.sysResourceModulesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getAppId, (Object)appId));
        List sysFunctions = this.sysFunctionsService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getAppId, (Object)appId));
        List functionIds = sysFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(functionIds)) {
            this.sysFunctionsService.removeByIds(functionIds);
            this.sysFunctionResourcesService.remove((Wrapper)new LambdaQueryWrapper().in(SysFunctionResources::getFunctionId, functionIds));
            this.sysMenuService.remove((Wrapper)new LambdaQueryWrapper().in(SysMenu::getFunctionId, functionIds));
        }
        List functionModules = this.sysFunctionModulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getAppId, (Object)appId));
        List functionModulesIds = functionModules.stream().map(SysFunctionModules::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty((Object)functionModules)) {
            this.sysFunctionModulesService.removeByIds(functionModulesIds);
            this.sysMenuService.remove((Wrapper)new LambdaQueryWrapper().in(SysMenu::getFunctionModuleId, functionModulesIds));
        }
        this.sysMenuService.deleteMenus(String.valueOf(appId));
        List sysRoles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getAppId, (Object)appId));
        List roleIds = sysRoles.stream().map(SysRoles::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(roleIds)) {
            this.sysRolesService.removeByIds(roleIds);
            this.sysRoleResourceService.remove((Wrapper)new LambdaQueryWrapper().in(SysRoleResource::getRoleId, roleIds));
            this.sysRoleFunctionsService.remove((Wrapper)new LambdaQueryWrapper().in(SysRoleFunctions::getRoleId, roleIds));
        }
        this.sysRoleGroupService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getAppId, (Object)appId));
        this.sysCodeRuleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysCodeRule::getAppId, (Object)appId));
        this.sysDicTypeService.remove((Wrapper)new LambdaQueryWrapper().eq(DicType::getAppId, (Object)appId));
        this.sysDicSingleService.remove((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getAppId, (Object)appId));
        this.dicGroupService.remove((Wrapper)new LambdaQueryWrapper().eq(DicGroup::getAppId, (Object)appId));
    }

    private void deleteTeamMember(SysApplication app) {
        Long appId = app.getId();
        SysAppDevelopTeam appDevelopTeam = (SysAppDevelopTeam)this.appDevelopTeamService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (null != appDevelopTeam) {
            List teamMemberVos = this.appDevelopTeamMemberService.listAppDevelopTeamMember(appDevelopTeam.getId());
            teamMemberVos.forEach(vo -> {
                long count = this.appDevelopTeamMemberService.count((Wrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeamMember::getUserId, (Object)vo.getId()));
                if (count < 2L) {
                    this.userRoleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)vo.getId())).in(SysUserRole::getGrantedRole, new Object[]{TenantConstant.APP_DEVELOP_ROLE}));
                    SysUsers sysUser = this.usersService.getById(vo.getId());
                    if (!"1".equals(sysUser.getIsSys()) && !Objects.equals(this.hussarSystemIdProperties.getOutOrganNodeId(), sysUser.getDepartmentId())) {
                        this.userRoleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)vo.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.DEVELOP_ROLE.getValue()));
                    }
                }
            });
        }
    }

    private void deleteDirectory(String path) throws IOException {
        File directory = new File(path);
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.deleteDirectory(file.getAbsolutePath());
                        continue;
                    }
                    file.delete();
                }
            }
            directory.delete();
        }
    }

    private void deleteDependencyFromPackageJson(String packageJsonFilePath, String appCode) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode root = objectMapper.readTree(new File(packageJsonFilePath));
        JsonNode dependenciesNode = root.get(DEPENDENCIES_STR);
        if (dependenciesNode == null || !dependenciesNode.isObject()) {
            ((ObjectNode)root).put(DEPENDENCIES_STR, (JsonNode)objectMapper.createObjectNode());
            dependenciesNode = root.get(DEPENDENCIES_STR);
        }
        ((ObjectNode)dependenciesNode).remove(appCode);
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(new File(packageJsonFilePath), (Object)root);
    }

    private void deleteAppView(String appCode, String filePath) {
        try {
            List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]));
            List filteredLines = lines.stream().filter(line -> !line.contains(appCode)).collect(Collectors.toList());
            Files.write(Paths.get(filePath, new String[0]), filteredLines, new OpenOption[0]);
            logger.info("File view.js successfully.");
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    private void removeDependencyAndModule(String appCode, String pomPath) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document pomDocument = builder.parse(new File(pomPath));
            NodeList dependencies = pomDocument.getElementsByTagName("dependency");
            for (int i = dependencies.getLength() - 1; i >= 0; --i) {
                Node dependencyNode = dependencies.item(i);
                if (!this.isDependencyForAppCode(dependencyNode, appCode)) continue;
                dependencyNode.getParentNode().removeChild(dependencyNode);
            }
            NodeList modules = pomDocument.getElementsByTagName("module");
            for (int i = modules.getLength() - 1; i >= 0; --i) {
                Node moduleNode = modules.item(i);
                if (!moduleNode.getTextContent().equals(appCode)) continue;
                moduleNode.getParentNode().removeChild(moduleNode);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(pomDocument);
            StreamResult result = new StreamResult(new File(pomPath));
            transformer.transform(source, result);
            logger.info("Removed dependency and module for appCode '" + appCode + "' in pom file at " + pomPath);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new BaseException("Failed to edit pom file", (Throwable)e);
        }
    }

    private boolean isDependencyForAppCode(Node dependencyNode, String appCode) {
        Element dependencyElement = (Element)dependencyNode;
        NodeList artifactIdNodes = dependencyElement.getElementsByTagName("artifactId");
        if (artifactIdNodes.getLength() == 1) {
            Node artifactIdNode = artifactIdNodes.item(0);
            return artifactIdNode.getTextContent().equals(appCode);
        }
        return false;
    }

    private void updateAppGroupName(Long appId, String appName) {
        try {
            this.sysResourceModulesService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysResourceModules::getAppId, (Object)appId)).set(SysResourceModules::getModuleName, (Object)appName));
            this.sysFunctionModulesService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysFunctionModules::getAppId, (Object)appId)).set(SysFunctionModules::getFunctionModuleName, (Object)appName));
            this.dicGroupService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(DicGroup::getAppId, (Object)appId)).set(DicGroup::getGroupDescription, (Object)appName));
            this.sysRoleGroupService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysRoleGroup::getFromAppId, (Object)appId)).set(SysRoleGroup::getGroupName, (Object)appName));
            this.sysMenuService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysMenu::getId, (Object)appId)).set(SysMenu::getText, (Object)appName));
        }
        catch (Exception e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_EDIT_APP_GROUP_NAME_FAIL", (String)"\u4fee\u6539\u5e94\u7528\u5206\u7ec4\u540d\u5931\u8d25"));
        }
    }
}

