/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.tool.aspect;

import com.jxdinfo.hussar.application.tool.annotation.ExportProgressCache;
import com.jxdinfo.hussar.application.tool.annotation.ImportProgressCache;
import com.jxdinfo.hussar.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.mybatis.logging.Logger;
import org.mybatis.logging.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ImportProgressCacheAspect {
    private static Logger logger = LoggerFactory.getLogger(ImportProgressCacheAspect.class);
    public static final String EXPORT_CACHE_NAME = "app_export_Progress";
    public static String EXPORT_CACHE_KEY = "app_export_Progress";
    public static final String IMPORT_CACHE_NAME = "app_import_progress";
    public static String IMPORT_CACHE_KEY = "app_import_progress";

    @Around(value="execution(* *(..)) && @annotation(annotation)", argNames="joinPoint,annotation")
    public Object around(ProceedingJoinPoint joinPoint, ExportProgressCache annotation) throws Throwable {
        Object proceed = joinPoint.proceed();
        long fileId = 0L;
        if (annotation.finish() && proceed instanceof Long) {
            fileId = Long.parseLong(String.valueOf(proceed));
        }
        HussarCacheUtil.put((String)EXPORT_CACHE_NAME, (Object)EXPORT_CACHE_KEY, (Object)ExportStatusVo.put(annotation.status(), annotation.msg(), fileId, false));
        return proceed;
    }

    @AfterThrowing(pointcut="execution(* *(..)) && @annotation(annotation)", throwing="exception")
    public void afterThrowing(ExportProgressCache annotation, Exception exception) {
        HussarCacheUtil.put((String)EXPORT_CACHE_NAME, (Object)EXPORT_CACHE_KEY, (Object)ExportStatusVo.put(annotation.status(), exception.getMessage(), 0L, true));
    }

    @Around(value="execution(* *(..)) && @annotation(annotation)", argNames="joinPoint,annotation")
    public Object around(ProceedingJoinPoint joinPoint, ImportProgressCache annotation) throws Throwable {
        Object proceed = joinPoint.proceed();
        HussarCacheUtil.put((String)IMPORT_CACHE_NAME, (Object)IMPORT_CACHE_KEY, (Object)ImportStatusVo.put(annotation.status(), annotation.msg(), annotation.finish(), false));
        return proceed;
    }

    @AfterThrowing(pointcut="execution(* *(..)) && @annotation(annotation)", throwing="exception")
    public void afterThrowing(ImportProgressCache annotation, Exception exception) {
        HussarCacheUtil.put((String)IMPORT_CACHE_NAME, (Object)IMPORT_CACHE_KEY, (Object)ImportStatusVo.put(annotation.status(), exception.getMessage(), annotation.finish(), true));
    }
}

