/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppGroupCommonMapper;
import com.jxdinfo.hussar.application.dao.SysApplicationCommonMapper;
import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.ApplicationDto;
import com.jxdinfo.hussar.application.dto.SearchAppDto;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.factory.HussarApplicationCallBackFactory;
import com.jxdinfo.hussar.application.factory.HussarApplicationTeamCallBackFactory;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysAppOperationLog;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysAppVisitAuthorization;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysAppVerifyService;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationService;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.AppGroupVo;
import com.jxdinfo.hussar.application.vo.AppResponseVo;
import com.jxdinfo.hussar.application.vo.ApplicationVo;
import com.jxdinfo.hussar.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.application.vo.SysApplicationClientInfoVo;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.client.dto.ClientDto;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientModelService;
import com.jxdinfo.hussar.iam.client.vo.ClientInfoVo;
import com.jxdinfo.hussar.iam.client.vo.ClientVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.SysApplicationServiceImpl")
public class SysApplicationServiceImpl
extends HussarServiceImpl<SysApplicationCommonMapper, SysApplication>
implements ISysApplicationService {
    private static final String TEAMNAME_SUFFIX = "\u5f00\u53d1\u56e2\u961f";
    @Resource
    private SysApplicationCommonMapper sysApplicationCommonMapper;
    @Resource
    private SysAppGroupCommonMapper sysAppGroupCommonMapper;
    @Resource
    private SysAppDevelopTeamCommonMapper developTeamMapper;
    @Autowired
    private ISysIdtableService sysIdTableService;
    @Autowired
    private ISysAppRecycleService sysAppRecycleService;
    @Autowired
    private ISysAppDevelopTeamService developTeamService;
    @Autowired
    private IHussarBaseUserBoService userBoService;
    @Autowired
    private ISysAppClientService sysAppClientService;
    @Autowired
    private ISysAppDevelopTeamMemberService sysAppDevelopTeamMemberService;
    @Autowired
    private ISysAppOperationLogService sysAppOperationLogService;
    @Resource
    private IHussarIamClientModelService iHussarIamClientModelService;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Autowired
    private ISysAppDevelopTeamMemberService appDevelopTeamMemberService;
    @Autowired
    private ISysAppVerifyService appVerifyService;
    @Resource
    private ISysAppVisitAuthorizationService appVisitAuthorizationService;
    @Resource
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private ISysAppDevelopTeamService appDevelopTeamService;
    @Resource
    private ISysAppVisitAuthorizationService sysAppVisitAuthorizationService;

    public List<SysAppGroupVo> getManageAppList(Long appGroupId, String appName, List<String> appTypes) {
        ArrayList appListVo = Lists.newArrayListWithCapacity((int)10);
        SecurityUser user = BaseSecurityUtil.getUser();
        List<SysApplicationVo> appList = null;
        List<Object> sysAppGroups = new ArrayList<SysAppGroup>();
        if (user.isSuperAdmin() || HussarUtils.equals((Object)user.getId(), (Object)SysUserAndRole.SUPERADMIN.getValue()) || this.appVerifyService.isShowAllTenant(user)) {
            appList = this.sysApplicationCommonMapper.getAppListManage(appGroupId, SqlQueryUtil.transferSpecialChar((String)appName), null, appTypes, null);
            LinkedHashSet groupIds = Sets.newLinkedHashSetWithExpectedSize((int)10);
            for (SysApplication sysApplication : appList) {
                groupIds.add(sysApplication.getAppGroupId());
            }
            if (HussarUtils.isNotEmpty((Object)groupIds)) {
                sysAppGroups = this.sysAppGroupCommonMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysAppGroup::getId, (Collection)groupIds));
            }
        } else {
            List appIds = this.developTeamService.selectAppListByCurrentUser();
            if (HussarUtils.isEmpty((Object)appIds)) {
                return Collections.emptyList();
            }
            appList = this.sysApplicationCommonMapper.getAppListManage(appGroupId, SqlQueryUtil.transferSpecialChar((String)appName), appIds, appTypes, null);
            if (HussarUtils.isEmpty(appList)) {
                return Collections.emptyList();
            }
            Set groupIds = appList.stream().map(SysApplication::getAppGroupId).collect(Collectors.toSet());
            sysAppGroups = this.sysAppGroupCommonMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysAppGroup::getId, groupIds));
        }
        this.setUserInfo(appList);
        this.initAppList(appList);
        return this.combinedData(appList, sysAppGroups);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean addApp(SysApplicationDto sysApplicationDto) {
        this.publicSaveApplication(sysApplicationDto);
        return Boolean.TRUE;
    }

    public SysApplicationVo addApplication(SysApplicationDto sysApplicationDto) {
        SysApplicationDto sysApplication = this.publicSaveApplication(sysApplicationDto);
        SysApplicationVo sysApplicationVo = new SysApplicationVo();
        BeanUtil.copy((Object)sysApplication, (Object)sysApplicationVo);
        return sysApplicationVo;
    }

    private SysApplicationDto publicSaveApplication(SysApplicationDto sysApplicationDto) {
        String currentCode;
        List appName = this.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)sysApplicationDto.getAppName()));
        List recycleAppNames = this.sysAppRecycleService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppRecycle::getAppName, (Object)sysApplicationDto.getAppName()));
        if (HussarUtils.isNotEmpty((Object)appName) || HussarUtils.isNotEmpty((Object)recycleAppNames)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        if (HussarUtils.isEmpty((Object)sysApplicationDto.getAppCode())) {
            currentCode = this.getCode();
            sysApplicationDto.setAppCode(currentCode);
        } else {
            currentCode = sysApplicationDto.getAppCode().trim();
            List list = this.sysAppRecycleService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppRecycle::getAppCode, (Object)currentCode));
            Integer codeNum = this.sysApplicationCommonMapper.checkApplicationCode(currentCode);
            if (codeNum > 0 || !list.isEmpty()) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5e94\u7528\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
            }
        }
        ApplicationDto applicationDto = new ApplicationDto();
        BeanUtil.copy((Object)sysApplicationDto, (Object)applicationDto);
        AppResponseVo beforeAddAppResponse = HussarApplicationCallBackFactory.beforeAddApplicationCallback(applicationDto);
        if (!beforeAddAppResponse.getStatus().booleanValue()) {
            throw new BaseException(beforeAddAppResponse.getMessage());
        }
        Long appId = sysApplicationDto.getId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = IdWorker.getId((Object)new SysApplicationDto());
        }
        sysApplicationDto.setId(appId);
        if (HussarUtils.isEmpty((Object)sysApplicationDto.getAppStatus())) {
            sysApplicationDto.setAppStatus("1");
        }
        if (HussarUtils.isEmpty((Object)sysApplicationDto.getReleaseStatus())) {
            sysApplicationDto.setReleaseStatus("0");
        }
        sysApplicationDto.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        Integer seq = this.sysApplicationCommonMapper.getMaxAppSeq();
        seq = HussarUtils.isEmpty((Object)seq) ? 1 : seq + 1;
        sysApplicationDto.setAppSeq(seq);
        if (sysApplicationDto.getOpenClient().booleanValue()) {
            ApiResponse clientInfo = this.iHussarIamClientModelService.getClientInfo();
            ClientDto clientDto = new ClientDto();
            clientDto.setClientSecret(((ClientInfoVo)clientInfo.getData()).getClientSecret());
            clientDto.setAppId(Long.valueOf(1L));
            clientDto.setClientId(((ClientInfoVo)clientInfo.getData()).getClientId());
            clientDto.setAccessTokenValidTime(1800L);
            try {
                ApiResponse response = this.iHussarIamClientModelService.saveClientModels(clientDto);
                ClientVo data = (ClientVo)response.getData();
                SysAppClient appClient = new SysAppClient();
                appClient.setAppId(appId);
                appClient.setClientModelId(data.getId());
                this.sysAppClientService.save((Object)appClient);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String teamName = sysApplicationDto.getAppName() + TEAMNAME_SUFFIX;
        AppDevelopTeamDto developTeamDto = new AppDevelopTeamDto();
        developTeamDto.setAppId(appId);
        developTeamDto.setTeamName(teamName);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            ArrayList<Long> userLists = new ArrayList<Long>();
            userLists.add(sysApplicationDto.getCreator());
            developTeamDto.setUserIds(userLists);
        } else {
            developTeamDto.setUserIds(Arrays.asList(BaseSecurityUtil.getUser().getId()));
        }
        developTeamDto.setOpenTeam(sysApplicationDto.getOpenTeam());
        this.save((BaseEntity)sysApplicationDto);
        this.developTeamService.addAppDevelopTeam(developTeamDto);
        HussarApplicationCallBackFactory.addCallback((SysApplication)sysApplicationDto);
        HussarApplicationTeamCallBackFactory.saveAppDevelopTeam(developTeamDto, sysApplicationDto.getAppType());
        this.sysAppOperationLogService.saveAppOperation(appId, "2");
        HussarCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        return sysApplicationDto;
    }

    @HussarTransactional
    public Boolean updateApp(SysApplicationDto sysApplicationDto) {
        if (!this.appVerifyService.checkPermissions(sysApplicationDto.getId()).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        boolean flag = false;
        SysApplication sysApplication = (SysApplication)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)sysApplicationDto.getId()));
        if (HussarUtils.isEmpty((Object)sysApplication)) {
            return flag;
        }
        if (!Objects.equals(sysApplication.getAppName(), sysApplicationDto.getAppName())) {
            List appName = this.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)sysApplicationDto.getAppName()));
            List recycleAppNames = this.sysAppRecycleService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppRecycle::getAppName, (Object)sysApplicationDto.getAppName()));
            if (HussarUtils.isNotEmpty((Object)appName) || HussarUtils.isNotEmpty((Object)recycleAppNames)) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
        }
        flag = this.updateById((BaseEntity)sysApplicationDto);
        this.sysAppOperationLogService.saveAppOperation(sysApplicationDto.getId(), "2");
        HussarApplicationCallBackFactory.updateApp((SysApplication)sysApplicationDto);
        return flag;
    }

    @HussarTransactional
    public Boolean deleteApp(Long appId) {
        ClientVo client;
        SysAppDevelopTeam developTeamServiceOne;
        SysApplication appInfo = (SysApplication)this.getById(appId);
        HussarApplicationCallBackFactory.beforeDeleteApp(appInfo);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (!(user.isSuperAdmin() || HussarUtils.equals((Object)user.getId(), (Object)SysUserAndRole.SUPERADMIN.getValue()) || this.appVerifyService.isShowAllTenant(user) || this.appVerifyService.checkPermissionForMember((developTeamServiceOne = (SysAppDevelopTeam)this.developTeamService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId))).getId()).booleanValue())) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        SysAppRecycle sysAppRecycle = new SysAppRecycle();
        BeanUtils.copyProperties((Object)appInfo, (Object)sysAppRecycle);
        sysAppRecycle.setDeleteUser(BaseSecurityUtil.getUser().getUserId());
        sysAppRecycle.setCreateUser(BaseSecurityUtil.getUser().getUserId());
        sysAppRecycle.setDeleteTime(LocalDateTime.now());
        this.sysAppRecycleService.save((Object)sysAppRecycle);
        boolean flag = this.removeById(appId);
        SysAppClient appClient = (SysAppClient)this.sysAppClientService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)appClient) && HussarUtils.isNotEmpty((Object)(client = (ClientVo)this.iHussarIamClientModelService.detail(appClient.getClientModelId()).getData()))) {
            this.iHussarIamClientModelService.updateClientStatus(client.getClientId(), "0");
        }
        this.sysAppOperationLogService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysAppOperationLog::getOperationType, (Object)"1")).eq(SysAppOperationLog::getAppId, (Object)appId));
        HussarApplicationCallBackFactory.deleteApp(appInfo);
        return flag;
    }

    @HussarTransactional
    public Boolean deleteAppCascade(Long appId) {
        this.removeById(appId);
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.appDevelopTeamService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)sysAppDevelopTeam)) {
            this.appDevelopTeamMemberService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
            this.appDevelopTeamService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        }
        this.sysAppVisitAuthorizationService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitAuthorization::getAppId, (Object)appId));
        this.sysAppOperationLogService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppOperationLog::getAppId, (Object)appId));
        return Boolean.TRUE;
    }

    public ApiResponse<SysApplicationVo> getAppDetail(Long appId) {
        if (!this.appVerifyService.checkPermissions(appId).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        SysApplicationVo sysApplicationVo = this.sysApplicationCommonMapper.getAppDetail(appId);
        if (HussarUtils.isNotEmpty((Object)sysApplicationVo)) {
            ArrayList<SysApplicationVo> sysApplicationVoList = new ArrayList<SysApplicationVo>();
            sysApplicationVoList.add(sysApplicationVo);
            this.setUserInfo(sysApplicationVoList);
        }
        return ApiResponse.success((Object)sysApplicationVo);
    }

    public ApiResponse<SysApplicationVo> getNoAuthAppDetail(Long appId) {
        return ApiResponse.success((Object)this.sysApplicationCommonMapper.getAppDetail(appId));
    }

    public String getCurrentCode() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    public List<SysApplicationVo> getLastApp(String appTypes) {
        List appIds = this.sysAppOperationLogService.getLastApp();
        if (HussarUtils.isEmpty((Object)appIds)) {
            return Collections.emptyList();
        }
        if (HussarUtils.isEmpty((Object)appIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysApplication::getId, (Collection)appIds);
        if (HussarUtils.isNotEmpty((Object)appTypes)) {
            queryWrapper.in(SysApplication::getAppType, Arrays.asList(appTypes.split(",")));
        }
        List appList = this.list((Wrapper)queryWrapper);
        ArrayList<SysApplicationVo> voList = new ArrayList<SysApplicationVo>();
        block0: for (Long appId : appIds) {
            for (SysApplication application : appList) {
                if (!appId.equals(application.getId())) continue;
                SysApplicationVo vo = new SysApplicationVo();
                BeanUtils.copyProperties((Object)application, (Object)vo);
                voList.add(vo);
                continue block0;
            }
        }
        this.setUserInfo(voList);
        this.initAppList(voList);
        return voList;
    }

    public Page<SysApplicationVo> getManageAppPageList(PageInfo pageInfo, Long appGroupId, String appName, List<String> appTypes) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<Object> appList = new ArrayList();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.isSuperAdmin() || HussarUtils.equals((Object)user.getId(), (Object)SysUserAndRole.SUPERADMIN.getValue()) || this.appVerifyService.isShowAllTenant(user)) {
            appList = this.sysApplicationCommonMapper.getManageAppPageList((Page<SysApplicationVo>)page, appGroupId, SqlQueryUtil.transferSpecialChar((String)appName), null, appTypes);
        } else {
            List appIds = this.developTeamService.selectAppListByCurrentUser();
            if (HussarUtils.isEmpty((Object)appIds)) {
                page.setRecords(appList);
                return page;
            }
            appList = this.sysApplicationCommonMapper.getManageAppPageList((Page<SysApplicationVo>)page, appGroupId, SqlQueryUtil.transferSpecialChar((String)appName), appIds, appTypes);
            if (HussarUtils.isEmpty(appList)) {
                page.setRecords(appList);
                return page;
            }
        }
        this.setUserInfo(appList);
        this.initAppList(appList);
        page.setRecords(appList);
        return page;
    }

    public List<SysApplicationVo> getUserApplications(Long userId) {
        return this.sysApplicationCommonMapper.getUserApplications(userId);
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplicationVo sysApplication : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplicationVo> sysApplicationList = new ArrayList<SysApplicationVo>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<SysAppGroupVo>(resultCollect.values());
    }

    private void setUserInfo(List<SysApplicationVo> appList) {
        if (HussarUtils.isNotEmpty(appList)) {
            List userIdList = appList.stream().map(HussarBaseEntity::getCreator).collect(Collectors.toList());
            Map userMap = this.userBoService.getUserInfo(userIdList);
            for (SysApplicationVo item : appList) {
                SysUsers sysUsers = (SysUsers)userMap.get(item.getCreator());
                if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
                item.setCreateUserName(sysUsers.getUserName());
            }
        }
    }

    private void initAppList(List<SysApplicationVo> appList) {
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Long> appIds = appList.stream().map(SysApplication::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(appIds)) {
            List<SysAppDevelopTeam> sysAppDevelopTeams = this.developTeamMapper.selectAppDevelopTeamList(appIds);
            List teamIds = sysAppDevelopTeams.stream().map(SysAppDevelopTeam::getId).distinct().collect(Collectors.toList());
            List members = this.sysAppDevelopTeamMemberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysAppDevelopTeamMember::getTeamId, teamIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            Map<Long, List<SysAppDevelopTeamMember>> teamMemberMap = members.stream().collect(Collectors.groupingBy(SysAppDevelopTeamMember::getTeamId));
            Map teamUserIdMap = members.stream().collect(Collectors.groupingBy(SysAppDevelopTeamMember::getTeamId, Collectors.mapping(SysAppDevelopTeamMember::getUserId, Collectors.toList())));
            Map sysAppDevelopTeamMap = sysAppDevelopTeams.stream().collect(Collectors.toMap(SysAppDevelopTeam::getAppId, Function.identity()));
            Long currentUserId = user.getId();
            for (SysApplicationVo app : appList) {
                if (!HussarUtils.isNotEmpty(sysAppDevelopTeamMap.get(app.getId()))) continue;
                Long teamId = ((SysAppDevelopTeam)sysAppDevelopTeamMap.get(app.getId())).getId();
                if (user.isSuperAdmin() || HussarUtils.equals((Object)user.getId(), (Object)SysUserAndRole.SUPERADMIN.getValue()) || this.appVerifyService.isShowAllTenant(user)) {
                    app.setMemberType(Integer.valueOf(1));
                } else {
                    List userIds = teamUserIdMap.get(teamId);
                    if (HussarUtils.isNotEmpty(userIds)) {
                        if (userIds.contains(currentUserId)) {
                            List<SysAppDevelopTeamMember> memberList = teamMemberMap.get(teamId);
                            SysAppDevelopTeamMember member = memberList.stream().filter(item -> item.getUserId().equals(currentUserId)).findFirst().get();
                            app.setMemberType(Integer.valueOf(member.getMemberType()));
                        }
                        if ((Long)userIds.get(0) == -1L) {
                            app.setMemberType(Integer.valueOf(1));
                        }
                    }
                }
                app.setTeamId(teamId);
            }
        }
    }

    public Page<SysApplicationVo> getUserAppList(PageInfo pageInfo, String appName) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getId();
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("appName", StringUtils.trimToEmpty((String)appName));
        queryParams.put("userId", userId);
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SysApplicationVo> appList = this.sysApplicationCommonMapper.getUserAppList((Page<SysApplicationVo>)page, queryParams);
        page.setRecords(appList);
        return page;
    }

    public Boolean checkSameAppName(Long appId, String appName) {
        if (HussarUtils.isEmpty((Object)appId)) {
            List list = this.sysApplicationCommonMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)appName));
            if (HussarUtils.isEmpty((Object)list)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        List list = this.sysApplicationCommonMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysApplication::getId, (Object)appId)).eq(SysApplication::getAppName, (Object)appName));
        if (HussarUtils.isEmpty((Object)list)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public ApiResponse<SysApplicationClientInfoVo> getAppDetailClientInfo(Long appId) {
        ArrayList<SysApplicationVo> sysApplicationVoList = new ArrayList<SysApplicationVo>();
        SysApplicationVo sysApplicationVo = this.sysApplicationCommonMapper.getAppDetail(appId);
        sysApplicationVoList.add(sysApplicationVo);
        this.setUserInfo(sysApplicationVoList);
        ClientVo appClientSecret = this.sysApplicationBoService.getAppClientSecret(appId);
        SysApplicationClientInfoVo sysApplicationClientInfoVo = new SysApplicationClientInfoVo();
        BeanUtil.copyProperties((Object)sysApplicationVo, (Object)sysApplicationClientInfoVo);
        if (HussarUtils.isNotEmpty((Object)appClientSecret)) {
            sysApplicationClientInfoVo.setClientId(appClientSecret.getClientId());
            sysApplicationClientInfoVo.setClientSecret(appClientSecret.getClientSecret());
        }
        return ApiResponse.success((Object)sysApplicationClientInfoVo);
    }

    private String getCode() {
        String code = "";
        String fieldName = "APP_CODE";
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper recycleWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        while (currentCount != 0L) {
            lambdaQueryWrapper.clear();
            recycleWrapper.clear();
            code = this.sysIdTableService.getCurrentCode(fieldName, "SYS_APPLICATION");
            lambdaQueryWrapper.eq(SysApplication::getAppCode, (Object)code);
            Long appCount = this.sysApplicationCommonMapper.selectCount((Wrapper)lambdaQueryWrapper);
            recycleWrapper.eq(SysAppRecycle::getAppCode, (Object)code);
            Long appRecycleCount = this.sysAppRecycleService.count((Wrapper)recycleWrapper);
            currentCount = appCount + appRecycleCount;
        }
        return code;
    }

    public Long saveApp(ApplicationDto applicationDto) {
        String appType = applicationDto.getAppType();
        if (HussarUtils.isBlank((CharSequence)appType)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5e94\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        long appName = this.count((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)applicationDto.getAppName()));
        long recycleAppNames = this.sysAppRecycleService.count((Wrapper)new LambdaQueryWrapper().eq(SysAppRecycle::getAppName, (Object)applicationDto.getAppName()));
        if (appName > 0L || recycleAppNames > 0L) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        if (HussarUtils.isEmpty((Object)applicationDto.getAppCode())) {
            applicationDto.setAppCode(IdWorker.getIdStr((Object)new ApplicationDto()));
        } else {
            String currentCode = applicationDto.getAppCode().trim();
            long recycleCode = this.sysAppRecycleService.count((Wrapper)new LambdaQueryWrapper().eq(SysAppRecycle::getAppCode, (Object)currentCode));
            Integer codeNum = this.sysApplicationCommonMapper.checkApplicationCode(currentCode);
            if (codeNum > 0 || recycleCode > 0L) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5e94\u7528\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
            }
        }
        AppResponseVo beforeAddAppResponse = HussarApplicationCallBackFactory.beforeAddApplicationCallback(applicationDto);
        if (!beforeAddAppResponse.getStatus().booleanValue()) {
            throw new BaseException(beforeAddAppResponse.getMessage());
        }
        Long appId = applicationDto.getId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = IdWorker.getId((Object)new SysApplicationDto());
        }
        applicationDto.setId(appId);
        if (HussarUtils.isEmpty((Object)applicationDto.getAppStatus())) {
            applicationDto.setAppStatus("1");
        }
        if (HussarUtils.isEmpty((Object)applicationDto.getReleaseStatus())) {
            applicationDto.setReleaseStatus("0");
        }
        applicationDto.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        Integer seq = this.sysApplicationCommonMapper.getMaxAppSeq();
        seq = HussarUtils.isEmpty((Object)seq) ? 1 : seq + 1;
        applicationDto.setAppSeq(seq);
        if (applicationDto.getOpenClient().booleanValue()) {
            ApiResponse clientInfo = this.iHussarIamClientModelService.getClientInfo();
            ClientDto clientDto = new ClientDto();
            clientDto.setClientSecret(((ClientInfoVo)clientInfo.getData()).getClientSecret());
            clientDto.setAppId(Long.valueOf(1L));
            clientDto.setClientId(((ClientInfoVo)clientInfo.getData()).getClientId());
            clientDto.setAccessTokenValidTime(1800L);
            try {
                ApiResponse response = this.iHussarIamClientModelService.saveClientModels(clientDto);
                ClientVo data = (ClientVo)response.getData();
                SysAppClient appClient = new SysAppClient();
                appClient.setAppId(appId);
                appClient.setClientModelId(data.getId());
                this.sysAppClientService.save((Object)appClient);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String teamName = applicationDto.getAppName() + TEAMNAME_SUFFIX;
        AppDevelopTeamDto developTeamDto = new AppDevelopTeamDto();
        developTeamDto.setAppId(appId);
        developTeamDto.setTeamName(teamName);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            ArrayList<Long> userLists = new ArrayList<Long>();
            userLists.add(applicationDto.getCreator());
            developTeamDto.setUserIds(userLists);
        } else {
            developTeamDto.setUserIds(Arrays.asList(BaseSecurityUtil.getUser().getId()));
        }
        developTeamDto.setOpenTeam(applicationDto.getOpenTeam());
        this.save((BaseEntity)applicationDto);
        developTeamDto.setAppType(appType);
        this.developTeamService.saveAppTeam(developTeamDto);
        HussarApplicationCallBackFactory.addCallback((SysApplication)applicationDto);
        HussarCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        List appAuthorList = applicationDto.getAppAuthorList();
        this.appVisitAuthorizationService.addAppAuthorization(applicationDto.getAuthorType(), appId, appAuthorList, appType);
        this.sysAppOperationLogService.saveAppOperation(appId, "2");
        return appId;
    }

    public ApiResponse<ApplicationVo> getAppInfo(Long appId) {
        List list;
        ApplicationVo applicationVo = new ApplicationVo();
        ArrayList<SysApplicationVo> sysApplicationVoList = new ArrayList<SysApplicationVo>();
        SysApplicationVo sysApplicationVo = this.sysApplicationCommonMapper.getAppInfo(appId);
        if (HussarUtils.isEmpty((Object)sysApplicationVo)) {
            return ApiResponse.success((Object)applicationVo);
        }
        sysApplicationVoList.add(sysApplicationVo);
        this.setUserInfo(sysApplicationVoList);
        ClientVo appClientSecret = this.sysApplicationBoService.getAppClientSecret(appId);
        BeanUtil.copyProperties((Object)sysApplicationVo, (Object)applicationVo);
        if (HussarUtils.isNotEmpty((Object)appClientSecret)) {
            applicationVo.setClientId(appClientSecret.getClientId());
            applicationVo.setClientSecret(appClientSecret.getClientSecret());
        }
        if (HussarUtils.isEmpty((Object)(list = this.appVisitAuthorizationService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitAuthorization::getAppId, (Object)appId))))) {
            applicationVo.setAuthorType("1");
        } else {
            List typeList = list.stream().map(SysAppVisitAuthorization::getAuthorizationType).collect(Collectors.toList());
            String type = typeList.contains("5") ? "0" : "1";
            applicationVo.setAuthorType(type);
        }
        return ApiResponse.success((Object)applicationVo);
    }

    @HussarTransactional
    public Boolean editApp(ApplicationDto applicationDto) {
        LambdaQueryWrapper queryWrapper;
        this.updateApp((SysApplicationDto)applicationDto);
        Long appId = applicationDto.getId();
        List appAuthorList = applicationDto.getAppAuthorList();
        String type = applicationDto.getAuthorType();
        if ("0".equals(type)) {
            queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(SysAppVisitAuthorization::getAppId, (Object)appId)).eq(SysAppVisitAuthorization::getAuthorizationType, (Object)"5");
            this.appVisitAuthorizationService.remove((Wrapper)queryWrapper);
            this.appVisitAuthorizationService.addAppAuthorization(type, appId, appAuthorList, applicationDto.getAppType());
        }
        if ("1".equals(type) && HussarUtils.isNotEmpty((Object)appAuthorList)) {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysAppVisitAuthorization::getAppId, (Object)appId);
            this.appVisitAuthorizationService.remove((Wrapper)queryWrapper);
            this.appVisitAuthorizationService.addAppAuthorization(type, appId, appAuthorList, applicationDto.getAppType());
        }
        return Boolean.TRUE;
    }

    @HussarTransactional
    public Boolean sortApp(List<Long> idList) {
        if (HussarUtils.isEmpty(idList)) {
            return Boolean.FALSE;
        }
        ArrayList<SysApplication> list = new ArrayList<SysApplication>();
        int num = 1;
        for (Long appId : idList) {
            SysApplication app = new SysApplication();
            app.setId(appId);
            app.setAppSeq(Integer.valueOf(num));
            list.add(app);
            ++num;
        }
        return super.updateBatchById(list);
    }

    public List<AppGroupVo> getManageApplicationList(SearchAppDto searchAppDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("appName", SqlQueryUtil.transferSpecialChar((String)StringUtils.trimToEmpty((String)searchAppDto.getAppName())));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("appGroupId", searchAppDto.getAppGroupId());
        queryParams.put("appTypes", searchAppDto.getAppTypes());
        if (!"2".equals(searchAppDto.getAppStatus())) {
            queryParams.put("appStatus", searchAppDto.getAppStatus());
        } else {
            queryParams.put("appStatus", null);
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List<ApplicationVo> finalApp = null;
        Set<Object> groupIds = new HashSet();
        if (user.isSuperAdmin() || this.appVerifyService.isShowAllTenant(user)) {
            List<SysApplicationVo> appList = null;
            boolean selectAppFlag = true;
            if (!"0".equals(searchAppDto.getVisibleType())) {
                List appIds = this.developTeamService.selectAppListByCurrentUserByVisibleType(searchAppDto.getVisibleType());
                if (HussarUtils.isEmpty((Object)appIds)) {
                    selectAppFlag = false;
                }
                queryParams.put("appIds", appIds);
            } else {
                queryParams.put("appIds", null);
            }
            if (selectAppFlag) {
                appList = this.sysApplicationCommonMapper.getAppList(queryParams);
            }
            if (HussarUtils.isNotEmpty(appList)) {
                finalApp = this.getFinalApp(searchAppDto, appList);
            }
        } else {
            List<SysApplicationVo> appList = null;
            List appIds = this.developTeamService.selectAppListByCurrentUserByVisibleType(searchAppDto.getVisibleType());
            if (!searchAppDto.getShowAllGroup().booleanValue() && HussarUtils.isEmpty((Object)appIds)) {
                return Collections.emptyList();
            }
            if (HussarUtils.isNotEmpty((Object)appIds)) {
                queryParams.put("appIds", appIds);
                appList = this.sysApplicationCommonMapper.getAppList(queryParams);
            }
            if (!searchAppDto.getShowAllGroup().booleanValue() && HussarUtils.isEmpty(appList)) {
                return Collections.emptyList();
            }
            if (HussarUtils.isNotEmpty(appList)) {
                finalApp = this.getFinalApp(searchAppDto, appList);
            }
            if (!searchAppDto.getShowAllGroup().booleanValue() && HussarUtils.isNotEmpty(finalApp)) {
                groupIds = finalApp.stream().map(SysApplication::getAppGroupId).collect(Collectors.toSet());
            }
        }
        List sysAppGroups = this.sysAppGroupCommonMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(HussarUtils.isNotEmpty(groupIds), SysAppGroup::getId, groupIds)).orderByAsc(SysAppGroup::getSEQ)).orderByAsc(HussarBaseEntity::getCreateTime));
        return this.combinedDataNew(finalApp, sysAppGroups);
    }

    @HussarTransactional
    public Boolean sortGroupAndApp(List<SysAppGroupVo> appGroupVos) {
        if (HussarUtils.isEmpty(appGroupVos)) {
            return Boolean.FALSE;
        }
        ArrayList<Long> groupIdList = new ArrayList<Long>();
        ArrayList<SysApplicationVo> appList = new ArrayList<SysApplicationVo>();
        for (SysAppGroupVo appGroupVo : appGroupVos) {
            Long groupId = appGroupVo.getId();
            groupIdList.add(groupId);
            List applicationList = appGroupVo.getSysApplicationList();
            if (!HussarUtils.isNotEmpty((Object)applicationList)) continue;
            for (SysApplicationVo vo : applicationList) {
                vo.setAppGroupId(groupId);
                appList.add(vo);
            }
        }
        this.sysAppGroupService.sortGroup(groupIdList);
        if (HussarUtils.isNotEmpty(appList)) {
            this.sortUpdateApp(appList);
        }
        return Boolean.TRUE;
    }

    public ApiResponse<SysApplicationVo> getAppDetailByAppCode(String appCode) {
        SysApplicationVo sysApplicationVo = this.sysApplicationCommonMapper.getAppDetailByAppCode(appCode);
        if (HussarUtils.isNotEmpty((Object)sysApplicationVo)) {
            ArrayList<SysApplicationVo> sysApplicationVoList = new ArrayList<SysApplicationVo>();
            sysApplicationVoList.add(sysApplicationVo);
            this.setUserInfo(sysApplicationVoList);
        }
        return ApiResponse.success((Object)sysApplicationVo);
    }

    public List<Long> getCurrentAppIds(Long userId) {
        List currentTeamIds = ((LambdaQueryChainWrapper)this.sysAppDevelopTeamMemberService.lambdaQuery().eq(SysAppDevelopTeamMember::getUserId, (Object)userId)).list().stream().map(SysAppDevelopTeamMember::getTeamId).collect(Collectors.toList());
        List<Long> currentAppIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(currentTeamIds)) {
            currentAppIds = ((LambdaQueryChainWrapper)this.appDevelopTeamService.lambdaQuery().in(SysAppDevelopTeam::getId, currentTeamIds)).list().stream().map(SysAppDevelopTeam::getAppId).distinct().collect(Collectors.toList());
        }
        return currentAppIds;
    }

    private void sortUpdateApp(List<SysApplicationVo> appList) {
        if (HussarUtils.isNotEmpty(appList)) {
            ArrayList<SysApplication> list = new ArrayList<SysApplication>();
            int num = 1;
            for (SysApplicationVo vo : appList) {
                SysApplication app = new SysApplication();
                app.setId(vo.getId());
                app.setAppGroupId(vo.getAppGroupId());
                app.setAppSeq(Integer.valueOf(num));
                list.add(app);
                ++num;
            }
            super.updateBatchById(list);
        }
    }

    private void setUserInfoNew(List<ApplicationVo> appList) {
        if (HussarUtils.isNotEmpty(appList)) {
            List userIdList = appList.stream().map(HussarBaseEntity::getCreator).collect(Collectors.toList());
            Map userMap = this.userBoService.getUserInfo(userIdList);
            for (ApplicationVo item : appList) {
                SysUsers sysUsers = (SysUsers)userMap.get(item.getCreator());
                if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
                item.setCreateUserName(sysUsers.getUserName());
            }
        }
    }

    private List<AppGroupVo> combinedDataNew(List<ApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), AppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, appGroupVo -> appGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        if (HussarUtils.isEmpty(appList)) {
            return new ArrayList<AppGroupVo>(resultCollect.values());
        }
        for (ApplicationVo sysApplication : appList) {
            AppGroupVo sysAppGroupVo = (AppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo.getSysApplicationList())) {
                sysAppGroupVo.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo.getSysApplicationList())) continue;
            ArrayList<ApplicationVo> sysApplicationList = new ArrayList<ApplicationVo>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<AppGroupVo>(resultCollect.values());
    }

    private void initAppListNew(List<ApplicationVo> appList) {
        if (HussarUtils.isEmpty(appList)) {
            return;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Long> appIds = appList.stream().map(SysApplication::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(appIds)) {
            List<SysAppDevelopTeam> sysAppDevelopTeams = this.developTeamMapper.selectAppDevelopTeamList(appIds);
            List teamIds = sysAppDevelopTeams.stream().map(SysAppDevelopTeam::getId).distinct().collect(Collectors.toList());
            List members = this.sysAppDevelopTeamMemberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysAppDevelopTeamMember::getTeamId, teamIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            Map<Long, List<SysAppDevelopTeamMember>> teamMemberMap = members.stream().collect(Collectors.groupingBy(SysAppDevelopTeamMember::getTeamId));
            Map teamUserIdMap = members.stream().collect(Collectors.groupingBy(SysAppDevelopTeamMember::getTeamId, Collectors.mapping(SysAppDevelopTeamMember::getUserId, Collectors.toList())));
            Map sysAppDevelopTeamMap = sysAppDevelopTeams.stream().collect(Collectors.toMap(SysAppDevelopTeam::getAppId, Function.identity()));
            Long currentUserId = user.getId();
            for (ApplicationVo app : appList) {
                if (!HussarUtils.isNotEmpty(sysAppDevelopTeamMap.get(app.getId()))) continue;
                Long teamId = ((SysAppDevelopTeam)sysAppDevelopTeamMap.get(app.getId())).getId();
                if (user.isSuperAdmin() || this.appVerifyService.isShowAllTenant(user)) {
                    app.setMemberType(Integer.valueOf(1));
                } else {
                    List userIds = teamUserIdMap.get(teamId);
                    if (HussarUtils.isNotEmpty(userIds)) {
                        if (userIds.contains(currentUserId)) {
                            List<SysAppDevelopTeamMember> memberList = teamMemberMap.get(teamId);
                            SysAppDevelopTeamMember member = memberList.stream().filter(item -> item.getUserId().equals(currentUserId)).findFirst().get();
                            app.setMemberType(Integer.valueOf(member.getMemberType()));
                        }
                        if ((Long)userIds.get(0) == -1L) {
                            app.setMemberType(Integer.valueOf(1));
                        }
                    }
                }
                app.setTeamId(teamId);
            }
        }
    }

    private List<ApplicationVo> getFinalApp(SearchAppDto searchAppDto, List<SysApplicationVo> appList) {
        String authorType = searchAppDto.getAuthorType();
        Map appMap = appList.stream().collect(Collectors.toMap(SysApplication::getId, Function.identity()));
        List appIds = appList.stream().map(SysApplication::getId).distinct().collect(Collectors.toList());
        List list = this.appVisitAuthorizationService.list((Wrapper)new LambdaQueryWrapper().in(SysAppVisitAuthorization::getAppId, appIds));
        Map<Long, List<SysAppVisitAuthorization>> authorizationMap = list.stream().collect(Collectors.groupingBy(SysAppVisitAuthorization::getAppId));
        List<ApplicationVo> result = appIds.parallelStream().map(appId -> {
            SysApplicationVo vo = (SysApplicationVo)appMap.get(appId);
            List authorizationList = (List)authorizationMap.get(appId);
            String type = "1";
            if (authorizationList != null && authorizationList.stream().anyMatch(auth -> "5".equals(auth.getAuthorizationType()))) {
                type = "0";
            }
            if ("2".equals(authorType) || type.equals(authorType)) {
                ApplicationVo applicationVo = new ApplicationVo();
                BeanUtils.copyProperties((Object)vo, (Object)applicationVo);
                applicationVo.setAuthorType("2".equals(authorType) ? type : authorType);
                return applicationVo;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return result;
    }
}

