/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.AppTeamDto;
import com.jxdinfo.hussar.application.dto.RemoveMemberDto;
import com.jxdinfo.hussar.application.dto.TransferMemberTypeDto;
import com.jxdinfo.hussar.application.dto.UpdateMemberTypeDto;
import com.jxdinfo.hussar.application.factory.HussarApplicationTeamCallBackFactory;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysAppVerifyService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.AppDevelopTeamDetailVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.sysAppDevelopTeamServiceImpl")
public class SysAppDevelopTeamServiceImpl
extends HussarServiceImpl<SysAppDevelopTeamCommonMapper, SysAppDevelopTeam>
implements ISysAppDevelopTeamService {
    @Autowired
    private ISysAppDevelopTeamMemberService appDevelopTeamMemberService;
    @Resource
    private SysAppDevelopTeamCommonMapper sysAppDevelopTeamCommonMapper;
    @Autowired
    private ISysAppOperationLogService sysAppOperationLogService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Autowired
    private ISysAppVerifyService appVerifyService;

    @HussarTransactional
    public Boolean saveAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appDevelopTeamDto, (Object)sysAppDevelopTeam);
        long id = IdWorker.getId((Object)sysAppDevelopTeam);
        List userIds = appDevelopTeamDto.getUserIds();
        if (appDevelopTeamDto.getOpenTeam().booleanValue()) {
            if (HussarUtils.isNotEmpty((Object)userIds)) {
                userIds = userIds.stream().distinct().collect(Collectors.toList());
                ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
                for (Long userId : userIds) {
                    SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                    member.setTeamId(Long.valueOf(id));
                    member.setUserId(userId);
                    member.setMemberType("1");
                    memberList.add(member);
                }
                this.appDevelopTeamMemberService.saveBatch(memberList);
            }
        } else {
            SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
            member.setTeamId(Long.valueOf(id));
            member.setUserId(Long.valueOf(-1L));
            member.setMemberType("1");
            this.appDevelopTeamMemberService.save((Object)member);
        }
        sysAppDevelopTeam.setId(Long.valueOf(id));
        Boolean result = this.save((BaseEntity)sysAppDevelopTeam);
        String appType = ((SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)appDevelopTeamDto.getAppId()))).getAppType();
        HussarApplicationTeamCallBackFactory.saveAppDevelopTeam(appDevelopTeamDto, appType);
        return result;
    }

    @HussarTransactional
    public Boolean addAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appDevelopTeamDto, (Object)sysAppDevelopTeam);
        long id = IdWorker.getId((Object)sysAppDevelopTeam);
        List userIds = appDevelopTeamDto.getUserIds();
        if (appDevelopTeamDto.getOpenTeam().booleanValue()) {
            if (HussarUtils.isNotEmpty((Object)userIds)) {
                userIds = userIds.stream().distinct().collect(Collectors.toList());
                ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
                for (Long userId : userIds) {
                    SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                    member.setTeamId(Long.valueOf(id));
                    member.setUserId(userId);
                    member.setMemberType("1");
                    memberList.add(member);
                }
                this.appDevelopTeamMemberService.saveBatch(memberList);
            }
        } else {
            SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
            member.setTeamId(Long.valueOf(id));
            member.setUserId(Long.valueOf(-1L));
            member.setMemberType("1");
            this.appDevelopTeamMemberService.save((Object)member);
        }
        sysAppDevelopTeam.setId(Long.valueOf(id));
        return this.save((BaseEntity)sysAppDevelopTeam);
    }

    @HussarTransactional
    public Boolean updateAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
        List addUserIds;
        Long teamId = appDevelopTeamDto.getTeamId();
        if (!this.appVerifyService.checkPermissionForMember(teamId).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appDevelopTeamDto, (Object)sysAppDevelopTeam);
        List newUserIds = appDevelopTeamDto.getUserIds();
        if (HussarUtils.isEmpty((Object)newUserIds)) {
            return false;
        }
        List oldUserVoList = this.appDevelopTeamMemberService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId));
        List oldUserIds = oldUserVoList.stream().map(SysAppDevelopTeamMember::getUserId).distinct().collect(Collectors.toList());
        List<Object> delUserIds = new ArrayList();
        if (HussarUtils.isEmpty(oldUserIds)) {
            addUserIds = newUserIds;
        } else {
            addUserIds = newUserIds.stream().filter(item -> !oldUserIds.contains(item)).collect(Collectors.toList());
            delUserIds = oldUserIds.stream().filter(item -> !newUserIds.contains(item)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(delUserIds)) {
            this.appDevelopTeamMemberService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId)).in(SysAppDevelopTeamMember::getUserId, delUserIds));
        }
        if (HussarUtils.isNotEmpty((Object)addUserIds)) {
            ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
            for (Long userId : addUserIds) {
                SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                member.setTeamId(teamId);
                member.setUserId(userId);
                member.setMemberType("0");
                memberList.add(member);
            }
            this.appDevelopTeamMemberService.saveBatch(memberList);
        }
        sysAppDevelopTeam.setId(teamId);
        boolean flag = this.updateById((BaseEntity)sysAppDevelopTeam);
        this.sysAppOperationLogService.saveAppOperation(appDevelopTeamDto.getAppId(), "2");
        String appType = ((SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)appDevelopTeamDto.getAppId()))).getAppType();
        appDevelopTeamDto.setDelUserIds(delUserIds);
        HussarApplicationTeamCallBackFactory.updateAppDevelopTeam(appDevelopTeamDto, appType);
        return flag;
    }

    public ApiResponse<AppDevelopTeamDetailVo> getAppDevelopTeamDetail(Long appId) {
        AppDevelopTeamDetailVo teamDetailVo = new AppDevelopTeamDetailVo();
        SysAppDevelopTeam team = (SysAppDevelopTeam)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)team)) {
            throw new BaseException("\u8be5\u5e94\u7528\u6ca1\u6709\u5e94\u7528\u5f00\u53d1\u56e2\u961f\uff01");
        }
        if (!this.appVerifyService.checkAdministrator(team.getId()).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        BeanUtils.copyProperties((Object)team, (Object)teamDetailVo);
        teamDetailVo.setTeamId(team.getId());
        List userVoList = this.appDevelopTeamMemberService.listAppDevelopTeamMember(team.getId());
        teamDetailVo.setUserList(userVoList);
        return ApiResponse.success((Object)teamDetailVo);
    }

    public List<Long> selectAppListByCurrentUser() {
        Long userId = BaseSecurityUtil.getUser().getId();
        return this.sysAppDevelopTeamCommonMapper.selectAppListByCurrentUser(userId);
    }

    public Boolean checkCurrentUserInTeam(Long appId) {
        List<Long> appIdList = this.selectAppListByCurrentUser();
        return appIdList.contains(appId);
    }

    @HussarTransactional
    public Boolean updateMemberType(UpdateMemberTypeDto updateDto) {
        if (!this.appVerifyService.checkAdministrator(updateDto.getTeamId()).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        return this.editMemberType(updateDto);
    }

    private boolean editMemberType(UpdateMemberTypeDto updateDto) {
        SysAppDevelopTeamMember member = (SysAppDevelopTeamMember)this.appDevelopTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)updateDto.getTeamId())).eq(SysAppDevelopTeamMember::getUserId, (Object)updateDto.getUserId()));
        member.setMemberType(String.valueOf(updateDto.getType()));
        boolean update = this.appDevelopTeamMemberService.updateById((Object)member);
        this.sysAppOperationLogService.saveAppOperation(updateDto.getAppId(), "2");
        String appType = ((SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)updateDto.getAppId()))).getAppType();
        HussarApplicationTeamCallBackFactory.updateMember(updateDto, appType);
        return update;
    }

    @HussarTransactional
    public Boolean transferMemberType(TransferMemberTypeDto transferDto) {
        if (!this.appVerifyService.checkAdministrator(transferDto.getTeamId()).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        SysAppDevelopTeamMember member = (SysAppDevelopTeamMember)this.appDevelopTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)transferDto.getTeamId())).eq(SysAppDevelopTeamMember::getUserId, (Object)transferDto.getTargetUserId()));
        if (member.getMemberType().equals(1)) {
            throw new BaseException("\u76ee\u6807\u7528\u6237\u5df2\u662f\u7ba1\u7406\u5458\uff01");
        }
        member.setMemberType("1");
        boolean update = this.appDevelopTeamMemberService.updateById((Object)member);
        Long userId = BaseSecurityUtil.getUser().getId();
        SysAppDevelopTeamMember teamMember = (SysAppDevelopTeamMember)this.appDevelopTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)transferDto.getTeamId())).eq(SysAppDevelopTeamMember::getUserId, (Object)userId));
        teamMember.setMemberType("0");
        boolean update2 = this.appDevelopTeamMemberService.updateById((Object)teamMember);
        this.sysAppOperationLogService.saveAppOperation(transferDto.getAppId(), "2");
        String appType = ((SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)transferDto.getAppId()))).getAppType();
        HussarApplicationTeamCallBackFactory.transferAdministrator(transferDto, appType);
        return update && update2;
    }

    @HussarTransactional
    public Boolean removeMember(RemoveMemberDto removeMemberDto) {
        if (!this.appVerifyService.checkAdministrator(removeMemberDto.getTeamId()).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        return this.delMember(removeMemberDto);
    }

    private Boolean delMember(RemoveMemberDto removeMemberDto) {
        Boolean result = this.appDevelopTeamMemberService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)removeMemberDto.getTeamId())).eq(SysAppDevelopTeamMember::getUserId, (Object)removeMemberDto.getUserId()));
        String appType = ((SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)removeMemberDto.getAppId()))).getAppType();
        HussarApplicationTeamCallBackFactory.removeMembers(removeMemberDto.getAppId(), removeMemberDto.getUserId(), appType);
        return result;
    }

    @HussarTransactional
    public Boolean editAppTeam(AppTeamDto appTeamDto) {
        Long teamId = appTeamDto.getTeamId();
        if (!this.appVerifyService.checkPermissionForMember(teamId).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appTeamDto, (Object)sysAppDevelopTeam);
        List newUserIds = appTeamDto.getUserIds();
        if (HussarUtils.isEmpty((Object)newUserIds)) {
            return false;
        }
        List oldUserVoList = this.appDevelopTeamMemberService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId));
        List oldUserIds = oldUserVoList.stream().map(SysAppDevelopTeamMember::getUserId).distinct().collect(Collectors.toList());
        ArrayList finalUserIds = new ArrayList();
        finalUserIds.addAll(oldUserIds);
        List addUserIds = HussarUtils.isEmpty(oldUserIds) ? newUserIds : newUserIds.stream().filter(item -> !oldUserIds.contains(item)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty((Object)addUserIds)) {
            ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
            for (Long userId : addUserIds) {
                SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                member.setTeamId(teamId);
                member.setUserId(userId);
                member.setMemberType(String.valueOf(appTeamDto.getMemberType()));
                memberList.add(member);
            }
            this.appDevelopTeamMemberService.saveBatch(memberList);
            finalUserIds.addAll(addUserIds);
        }
        sysAppDevelopTeam.setId(teamId);
        boolean flag = this.updateById((BaseEntity)sysAppDevelopTeam);
        this.sysAppOperationLogService.saveAppOperation(appTeamDto.getAppId(), "2");
        String appType = ((SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)appTeamDto.getAppId()))).getAppType();
        appTeamDto.setUserIds(finalUserIds);
        HussarApplicationTeamCallBackFactory.updateAppDevelopTeam((AppDevelopTeamDto)appTeamDto, appType);
        return Boolean.TRUE;
    }

    @HussarTransactional
    public Boolean updateTeamMemberType(UpdateMemberTypeDto updateMemberTypeDto) {
        if (!this.appVerifyService.checkPermissionForMember(updateMemberTypeDto.getTeamId()).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        return this.editMemberType(updateMemberTypeDto);
    }

    @HussarTransactional
    public Boolean removeTeamMember(RemoveMemberDto removeMemberDto) {
        if (!this.appVerifyService.checkPermissionForMember(removeMemberDto.getTeamId()).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        return this.delMember(removeMemberDto);
    }

    @HussarTransactional
    public Boolean saveAppTeam(AppDevelopTeamDto appDevelopTeamDto) {
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appDevelopTeamDto, (Object)sysAppDevelopTeam);
        long id = IdWorker.getId((Object)sysAppDevelopTeam);
        List userIds = appDevelopTeamDto.getUserIds();
        if (appDevelopTeamDto.getOpenTeam().booleanValue()) {
            if (HussarUtils.isNotEmpty((Object)userIds)) {
                userIds = userIds.stream().distinct().collect(Collectors.toList());
                ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
                for (Long userId : userIds) {
                    SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                    member.setTeamId(Long.valueOf(id));
                    member.setUserId(userId);
                    member.setMemberType("2");
                    memberList.add(member);
                }
                this.appDevelopTeamMemberService.saveBatch(memberList);
            }
        } else {
            SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
            member.setTeamId(Long.valueOf(id));
            member.setUserId(Long.valueOf(-1L));
            member.setMemberType("1");
            this.appDevelopTeamMemberService.save((Object)member);
        }
        sysAppDevelopTeam.setId(Long.valueOf(id));
        Boolean result = this.save((BaseEntity)sysAppDevelopTeam);
        HussarApplicationTeamCallBackFactory.saveAppDevelopTeam(appDevelopTeamDto, appDevelopTeamDto.getAppType());
        return result;
    }

    public List<Long> selectAppListByCurrentUserByVisibleType(String visibleType) {
        Long userId = BaseSecurityUtil.getUser().getId();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("userId", userId);
        queryParams.put("visibleType", visibleType);
        return this.sysAppDevelopTeamCommonMapper.selectAppListByCurrentUserByVisibleType(queryParams);
    }

    public AppDevelopTeamDetailVo getAppTeamDetail(Long appId) {
        AppDevelopTeamDetailVo teamDetailVo = new AppDevelopTeamDetailVo();
        SysAppDevelopTeam team = (SysAppDevelopTeam)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)team)) {
            throw new BaseException("\u8be5\u5e94\u7528\u6ca1\u6709\u5e94\u7528\u5f00\u53d1\u56e2\u961f\uff01");
        }
        if (!this.appVerifyService.checkPermissions(team.getAppId()).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u65e0\u6743\u9650\uff01");
        }
        BeanUtils.copyProperties((Object)team, (Object)teamDetailVo);
        teamDetailVo.setTeamId(team.getId());
        List userVoList = this.appDevelopTeamMemberService.listAppTeamMember(team.getId());
        teamDetailVo.setUserList(userVoList);
        return teamDetailVo;
    }

    public Integer getMemberType(Long appId) {
        return this.appDevelopTeamMemberService.getMemberType(appId);
    }
}

